/*
 * Decompiled with CFR 0.152.
 */
package com.pcbsys.foundation.system.memory;

import com.pcbsys.foundation.base.fFile;
import com.pcbsys.foundation.fConstants;
import com.pcbsys.foundation.system.memory.Constants;
import com.pcbsys.foundation.system.memory.fMemoryAllocator;
import com.pcbsys.foundation.system.memory.fMemoryPage;
import com.pcbsys.foundation.system.memory.fMemoryPageFile;
import com.pcbsys.foundation.system.memory.fOffHeapAllocator;
import com.pcbsys.foundation.system.memory.fPage;
import com.pcbsys.foundation.utils.fEnvironment;
import java.io.File;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.nio.ByteBuffer;
import java.nio.MappedByteBuffer;
import java.nio.channels.FileChannel;
import sun.misc.Cleaner;
import sun.nio.ch.DirectBuffer;

public class fMemoryPageFileAllocator
implements fMemoryAllocator {
    private static final int sFileExtensionSize = 500;
    private static final float sVersion = 1.0f;
    private final RandomAccessFile myFile;
    private final FileChannel myChannel;
    private final boolean reload;
    private final int myBufSize;
    private final int myInitSize;
    private final String myName;
    private int allocationCount;
    private long myFileOffset;

    public fMemoryPageFileAllocator(String string, int n, int n2) throws Exception {
        this.myName = string;
        File file = new File(this.myName);
        this.reload = file.exists() && file.length() > 8L;
        this.myFile = fFile.openRandomAccessFile(this.myName, "rw");
        int n3 = n;
        if (this.reload) {
            float f = this.myFile.readFloat();
            if (f != 1.0f) {
                fConstants.logger.info("File Page Allocator detected version change");
            }
            if ((n3 = this.myFile.readInt()) == 0) {
                n3 = n;
            }
        }
        this.myBufSize = n3;
        this.myFile.seek(0L);
        this.myFile.writeFloat(1.0f);
        this.myFile.writeInt(this.myBufSize);
        if (!this.reload) {
            long l = n2 / this.myBufSize;
            long l2 = l * (long)this.myBufSize;
            this.myFile.setLength(l2);
        } else {
            n2 = (int)this.myFile.length() / this.myBufSize;
        }
        this.myFileOffset = 8L;
        this.myInitSize = n2;
        this.myChannel = this.myFile.getChannel();
    }

    public long getCurrentSize() throws IOException {
        return this.myFile.length();
    }

    @Override
    public String getName() {
        return this.myName;
    }

    @Override
    public int getBufferSize() {
        return this.myBufSize;
    }

    @Override
    public int getUsableBufferSize() {
        return this.myBufSize - 16;
    }

    @Override
    public boolean supportSwapOut() {
        return true;
    }

    @Override
    public long unMapIdlePages() {
        return 0L;
    }

    @Override
    public void close() throws IOException {
        if (this.myChannel.isOpen()) {
            this.myChannel.force(false);
            this.myChannel.close();
        }
        this.myFile.close();
    }

    @Override
    public fPage allocate(long l) throws IOException {
        ++this.allocationCount;
        MappedByteBuffer mappedByteBuffer = (MappedByteBuffer)this.allocate(this.myFileOffset, this.myBufSize);
        fMemoryPageFile fMemoryPageFile2 = new fMemoryPageFile(mappedByteBuffer, l, this, this.myFileOffset);
        this.myFileOffset += (long)this.myBufSize;
        return fMemoryPageFile2;
    }

    @Override
    public boolean reload() {
        return this.reload;
    }

    @Override
    public int initialAllocation() {
        return this.myInitSize;
    }

    @Override
    public long extend() throws IOException {
        long l = this.myBufSize;
        long l2 = 500L;
        long l3 = this.myFile.length() + l * l2;
        if (Constants.sDebug) {
            Constants.debugMsg("Extending " + this.myName + " to " + l3 + " Extended by " + 500 + " records");
        }
        this.myFile.setLength(l3);
        return 500L;
    }

    @Override
    public void trim(long l) throws IOException {
        if (fEnvironment.isWindows()) {
            if (Constants.sDebug) {
                Constants.debugMsg("Trim not supported on Windows OS");
            }
            return;
        }
        this.myFileOffset -= l;
        this.myFile.setLength(this.myFileOffset);
        this.myFile.seek(this.myFileOffset);
        if (Constants.sDebug) {
            Constants.debugMsg("Trimming " + this.myName + " to " + this.myFileOffset);
        }
    }

    @Override
    public int allocated() {
        return this.allocationCount;
    }

    protected ByteBuffer allocate(long l, int n) throws IOException {
        return fOffHeapAllocator.getAllocator().allocateMapped(this.myChannel, l, n);
    }

    @Override
    public void release(fPage fPage2) throws IOException {
        --this.allocationCount;
        if (fPage2.isMemoryMapped()) {
            fOffHeapAllocator.getAllocator().release(this.myBufSize);
            Cleaner cleaner = ((DirectBuffer)((Object)((fMemoryPage)fPage2).myMap)).cleaner();
            if (cleaner != null) {
                cleaner.clean();
            }
        }
    }

    @Override
    public void compact() throws IOException {
    }
}

