/*
 * Decompiled with CFR 0.152.
 */
package com.pcbsys.foundation.system.memory;

import com.pcbsys.foundation.system.memory.Constants;
import com.pcbsys.foundation.system.memory.fMemoryAllocator;
import com.pcbsys.foundation.system.memory.fMemoryRemap;
import com.pcbsys.foundation.system.memory.fPage;
import com.pcbsys.foundation.system.memory.fPageMonitor;
import com.pcbsys.foundation.system.memory.fPageSwapOutManager;
import java.io.IOException;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedList;

public class fMemoryPageManager {
    private static final fMemoryPageComparator comparator = new fMemoryPageComparator();
    private final LinkedList<fPage> myLockedPages;
    private final LinkedList<fPage> myFreeList;
    private final LinkedHashMap<Long, fPage> myUsedList;
    private final fMemoryAllocator myAllocator;
    private final fPageSwapOutManager mySwapOutManager;
    private long myLastID = 0L;

    public fMemoryPageManager(fMemoryAllocator fMemoryAllocator2) throws Exception {
        this.myAllocator = fMemoryAllocator2;
        this.myFreeList = new LinkedList();
        this.myUsedList = new LinkedHashMap();
        this.myLockedPages = new LinkedList();
        boolean bl = this.myAllocator.reload();
        if (Constants.sDebug && bl) {
            Constants.debugMsg("Allocator requires reloading of data");
        }
        LinkedHashMap<Long, fPage> linkedHashMap = new LinkedHashMap<Long, fPage>();
        LinkedList<fPage> linkedList = new LinkedList<fPage>();
        int n = this.myAllocator.initialAllocation();
        for (long i = 0L; i < (long)n; ++i) {
            boolean bl2 = false;
            fPage fPage2 = this.myAllocator.allocate(this.myLastID++);
            if (bl) {
                if (!fPage2.isLoaded()) {
                    fPage2.load();
                }
                fPage.type type2 = fPage2.getType();
                fPage2.seek(0);
                if (type2 == fPage.type.head) {
                    this.myUsedList.put(fPage2.getUniqueId(), fPage2);
                    bl2 = true;
                } else if (type2 == fPage.type.chain) {
                    linkedHashMap.put(fPage2.getUniqueId(), fPage2);
                    linkedList.addLast(fPage2);
                    bl2 = true;
                }
            }
            if (bl2) continue;
            this.myFreeList.addLast(fPage2);
        }
        if (linkedHashMap.size() != 0) {
            if (Constants.sDebug) {
                Constants.debugMsg("Found linked pages, recreating chains");
            }
            this.recreateLinks(linkedList, linkedHashMap);
        }
        if (Constants.sDebug) {
            Constants.debugMsg("Loaded " + this.myFreeList.size() + " Free pages, " + this.myUsedList.size() + " Used pages and " + linkedHashMap.size() + " chained pages");
        }
        fPageMonitor.getInstance().add(this);
        this.mySwapOutManager = fPageMonitor.getInstance().getRegisteredManager();
    }

    public void copy(fMemoryPageManager fMemoryPageManager2) throws IOException {
        for (fPage fPage2 : fMemoryPageManager2.myUsedList.values()) {
            fPage fPage3 = this.allocate();
            while (fPage2 != null) {
                fPage3.copy(fPage2);
                if ((fPage2 = fPage2.getChain()) == null) continue;
                fPage3 = this.chain(fPage3);
            }
        }
    }

    public int getPageSize() {
        return this.myAllocator.getBufferSize();
    }

    public int getUsableBufferSize() {
        return this.myAllocator.getUsableBufferSize();
    }

    public void close() throws Exception {
        fPageMonitor.getInstance().remove(this);
        if (Constants.sDebug) {
            Constants.debugMsg("Closing " + this.myAllocator.getName());
        }
        while (this.myFreeList.size() != 0) {
            this.myFreeList.removeFirst().close();
        }
        for (fPage fPage2 : this.myUsedList.values()) {
            fPage2.close();
        }
        while (this.myLockedPages.size() != 0) {
            this.myLockedPages.removeFirst().close();
        }
        this.myUsedList.clear();
        this.myAllocator.close();
        if (Constants.sDebug) {
            Constants.debugMsg("Completed closing " + this.myAllocator.getName());
        }
    }

    protected void finalize() throws Throwable {
        if (this.myUsedList.size() != 0) {
            if (Constants.sDebug) {
                Constants.debugMsg("Manager was not closed but picked up by the GC");
            }
            this.close();
        }
        super.finalize();
    }

    public int getFreeListSize() {
        return this.myFreeList.size();
    }

    public int getUsedListSize() {
        return this.myUsedList.size();
    }

    public void trim() {
        if (this.myUsedList.size() == 0 || this.myFreeList.size() == 0) {
            return;
        }
        if (Constants.sDebug) {
            Constants.debugMsg(this.myAllocator.getName() + " Trimming Page Manager : " + this.myAllocator.getName());
            Constants.debugMsg(this.myAllocator.getName() + " Starting with Used list size : " + this.myUsedList.size() + " Free list size : " + this.myFreeList.size());
            Constants.debugMsg(this.myAllocator.getName() + " Sorting used list index of size : " + this.myUsedList.size());
        }
        Object[] objectArray = new Long[this.myUsedList.size()];
        objectArray = this.myUsedList.keySet().toArray(objectArray);
        Arrays.sort(objectArray);
        long l = (Long)objectArray[objectArray.length - 1];
        if (Constants.sDebug) {
            Constants.debugMsg(this.myAllocator.getName() + " Last used page : " + l + ", clearing and releasing all pages past this point");
        }
        Iterator iterator = this.myFreeList.iterator();
        LinkedList<fPage> linkedList = new LinkedList<fPage>();
        while (iterator.hasNext()) {
            fPage fPage2 = (fPage)iterator.next();
            if (fPage2.getUniqueId() <= l) continue;
            linkedList.add(fPage2);
            iterator.remove();
        }
        int n = 0;
        for (fPage fPage3 : linkedList) {
            try {
                n += this.release(fPage3);
            }
            catch (Exception exception) {
                Constants.debugMsg(exception);
            }
        }
        long l2 = n * this.myAllocator.getBufferSize();
        try {
            this.myAllocator.trim(l2);
        }
        catch (IOException iOException) {
            Constants.debugMsg(iOException);
        }
        linkedList.clear();
        if (Constants.sDebug) {
            Constants.debugMsg(this.myAllocator.getName() + " released " + n + " pages, " + l2 + " bytes");
            Constants.debugMsg(this.myAllocator.getName() + " Completed with Used list size : " + this.myUsedList.size() + " Free list size : " + this.myFreeList.size());
        }
    }

    public void compact() throws IOException {
        if (this.myUsedList.size() == 0 || this.myFreeList.size() == 0) {
            return;
        }
        if (Constants.sDebug) {
            Constants.debugMsg(this.myAllocator.getName() + " Compacting Page Manager : " + this.myAllocator.getName());
            Constants.debugMsg(this.myAllocator.getName() + " Sorting free list size : " + this.myFreeList.size());
        }
        Collections.sort(this.myFreeList, comparator);
        if (Constants.sDebug) {
            Constants.debugMsg(this.myAllocator.getName() + " Sorting used list index of size : " + this.myUsedList.size());
        }
        Object[] objectArray = new Long[this.myUsedList.size()];
        objectArray = this.myUsedList.keySet().toArray(objectArray);
        Arrays.sort(objectArray);
        if (Constants.sDebug) {
            Constants.debugMsg(this.myAllocator.getName() + " Walking used list looking for compact opportunities");
        }
        fPage fPage2 = this.myFreeList.getFirst();
        for (int i = 0; this.myFreeList.size() > 0 && i < objectArray.length; ++i) {
            if ((Long)objectArray[i] <= fPage2.getUniqueId()) continue;
            fPage fPage3 = (fPage)this.myUsedList.remove(objectArray[i]);
            fPage2 = this.myFreeList.removeFirst();
            this.swapRecord(fPage2, fPage3);
            fPage2.flip();
            fPage2 = this.myFreeList.getFirst();
        }
        if (Constants.sDebug) {
            Constants.debugMsg(this.myAllocator.getName() + " Completed compact of " + this.myAllocator.getName() + " FreeList size:" + this.myFreeList.size() + " Used size : " + this.myUsedList.size());
        }
        this.myAllocator.compact();
    }

    private void swapRecord(fPage fPage2, fPage fPage3) throws IOException {
        fMemoryRemap fMemoryRemap2 = fPage3.getRemapListener();
        fPage2.allocate();
        fPage2.copy(fPage3);
        this.myUsedList.remove(fPage3.getUniqueId());
        this.myUsedList.put(fPage2.getUniqueId(), fPage2);
        this.addToFreeList(fPage3);
        for (fPage fPage4 = fPage3.getChain(); fPage4 != null; fPage4 = fPage4.getChain()) {
            this.checkChain(fPage2, fPage4);
        }
        if (fMemoryRemap2 != null) {
            fMemoryRemap2.mapMoved(fPage2, fPage3);
        }
    }

    private void checkChain(fPage fPage2, fPage fPage3) throws IOException {
        fPage fPage4 = this.myFreeList.getFirst();
        if (fPage4 != null && fPage4.getUniqueId() < fPage3.getUniqueId()) {
            fPage4 = this.myFreeList.removeFirst();
            fPage4.copy(fPage3);
            fPage fPage5 = fPage3.getChain();
            this.addToFreeList(fPage3);
            fPage2.chain(fPage4);
            if (fPage5 != null) {
                this.checkChain(fPage4, fPage5);
            }
        } else {
            fPage2.chain(fPage3);
        }
    }

    protected void addToFreeList(fPage fPage2) throws IOException {
        fPage2.deallocate();
        if (this.myFreeList.size() > 0 && fPage2.getUniqueId() < this.myFreeList.getFirst().getUniqueId()) {
            this.myFreeList.addFirst(fPage2);
        } else {
            this.myFreeList.addLast(fPage2);
        }
    }

    public Iterator<fPage> getRecords() {
        return this.myUsedList.values().iterator();
    }

    public void deallocateAll() throws IOException {
        ArrayList<fPage> arrayList = new ArrayList<fPage>(this.myUsedList.values());
        while (arrayList.size() != 0) {
            this.deallocate(arrayList.remove(0));
        }
        this.myUsedList.clear();
    }

    public fPage allocate() throws IOException {
        if (this.myFreeList.size() == 0) {
            this.extendFile();
        }
        int n = this.myFreeList.size();
        fPage fPage2 = this.myFreeList.removeFirst();
        if (n == this.myFreeList.size()) {
            Constants.debugMsg("myFreeList is not the same size");
        }
        this.myUsedList.put(fPage2.getUniqueId(), fPage2);
        fPage2.swapIn();
        fPage2.allocate();
        return fPage2;
    }

    public fPage allocateLocked() throws IOException {
        if (this.myFreeList.size() == 0) {
            this.extendFile();
        }
        int n = this.myFreeList.size();
        fPage fPage2 = this.myFreeList.removeFirst();
        if (n == this.myFreeList.size()) {
            Constants.debugMsg("myFreeList is not the same size");
        }
        this.myLockedPages.add(fPage2);
        fPage2.swapIn();
        fPage2.allocate();
        return fPage2;
    }

    public fPage chain(fPage fPage2) throws IOException {
        if (this.myFreeList.size() == 0) {
            this.extendFile();
        }
        fPage fPage3 = this.myFreeList.removeFirst();
        fPage3.swapIn();
        fPage2.chain(fPage3);
        return fPage3;
    }

    public void deallocate(fPage fPage2) throws IOException {
        fPage fPage3 = fPage2;
        while (fPage3 != null) {
            fPage fPage4 = fPage3.getChain();
            this.myUsedList.remove(fPage3.getUniqueId());
            this.addToFreeList(fPage3);
            fPage3 = fPage4;
        }
    }

    public int release(fPage fPage2) throws IOException {
        int n = 0;
        fPage fPage3 = fPage2;
        while (fPage3 != null) {
            fPage fPage4 = fPage3.getChain();
            try {
                this.myAllocator.release(fPage3);
            }
            catch (Exception exception) {
                Constants.debugMsg(exception);
            }
            fPage3 = fPage4;
            ++n;
        }
        return n;
    }

    public int free() {
        return this.myFreeList.size();
    }

    public int chains() {
        return this.myUsedList.size();
    }

    private void extendFile() throws IOException {
        long l = this.myAllocator.extend();
        for (long i = 0L; i < l; ++i) {
            fPage fPage2 = this.myAllocator.allocate(this.myLastID++);
            this.myFreeList.addLast(fPage2);
        }
    }

    private void reLink(fPage fPage2, LinkedHashMap<Long, fPage> linkedHashMap) {
        fPage fPage3;
        long l = fPage2.getChainUniqueId();
        if (l != 0L && (fPage3 = (fPage)linkedHashMap.remove(l)) != null) {
            fPage2.reLink(fPage3);
        }
    }

    private void recreateLinks(LinkedList<fPage> linkedList, LinkedHashMap<Long, fPage> linkedHashMap) {
        for (fPage fPage2 : linkedList) {
            fPage fPage3;
            long l = fPage2.getChainUniqueId();
            if (l == 0L || (fPage3 = (fPage)linkedHashMap.remove(l)) == null) continue;
            fPage2.reLink(fPage3);
        }
        for (fPage fPage2 : this.myUsedList.values()) {
            this.reLink(fPage2, linkedHashMap);
        }
    }

    public int used() {
        return this.myAllocator.allocated();
    }

    public long unMapIdlePages() {
        long l = 0L;
        if (this.myAllocator.supportSwapOut()) {
            for (fPage fPage2 : this.myUsedList.values()) {
                try {
                    if (!this.mySwapOutManager.unmap(fPage2)) continue;
                    l += (long)this.myAllocator.getBufferSize();
                }
                catch (IOException iOException) {
                    Constants.debugMsg(iOException);
                }
            }
            for (fPage fPage2 : this.myFreeList) {
                try {
                    this.mySwapOutManager.unmap(fPage2);
                }
                catch (IOException iOException) {
                    Constants.debugMsg(iOException);
                }
            }
        }
        return l += this.myAllocator.unMapIdlePages();
    }

    public void sync() throws IOException {
        for (fPage fPage2 : this.myUsedList.values()) {
            fPage2.sync();
        }
    }

    protected static final class fMemoryPageComparator
    implements Comparator<fPage>,
    Serializable {
        static final long serialVersionUID = 1L;

        protected fMemoryPageComparator() {
        }

        @Override
        public int compare(fPage fPage2, fPage fPage3) {
            return (int)(fPage2.getUniqueId() - fPage3.getUniqueId());
        }
    }
}

