/*
 * Decompiled with CFR 0.152.
 */
package com.pcbsys.foundation.system.memory;

import com.pcbsys.foundation.collections.fast.Long2ObjectOpenAddressingHashMap;
import com.pcbsys.foundation.fConstants;
import com.pcbsys.foundation.system.memory.Constants;
import com.pcbsys.foundation.system.memory.fMemoryAllocator;
import com.pcbsys.foundation.system.memory.fMemoryPage;
import com.pcbsys.foundation.system.memory.fMemoryPageFileAllocator;
import com.pcbsys.foundation.system.memory.fMemoryPageManager;
import com.pcbsys.foundation.system.memory.fMemoryPageWindow;
import com.pcbsys.foundation.system.memory.fPage;
import com.pcbsys.foundation.utils.fUtilities;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.BitSet;
import java.util.Iterator;

public class fMemoryPageWindowFileAllocator
implements fMemoryAllocator {
    private final fMemoryPageFileAllocator myFilePageAllocator;
    private final fMemoryPageManager myManager;
    private final Long2ObjectOpenAddressingHashMap<fPage> myPages;
    private final int myLargePageRecordSize;
    private final int mySmallPageRecordSize;
    private final int myPagesPerMap;
    private BitSet myAllocatedList;
    private int allocationCount;

    public fMemoryPageWindowFileAllocator(String string, int n, int n2, int n3) throws Exception {
        fPage fPage2;
        this.mySmallPageRecordSize = fUtilities.findNextPowerOfTwo(n);
        n2 = n2 / this.mySmallPageRecordSize * this.mySmallPageRecordSize;
        this.myLargePageRecordSize = fUtilities.findNextPowerOfTwo(n2) + 16;
        if (this.mySmallPageRecordSize >= this.myLargePageRecordSize) {
            throw new Exception("Invalid page sizes specified, smaller record size must be less than the large page size");
        }
        if (Constants.sDebug) {
            Constants.debugMsg("Allocating Large Page Record Sizes : " + this.myLargePageRecordSize + " With " + n3 + " initial records");
        }
        this.myFilePageAllocator = new fMemoryPageFileAllocator(string, this.myLargePageRecordSize, n3);
        this.myManager = new fMemoryPageManager(this.myFilePageAllocator);
        this.myPagesPerMap = (this.myLargePageRecordSize - 16) / this.mySmallPageRecordSize;
        long l = this.myFilePageAllocator.getCurrentSize();
        int n4 = (int)(l / (long)this.myLargePageRecordSize);
        int n5 = n4 * this.myPagesPerMap;
        this.myAllocatedList = new BitSet(n5);
        if (Constants.sDebug) {
            Constants.debugMsg("Allocating Small Page Record Sizes : " + this.mySmallPageRecordSize + " With " + n5 + " initial records");
        }
        this.myPages = new Long2ObjectOpenAddressingHashMap();
        if (Constants.sDebug) {
            Constants.debugMsg("Allocating and loading Large Pages");
        }
        Iterator<fPage> iterator = this.myManager.getRecords();
        while (iterator.hasNext()) {
            fPage2 = iterator.next();
            if (!fPage2.isLoaded()) {
                fPage2.load();
            }
            this.myPages.put(fPage2.getUniqueId(), fPage2);
        }
        while (this.myManager.getFreeListSize() != 0) {
            fPage2 = this.myManager.allocate();
            this.myPages.put(fPage2.getUniqueId(), fPage2);
        }
    }

    @Override
    public void close() throws IOException {
        try {
            try {
                Iterator<fPage> iterator = this.myPages.iterator();
                while (iterator.hasNext()) {
                    try {
                        iterator.next().close();
                    }
                    catch (Exception exception) {
                        fConstants.logger.warn(exception);
                    }
                }
                try {
                    this.myManager.close();
                }
                catch (Exception exception) {
                    throw new IOException(exception.getMessage());
                }
            }
            finally {
                this.myFilePageAllocator.close();
            }
        }
        catch (Exception exception) {
            throw new IOException(exception.getMessage());
        }
    }

    @Override
    public String getName() {
        return this.myFilePageAllocator.getName();
    }

    @Override
    public int getBufferSize() {
        return this.mySmallPageRecordSize;
    }

    @Override
    public boolean supportSwapOut() {
        return false;
    }

    @Override
    public fMemoryPage allocate(long l) throws IOException {
        int n = this.myAllocatedList.nextClearBit(0);
        if (n == this.myAllocatedList.size()) {
            if (Constants.sDebug) {
                Constants.debugMsg("No free space, allocating Large Page");
            }
            this.extend();
            return this.allocate(l);
        }
        this.myAllocatedList.set(n);
        int n2 = n % this.myPagesPerMap * this.mySmallPageRecordSize + 16;
        long l2 = n / this.myPagesPerMap;
        if ((long)(this.myPages.size() - 1) < l2) {
            this.extend();
        }
        fPage fPage2 = this.myPages.get(l2);
        ++this.allocationCount;
        return new fMemoryPageWindow((fMemoryPage)fPage2, l, this, n2, this.mySmallPageRecordSize);
    }

    @Override
    public boolean reload() {
        return this.myFilePageAllocator.reload();
    }

    public int bufferSize() {
        return this.mySmallPageRecordSize;
    }

    @Override
    public int initialAllocation() {
        return this.myAllocatedList.size();
    }

    @Override
    public long extend() throws IOException {
        int n = this.myAllocatedList.size();
        fPage fPage2 = this.myManager.allocate();
        this.myPages.put(fPage2.getUniqueId(), fPage2);
        while (this.myManager.getFreeListSize() != 0) {
            fPage2 = this.myManager.allocate();
            this.myPages.put(fPage2.getUniqueId(), fPage2);
        }
        BitSet bitSet = new BitSet((int)(this.myFilePageAllocator.getCurrentSize() / (long)this.mySmallPageRecordSize));
        bitSet.or(this.myAllocatedList);
        bitSet.clear(this.myAllocatedList.size(), bitSet.size());
        this.myAllocatedList = bitSet;
        return this.myAllocatedList.size() - n;
    }

    @Override
    public void trim(long l) throws IOException {
    }

    @Override
    public int allocated() {
        return this.allocationCount;
    }

    private ByteBuffer allocate() throws IOException {
        return null;
    }

    @Override
    public void release(fPage fPage2) throws IOException {
        --this.allocationCount;
        if (fPage2 instanceof fMemoryPageWindow) {
            fMemoryPageWindow fMemoryPageWindow2 = (fMemoryPageWindow)fPage2;
            this.myAllocatedList.clear(fMemoryPageWindow2.getIndex());
        }
    }

    @Override
    public long unMapIdlePages() {
        return this.myManager.unMapIdlePages();
    }

    @Override
    public void compact() throws IOException {
        this.myManager.compact();
    }

    @Override
    public int getUsableBufferSize() {
        return this.mySmallPageRecordSize - 16;
    }
}

