/*
 * Decompiled with CFR 0.152.
 */
package com.pcbsys.foundation.system.memory;

import com.pcbsys.foundation.base.fBaseApplication;
import com.pcbsys.foundation.drivers.jdk.fJDKHelperBase;
import com.pcbsys.foundation.drivers.jdk.fUnSafe;
import com.pcbsys.foundation.fConstants;
import com.pcbsys.foundation.memory.fMemoryManager;
import com.pcbsys.foundation.system.memory.Constants;
import com.pcbsys.foundation.system.memory.fPageMonitor;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.channels.FileChannel;

public class fOffHeapAllocator {
    private static final fUnSafe unsafe = fJDKHelperBase.getUnsafe();
    private static final fOffHeapAllocator sAllocator = new fOffHeapAllocator();

    public static fOffHeapAllocator getAllocator() {
        return sAllocator;
    }

    private fOffHeapAllocator() {
        fConstants.logger.log("Startup> Direct Memory Manager detected " + fMemoryManager.getInstance().getMaxDirectMemory() + " direct memory quota");
    }

    public long getTotalDirectMemory() {
        return fMemoryManager.getInstance().getMaxDirectMemory();
    }

    public long getUsedDirectMemory() {
        return fMemoryManager.getInstance().getUsedDirectMemory();
    }

    public ByteBuffer allocate(int n) {
        this.checkMemory(n);
        return ByteBuffer.allocateDirect(n);
    }

    public ByteBuffer allocateMapped(FileChannel fileChannel, long l, int n) throws IOException {
        this.checkMemory(n);
        return fileChannel.map(FileChannel.MapMode.READ_WRITE, l, n);
    }

    public long allocateMemory(int n) {
        this.checkMemory(n);
        return unsafe.allocateMemory(n);
    }

    public void release(int n) {
    }

    public void freeMemory(long l, int n) {
        unsafe.freeMemory(l);
    }

    private void checkMemory(int n) {
        int n2 = 0;
        while ((long)n >= fMemoryManager.getInstance().getFreeDirectMemory()) {
            if (n2 > 10) {
                Constants.log("Exceeded direct memory allocation");
                fMemoryManager.getInstance().handleOutOfMemoryException(new OutOfMemoryError("Exceeded direct memory allocation"));
                fBaseApplication.getApplication().memoryError("Exceeded direct memory allocation");
            }
            this.handleOOMException();
            ++n2;
        }
    }

    public void handleOOMException() {
        fPageMonitor.getInstance().outOfMemoryException();
    }
}

