/*
 * Decompiled with CFR 0.152.
 */
package com.pcbsys.foundation.system.memory;

import com.pcbsys.foundation.base.fTimer;
import com.pcbsys.foundation.system.memory.Constants;
import com.pcbsys.foundation.system.memory.Swapable;
import com.pcbsys.foundation.system.memory.fMemoryRemap;
import com.pcbsys.foundation.utils.fEnvironment;
import java.io.IOException;

public abstract class fPage
implements Swapable {
    public static final long sHead = Long.MAX_VALUE;
    public static final long sChained = 0x7777777777777777L;
    public static final long sFree = 0L;
    protected static final boolean sDebug = fEnvironment.isDebugEnabled("MappedMemory.Paging");
    protected static final int sHeaderSize = 16;
    protected final long myUniqueId;
    protected long A0;
    protected long A1;
    protected long A2;
    protected long A3;
    protected long A4;
    protected long A5;
    protected long A6;
    protected long myLastAccessTime = fTimer.currentTimeMillis();
    protected fPage link;
    protected fMemoryRemap myRemapListener = null;
    protected final int mySize;

    public fPage(long l, int n) {
        this.myUniqueId = l;
        this.mySize = n;
    }

    public abstract void close() throws Exception;

    @Override
    public int size() {
        return this.mySize;
    }

    public abstract void clear();

    public abstract void sync() throws IOException;

    @Override
    public long getAccessTime() {
        return this.myLastAccessTime;
    }

    public void setAccessTime(long l) {
        this.myLastAccessTime = l;
    }

    public long getUniqueId() {
        return this.myUniqueId;
    }

    public abstract type getType();

    protected type lookupType(long l) {
        if (l == Long.MAX_VALUE) {
            return type.head;
        }
        if (l == 0x7777777777777777L) {
            return type.chain;
        }
        if (Constants.sValidate && l != 0L) {
            Constants.debugMsg("Header block has been overwritten... " + Long.toHexString(l) + " " + this.toString());
            throw new Error("MappedMemory Header is corrupt, expected 0x0 but read " + Long.toHexString(l));
        }
        return type.free;
    }

    public abstract boolean isMemoryMapped();

    public abstract void allocate() throws IOException;

    public abstract void deallocate() throws IOException;

    public abstract void chain(fPage var1) throws IOException;

    public fPage getChain() {
        return this.link;
    }

    public void reLink(fPage fPage2) {
        this.link = fPage2;
    }

    public abstract void copy(fPage var1) throws IOException;

    public void setRemapListener(fMemoryRemap fMemoryRemap2) {
        this.myRemapListener = fMemoryRemap2;
    }

    public fMemoryRemap getRemapListener() {
        return this.myRemapListener;
    }

    public abstract int available();

    public abstract int getPosition();

    public abstract void seek(int var1);

    public abstract long getChainUniqueId();

    public abstract boolean isLoaded() throws IOException;

    public abstract void load() throws IOException;

    public abstract void force() throws IOException;

    public abstract void flip() throws IOException;

    public abstract boolean isActive();

    public abstract void put(byte[] var1) throws IOException;

    public abstract void put(byte[] var1, int var2, int var3) throws IOException;

    public abstract void put(int var1, byte[] var2, int var3, int var4) throws IOException;

    public abstract void putOrderedLong(long var1) throws IOException;

    public abstract void putOrderedLong(int var1, long var2) throws IOException;

    public abstract void putLong(long var1) throws IOException;

    public abstract void putLong(int var1, long var2) throws IOException;

    public abstract void putDouble(double var1) throws IOException;

    public abstract void putDouble(int var1, double var2) throws IOException;

    public abstract void putFloat(float var1) throws IOException;

    public abstract void putFloat(int var1, float var2) throws IOException;

    public abstract void putInt(int var1) throws IOException;

    public abstract void putInt(int var1, int var2) throws IOException;

    public abstract void putShort(short var1) throws IOException;

    public abstract void putShort(int var1, short var2) throws IOException;

    public abstract void putByte(byte var1) throws IOException;

    public abstract void putByte(int var1, byte var2) throws IOException;

    public abstract void putLongVolatile(long var1) throws IOException;

    public abstract void putLongVolatile(int var1, long var2) throws IOException;

    public abstract void putVolatileDouble(double var1) throws IOException;

    public abstract void putVolatileDouble(int var1, double var2) throws IOException;

    public abstract void putVolatileFloat(float var1) throws IOException;

    public abstract void putVolatileFloat(int var1, float var2) throws IOException;

    public abstract void putVolatileInt(int var1) throws IOException;

    public abstract void putVolatileInt(int var1, int var2) throws IOException;

    public abstract void putVolatileShort(short var1) throws IOException;

    public abstract void putVolatileShort(int var1, short var2) throws IOException;

    public abstract void putVolatileByte(byte var1) throws IOException;

    public abstract void putVolatileByte(int var1, byte var2) throws IOException;

    public abstract void get(byte[] var1, int var2, int var3) throws IOException;

    public abstract void get(int var1, byte[] var2, int var3, int var4) throws IOException;

    public abstract long getLongVolatile() throws IOException;

    public abstract long getLongVolatile(int var1) throws IOException;

    public abstract double getDoubleVolatile() throws IOException;

    public abstract double getDoubleVolatile(int var1) throws IOException;

    public abstract int getIntVolatile() throws IOException;

    public abstract int getIntVolatile(int var1) throws IOException;

    public abstract float getFloatVolatile() throws IOException;

    public abstract float getFloatVolatile(int var1) throws IOException;

    public abstract short getShortVolatile() throws IOException;

    public abstract short getShortVolatile(int var1) throws IOException;

    public abstract byte getByteVolatile() throws IOException;

    public abstract byte getByteVolatile(int var1) throws IOException;

    public abstract long getLong() throws IOException;

    public abstract long getLong(int var1) throws IOException;

    public abstract double getDouble() throws IOException;

    public abstract double getDouble(int var1) throws IOException;

    public abstract int getInt() throws IOException;

    public abstract int getInt(int var1) throws IOException;

    public abstract float getFloat() throws IOException;

    public abstract float getFloat(int var1) throws IOException;

    public abstract short getShort() throws IOException;

    public abstract short getShort(int var1) throws IOException;

    public abstract byte getByte() throws IOException;

    public abstract byte getByte(int var1) throws IOException;

    public static enum type {
        free,
        head,
        chain;

    }
}

