/*
 * Decompiled with CFR 0.152.
 */
package com.pcbsys.foundation.system.memory;

import com.pcbsys.foundation.system.memory.Constants;
import com.pcbsys.foundation.system.memory.SimplePageSwapImpl;
import com.pcbsys.foundation.system.memory.fMemoryPageManager;
import com.pcbsys.foundation.system.memory.fPageSwapOutManager;
import com.pcbsys.foundation.threads.fScheduledTask;
import com.pcbsys.foundation.threads.fThreadScheduler;
import java.util.LinkedList;

public class fPageMonitor
extends fScheduledTask {
    private static long sPageIdleTime = 60000L;
    private static float sFreeSpacePercentTarget = 10.0f;
    private static long sScanTime = 1000L;
    private static final fPageMonitor sMonitor = new fPageMonitor();
    private final LinkedList<fMemoryPageManager> myManagers = new LinkedList();
    private fPageSwapOutManager mySwapOutManager = new SimplePageSwapImpl(sFreeSpacePercentTarget, sPageIdleTime);

    public static fPageMonitor getInstance() {
        return sMonitor;
    }

    public static long getsPageIdleTime() {
        return sPageIdleTime;
    }

    public static void setsPageIdleTime(long l) {
        sPageIdleTime = l;
    }

    public static float getsFreeSpacePercentTarget() {
        return sFreeSpacePercentTarget;
    }

    public static void setsFreeSpacePercentTarget(float f) {
        sFreeSpacePercentTarget = f;
    }

    public static long getsScanTime() {
        return sScanTime;
    }

    public static void setsScanTime(long l) {
        sScanTime = l;
    }

    private fPageMonitor() {
    }

    public void start() {
        if (Constants.sEnableSwapping) {
            fThreadScheduler.getInstance().addReoccuringTask(this, sScanTime);
        }
    }

    public void stop() {
        if (Constants.sEnableSwapping) {
            fThreadScheduler.getInstance().delReoccuringTask(this);
            this.myManagers.clear();
        }
    }

    @Override
    public long reSchedule() {
        return sScanTime;
    }

    public void add(fMemoryPageManager fMemoryPageManager2) {
        this.myManagers.add(fMemoryPageManager2);
    }

    public boolean remove(fMemoryPageManager fMemoryPageManager2) {
        return this.myManagers.remove(fMemoryPageManager2);
    }

    public fPageSwapOutManager getRegisteredManager() {
        return this.mySwapOutManager;
    }

    public void setRegisteredManager(fPageSwapOutManager fPageSwapOutManager2) {
        this.mySwapOutManager = fPageSwapOutManager2;
    }

    @Override
    public void execute() {
        this.mySwapOutManager.scanMapManagers(this.myManagers, false);
    }

    public void outOfMemoryException() {
        this.execute();
    }
}

