/*
 * Decompiled with CFR 0.152.
 */
package com.pcbsys.foundation.threads;

import com.pcbsys.foundation.collections.fQueue;
import com.pcbsys.foundation.drivers.MonitoredOutputStream;
import com.pcbsys.foundation.drivers.fNIOOutputStream;
import com.pcbsys.foundation.drivers.fWriteReadyCallback;
import com.pcbsys.foundation.fConstants;
import com.pcbsys.foundation.io.javascript.fStreamWrapperInterface;
import com.pcbsys.foundation.threads.fProcessQueue;
import com.pcbsys.foundation.threads.fQueueHandler;
import com.pcbsys.foundation.threads.fTask;
import com.pcbsys.foundation.threads.fThreadPool;
import java.io.IOException;
import java.io.OutputStream;

public class fProcessNIOQueue
extends fProcessQueue
implements fWriteReadyCallback,
fTask {
    private static int sMyLoopCount = 30;
    private static fThreadPool myPool = fThreadPool.getWritePool();
    private fNIOOutputStream myNIOStream;
    protected final fQueue myQueue;
    private volatile boolean isSuspended = false;
    private boolean isScheduled = false;
    private boolean isClosed = false;
    private boolean writeReady = true;
    private boolean inUserWrite = false;

    public static int getLoopCount() {
        return sMyLoopCount;
    }

    public static void setLoopCount(int n) {
        sMyLoopCount = n;
    }

    public fProcessNIOQueue(fQueueHandler fQueueHandler2, fQueue fQueue2, int n, int n2, OutputStream outputStream) {
        super(fQueueHandler2, n, n2);
        this.myQueue = fQueue2;
        if (outputStream instanceof fNIOOutputStream) {
            this.myNIOStream = (fNIOOutputStream)((Object)outputStream);
        } else if (outputStream instanceof MonitoredOutputStream) {
            OutputStream outputStream2 = ((MonitoredOutputStream)outputStream).getBaseOutputStream();
            if (outputStream2 instanceof fNIOOutputStream) {
                this.myNIOStream = (fNIOOutputStream)((Object)outputStream2);
            }
        } else if (outputStream instanceof fStreamWrapperInterface) {
            OutputStream outputStream3;
            OutputStream outputStream4 = ((fStreamWrapperInterface)outputStream).getBaseStream();
            if (outputStream4 instanceof fNIOOutputStream) {
                this.myNIOStream = (fNIOOutputStream)((Object)outputStream4);
            } else if (outputStream4 instanceof MonitoredOutputStream && (outputStream3 = ((MonitoredOutputStream)outputStream4).getBaseOutputStream()) instanceof fNIOOutputStream) {
                this.myNIOStream = (fNIOOutputStream)((Object)outputStream3);
            }
        }
        this.myNIOStream.registerCallback(this);
    }

    @Override
    public int length() {
        return this.myQueue.size();
    }

    @Override
    public long size() {
        return this.myQueue.size();
    }

    @Override
    public boolean isSuspended() {
        return this.isSuspended;
    }

    @Override
    public void setHighWaterMark(int n) {
        super.setHighWaterMark(n);
    }

    @Override
    public void setLowWaterMark(int n) {
        super.setLowWaterMark(n);
    }

    public boolean isWriting() {
        return this.myNIOStream.isWriting();
    }

    @Override
    public void push(Object object) {
        this.push(object, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void push(Object object, boolean bl) {
        if (this.isClosed) {
            return;
        }
        if (this.myQueue.size() >= this.myHighWaterMark && this.myHighWaterMark != -1 && !this.isSuspended) {
            this.isSuspended = true;
            this.myHandler.reachedHWM();
        }
        fQueue fQueue2 = this.myQueue;
        synchronized (fQueue2) {
            if (this.myNIOStream.isWriting() || this.myQueue.size() != 0 || this.inUserWrite) {
                this.myQueue.put(object);
                if (!this.myNIOStream.isWriting() && !this.inUserWrite) {
                    this.queueTask();
                }
                return;
            }
            this.inUserWrite = true;
        }
        int n = 1;
        while (this.inUserWrite) {
            try {
                this.myHandler.processObject(object, n, false);
            }
            catch (IOException iOException) {
                break;
            }
            catch (Throwable throwable) {
                fConstants.logger.error("NIOQueue push - unhandled exception : " + throwable);
                fConstants.logger.debug(throwable);
            }
            fQueue fQueue3 = this.myQueue;
            synchronized (fQueue3) {
                n = this.myQueue.size();
                if (this.myNIOStream.isWriting() || n == 0) {
                    this.inUserWrite = false;
                    return;
                }
                object = this.myQueue.pop();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() {
        fQueue fQueue2 = this.myQueue;
        synchronized (fQueue2) {
            this.isClosed = true;
            while (this.myQueue.size() != 0) {
                this.myQueue.pop();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void closeAndCopy(fProcessQueue fProcessQueue2) {
        fQueue fQueue2 = this.myQueue;
        synchronized (fQueue2) {
            this.isClosed = true;
            while (this.myQueue.size() != 0) {
                fProcessQueue2.push(this.myQueue.pop());
            }
        }
    }

    private boolean queueTask() {
        if (!this.isScheduled) {
            this.isScheduled = true;
            myPool.addTask(this);
            return true;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void writeReady() {
        if (this.isClosed) {
            return;
        }
        fQueue fQueue2 = this.myQueue;
        synchronized (fQueue2) {
            this.writeReady = true;
            if (this.myQueue.size() != 0) {
                this.queueTask();
            } else if (this.isSuspended) {
                this.queueTask();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void execute() {
        fQueue fQueue2;
        if (this.isSuspended && this.myQueue.size() <= this.myLowWaterMark && !this.isClosed) {
            this.isSuspended = false;
            this.myHandler.reachedLWM();
        }
        fQueue fQueue3 = this.myQueue;
        synchronized (fQueue3) {
            if (this.inUserWrite) {
                return;
            }
            this.inUserWrite = true;
        }
        int n = 0;
        if (this.myQueue.size() == 0 && this.writeReady) {
            try {
                this.myHandler.processObject(null, 1L, true);
                this.writeReady = false;
            }
            catch (IOException iOException) {
            }
            catch (Throwable throwable) {
                fConstants.logger.error("NIOQueue execute - unhandled exception : " + throwable);
                fConstants.logger.debug(throwable);
            }
        }
        while (this.myQueue.size() != 0 && this.myNIOStream.getBufferSize() < 20 && n <= sMyLoopCount && !this.isClosed) {
            try {
                ++n;
                fQueue2 = null;
                int n2 = 0;
                fQueue fQueue4 = this.myQueue;
                synchronized (fQueue4) {
                    if (!this.isClosed) {
                        n2 = this.myQueue.size();
                        fQueue2 = this.myQueue.pop();
                    }
                }
                if (fQueue2 == null) continue;
                this.myHandler.processObject(fQueue2, n2, true);
            }
            catch (IOException iOException) {
            }
            catch (Throwable throwable) {
                fConstants.logger.error("NIOQueue execute/Q -  unhandled exception : " + throwable);
                fConstants.logger.debug(throwable);
            }
        }
        fQueue2 = this.myQueue;
        synchronized (fQueue2) {
            this.inUserWrite = false;
        }
        if (this.myNIOStream.getBufferSize() >= 20) {
            this.writeReady = false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean reQueue() {
        if (this.isClosed) {
            return false;
        }
        boolean bl = false;
        fQueue fQueue2 = this.myQueue;
        synchronized (fQueue2) {
            if (!this.myNIOStream.isWriting() && this.myQueue.size() != 0) {
                bl = true;
            }
            this.isScheduled = bl = bl || this.myQueue.size() != 0 && this.writeReady;
        }
        return bl;
    }
}

