/*
 * Decompiled with CFR 0.152.
 */
package com.pcbsys.foundation.threads;

import com.pcbsys.foundation.collections.Queue;
import com.pcbsys.foundation.collections.fQueue;
import com.pcbsys.foundation.fConstants;
import com.pcbsys.foundation.io.fConnectionSettings;
import com.pcbsys.foundation.threads.fProcessQueue;
import com.pcbsys.foundation.threads.fQueueHandler;
import com.pcbsys.foundation.threads.fTask;
import com.pcbsys.foundation.threads.fThreadPool;
import java.io.IOException;

public class fProcessPooledQueue
extends fProcessQueue
implements fTask {
    public static int sMyMinThreadCount = 5;
    public static int sMyMaxThreadCount = 1000;
    private static fThreadPool sMyWritePool = null;
    private static Object lock = new Object();
    private fQueue myQueue = new Queue(fConnectionSettings.getHWMark());
    private boolean isSuspended = false;
    private boolean isOpen = true;
    private Object myMutex = new Object();
    private boolean isAdded = false;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected static void setupPool() {
        Object object = lock;
        synchronized (object) {
            if (sMyWritePool == null) {
                sMyWritePool = new fThreadPool("WritePool", sMyMinThreadCount, sMyMaxThreadCount, 8);
            }
        }
    }

    public static int getMinThreadCount() {
        return sMyMinThreadCount;
    }

    public static void setMinThreadCount(int n) {
        sMyMinThreadCount = n;
    }

    public static int getMaxThreadCount() {
        return sMyMaxThreadCount;
    }

    public static void setMaxThreadCount(int n) {
        sMyMaxThreadCount = n;
        if (sMyWritePool != null) {
            sMyWritePool.setMaxSize(n);
        }
    }

    public static fThreadPool getWritePool() {
        if (sMyWritePool == null) {
            fProcessPooledQueue.setupPool();
        }
        return sMyWritePool;
    }

    public fProcessPooledQueue(fQueueHandler fQueueHandler2, int n, int n2) {
        this(fQueueHandler2, n, n2, 5, "fProcessThreadedQueue");
    }

    public fProcessPooledQueue(fQueueHandler fQueueHandler2, int n, int n2, int n3, String string) {
        super(fQueueHandler2, n, n2);
        if (sMyWritePool == null) {
            fProcessPooledQueue.setupPool();
        }
    }

    @Override
    public int length() {
        return this.myQueue.size();
    }

    @Override
    public long size() {
        return this.myQueue.size();
    }

    @Override
    public boolean isSuspended() {
        return this.isSuspended;
    }

    @Override
    public void setHighWaterMark(int n) {
        super.setHighWaterMark(n);
    }

    @Override
    public void setLowWaterMark(int n) {
        super.setLowWaterMark(n);
    }

    @Override
    public void push(Object object) {
        this.push(object, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void push(Object object, boolean bl) {
        if (this.myQueue.size() >= this.myHighWaterMark && this.myHighWaterMark != -1 && !this.isSuspended) {
            this.isSuspended = true;
            this.myHandler.reachedHWM();
        }
        Object object2 = this.myMutex;
        synchronized (object2) {
            this.myQueue.put(object);
            if (!this.isAdded) {
                sMyWritePool.addTask(this);
                this.isAdded = true;
            }
        }
    }

    @Override
    public void close() {
        this.isOpen = false;
    }

    @Override
    public void execute() {
        while (this.myQueue.size() != 0) {
            try {
                this.myHandler.processObject(this.pop(), this.length(), true);
            }
            catch (IOException iOException) {
            }
            catch (Throwable throwable) {
                fConstants.logger.error("PooledQueue execute -  unhandled exception : " + throwable);
                fConstants.logger.debug(throwable);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean reQueue() {
        Object object = this.myMutex;
        synchronized (object) {
            this.isAdded = this.myQueue.size() != 0 && this.isOpen;
            return this.isAdded;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Object pop() {
        if (this.isSuspended && this.myQueue.size() <= this.myLowWaterMark && this.myLowWaterMark != -1 && this.isSuspended) {
            this.isSuspended = false;
            this.myHandler.reachedLWM();
        }
        Object object = this.myMutex;
        synchronized (object) {
            return this.myQueue.pop();
        }
    }
}

