/*
 * Decompiled with CFR 0.152.
 */
package com.pcbsys.foundation.threads;

import com.pcbsys.foundation.collections.Queue;
import com.pcbsys.foundation.collections.fQueue;
import com.pcbsys.foundation.fConstants;
import com.pcbsys.foundation.io.fConnectionSettings;
import com.pcbsys.foundation.io.fConnectionWriteHandler;
import com.pcbsys.foundation.threads.fProcessQueue;
import com.pcbsys.foundation.threads.fQueueHandler;
import java.io.IOException;
import java.util.concurrent.atomic.AtomicBoolean;

public class fProcessThreadedQueue
extends fProcessQueue {
    private final fQueue<Object> myQueue;
    private final fQueueHandler myHandler;
    private AtomicBoolean isSuspended = new AtomicBoolean(false);
    private boolean isOpen = true;
    private final boolean canWriteDirect;

    public fProcessThreadedQueue(fQueueHandler fQueueHandler2, int n, int n2) {
        this(fQueueHandler2, n, n2, 5, "fProcessThreadedQueue");
    }

    public fProcessThreadedQueue(fQueueHandler fQueueHandler2, int n, int n2, int n3, String string) {
        this(fQueueHandler2, new Queue(fConnectionSettings.getHWMark()), n, n2, n3, string);
    }

    public fProcessThreadedQueue(fQueueHandler fQueueHandler2, fQueue fQueue2, int n, int n2, int n3, String string) {
        super(fQueueHandler2, n, n2);
        this.myQueue = fQueue2;
        this.myHandler = fQueueHandler2;
        fPump fPump2 = new fPump();
        fPump2.setDaemon(true);
        boolean bl = this.canWriteDirect = fQueueHandler2 instanceof fConnectionWriteHandler && ((fConnectionWriteHandler)fQueueHandler2).directWriteEnabled();
        if (!this.canWriteDirect) {
            fPump2.setPriority(n3);
            fPump2.setName(string);
            fPump2.start();
        }
    }

    @Override
    public int length() {
        return this.myQueue.size();
    }

    @Override
    public long size() {
        return this.myQueue.size();
    }

    @Override
    public boolean isSuspended() {
        return this.isSuspended.get();
    }

    @Override
    public void setHighWaterMark(int n) {
        super.setHighWaterMark(n);
    }

    @Override
    public void setLowWaterMark(int n) {
        super.setLowWaterMark(n);
    }

    @Override
    public void push(Object object) {
        this.push(object, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void push(Object object, boolean bl) {
        if (this.canWriteDirect) {
            this.sendEvent(object);
        } else {
            if (this.myQueue.size() >= this.myHighWaterMark && this.myHighWaterMark != -1 && !this.isSuspended.getAndSet(true)) {
                this.myHandler.reachedHWM();
            }
            fQueue<Object> fQueue2 = this.myQueue;
            synchronized (fQueue2) {
                this.myQueue.put(object);
                if (bl) {
                    this.myQueue.notify();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() {
        this.isOpen = false;
        fQueue<Object> fQueue2 = this.myQueue;
        synchronized (fQueue2) {
            this.myQueue.notifyAll();
        }
    }

    protected void sendEvent(Object object) {
        try {
            this.myHandler.processObject(object, 1L, true);
        }
        catch (IOException iOException) {
        }
        catch (Throwable throwable) {
            fConstants.logger.error("ThreadedQueue sendEvent -  unhandled exception : " + throwable);
            fConstants.logger.debug(throwable);
        }
    }

    private Object pop() {
        if (this.isSuspended.get() && this.myQueue.size() <= this.myLowWaterMark && this.myLowWaterMark != -1 && this.isSuspended.getAndSet(false)) {
            this.myHandler.reachedLWM();
        }
        return this.myQueue.pop();
    }

    private class fPump
    extends Thread {
        fPump() {
            this.setDaemon(true);
            this.setName("fProcessThreadedQueue");
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            while (fProcessThreadedQueue.this.isOpen) {
                Object object = fProcessThreadedQueue.this.myQueue;
                synchronized (object) {
                    while (fProcessThreadedQueue.this.length() == 0 && fProcessThreadedQueue.this.isOpen) {
                        try {
                            fProcessThreadedQueue.this.myQueue.wait(1000L);
                        }
                        catch (InterruptedException interruptedException) {}
                    }
                }
                while (fProcessThreadedQueue.this.length() != 0 && fProcessThreadedQueue.this.isOpen) {
                    object = fProcessThreadedQueue.this.pop();
                    if (object == null) continue;
                    try {
                        fProcessThreadedQueue.this.myHandler.processObject(object, fProcessThreadedQueue.this.length(), true);
                    }
                    catch (IOException iOException) {
                    }
                    catch (Throwable throwable) {
                        fConstants.logger.error("ThreadedQueue run -  unhandled exception : " + throwable);
                        fConstants.logger.debug(throwable);
                    }
                }
            }
        }
    }
}

