/*
 * Decompiled with CFR 0.152.
 */
package com.pcbsys.foundation.threads;

import com.pcbsys.foundation.base.fTimer;
import com.pcbsys.foundation.collections.SortedObject;
import com.pcbsys.foundation.threads.fTask;
import com.pcbsys.foundation.threads.fThreadPool;
import com.pcbsys.foundation.threads.fThreadScheduler;
import java.util.concurrent.atomic.AtomicInteger;

public abstract class fScheduledTask
implements fTask,
SortedObject {
    protected static final int DO_NOT_RESCHEDULE = -1;
    private static final AtomicInteger sUniqueID = new AtomicInteger(0);
    private final int myUniqueId = sUniqueID.getAndIncrement();
    private long myScheduledTime;
    private fThreadScheduler myScheduler;
    private fThreadPool myThreadPool;
    private Exception addedStack;

    public fScheduledTask() {
        this(null);
    }

    public fScheduledTask(fThreadPool fThreadPool2) {
        this.myThreadPool = fThreadPool2;
        this.myScheduledTime = fTimer.getTicks();
    }

    public long getTime() {
        return this.myScheduledTime;
    }

    fThreadPool getThreadPool() {
        return this.myThreadPool;
    }

    void setThreadPool(fThreadPool fThreadPool2) {
        this.myThreadPool = fThreadPool2;
    }

    void scheduleTaskExecution() {
        this.myThreadPool.addTask(this);
    }

    void setTime(long l) {
        this.myScheduledTime = l + fTimer.getTicks();
    }

    public abstract long reSchedule();

    public String getName() {
        return this.getClass().getName();
    }

    @Override
    public boolean reQueue() {
        long l = this.reSchedule();
        if (l != -1L) {
            this.myScheduler.addTask(this, l);
        }
        return false;
    }

    public int getUniqueId() {
        return this.myUniqueId;
    }

    public void setScheduler(fThreadScheduler fThreadScheduler2) {
        this.myScheduler = fThreadScheduler2;
    }

    Exception getAddedStack() {
        return this.addedStack;
    }

    void setAddedStack(Exception exception) {
        this.addedStack = exception;
    }

    int compare(Object object) {
        if (object instanceof Long) {
            Long l = (Long)object;
            return (int)(this.myScheduledTime - l);
        }
        if (object instanceof fScheduledTask) {
            fScheduledTask fScheduledTask2 = (fScheduledTask)object;
            if (this.myScheduledTime == fScheduledTask2.myScheduledTime) {
                return this.myUniqueId - fScheduledTask2.myUniqueId;
            }
            return this.myScheduledTime < fScheduledTask2.myScheduledTime ? -1 : 1;
        }
        return 1;
    }

    public boolean equals(Object object) {
        return object instanceof fScheduledTask && this.compare(object) == 0;
    }

    public int hashCode() {
        return (int)this.myScheduledTime + this.myUniqueId;
    }

    @Override
    public boolean lessThan(Object object) {
        return this.compare(object) < 0;
    }

    @Override
    public boolean equals(long l) {
        return this.myScheduledTime == l;
    }

    @Override
    public boolean lessThan(long l) {
        return this.myScheduledTime < l;
    }
}

