/*
 * Decompiled with CFR 0.152.
 */
package com.pcbsys.foundation.threads;

import com.pcbsys.foundation.base.fBaseApplication;
import com.pcbsys.foundation.base.fMonitor;
import com.pcbsys.foundation.base.fMonitorState;
import com.pcbsys.foundation.base.fMonitorable;
import com.pcbsys.foundation.base.fTimer;
import com.pcbsys.foundation.collections.fCircularQueue;
import com.pcbsys.foundation.fConstants;
import com.pcbsys.foundation.io.fConnectionAsyncReadHandler;
import com.pcbsys.foundation.logger.fLogLevel;
import com.pcbsys.foundation.memory.fMemoryManager;
import com.pcbsys.foundation.threads.fLongLivedTask;
import com.pcbsys.foundation.threads.fProcessPooledQueue;
import com.pcbsys.foundation.threads.fTask;
import com.pcbsys.foundation.threads.fThread;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;

public class fThreadPool
implements fMonitorable {
    private final String LOG_HEADER;
    private static fThreadPool sMyThreadPool = null;
    private final ArrayList<WorkerThread> myThreads;
    private final fCircularQueue<fTask> myTaskQueue;
    private final String myName;
    private final int myPriority;
    private boolean reportStalledTasks;
    private long myTotalAddedTasks;
    private int myIdleThreadCount;
    private int myInitialPoolSize;
    private int myMaxPoolSize;
    private int myThreadCounter;
    private final boolean reportThreadPoolExhaustion;
    private static long idleThreadTimeout = 60000L;
    private static long stalledTaskWarningTime = 60000L;
    private static int pendingTaskErrorThreshold = 1000;
    private static int pendingTaskWarningThreshold = 100;
    private static long slowMovingTasksTimeout = 5000L;
    private static boolean threadDumpOnSlowTask = false;
    private static long threadDumpInterval = 60000L;
    private final AtomicLong lastThreadDumpTime = new AtomicLong(-threadDumpInterval);
    private final AtomicInteger slowMovingTasksSinceStart = new AtomicInteger(0);
    private int stalledCount;
    private boolean threadPoolExhausted;

    public static synchronized fThreadPool getCommonThreadPool() {
        if (sMyThreadPool == null) {
            sMyThreadPool = new fThreadPool("CommonPool", 1, 5);
        }
        return sMyThreadPool;
    }

    public static boolean reportThreadDumpOnSlowTasks() {
        return threadDumpOnSlowTask;
    }

    public static void setThreadDumpOnSlowTask(boolean bl) {
        threadDumpOnSlowTask = bl;
    }

    public static long getSlowMovingTasksTimeout() {
        return slowMovingTasksTimeout;
    }

    public static void setSlowMovingTasksTimeout(long l) {
        slowMovingTasksTimeout = l;
    }

    public static long getThreadDumpInterval() {
        return threadDumpInterval;
    }

    public static void setThreadDumpInterval(long l) {
        threadDumpInterval = l;
    }

    public static void setThreadIdleTimeout(long l) {
        idleThreadTimeout = l;
    }

    public static long getThreadIdleTimeout() {
        return idleThreadTimeout;
    }

    public static fThreadPool getReadPool() {
        return fConnectionAsyncReadHandler.getReadPool();
    }

    public static fThreadPool getWritePool() {
        return fProcessPooledQueue.getWritePool();
    }

    public fThreadPool(String string, int n) {
        this(string, n, n);
    }

    public fThreadPool(String string, int n, int n2) {
        this(string, n, n2, 1);
    }

    public fThreadPool(String string, int n, int n2, int n3) {
        this(string, n, n2, n3, true, true);
    }

    public fThreadPool(String string, int n, int n2, int n3, boolean bl) {
        this(string, n, n2, n3, bl, true);
    }

    public fThreadPool(String string, int n, int n2, int n3, boolean bl, boolean bl2) {
        this.myMaxPoolSize = Math.max(n, n2);
        this.myInitialPoolSize = Math.max(1, n);
        this.myName = string;
        this.LOG_HEADER = "ThreadPool: <" + this.myName + ">";
        this.myPriority = n3;
        this.myThreads = new ArrayList();
        this.myTaskQueue = new fCircularQueue(1024, false, true);
        this.reportThreadPoolExhaustion = bl;
        this.reportStalledTasks = bl2;
        this.initialisePool();
        fMonitor.getInstance().add(this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<fTask> getActiveTasks() {
        ArrayList<fTask> arrayList = new ArrayList<fTask>();
        ArrayList<WorkerThread> arrayList2 = this.myThreads;
        synchronized (arrayList2) {
            for (WorkerThread workerThread : this.myThreads) {
                if (workerThread.task == null) continue;
                arrayList.add(workerThread.task);
            }
        }
        return arrayList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean isPoolMember(Thread thread) {
        ArrayList<WorkerThread> arrayList = this.myThreads;
        synchronized (arrayList) {
            for (int i = 0; i != this.myThreads.size(); ++i) {
                if (!this.myThreads.get(i).isThread(thread)) continue;
                return true;
            }
        }
        return false;
    }

    public static long getStalledTaskWarningTime() {
        return stalledTaskWarningTime;
    }

    public static void setStalledTaskWarningTime(long l) {
        stalledTaskWarningTime = l;
        ArrayList<fThreadPool> arrayList = new ArrayList<fThreadPool>(50);
        Iterator<fMonitorable> iterator = fMonitor.getInstance().list();
        while (iterator.hasNext()) {
            fMonitorable fMonitorable2 = iterator.next();
            if (!(fMonitorable2 instanceof fThreadPool)) continue;
            arrayList.add((fThreadPool)fMonitorable2);
        }
        for (fThreadPool fThreadPool2 : arrayList) {
            fMonitor.getInstance().reSchedule(fThreadPool2);
        }
    }

    public static int getPendingTaskErrorThreshold() {
        return pendingTaskErrorThreshold;
    }

    public static void setPendingTaskErrorThreshold(int n) {
        pendingTaskErrorThreshold = n;
    }

    public static int getPendingTaskWarningThreshold() {
        return pendingTaskWarningThreshold;
    }

    public static void setPendingTaskWarningThreshold(int n) {
        pendingTaskWarningThreshold = n;
    }

    public void setReportStalledTasks(boolean bl) {
        this.reportStalledTasks = bl;
    }

    public int getMaxThreadCount() {
        return this.myMaxPoolSize;
    }

    public String getName() {
        return this.myName;
    }

    public int getIdleCount() {
        return this.myIdleThreadCount;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getTaskQueue() {
        fCircularQueue<fTask> fCircularQueue2 = this.myTaskQueue;
        synchronized (fCircularQueue2) {
            return this.myTaskQueue.size();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close() {
        block9: {
            try {
                fMonitor.getInstance().del(this);
                Object object = this.myThreads;
                synchronized (object) {
                    for (WorkerThread workerThread : this.myThreads) {
                        workerThread.close();
                    }
                }
                object = this.myTaskQueue;
                synchronized (object) {
                    this.myTaskQueue.notifyAll();
                    this.myTaskQueue.reset();
                }
            }
            catch (Throwable throwable) {
                if (!fConstants.logger.isErrorEnabled()) break block9;
                this.log(fLogLevel.ERROR, "Exception while closing the Thread pool.");
                fConstants.logger.error(throwable);
            }
        }
    }

    public void setMaxSize(int n) {
        this.myMaxPoolSize = n;
    }

    public void setMinimumSize(int n) {
        if (this.myMaxPoolSize < n) {
            this.setMaxSize(n);
        }
        this.myInitialPoolSize = n;
        this.initialisePool();
    }

    public int getSize() {
        return this.myThreads.size();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addTask(fTask fTask2) {
        fCircularQueue<fTask> fCircularQueue2 = this.myTaskQueue;
        synchronized (fCircularQueue2) {
            this.myTaskQueue.put(fTask2);
            this.myTaskQueue.notify();
            ++this.myTotalAddedTasks;
        }
    }

    public long getTotalAddedTasks() {
        return this.myTotalAddedTasks;
    }

    @Override
    public long monitorInterval() {
        return stalledTaskWarningTime;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public fMonitorState state() {
        boolean bl = false;
        ArrayList<WorkerThread> arrayList = this.myThreads;
        synchronized (arrayList) {
            if (this.myThreads.size() == 0) {
                this.log(fLogLevel.ERROR, "There are no threads in this pool");
                bl = true;
            }
            if (this.myIdleThreadCount > 0 && this.myThreads.size() > this.myInitialPoolSize) {
                Iterator<WorkerThread> iterator = this.myThreads.iterator();
                while (iterator.hasNext() && this.myThreads.size() > this.myInitialPoolSize) {
                    WorkerThread workerThread = iterator.next();
                    if (!workerThread.closeIfIdle()) continue;
                    iterator.remove();
                }
            }
        }
        if (this.checkForExhaustedPool()) {
            bl = true;
        }
        if (this.checkForStalledTasks() > 0) {
            bl = true;
        }
        if (bl) {
            return fMonitorState.FAIL;
        }
        return fMonitorState.OK;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean reportThreadDump(String string) {
        long l = fTimer.getTicks();
        AtomicLong atomicLong = this.lastThreadDumpTime;
        synchronized (atomicLong) {
            if (l - this.lastThreadDumpTime.get() > fThreadPool.getThreadDumpInterval()) {
                fConstants.logger.log(this.LOG_HEADER + "Requesting thread dump, Reason: " + string);
                fBaseApplication.getApplication().reportThreadPoolStall(this.LOG_HEADER + string);
                this.lastThreadDumpTime.set(fTimer.getTicks());
                return true;
            }
        }
        return false;
    }

    private void log(fLogLevel fLogLevel2, String string) {
        if (fConstants.logger.canLog(fLogLevel2)) {
            fConstants.logger.report(fLogLevel2, this.LOG_HEADER + string + ", Num Threads " + this.getSize() + ", Tasks " + this.myTaskQueue.size() + ", Idle " + this.myIdleThreadCount);
        }
    }

    private boolean checkForExhaustedPool() {
        boolean bl = false;
        if (this.reportThreadPoolExhaustion) {
            if (this.myTaskQueue.size() > fThreadPool.getPendingTaskErrorThreshold()) {
                bl = true;
                this.log(fLogLevel.ERROR, "Pending tasks are above the threshold, " + fThreadPool.getPendingTaskErrorThreshold());
                this.reportThreadDump("Pending tasks are above the threshold, " + fThreadPool.getPendingTaskErrorThreshold());
            } else if (this.myTaskQueue.size() > fThreadPool.getPendingTaskWarningThreshold()) {
                this.log(fLogLevel.WARN, "Pending tasks are above the threshold, " + fThreadPool.getPendingTaskWarningThreshold());
            }
        }
        this.threadPoolExhausted = bl;
        return bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int checkForStalledTasks() {
        int n = 0;
        if (this.reportStalledTasks) {
            ArrayList<WorkerThread> arrayList = this.myThreads;
            synchronized (arrayList) {
                long l = fTimer.getTicks();
                for (WorkerThread workerThread : this.myThreads) {
                    long l2;
                    long l3 = workerThread.getStartTime();
                    fTask fTask2 = workerThread.task;
                    if (l3 == 0L || fTask2 != null && fTask2 instanceof fLongLivedTask || (l2 = l - l3) <= fThreadPool.getStalledTaskWarningTime()) continue;
                    ++n;
                    if (!fConstants.logger.isErrorEnabled()) continue;
                    this.log(fLogLevel.ERROR, "Stalled task found, Thread " + workerThread.getName() + " has been active for " + l2 + "(ms) running task " + (fTask2 != null ? fTask2.getClass().toString() : " null"));
                    this.reportThreadDump("Stalled task detected on this thread pool.");
                }
            }
        }
        this.stalledCount = n;
        return n;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void rectify() throws Exception {
        ArrayList<WorkerThread> arrayList = this.myThreads;
        synchronized (arrayList) {
            long l = fTimer.getTicks();
            Iterator<WorkerThread> iterator = this.myThreads.iterator();
            boolean bl = false;
            while (iterator.hasNext()) {
                WorkerThread workerThread = iterator.next();
                if (l - workerThread.getStartTime() <= fThreadPool.getThreadIdleTimeout() || workerThread.isAlive()) continue;
                this.log(fLogLevel.ERROR, "Thread has died will restart now, task " + (workerThread.task != null ? workerThread.task.getClass() : null) + " Thread Name " + workerThread.getName());
                bl = true;
                iterator.remove();
            }
            if (bl) {
                this.initialisePool();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void initialisePool() {
        ArrayList<WorkerThread> arrayList = this.myThreads;
        synchronized (arrayList) {
            while (this.myThreads.size() < this.myInitialPoolSize) {
                this.addWorkerThread();
            }
        }
    }

    private void addWorkerThread() {
        this.myThreads.add(new WorkerThread(this.myName, this.myThreadCounter++, this.myPriority));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean contains(fTask fTask2) {
        fCircularQueue<fTask> fCircularQueue2 = this.myTaskQueue;
        synchronized (fCircularQueue2) {
            return this.myTaskQueue.contains(fTask2);
        }
    }

    public int getStalledCount() {
        return this.stalledCount;
    }

    public int getSlowMovingTasksSinceStart() {
        return this.slowMovingTasksSinceStart.get();
    }

    public boolean isThreadPoolExhausted() {
        return this.threadPoolExhausted;
    }

    class WorkerThread
    extends fThread {
        volatile boolean canRun = true;
        fTask task = null;
        long lastRun = 0L;
        long startTime = 0L;

        WorkerThread(String string, int n, int n2) {
            this.setDaemon(true);
            this.setPriority(n2);
            this.setName(string + ":" + n);
            this.start();
        }

        public void close() {
            this.canRun = false;
            Thread thread = this.getNative();
            if (thread != null) {
                thread.interrupt();
            }
        }

        long getLastRun() {
            return this.lastRun;
        }

        long getStartTime() {
            return this.startTime;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        boolean closeIfIdle() {
            fCircularQueue fCircularQueue2 = fThreadPool.this.myTaskQueue;
            synchronized (fCircularQueue2) {
                if (this.task == null && fTimer.getTicks() - this.getLastRun() > fThreadPool.getThreadIdleTimeout() || !this.isAlive()) {
                    this.close();
                    return true;
                }
                return false;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void runLoop() {
            while (this.canRun) {
                Object object = fThreadPool.this.myTaskQueue;
                synchronized (object) {
                    fThreadPool.this.myIdleThreadCount++;
                    while (this.canRun && fThreadPool.this.myTaskQueue.size() == 0) {
                        try {
                            fThreadPool.this.myTaskQueue.wait();
                            if (!Thread.currentThread().isInterrupted()) continue;
                            fThreadPool.this.myTaskQueue.notify();
                        }
                        catch (InterruptedException interruptedException) {}
                    }
                    if (!this.canRun) {
                        fThreadPool.this.myIdleThreadCount--;
                        break;
                    }
                    if (fThreadPool.this.myTaskQueue.size() != 0 && this.canRun) {
                        this.task = (fTask)fThreadPool.this.myTaskQueue.get();
                    }
                    fThreadPool.this.myIdleThreadCount--;
                }
                if (fThreadPool.this.myIdleThreadCount == 0) {
                    object = fThreadPool.this.myThreads;
                    synchronized (object) {
                        if (this.canRun && fThreadPool.this.myIdleThreadCount == 0 && fThreadPool.this.myThreads.size() < fThreadPool.this.myMaxPoolSize) {
                            fThreadPool.this.addWorkerThread();
                        }
                    }
                }
                if (this.task == null) continue;
                this.startTime = fTimer.getTicks();
                this.executeTask(this.task);
                this.checkSlowMovingTask();
                object = fThreadPool.this.myTaskQueue;
                synchronized (object) {
                    this.lastRun = fTimer.getTicks();
                    this.startTime = 0L;
                    this.task = null;
                }
            }
        }

        private boolean checkSlowMovingTask() {
            long l;
            if (this.task != null && !(this.task instanceof fLongLivedTask) && (l = fTimer.getTicks() - this.getStartTime()) > fThreadPool.getSlowMovingTasksTimeout()) {
                fThreadPool.this.slowMovingTasksSinceStart.incrementAndGet();
                if (fConstants.logger.isWarningEnabled()) {
                    fThreadPool.this.log(fLogLevel.WARN, " Slow moving task detected. " + this.getName() + " has been active for over " + l + "(ms) running task " + this.task.getClass().toString());
                    if (fThreadPool.reportThreadDumpOnSlowTasks()) {
                        fThreadPool.this.reportThreadDump("Slow moving task detected on this thread pool.");
                    }
                }
                return true;
            }
            return false;
        }

        private void executeTask(fTask fTask2) {
            try {
                fTask2.execute();
            }
            catch (OutOfMemoryError outOfMemoryError) {
                fBaseApplication.getApplication().memoryError("OutOfMemoryException in " + this.getName() + " task " + fTask2.getClass().toString());
                fMemoryManager.getInstance().handleOutOfMemoryException(outOfMemoryError);
            }
            catch (Throwable throwable) {
                fThreadPool.this.log(fLogLevel.ERROR, "Task exception below : " + this.getName() + " task " + fTask2.getClass().toString());
                fConstants.logger.error(throwable);
            }
            try {
                if (fTask2.reQueue()) {
                    fThreadPool.this.addTask(fTask2);
                }
            }
            catch (Throwable throwable) {
                fThreadPool.this.log(fLogLevel.ERROR, "Task exception below : " + this.getName() + " task " + fTask2.getClass().toString());
                fConstants.logger.error(throwable);
            }
        }

        @Override
        public void run() {
            try {
                this.runLoop();
            }
            catch (Throwable throwable) {
                fThreadPool.this.log(fLogLevel.ERROR, "Task's runLoop exception below : " + this.getName() + " task " + this.task.getClass().toString());
                fConstants.logger.error(throwable);
            }
        }
    }
}

