/*
 * Decompiled with CFR 0.152.
 */
package com.pcbsys.foundation.threads;

import com.pcbsys.foundation.base.fMonitor;
import com.pcbsys.foundation.base.fMonitorState;
import com.pcbsys.foundation.base.fMonitorable;
import com.pcbsys.foundation.base.fTimer;
import com.pcbsys.foundation.fConstants;
import com.pcbsys.foundation.threads.Constants;
import com.pcbsys.foundation.threads.fScheduledTask;
import com.pcbsys.foundation.threads.fThreadPool;
import com.pcbsys.foundation.vm.VMHelper;
import java.io.Serializable;
import java.util.Comparator;
import java.util.LinkedHashMap;
import java.util.PriorityQueue;
import java.util.Timer;
import java.util.TimerTask;

public class fThreadScheduler
implements fMonitorable,
Runnable {
    private final PriorityQueue<fScheduledTask> myScheduledTasks;
    private boolean canRun = true;
    private fThreadPool myWorkerPool = new fThreadPool("Scheduler Worker Pool", 2, 10, 5);
    private Thread myThread;
    private Timer myStandardTimer;
    private LinkedHashMap<fScheduledTask, TaskWrapper> myMapping = new LinkedHashMap();
    private static final fThreadScheduler sMySinglton = new fThreadScheduler("Task - Scheduler");

    protected fThreadScheduler(String string) {
        this.myStandardTimer = VMHelper.getTimer("Standard Timer");
        this.myScheduledTasks = new PriorityQueue<fScheduledTask>(11, new TaskComparator());
        this.myThread = VMHelper.allocateThread(this);
        this.myThread.setName(string);
        this.myThread.setDaemon(true);
        this.myThread.start();
        fMonitor.getInstance().add(this);
    }

    public boolean isPoolMember(Thread thread) {
        return this.myWorkerPool.isPoolMember(thread);
    }

    public static fThreadScheduler getInstance() {
        return sMySinglton;
    }

    public synchronized void addReoccuringTask(fScheduledTask fScheduledTask2, long l) {
        TaskWrapper taskWrapper = new TaskWrapper(fScheduledTask2);
        this.myMapping.put(fScheduledTask2, taskWrapper);
        VMHelper.schedule(this.myStandardTimer, taskWrapper, l, l);
    }

    public synchronized void delReoccuringTask(fScheduledTask fScheduledTask2) {
        TaskWrapper taskWrapper = (TaskWrapper)this.myMapping.remove(fScheduledTask2);
        if (taskWrapper != null) {
            taskWrapper.cancel();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void delTask(fScheduledTask fScheduledTask2) {
        PriorityQueue<fScheduledTask> priorityQueue = this.myScheduledTasks;
        synchronized (priorityQueue) {
            this.myScheduledTasks.remove(fScheduledTask2);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addTask(fScheduledTask fScheduledTask2, long l) {
        Serializable serializable;
        if (Constants.sSchedulingDebug) {
            if (this.contains(fScheduledTask2)) {
                if (fScheduledTask2.getAddedStack() != null) {
                    fScheduledTask2.getAddedStack().printStackTrace();
                }
                serializable = new Exception("Already added " + fScheduledTask2.getName());
                ((Throwable)serializable).fillInStackTrace();
                ((Throwable)serializable).printStackTrace();
            }
            fScheduledTask2.setAddedStack(new Exception("Added by " + fScheduledTask2.getName()));
            fScheduledTask2.getAddedStack().fillInStackTrace();
        }
        if (fScheduledTask2.getThreadPool() == null) {
            fScheduledTask2.setThreadPool(this.myWorkerPool);
        }
        serializable = this.myScheduledTasks;
        synchronized (serializable) {
            this.myScheduledTasks.remove(fScheduledTask2);
            fScheduledTask2.setTime(l);
            fScheduledTask2.setScheduler(this);
            this.myScheduledTasks.offer(fScheduledTask2);
            this.myScheduledTasks.notifyAll();
        }
    }

    public void setThreadPoolSize(int n) {
        this.myWorkerPool.setMaxSize(n);
    }

    public int getThreadPoolSize() {
        return this.myWorkerPool.getMaxThreadCount();
    }

    public void close() {
        this.canRun = false;
        this.myWorkerPool.close();
        fMonitor.getInstance().del(this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        long l = -1L;
        while (this.canRun) {
            PriorityQueue<fScheduledTask> priorityQueue = this.myScheduledTasks;
            synchronized (priorityQueue) {
                if (l != -1L || this.myScheduledTasks.size() == 0) {
                    try {
                        this.myScheduledTasks.wait(l >= 0L ? l : Long.MAX_VALUE);
                    }
                    catch (InterruptedException interruptedException) {
                        // empty catch block
                    }
                    l = -1L;
                } else {
                    l = this.myScheduledTasks.peek().getTime();
                    if (l <= fTimer.getTicks()) {
                        this.myScheduledTasks.poll().scheduleTaskExecution();
                        l = -1L;
                    } else if ((l -= fTimer.getTicks()) <= 0L) {
                        l = -1L;
                    }
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public fScheduledTask[] listTasks() {
        PriorityQueue<fScheduledTask> priorityQueue = this.myScheduledTasks;
        synchronized (priorityQueue) {
            return this.myScheduledTasks.toArray(new fScheduledTask[this.myScheduledTasks.size()]);
        }
    }

    public int size() {
        return this.myScheduledTasks.size();
    }

    @Override
    public fMonitorState state() {
        if (this.myThread.isAlive()) {
            return fMonitorState.OK;
        }
        fConstants.logger.error("fThreadScheduler: The main thread for the thread scheduler has exited");
        return fMonitorState.FAIL;
    }

    @Override
    public void rectify() throws Exception {
        if (!this.myThread.isAlive()) {
            this.myThread = VMHelper.allocateThread(this);
            this.myThread.setName("Task - Scheduler");
            this.myThread.setDaemon(true);
            this.myThread.start();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean contains(fScheduledTask fScheduledTask2) {
        PriorityQueue<fScheduledTask> priorityQueue = this.myScheduledTasks;
        synchronized (priorityQueue) {
            return this.myScheduledTasks.contains(fScheduledTask2);
        }
    }

    private static class TaskComparator
    implements Comparator<fScheduledTask> {
        private TaskComparator() {
        }

        @Override
        public int compare(fScheduledTask fScheduledTask2, fScheduledTask fScheduledTask3) {
            return fScheduledTask2.compare(fScheduledTask3);
        }
    }

    private class TaskWrapper
    extends TimerTask {
        private fScheduledTask myTask;

        TaskWrapper(fScheduledTask fScheduledTask2) {
            this.myTask = fScheduledTask2;
        }

        @Override
        public void run() {
            this.myTask.execute();
        }
    }
}

