/*
 * Decompiled with CFR 0.152.
 */
package com.pcbsys.foundation.utils;

public final class NativeAccess {
    private static int freeCPUMask;
    private static int reservedCPUMask;
    private static final int sCPUMask;
    private static int firstFreeCPU;
    private static final Thread[] myReservedThreads;
    private static final int TotalCores;
    private static final boolean isAvailable;

    public static boolean isAvailable() {
        return isAvailable;
    }

    private static boolean init() {
        try {
            System.loadLibrary("NativeAccess");
            System.err.println("Loaded Native Access Library");
        }
        catch (UnsatisfiedLinkError unsatisfiedLinkError) {
            return false;
        }
        return true;
    }

    public static int getCPUMask() {
        return sCPUMask;
    }

    public static int getFreeCPUMask() {
        if (sCPUMask < 0) {
            return sCPUMask;
        }
        return freeCPUMask;
    }

    public static int getReservedCPUMask() {
        if (sCPUMask < 0) {
            return -1;
        }
        return reservedCPUMask;
    }

    public static synchronized void deallocateCPU(int n) {
        if (n < 0) {
            return;
        }
        NativeAccess.myReservedThreads[n] = null;
        reservedCPUMask &= ~(1 << n);
        freeCPUMask += 1 << n;
    }

    public static synchronized int allocateCPU(Thread thread) {
        return -1;
    }

    public static native boolean isVirtualOS();

    public static native boolean affinitySupported();

    public static native boolean setThreadAffinity(int var0);

    public static native void setThreadAffinityMask(long var0, int var2);

    public static native void pause();

    public static native long getLong(long var0);

    public static native void putLong(long var0, long var2);

    public static native long spinWhileEqual(long var0, long var2, long var4);

    public static native long spinWhileNotEqual(long var0, long var2, int var4);

    public static native long spinWhileLessThan(long var0, long var2, int var4);

    public static native long spinWhileLessThanOrEqual(long var0, long var2, int var4);

    public static native long spinWhileMoreThan(long var0, long var2, int var4);

    public static native long spinWhileMoreThanOrEqual(long var0, long var2, int var4);

    static {
        isAvailable = NativeAccess.init();
        TotalCores = firstFreeCPU = Runtime.getRuntime().availableProcessors();
        if (firstFreeCPU > 4) {
            freeCPUMask = sCPUMask = (1 << firstFreeCPU) - 1;
            reservedCPUMask = 0;
            myReservedThreads = new Thread[freeCPUMask];
        } else {
            myReservedThreads = null;
            sCPUMask = -1;
        }
    }
}

