/*
 * Decompiled with CFR 0.152.
 */
package com.pcbsys.foundation.utils;

import com.pcbsys.foundation.utils.fStringByteConverter;

public final class fAsciiEncoder {
    public static final byte[] LONG_MIN_VALUE = new byte[]{45, 57, 50, 50, 51, 51, 55, 50, 48, 51, 54, 56, 53, 52, 55, 55, 53, 56, 48, 56};
    public static final byte[] INT_MIN_VALUE = new byte[]{45, 50, 49, 52, 55, 52, 56, 51, 54, 52, 56};
    public static final byte[] DIGITS = new byte[]{48, 49, 50, 51, 52, 53, 54, 55, 56, 57, 97, 98, 99, 100, 101, 102, 103, 104, 105, 106, 107, 108, 109, 110, 111, 112, 113, 114, 115, 116, 117, 118, 119, 120, 121, 122};
    public static final byte[] DIGIT_TENS = new byte[]{48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 49, 49, 49, 49, 49, 49, 49, 49, 49, 49, 50, 50, 50, 50, 50, 50, 50, 50, 50, 50, 51, 51, 51, 51, 51, 51, 51, 51, 51, 51, 52, 52, 52, 52, 52, 52, 52, 52, 52, 52, 53, 53, 53, 53, 53, 53, 53, 53, 53, 53, 54, 54, 54, 54, 54, 54, 54, 54, 54, 54, 55, 55, 55, 55, 55, 55, 55, 55, 55, 55, 56, 56, 56, 56, 56, 56, 56, 56, 56, 56, 57, 57, 57, 57, 57, 57, 57, 57, 57, 57};
    public static final byte[] DIGIT_ONES = new byte[]{48, 49, 50, 51, 52, 53, 54, 55, 56, 57, 48, 49, 50, 51, 52, 53, 54, 55, 56, 57, 48, 49, 50, 51, 52, 53, 54, 55, 56, 57, 48, 49, 50, 51, 52, 53, 54, 55, 56, 57, 48, 49, 50, 51, 52, 53, 54, 55, 56, 57, 48, 49, 50, 51, 52, 53, 54, 55, 56, 57, 48, 49, 50, 51, 52, 53, 54, 55, 56, 57, 48, 49, 50, 51, 52, 53, 54, 55, 56, 57, 48, 49, 50, 51, 52, 53, 54, 55, 56, 57, 48, 49, 50, 51, 52, 53, 54, 55, 56, 57};

    public static int encodeInt(int n, byte[] byArray) {
        if (Integer.MIN_VALUE == n) {
            int n2 = INT_MIN_VALUE.length;
            System.arraycopy(INT_MIN_VALUE, 0, byArray, byArray.length - n2, n2);
            return n2;
        }
        return fAsciiEncoder.encodeValue(n, byArray);
    }

    public static byte[] encodeInt(int n) {
        int n2 = fAsciiEncoder.IntLengthIf(Math.abs(n));
        if (n < 0) {
            ++n2;
        }
        byte[] byArray = new byte[n2];
        fAsciiEncoder.encodeInt(n, byArray);
        return byArray;
    }

    private static int IntLengthIf(int n) {
        if (n < 10) {
            return 1;
        }
        if (n < 100) {
            return 2;
        }
        if (n < 1000) {
            return 3;
        }
        if (n < 10000) {
            return 4;
        }
        if (n < 100000) {
            return 5;
        }
        if (n < 1000000) {
            return 6;
        }
        if (n < 10000000) {
            return 7;
        }
        if (n < 100000000) {
            return 8;
        }
        if (n < 1000000000) {
            return 9;
        }
        return 10;
    }

    public static int encodeLong(long l, byte[] byArray) {
        if (Long.MIN_VALUE == l) {
            int n = LONG_MIN_VALUE.length;
            System.arraycopy(LONG_MIN_VALUE, 0, byArray, byArray.length - n, n);
            return n;
        }
        return fAsciiEncoder.encodeValue(l, byArray);
    }

    public static byte[] encodeFloat(float f) {
        return fStringByteConverter.convert(String.valueOf(f));
    }

    public static byte[] encodeDouble(double d) {
        return fStringByteConverter.convert(String.valueOf(d));
    }

    private static int encodeValue(long l, byte[] byArray) {
        int n;
        int n2;
        int n3 = byArray.length;
        boolean bl = false;
        if (l < 0L) {
            bl = true;
            l = -l;
        }
        while (l > Integer.MAX_VALUE) {
            long l2 = l / 100L;
            n2 = (int)(l - ((l2 << 6) + (l2 << 5) + (l2 << 2)));
            byArray[--n3] = DIGIT_ONES[n2];
            byArray[--n3] = DIGIT_TENS[n2];
            l = l2;
        }
        int n4 = (int)l;
        while (n4 >= 65536) {
            n = n4 / 100;
            n2 = n4 - ((n << 6) + (n << 5) + (n << 2));
            byArray[--n3] = DIGIT_ONES[n2];
            byArray[--n3] = DIGIT_TENS[n2];
            n4 = n;
        }
        do {
            n = n4 * 52429 >>> 19;
            n2 = n4 - ((n << 3) + (n << 1));
            byArray[--n3] = DIGITS[n2];
        } while (0 != (n4 = n));
        if (bl) {
            byArray[--n3] = 45;
        }
        return n3;
    }

    private static int encodeValue(int n, byte[] byArray) {
        int n2;
        int n3;
        int n4 = byArray.length;
        boolean bl = false;
        if (n < 0) {
            bl = true;
            n = -n;
        }
        while (n >= 65536) {
            n3 = n / 100;
            n2 = n - ((n3 << 6) + (n3 << 5) + (n3 << 2));
            byArray[--n4] = DIGIT_ONES[n2];
            byArray[--n4] = DIGIT_TENS[n2];
            n = n3;
        }
        do {
            n3 = n * 52429 >>> 19;
            n2 = n - ((n3 << 3) + (n3 << 1));
            byArray[--n4] = DIGITS[n2];
        } while (0 != (n = n3));
        if (bl) {
            byArray[--n4] = 45;
        }
        return n4;
    }
}

