/*
 * Decompiled with CFR 0.152.
 */
package com.pcbsys.foundation.utils;

import com.pcbsys.foundation.collections.fOrderedProperties;
import com.pcbsys.foundation.fConstants;
import com.pcbsys.foundation.utils.Base64;
import com.pcbsys.foundation.utils.fStringByteConverter;
import com.pcbsys.foundation.utils.fSystemConfiguration;
import java.io.File;
import java.io.InputStream;
import java.util.StringTokenizer;

public class fEnvironment {
    public static final String CKEYSTORE = "CKEYSTORE";
    public static final String CKEYSTOREPASSWD = "CKEYSTOREPASSWD";
    public static final String CAKEYSTORE = "CAKEYSTORE";
    public static final String CAKEYSTOREPASSWD = "CAKEYSTOREPASSWD";
    private static String myLicenseDir = null;
    private static String myServerDir = null;
    private static String myBaseDir = null;
    private static fOrderedProperties myConfigProps;
    private static String myCoreSpin;
    private static String myCoreCount;
    private static String securityFileLocation;
    private static String myDefaultUsername;
    private static String proxyHost;
    private static int proxyPort;
    private static boolean isDeveloperBuild;
    private static final boolean isWindows;
    private static final boolean isLinux;
    private static final boolean isOSX;

    public static boolean isWindows() {
        return isWindows;
    }

    public static boolean isLinux() {
        return isLinux;
    }

    public static boolean isOSX() {
        return isOSX;
    }

    public static String getUsername() {
        if (myDefaultUsername == null && (myDefaultUsername = fSystemConfiguration.getProperty("user.name", "anonymous")).trim().length() == 0) {
            myDefaultUsername = "anonymous";
        }
        return myDefaultUsername;
    }

    public static void setIsDeveloperBuild(boolean bl) {
        isDeveloperBuild = bl;
    }

    public static boolean isDebugEnabled(String string) {
        boolean bl;
        if (!isDeveloperBuild) {
            return false;
        }
        String string2 = fSystemConfiguration.getProperty("EnableDebug", "none").toLowerCase();
        boolean bl2 = bl = string2.contains("all") || string2.contains(string.toLowerCase());
        if (bl) {
            System.err.println("DEBUG:: Enabling Debug for " + string);
            fConstants.logger.info("DEBUG:: Enabling Debug for " + string);
        }
        return bl;
    }

    public static fOrderedProperties getConfigProps() {
        block6: {
            if (myConfigProps == null) {
                myConfigProps = new fOrderedProperties();
                try {
                    InputStream inputStream = ClassLoader.getSystemResourceAsStream("config.props");
                    if (inputStream == null) break block6;
                    try {
                        myConfigProps.load(inputStream);
                        System.out.println("File config.props found on classpath");
                    }
                    finally {
                        inputStream.close();
                    }
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }
        return myConfigProps;
    }

    public static void setDataDir(String string) {
        fSystemConfiguration.setDataDir(string);
    }

    public static String getDataDir() {
        return fSystemConfiguration.getDataDir();
    }

    public static String getLicenseDir() {
        if (myLicenseDir == null) {
            myLicenseDir = fSystemConfiguration.getProperty("LICENCE_DIR");
            if (myLicenseDir == null) {
                try {
                    myLicenseDir = fEnvironment.getServerDir();
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                }
                if (myLicenseDir == null) {
                    myLicenseDir = ".";
                }
            }
            myLicenseDir = myLicenseDir.replace('/', File.separatorChar);
            myLicenseDir = myLicenseDir.replace('\\', File.separatorChar);
        }
        return myLicenseDir;
    }

    public static String getServerDir() {
        if (myServerDir == null) {
            myServerDir = fSystemConfiguration.getProperty("SERVERDIR");
            if (myServerDir != null) {
                myServerDir = myServerDir.replace('/', File.separatorChar);
                myServerDir = myServerDir.replace('\\', File.separatorChar);
            } else {
                File file = new File(fEnvironment.getDataDir());
                file = file.getAbsoluteFile().getParentFile();
                myServerDir = file.getAbsolutePath();
            }
        }
        return myServerDir;
    }

    public static void setBaseDir(String string) {
        myBaseDir = string;
    }

    public static String getBaseDir() {
        if (myBaseDir == null) {
            myBaseDir = fSystemConfiguration.getProperty("BASEDIR");
            if (myBaseDir == null) {
                try {
                    myBaseDir = fEnvironment.getConfigProps().getProperty("install_dir");
                }
                catch (Exception exception) {
                    myBaseDir = ".";
                }
            }
            myBaseDir = myBaseDir.replace('/', File.separatorChar);
            myBaseDir = myBaseDir.replace('\\', File.separatorChar);
        }
        return myBaseDir;
    }

    public static void setProxyEnvironments() {
        String string = fSystemConfiguration.getProperty("HPROXY");
        if (string != null) {
            if (string.trim().length() > 1) {
                String string2 = fSystemConfiguration.getProperty("HPROXY");
                StringTokenizer stringTokenizer = new StringTokenizer(string2, ":");
                proxyHost = stringTokenizer.nextToken();
                try {
                    proxyPort = Integer.parseInt(stringTokenizer.nextToken());
                }
                catch (Exception exception) {
                    proxyHost = null;
                }
                if (proxyHost != null) {
                    System.getProperties().put("http.proxySet", "true");
                    System.getProperties().put("http.proxyHost", proxyHost);
                    System.getProperties().put("http.proxyPort", "" + proxyPort);
                    System.getProperties().put("https.proxySet", "true");
                    System.getProperties().put("https.proxyHost", proxyHost);
                    System.getProperties().put("https.proxyPort", "" + proxyPort);
                }
            }
        } else {
            proxyHost = fSystemConfiguration.getProperty("http.proxyHost");
            if (proxyHost != null) {
                String string3 = fSystemConfiguration.getProperty("http.proxyPort");
                try {
                    if (string3 != null) {
                        proxyPort = Integer.parseInt(string3);
                    }
                }
                catch (NumberFormatException numberFormatException) {
                    // empty catch block
                }
            }
        }
    }

    @Deprecated
    public static void setSSLEnvironments() {
        String string = fSystemConfiguration.getProperty(CKEYSTORE);
        String string2 = fSystemConfiguration.getProperty(CKEYSTOREPASSWD);
        String string3 = fSystemConfiguration.getProperty(CAKEYSTORE);
        String string4 = fSystemConfiguration.getProperty(CAKEYSTOREPASSWD);
        if (string != null && !string.isEmpty()) {
            System.getProperties().put("javax.net.ssl.keyStore", string);
            System.getProperties().put("java.protocol.handler.pkgs", "javax.net.ssl");
            System.out.println("The \"CKEYSTORE\" system property is deprecated. Consider using \"com.softwareag.um.client.ssl.keystore_path\" instead.");
        }
        if (string2 != null && !string2.isEmpty()) {
            System.getProperties().put("javax.net.ssl.keyStorePassword", string2);
            System.out.println("The \"CKEYSTOREPASSWD\" system property is deprecated. Consider using \"com.softwareag.um.client.ssl.keystore_password\" instead.");
        }
        if (string3 != null && !string3.isEmpty()) {
            System.getProperties().put("javax.net.ssl.trustStore", string3);
            System.out.println("The \"CAKEYSTORE\" system property is deprecated. Consider using \"com.softwareag.um.client.ssl.truststore_path\" instead.");
        }
        if (string4 != null && !string4.isEmpty()) {
            System.getProperties().put("javax.net.ssl.trustStorePassword", string4);
            System.out.println("The \"CAKEYSTOREPASSWD\" system property is deprecated. Consider using \"com.softwareag.um.client.ssl.truststore_password\" instead.");
        }
    }

    public static String getProxyAuthString() {
        String string = fSystemConfiguration.getProperty("HAUTH");
        if (string != null) {
            string = string.contains(":") && string.trim().length() > 1 ? Base64.encode(fStringByteConverter.convert(string)) : null;
        }
        return string;
    }

    public static String getProxyHost() {
        return proxyHost;
    }

    public static int getProxyPort() {
        return proxyPort;
    }

    public static void setCoreSpin(boolean bl) {
        myCoreSpin = bl ? "true" : "false";
    }

    public static String getCoreSpin() {
        return myCoreSpin;
    }

    public static void setCoreCount(int n) {
        myCoreCount = "" + n;
    }

    public static String getCoreCount() {
        return myCoreCount;
    }

    public static void setSecurityFileLocation(String string) {
        securityFileLocation = string;
    }

    public static String getSecurityFileLocation() {
        return securityFileLocation;
    }

    static {
        myCoreSpin = "false";
        myCoreCount = "8";
        proxyHost = null;
        proxyPort = -1;
        isDeveloperBuild = false;
        String string = fSystemConfiguration.getProperty("os.name").toLowerCase();
        isWindows = string.contains("windows");
        isLinux = string.contains("nix");
        isOSX = string.contains("os x");
    }
}

