/*
 * Decompiled with CFR 0.152.
 */
package com.pcbsys.foundation.utils;

import com.pcbsys.foundation.utils.Base64;
import com.pcbsys.foundation.utils.fEnvironment;
import com.pcbsys.foundation.utils.fStringByteConverter;
import com.pcbsys.foundation.utils.fSystemConfiguration;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.net.HttpURLConnection;
import java.net.URL;
import java.net.URLConnection;
import java.util.BitSet;
import java.util.List;
import java.util.StringTokenizer;

public class fHTTPAuthentication {
    private String myURL;
    private String myPassword;
    private String myUsername;
    private String myAuthUser;
    private int[] myGroupId;
    private String[] myGroupName;
    private String myHomeId;
    private String[] myGroupDesc;
    private String myToken;
    private BitSet myPerms;
    private String myDesc;
    private boolean isValid;
    public static final int BASIC = 0;
    public static final int DIGEST = 1;
    public static final int FORM = 2;

    public fHTTPAuthentication(String string, String string2, String string3, int n) throws IOException {
        this(string, string2, string3, false, n);
    }

    public fHTTPAuthentication(String string, String string2, String string3, boolean bl, int n) throws IOException {
        if (n > 2 | n < 0) {
            throw new IOException("Unknown authentication type, must be basic, digest or form");
        }
        this.myURL = string;
        this.myUsername = string2;
        String string4 = this.myUsername + ":" + string3;
        this.myPassword = Base64.encode(fStringByteConverter.convert(string4));
        this.myPerms = new BitSet(64);
        this.myToken = null;
        if (n == 0 || n == 1) {
            this.check(bl);
        } else {
            try {
                this.performServletLogin(string2, string3, string);
            }
            catch (Exception exception) {
                IOException iOException = new IOException("Error during cloud authentication. Details: " + exception.getMessage());
                iOException.initCause(exception);
                throw iOException;
            }
        }
    }

    public fHTTPAuthentication(URLConnection uRLConnection) throws IOException {
        this.myPerms = new BitSet(64);
        this.set(uRLConnection);
    }

    public boolean isValid() {
        return this.isValid;
    }

    private String getHeaderField(URLConnection uRLConnection, String string) {
        if (uRLConnection.getHeaderField(string) == null) {
            return uRLConnection.getHeaderField(string.toLowerCase());
        }
        return uRLConnection.getHeaderField(string);
    }

    protected void performServletLogin(String string, String string2, String string3) throws Exception {
        block14: {
            String string4 = fSystemConfiguration.getProperty("USERNAME_PARAMETER_NAME", "login");
            String string5 = fSystemConfiguration.getProperty("PASSWORD_PARAMETER_NAME", "password");
            String string6 = fSystemConfiguration.getProperty("COOKIE_NAME", "mcsessionid");
            boolean bl = false;
            if (fSystemConfiguration.getProperty("FOLLOW_REDIRECTS") != null) {
                bl = Boolean.parseBoolean(fSystemConfiguration.getProperty("FOLLOW_REDIRECTS"));
            }
            String string7 = "index.html";
            URL uRL = new URL(string3);
            URLConnection uRLConnection = uRL.openConnection();
            String string8 = fEnvironment.getProxyAuthString();
            if (string8 != null && string8.trim().length() > 0) {
                uRLConnection.setRequestProperty("Proxy-Authorization", "Basic " + string8);
            }
            uRLConnection.setDoOutput(true);
            uRLConnection.setDoInput(true);
            uRLConnection.setUseCaches(false);
            HttpURLConnection httpURLConnection = (HttpURLConnection)uRLConnection;
            httpURLConnection.setReadTimeout(30000);
            httpURLConnection.setAllowUserInteraction(false);
            httpURLConnection.setInstanceFollowRedirects(bl);
            OutputStream outputStream = httpURLConnection.getOutputStream();
            PrintWriter printWriter = new PrintWriter(outputStream);
            printWriter.write(string4 + "=" + string + "&" + string5 + "=" + string2 + "&success_redirect=" + string7);
            printWriter.flush();
            printWriter.close();
            this.myToken = this.getCookie(string6, uRLConnection);
            if (this.myToken != null) {
                String string9;
                String string10;
                this.isValid = true;
                this.myDesc = this.getHeaderField(uRLConnection, "userDesc");
                fHTTPAuthentication.loadPerms(this.myPerms, this.getHeaderField(uRLConnection, "userPerms"));
                String string11 = this.getHeaderField(uRLConnection, "groupName");
                StringTokenizer stringTokenizer = null;
                if (string11 != null) {
                    stringTokenizer = new StringTokenizer(string11, ",");
                    this.myGroupName = new String[stringTokenizer.countTokens()];
                    int n = 0;
                    while (stringTokenizer.hasMoreElements()) {
                        this.myGroupName[n] = stringTokenizer.nextToken();
                        ++n;
                    }
                    string10 = this.getHeaderField(uRLConnection, "groupDesc");
                    stringTokenizer = new StringTokenizer(string10, ",");
                    this.myGroupDesc = new String[stringTokenizer.countTokens()];
                    n = 0;
                    while (stringTokenizer.hasMoreElements()) {
                        this.myGroupDesc[n] = stringTokenizer.nextToken();
                        ++n;
                    }
                }
                if ((string9 = this.getHeaderField(uRLConnection, "groupId")) != null) {
                    stringTokenizer = new StringTokenizer(string9, ",");
                    this.myGroupId = new int[stringTokenizer.countTokens()];
                    int n = 0;
                    while (stringTokenizer.hasMoreElements()) {
                        this.myGroupId[n] = Integer.parseInt(stringTokenizer.nextToken());
                        ++n;
                    }
                }
                this.myHomeId = this.getHeaderField(uRLConnection, "homeId");
                try {
                    uRLConnection.getInputStream().close();
                }
                catch (IOException iOException) {
                    // empty catch block
                }
                string10 = this.getHeaderField(uRLConnection, "Location");
                if (string10 != null && bl) {
                    URL uRL2 = new URL(string10);
                    URLConnection uRLConnection2 = uRL2.openConnection();
                    if (string8 != null && string8.trim().length() > 0) {
                        uRLConnection2.setRequestProperty("Proxy-Authorization", "Basic " + string8);
                    }
                    uRLConnection2.setRequestProperty("Cookie", this.getHeaderField(httpURLConnection, "Set-Cookie"));
                    HttpURLConnection httpURLConnection2 = (HttpURLConnection)uRLConnection2;
                    httpURLConnection2.setInstanceFollowRedirects(false);
                    httpURLConnection2.setUseCaches(false);
                }
                break block14;
            }
            String string12 = "Login request not valid for auth user " + string + " [" + string + "]";
            throw new Exception(string12);
        }
    }

    private void check(boolean bl) throws IOException {
        URL uRL = null;
        uRL = bl ? new URL(this.myURL + "?Token=true") : new URL(this.myURL);
        URLConnection uRLConnection = uRL.openConnection();
        String string = fEnvironment.getProxyAuthString();
        uRLConnection.setRequestProperty("Proxy-Authorization", "Basic " + string);
        uRLConnection.setRequestProperty("Authorization", "Basic " + this.myPassword);
        try {
            InputStream inputStream = uRLConnection.getInputStream();
            byte[] byArray = new byte[1024];
            try {
                while (inputStream.read(byArray) != -1) {
                }
            }
            catch (IOException iOException) {
                // empty catch block
            }
            String string2 = uRLConnection.getHeaderField(0);
            this.myAuthUser = this.getCookie("AUTHUSER", uRLConnection);
            if (string2.indexOf("OK") != -1) {
                if (!this.myAuthUser.equals(this.myUsername)) {
                    this.isValid = false;
                    return;
                }
                this.isValid = true;
                if (bl) {
                    this.myToken = uRLConnection.getHeaderField("token");
                }
                this.myDesc = uRLConnection.getHeaderField("userDesc");
                fHTTPAuthentication.loadPerms(this.myPerms, uRLConnection.getHeaderField("userPerms"));
                String string3 = uRLConnection.getHeaderField("groupName");
                StringTokenizer stringTokenizer = new StringTokenizer(string3, ",");
                this.myGroupName = new String[stringTokenizer.countTokens()];
                int n = 0;
                while (stringTokenizer.hasMoreElements()) {
                    this.myGroupName[n] = stringTokenizer.nextToken();
                    ++n;
                }
                String string4 = uRLConnection.getHeaderField("groupDesc");
                stringTokenizer = new StringTokenizer(string4, ",");
                this.myGroupDesc = new String[stringTokenizer.countTokens()];
                n = 0;
                while (stringTokenizer.hasMoreElements()) {
                    this.myGroupDesc[n] = stringTokenizer.nextToken();
                    ++n;
                }
                String string5 = uRLConnection.getHeaderField("groupId");
                stringTokenizer = new StringTokenizer(string5, ",");
                this.myGroupId = new int[stringTokenizer.countTokens()];
                n = 0;
                while (stringTokenizer.hasMoreElements()) {
                    this.myGroupId[n] = Integer.parseInt(stringTokenizer.nextToken());
                    ++n;
                }
                this.myHomeId = uRLConnection.getHeaderField("homeId");
                try {
                    inputStream.close();
                }
                catch (IOException iOException) {
                    // empty catch block
                }
                return;
            }
            this.isValid = false;
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        this.isValid = false;
    }

    private void set(URLConnection uRLConnection) throws IOException {
        try {
            String string = uRLConnection.getHeaderField(0);
            this.myDesc = uRLConnection.getHeaderField("userDesc");
            fHTTPAuthentication.loadPerms(this.myPerms, uRLConnection.getHeaderField("userPerms"));
            String string2 = "";
            if (uRLConnection.getHeaderField("groupName") != null) {
                string2 = uRLConnection.getHeaderField("groupName");
            }
            StringTokenizer stringTokenizer = new StringTokenizer(string2, ",");
            this.myGroupName = new String[stringTokenizer.countTokens()];
            int n = 0;
            while (stringTokenizer.hasMoreElements()) {
                this.myGroupName[n] = stringTokenizer.nextToken();
                ++n;
            }
            String string3 = "";
            if (uRLConnection.getHeaderField("groupDesc") != null) {
                string3 = uRLConnection.getHeaderField("groupDesc");
            }
            stringTokenizer = new StringTokenizer(string3, ",");
            this.myGroupDesc = new String[stringTokenizer.countTokens()];
            n = 0;
            while (stringTokenizer.hasMoreElements()) {
                this.myGroupDesc[n] = stringTokenizer.nextToken();
                ++n;
            }
            String string4 = "";
            if (uRLConnection.getHeaderField("groupId") != null) {
                string4 = uRLConnection.getHeaderField("groupId");
            }
            stringTokenizer = new StringTokenizer(string4, ",");
            this.myGroupId = new int[stringTokenizer.countTokens()];
            n = 0;
            while (stringTokenizer.hasMoreElements()) {
                this.myGroupId[n] = Integer.parseInt(stringTokenizer.nextToken());
                ++n;
            }
            this.myHomeId = uRLConnection.getHeaderField("homeId");
            return;
        }
        catch (Exception exception) {
            exception.printStackTrace();
            this.isValid = false;
            return;
        }
    }

    public int[] getGroupId() {
        return this.myGroupId;
    }

    public String[] getGroupName() {
        return this.myGroupName;
    }

    public String getHomeId() {
        return this.myHomeId;
    }

    public String[] getGroupDesc() {
        return this.myGroupDesc;
    }

    public BitSet getPermissions() {
        return this.myPerms;
    }

    public String getDescription() {
        return this.myDesc;
    }

    public String getToken() {
        return this.myToken;
    }

    public String getAuthUser() {
        return this.myAuthUser;
    }

    public String getCookie(String string, URLConnection uRLConnection) {
        Object[] objectArray = uRLConnection.getHeaderFields().keySet().toArray();
        Object[] objectArray2 = uRLConnection.getHeaderFields().values().toArray();
        String string2 = null;
        for (int i = 0; i < objectArray.length; ++i) {
            try {
                String string3 = (String)objectArray[i];
                if (!string3.equalsIgnoreCase("Set-Cookie")) continue;
                List list = (List)objectArray2[i];
                Object[] objectArray3 = list.toArray();
                for (int j = 0; j < objectArray3.length; ++j) {
                    String string4 = (String)objectArray3[j];
                    int n = string4.indexOf(";");
                    while (n != -1) {
                        String string5 = string4.substring(0, n);
                        if (string5.indexOf(string) != -1) {
                            string2 = string5.substring(string5.indexOf("=") + 1);
                            return string2;
                        }
                        if ((n = (string4 = string4.substring(n + 2)).indexOf(";")) != -1 || string4.indexOf(string) == -1) continue;
                        string2 = string4.substring(string4.indexOf("=") + 1);
                        return string2;
                    }
                }
                continue;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return string2;
    }

    protected static void loadPerms(BitSet bitSet, String string) {
        int n = string.indexOf("{");
        if (n != -1) {
            string = string.substring(n + 1);
        }
        if ((n = string.indexOf("}")) != -1) {
            string = string.substring(0, n);
        }
        StringTokenizer stringTokenizer = new StringTokenizer(string, ",");
        while (stringTokenizer.hasMoreElements()) {
            String string2 = (String)stringTokenizer.nextElement();
            string2 = string2.trim();
            int n2 = Integer.parseInt(string2);
            bitSet.set(n2);
        }
    }
}

