/*
 * Decompiled with CFR 0.152.
 */
package com.pcbsys.foundation.utils;

import com.pcbsys.foundation.drivers.fDriver;
import com.pcbsys.foundation.drivers.fSocketDriver;
import com.pcbsys.foundation.drivers.fURLDriver;
import com.pcbsys.foundation.fConstants;
import java.net.Inet4Address;
import java.net.Inet6Address;
import java.net.InetAddress;
import java.net.NetworkInterface;
import java.net.SocketException;
import java.net.UnknownHostException;
import java.util.Enumeration;

public class fResolveLocalInterface {
    public static NetworkInterface resolveLocalInterface(fDriver fDriver2, boolean bl) throws SocketException {
        if (fDriver2 instanceof fSocketDriver) {
            return fResolveLocalInterface.checkValidInterface(NetworkInterface.getByInetAddress(((fSocketDriver)fDriver2).getLocalAddress()), bl);
        }
        if (fDriver2 instanceof fURLDriver) {
            fConstants.logger.error("Unable to resolve local interface whilst running NHP, please change protocol to NSP or set -DBindingInterface environment parameter.");
        }
        return fResolveLocalInterface.findPossibleValidInterface(bl);
    }

    public static NetworkInterface resolveLocalInterface(String string, boolean bl) throws SocketException, UnknownHostException {
        return fResolveLocalInterface.checkValidInterface(NetworkInterface.getByInetAddress(InetAddress.getByName(string)), bl);
    }

    private static NetworkInterface checkValidInterface(NetworkInterface networkInterface, boolean bl) throws SocketException {
        if (networkInterface.supportsMulticast()) {
            Enumeration<InetAddress> enumeration = networkInterface.getInetAddresses();
            while (enumeration.hasMoreElements()) {
                InetAddress inetAddress = enumeration.nextElement();
                if ((!(inetAddress instanceof Inet6Address) || !bl) && (!(inetAddress instanceof Inet4Address) || bl)) continue;
                return networkInterface;
            }
        }
        return fResolveLocalInterface.findPossibleValidInterface(bl);
    }

    private static NetworkInterface findPossibleValidInterface(boolean bl) throws SocketException {
        Enumeration<NetworkInterface> enumeration = NetworkInterface.getNetworkInterfaces();
        while (enumeration.hasMoreElements()) {
            NetworkInterface networkInterface = enumeration.nextElement();
            if (!networkInterface.supportsMulticast()) continue;
            Enumeration<InetAddress> enumeration2 = networkInterface.getInetAddresses();
            while (enumeration2.hasMoreElements()) {
                InetAddress inetAddress = enumeration2.nextElement();
                if ((!(inetAddress instanceof Inet6Address) || !bl) && (!(inetAddress instanceof Inet4Address) || bl)) continue;
                return networkInterface;
            }
        }
        return null;
    }
}

