/*
 * Decompiled with CFR 0.152.
 */
package com.pcbsys.foundation.utils;

import com.pcbsys.foundation.base.fTimer;
import com.pcbsys.foundation.drivers.fConnectionDetails;
import com.pcbsys.foundation.fConstants;
import com.pcbsys.foundation.logger.fLogLevel;
import java.net.InetAddress;
import java.net.NetworkInterface;
import java.net.SocketException;
import java.net.UnknownHostException;
import java.util.Arrays;
import java.util.Collection;
import java.util.Enumeration;
import java.util.HashSet;

public class fReverseDNSUtility {
    private static final long sDNSLookupWarningThreshold = 10000L;
    private static final String IPV4_LOOPBACK = "127.0.0.1";
    private static final String IPV6_LOOPBACK = "::1";

    public static String resolveAddress(String string) {
        try {
            return fReverseDNSUtility.resolveAddress(InetAddress.getByName(string));
        }
        catch (UnknownHostException unknownHostException) {
            if (fConstants.logger.canLog(fLogLevel.ERROR)) {
                fConstants.logger.error("Error: Failed to perform DNS lookup for " + string + " entry is in the wrong format");
            }
            return string;
        }
    }

    public static String resolveAddress(InetAddress inetAddress) {
        String string;
        if (fConnectionDetails.sEnableReverseDNSLookups) {
            boolean bl;
            long l = fTimer.getTicks();
            try {
                string = inetAddress.getCanonicalHostName();
                bl = true;
            }
            catch (Exception exception) {
                string = inetAddress.getHostAddress();
                bl = false;
            }
            l = fTimer.getTicks() - l;
            if (l > 10000L && fConstants.logger.canLog(fLogLevel.ERROR)) {
                fConstants.logger.error("Warning: DNS Lookup for connection " + inetAddress + " took " + l + "ms, success = " + bl + ", resolved name = " + string);
            }
        } else {
            string = inetAddress.getHostAddress();
        }
        return string;
    }

    public static Collection<String> getLocalHosts() {
        try {
            HashSet<String> hashSet = new HashSet<String>();
            Enumeration<NetworkInterface> enumeration = NetworkInterface.getNetworkInterfaces();
            if (enumeration.hasMoreElements()) {
                do {
                    NetworkInterface networkInterface = enumeration.nextElement();
                    Enumeration<InetAddress> enumeration2 = networkInterface.getInetAddresses();
                    while (enumeration2.hasMoreElements()) {
                        InetAddress inetAddress = enumeration2.nextElement();
                        if (!inetAddress.isLoopbackAddress()) continue;
                        hashSet.add(fReverseDNSUtility.sanitiseV6(inetAddress.getHostName()));
                        hashSet.add(fReverseDNSUtility.sanitiseV6(inetAddress.getHostAddress()));
                    }
                } while (enumeration.hasMoreElements());
                return hashSet;
            }
        }
        catch (SocketException socketException) {
            fConstants.logger.warn("Unable to get network interface information: ", socketException);
        }
        return fReverseDNSUtility.getAliases(Arrays.asList(IPV4_LOOPBACK, IPV6_LOOPBACK));
    }

    private static Collection<String> getAliases(Collection<String> collection) {
        HashSet<String> hashSet = new HashSet<String>();
        for (String string : collection) {
            try {
                InetAddress inetAddress = InetAddress.getByName(string);
                hashSet.add(fReverseDNSUtility.sanitiseV6(inetAddress.getCanonicalHostName()));
                hashSet.add(fReverseDNSUtility.sanitiseV6(inetAddress.getHostName()));
                hashSet.add(fReverseDNSUtility.sanitiseV6(inetAddress.getHostAddress()));
            }
            catch (UnknownHostException unknownHostException) {
                fConstants.logger.warn("Unable to resolve host " + string, unknownHostException);
            }
        }
        return hashSet;
    }

    public static String sanitiseV6(String string) {
        if (string == null) {
            return null;
        }
        if (string.contains("@")) {
            String[] stringArray = string.split("@");
            if (stringArray.length != 2) {
                fConstants.logger.error("Unexpected subject/address format: " + string);
                return string;
            }
            return stringArray[0] + "@" + stringArray[1].split("%")[0];
        }
        return string.split("%")[0];
    }
}

