/*
 * Decompiled with CFR 0.152.
 */
package com.pcbsys.foundation.utils;

import com.pcbsys.foundation.collections.fOrderedProperties;
import com.pcbsys.foundation.utils.fEnvironment;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.nio.file.Path;
import java.nio.file.Paths;

public class fSystemConfiguration {
    private static final boolean isApplet;
    private static String myDataDir;
    private static fOrderedProperties myConfigProps;

    public static String getProperty(String string) {
        return fSystemConfiguration.getProperty(string, null);
    }

    public static String getProperty(String string, String string2) {
        if (isApplet) {
            return string2;
        }
        String string3 = System.getProperty(string);
        if (string3 == null) {
            try {
                string3 = myConfigProps.getProperty(string);
            }
            catch (Exception exception) {
                string3 = string2;
            }
        }
        return string3;
    }

    public static long getLong(String string, long l) {
        if (isApplet) {
            return l;
        }
        long l2 = l;
        String string2 = fSystemConfiguration.getSystemProperty(string);
        if (string2 != null) {
            try {
                l2 = Long.parseLong(string2);
            }
            catch (NumberFormatException numberFormatException) {
                System.err.println("Could not parse system property. Property name: " + string + ", value: " + string2);
            }
        }
        return l2;
    }

    public static int getInt(String string, int n) {
        if (isApplet) {
            return n;
        }
        int n2 = n;
        String string2 = fSystemConfiguration.getSystemProperty(string);
        if (string2 != null) {
            try {
                n2 = Integer.parseInt(string2);
            }
            catch (NumberFormatException numberFormatException) {
                System.err.println("Could not parse system property. Property name: " + string + ", value: " + string2);
            }
        }
        return n2;
    }

    public static boolean getBoolean(String string, boolean bl) {
        if (isApplet) {
            return bl;
        }
        boolean bl2 = bl;
        String string2 = fSystemConfiguration.getSystemProperty(string);
        if (string2 != null) {
            bl2 = Boolean.parseBoolean(string2);
        }
        return bl2;
    }

    private static String getSystemProperty(String string) {
        String string2 = System.getProperty(string);
        if (string2 == null) {
            try {
                string2 = myConfigProps.getProperty(string);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return string2;
    }

    public static boolean isAnApplet() {
        return isApplet;
    }

    static String getDataDir() {
        return myDataDir;
    }

    static void setDataDir(String string) {
        Path path;
        myDataDir = string;
        if (myDataDir == null) {
            myDataDir = fSystemConfiguration.getDataDir();
            if (myDataDir == null) {
                try {
                    myDataDir = fEnvironment.getConfigProps().getProperty("data_dir");
                    System.out.println("Property data_dir found.");
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            if (myDataDir == null) {
                myDataDir = ".";
            }
        }
        if (!(path = Paths.get(myDataDir, new String[0])).endsWith("data")) {
            path = path.resolve("data");
        }
        myDataDir = path.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static {
        boolean bl = false;
        SecurityManager securityManager = System.getSecurityManager();
        if (securityManager != null) {
            try {
                securityManager.checkPropertiesAccess();
            }
            catch (SecurityException securityException) {
                bl = true;
            }
        }
        isApplet = bl;
        myConfigProps = new fOrderedProperties();
        myDataDir = fSystemConfiguration.getProperty("DATADIR");
        fSystemConfiguration.setDataDir(myDataDir);
        File file = new File(fSystemConfiguration.getProperty("UM_CONFIGURATION_FILE", myDataDir + File.separatorChar + "data" + File.separatorChar + "configure.props"));
        if (file.exists()) {
            BufferedInputStream bufferedInputStream = null;
            try {
                bufferedInputStream = new BufferedInputStream(new FileInputStream(file));
                myConfigProps.load(bufferedInputStream);
            }
            catch (Exception exception) {
            }
            finally {
                if (bufferedInputStream != null) {
                    try {
                        bufferedInputStream.close();
                    }
                    catch (IOException iOException) {}
                }
            }
        }
    }
}

