/*
 * Decompiled with CFR 0.152.
 */
package com.pcbsys.foundation.utils;

import com.pcbsys.foundation.base.fFile;
import com.pcbsys.foundation.fConstants;
import com.pcbsys.foundation.utils.xmlHelperImpl;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.OutputStream;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.xml.sax.ErrorHandler;
import org.xml.sax.SAXParseException;

public class genericxmlHelperImpl
implements xmlHelperImpl {
    private Document idoc = null;

    public genericxmlHelperImpl() {
    }

    public genericxmlHelperImpl(File file) {
        try {
            DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactory.newInstance();
            documentBuilderFactory.setValidating(true);
            documentBuilderFactory.setNamespaceAware(true);
            documentBuilderFactory.setFeature("http://apache.org/xml/features/disallow-doctype-decl", true);
            documentBuilderFactory.setFeature("http://apache.org/xml/features/nonvalidating/load-external-dtd", false);
            DocumentBuilder documentBuilder = documentBuilderFactory.newDocumentBuilder();
            this.idoc = documentBuilder.parse(fFile.openFileInputStream(file));
        }
        catch (Exception exception) {
            fConstants.logger.error("XML failure on file=" + file + " - " + exception);
        }
    }

    public genericxmlHelperImpl(Document document) {
        this.idoc = document;
    }

    @Override
    public Document getDoc() {
        if (this.idoc != null) {
            return this.idoc;
        }
        return null;
    }

    @Override
    public void setDoc(Document document) {
        this.idoc = document;
    }

    protected ErrorHandler getErrorHandler() {
        XMLErrorHandler xMLErrorHandler = new XMLErrorHandler(new ErrorHandler(){

            @Override
            public void warning(SAXParseException sAXParseException) throws SAXParseException {
                fConstants.logger.warn("XMLHelper Parsing Warning - " + sAXParseException);
            }

            @Override
            public void error(SAXParseException sAXParseException) throws SAXParseException {
                fConstants.logger.error("XMLHelper Parsing Failure - " + sAXParseException);
            }

            @Override
            public void fatalError(SAXParseException sAXParseException) throws SAXParseException {
                fConstants.logger.fatal("XMLHelper Parsing Fatal Error - " + sAXParseException);
            }
        });
        return (ErrorHandler)xMLErrorHandler.getActualHandler();
    }

    @Override
    public byte[] encode() {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream(5000);
        if (this.idoc != null) {
            try {
                DOMSource dOMSource = new DOMSource(this.idoc);
                StreamResult streamResult = new StreamResult(byteArrayOutputStream);
                Transformer transformer = TransformerFactory.newInstance().newTransformer();
                transformer.transform(dOMSource, streamResult);
            }
            catch (Exception exception) {
                fConstants.logger.error("Failed to encode XML - " + exception);
            }
            return byteArrayOutputStream.toByteArray();
        }
        return null;
    }

    @Override
    public void decode(byte[] byArray) {
        try {
            DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactory.newInstance();
            documentBuilderFactory.setValidating(true);
            documentBuilderFactory.setNamespaceAware(true);
            DocumentBuilder documentBuilder = documentBuilderFactory.newDocumentBuilder();
            documentBuilder.setErrorHandler(this.getErrorHandler());
            this.idoc = documentBuilder.parse(new ByteArrayInputStream(byArray));
            this.idoc.normalizeDocument();
        }
        catch (Exception exception) {
            fConstants.logger.error("Failed to decode XML bytestream - " + exception);
        }
    }

    @Override
    public void dumpDoc(OutputStream outputStream) {
        if (this.idoc != null) {
            try {
                StreamResult streamResult = new StreamResult(outputStream);
                Transformer transformer = TransformerFactory.newInstance().newTransformer();
                transformer.transform(new DOMSource(this.idoc), streamResult);
            }
            catch (Exception exception) {
                fConstants.logger.error("Failed to dump XML - " + exception);
            }
        }
    }

    @Override
    public void dumpDoc() {
        this.dumpDoc(System.out);
    }

    @Override
    public String getDocumentName() {
        return this.getDocumentName(this.idoc);
    }

    private String getDocumentName(Node node) {
        if (node.getNodeType() == 9) {
            Node node2 = node.getFirstChild();
            return node2.getLocalName();
        }
        Node node3 = node.getFirstChild();
        String string = null;
        while (node3 != null) {
            string = this.getDocumentName(node3);
            if (string != null) continue;
            node3 = node3.getNextSibling();
        }
        return null;
    }

    private static class XMLErrorHandler {
        private final Object myObject;

        public XMLErrorHandler(Object object) {
            this.myObject = object;
        }

        public Object getActualHandler() {
            return this.myObject;
        }
    }
}

