/*
 * Decompiled with CFR 0.152.
 */
package com.pcbsys.foundation.vm;

import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Timer;
import java.util.TimerTask;
import java.util.concurrent.Callable;
import java.util.concurrent.FutureTask;

public class VMHelper {
    private static LinkedHashMap<String, Timer> myTimers = new LinkedHashMap();

    public static boolean supportsJMX() {
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Timer getTimer(String string) {
        LinkedHashMap<String, Timer> linkedHashMap = myTimers;
        synchronized (linkedHashMap) {
            Timer timer = myTimers.get(string);
            if (timer == null) {
                timer = new Timer(string, true);
            }
            myTimers.put(string, timer);
            return timer;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void cancelTimer(Timer timer) {
        LinkedHashMap<String, Timer> linkedHashMap = myTimers;
        synchronized (linkedHashMap) {
            Iterator<Timer> iterator = myTimers.values().iterator();
            while (iterator.hasNext()) {
                if (iterator.next() != timer) continue;
                iterator.remove();
                break;
            }
            timer.cancel();
        }
    }

    public static Thread allocateThread(Runnable runnable) {
        return new Thread(runnable);
    }

    public static Thread allocateThread(Callable callable) {
        FutureTask futureTask = new FutureTask(callable);
        return new Thread(futureTask);
    }

    public static TimerTask schedule(Timer timer, TimerTask timerTask, long l, long l2) {
        timer.schedule(timerTask, l, l2);
        return timerTask;
    }

    public static TimerTask scheduleAtFixedRate(Timer timer, TimerTask timerTask, long l, long l2) {
        timer.scheduleAtFixedRate(timerTask, l, l2);
        return timerTask;
    }
}

