/*
 * Decompiled with CFR 0.152.
 */
package com.pcbsys.nirvana.base;

import com.pcbsys.nirvana.base.nUnAckedEventManager;
import com.pcbsys.nirvana.client.nChannelImpl;
import com.pcbsys.nirvana.client.nIllegalArgumentException;
import com.pcbsys.nirvana.client.nIllegalStateException;
import com.pcbsys.nirvana.client.nNamedObject;
import com.pcbsys.nirvana.client.nRequestTimedOutException;
import com.pcbsys.nirvana.client.nSessionNotConnectedException;
import com.pcbsys.nirvana.client.nSessionPausedException;

public class AckRollbackHelper {
    public void sendChannelAck(long[] lArray, HelperAttributes helperAttributes) throws nSessionNotConnectedException, nSessionPausedException, nRequestTimedOutException, nIllegalArgumentException {
        nChannelImpl nChannelImpl2 = helperAttributes.getChannel();
        nNamedObject nNamedObject2 = helperAttributes.getDurable();
        nUnAckedEventManager nUnAckedEventManager2 = helperAttributes.getExternalUnAckedEventManager();
        if (nChannelImpl2 == null) {
            throw new nIllegalArgumentException("Missing external channel");
        }
        if (nChannelImpl2.isQueue()) {
            throw new nIllegalArgumentException("External channel is a queue");
        }
        if (nNamedObject2 == null) {
            throw new nIllegalArgumentException("Missing external durable");
        }
        nChannelImpl2.sendNamedAck(lArray, nNamedObject2.getID(), helperAttributes.getSynchronous(), helperAttributes.getIndividual());
        if (nUnAckedEventManager2 != null) {
            nUnAckedEventManager2.commit(lArray);
        }
    }

    public void sendQueueAck(long[] lArray, HelperAttributes helperAttributes) throws nSessionNotConnectedException, nSessionPausedException, nRequestTimedOutException, nIllegalStateException, nIllegalArgumentException {
        nChannelImpl nChannelImpl2 = helperAttributes.getChannel();
        nUnAckedEventManager nUnAckedEventManager2 = helperAttributes.getExternalUnAckedEventManager();
        if (nUnAckedEventManager2 == null) {
            throw new nIllegalArgumentException("Missing external nUnAckedEventManager");
        }
        if (nChannelImpl2 == null) {
            throw new nIllegalArgumentException("Missing external channel");
        }
        if (!nChannelImpl2.isQueue()) {
            throw new nIllegalArgumentException("External channel is a channel");
        }
        nChannelImpl2.commitOnlyTheseEvents(helperAttributes.getReaderUniqueId(), lArray);
        if (helperAttributes.getAckPrevious()) {
            nUnAckedEventManager2.commit(lArray);
        } else {
            nUnAckedEventManager2.commit(lArray[0], false);
        }
    }

    public void sendChannelRollback(long[] lArray, HelperAttributes helperAttributes) throws nSessionNotConnectedException, nSessionPausedException, nRequestTimedOutException, nIllegalArgumentException {
        nChannelImpl nChannelImpl2 = helperAttributes.getChannel();
        nNamedObject nNamedObject2 = helperAttributes.getDurable();
        nUnAckedEventManager nUnAckedEventManager2 = helperAttributes.getExternalUnAckedEventManager();
        if (nChannelImpl2 == null) {
            throw new nIllegalArgumentException("Missing external channel");
        }
        if (nChannelImpl2.isQueue()) {
            throw new nIllegalArgumentException("External channel is a queue");
        }
        long[] lArray2 = null;
        if (nUnAckedEventManager2 != null) {
            lArray2 = new long[lArray.length];
            for (int i = 0; i < lArray.length; ++i) {
                long l;
                lArray2[i] = l = lArray[i];
                nUnAckedEventManager2.rollback(l, false);
            }
        }
        try {
            if (nNamedObject2 == null) {
                throw new nIllegalArgumentException("Missing external durable");
            }
            nChannelImpl2.sendNamedRollback(lArray, nNamedObject2.getID(), helperAttributes.getSynchronous(), helperAttributes.getIndividual());
        }
        catch (nIllegalArgumentException | nRequestTimedOutException | nSessionNotConnectedException | nSessionPausedException nBaseClientException2) {
            if (nUnAckedEventManager2 != null) {
                this.handleException(nUnAckedEventManager2, false, lArray2);
            }
            throw nBaseClientException2;
        }
    }

    public void sendQueueRollback(long[] lArray, HelperAttributes helperAttributes) throws nSessionNotConnectedException, nSessionPausedException, nRequestTimedOutException, nIllegalStateException, nIllegalArgumentException {
        nChannelImpl nChannelImpl2 = helperAttributes.getChannel();
        nUnAckedEventManager nUnAckedEventManager2 = helperAttributes.getExternalUnAckedEventManager();
        if (nUnAckedEventManager2 == null) {
            throw new nIllegalArgumentException("Missing external nUnAckedEventManager");
        }
        if (nChannelImpl2 == null) {
            throw new nIllegalArgumentException("Missing external channel");
        }
        if (!nChannelImpl2.isQueue()) {
            throw new nIllegalArgumentException("External channel is a channel");
        }
        long[] lArray2 = new long[lArray.length];
        for (int i = 0; i < lArray.length; ++i) {
            long l;
            lArray2[i] = l = lArray[i];
            if (helperAttributes.getAckPrevious()) {
                nUnAckedEventManager2.rollback(lArray);
                continue;
            }
            nUnAckedEventManager2.rollback(lArray[0], false);
        }
        try {
            nChannelImpl2.rollbackOnlyTheseEvents(helperAttributes.getReaderUniqueId(), lArray);
        }
        catch (nIllegalStateException | nRequestTimedOutException | nSessionNotConnectedException | nSessionPausedException nBaseClientException2) {
            this.handleException(nUnAckedEventManager2, false, lArray2);
            throw nBaseClientException2;
        }
    }

    private void handleException(nUnAckedEventManager nUnAckedEventManager2, boolean bl, long[] lArray) {
        if (!bl && nUnAckedEventManager2 != null) {
            for (long l : lArray) {
                nUnAckedEventManager2.receivedEvent(l);
            }
        }
    }

    public static class HelperAttributes {
        private nChannelImpl externalChannel;
        private nNamedObject externalDurable;
        private nUnAckedEventManager externalUnAckedEventManager;
        private boolean ackPrevious;
        private boolean isIndividual;
        private boolean isSynchronous;
        private boolean rollbackTo;
        private long readerUniqueId;

        public nChannelImpl getChannel() {
            return this.externalChannel;
        }

        public void setChannel(nChannelImpl nChannelImpl2) {
            this.externalChannel = nChannelImpl2;
        }

        public nNamedObject getDurable() {
            return this.externalDurable;
        }

        public void setDurable(nNamedObject nNamedObject2) {
            this.externalDurable = nNamedObject2;
        }

        public nUnAckedEventManager getExternalUnAckedEventManager() {
            return this.externalUnAckedEventManager;
        }

        public void setUnAckedEventManager(nUnAckedEventManager nUnAckedEventManager2) {
            this.externalUnAckedEventManager = nUnAckedEventManager2;
        }

        public boolean getAckPrevious() {
            return this.ackPrevious;
        }

        public void setAckPrevious(boolean bl) {
            this.ackPrevious = bl;
        }

        public boolean getIndividual() {
            return this.isIndividual;
        }

        public void setIndividual(boolean bl) {
            this.isIndividual = bl;
        }

        public boolean getSynchronous() {
            return this.isSynchronous;
        }

        public void setSynchronous(boolean bl) {
            this.isSynchronous = bl;
        }

        public boolean getRollbackTo() {
            return this.rollbackTo;
        }

        public void setRollbackTo(boolean bl) {
            this.rollbackTo = bl;
        }

        public void setReaderUniqueId(long l) {
            this.readerUniqueId = l;
        }

        public long getReaderUniqueId() {
            return this.readerUniqueId;
        }
    }
}

