/*
 * Decompiled with CFR 0.152.
 */
package com.pcbsys.nirvana.base;

import com.pcbsys.foundation.base.EnvironmentProperties;
import com.pcbsys.foundation.base.fEventDictionary;
import com.pcbsys.foundation.logger.storelogger.EventTraceLoggerContext;
import com.pcbsys.foundation.logger.storelogger.StoreLogConfigLevel;
import com.pcbsys.foundation.logger.storelogger.StoreLoggerImpl;
import com.pcbsys.foundation.utils.fStringByteConverter;
import com.pcbsys.nirvana.base.KnownClientStoresCache;
import com.pcbsys.nirvana.base.clientimpl.ClientConnectionManager;
import com.pcbsys.nirvana.base.events.nChannelIterate;
import com.pcbsys.nirvana.base.events.nIndexedDurablePurgeEvent;
import com.pcbsys.nirvana.base.events.nPopQueue;
import com.pcbsys.nirvana.base.events.nPopQueueCommand;
import com.pcbsys.nirvana.base.events.nPublished;
import com.pcbsys.nirvana.base.events.nPurge;
import com.pcbsys.nirvana.base.nChannelAttributes;
import com.pcbsys.nirvana.base.nChannelQueue;
import com.pcbsys.nirvana.base.nConstants;
import com.pcbsys.nirvana.base.nConsumeEvent;
import com.pcbsys.nirvana.base.nHeader;
import com.pcbsys.nirvana.client.nDurable;
import com.pcbsys.nirvana.client.nDurableAttributes;
import com.pcbsys.nirvana.client.nEventProperties;
import com.pcbsys.nirvana.client.nSessionNotConnectedException;
import java.util.List;

public class ClientEventTraceLoggerContext
extends EventTraceLoggerContext {
    private static ClientEventTraceLoggerContext instance = new ClientEventTraceLoggerContext();

    private ClientEventTraceLoggerContext() {
        super("Client");
        this.setupTraceLogProperties();
    }

    public static ClientEventTraceLoggerContext getInstance() {
        return instance;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized void setEnabledStores(String string) {
        super.setEnabledStores(string);
        KnownClientStoresCache knownClientStoresCache = KnownClientStoresCache.getInstance();
        synchronized (knownClientStoresCache) {
            for (nChannelQueue nChannelQueue2 : KnownClientStoresCache.getInstance()) {
                this.updateStoreLogger((StoreLoggerImpl)nChannelQueue2.getTraceLogger());
            }
        }
    }

    @Override
    public boolean isLoggingEnabledForStore(String string) {
        if (string != null && nConstants.isSystemStore(string)) {
            return false;
        }
        return super.isLoggingEnabledForStore(string);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setLogPath(String string) {
        if (!string.equals(this.getLogPath())) {
            KnownClientStoresCache knownClientStoresCache;
            KnownClientStoresCache knownClientStoresCache2 = knownClientStoresCache = KnownClientStoresCache.getInstance();
            synchronized (knownClientStoresCache2) {
                for (nChannelQueue nChannelQueue2 : knownClientStoresCache) {
                    this.removeStoreTraceLogger(nChannelQueue2.getBaseChannelAttributes().getName());
                }
                super.setLogPath(string);
                for (nChannelQueue nChannelQueue2 : knownClientStoresCache) {
                    this.updateStoreLogger((StoreLoggerImpl)nChannelQueue2.getTraceLogger());
                }
            }
        }
    }

    public static String addClientConnectionInfo(ClientConnectionManager clientConnectionManager) {
        String string = ", Conn={SSID:" + Long.toHexString(clientConnectionManager.getServerProvidedSessionID());
        try {
            string = string + ",Local:" + clientConnectionManager.getLocalHostAndPort() + ",URL:" + clientConnectionManager.getRemoteUrl() + "}";
        }
        catch (nSessionNotConnectedException nSessionNotConnectedException2) {
            string = string + ",NOT CONNECTED }";
        }
        return string;
    }

    public static String addClientConnectionInfo(List<ClientConnectionManager> list) {
        StringBuilder stringBuilder = new StringBuilder();
        for (ClientConnectionManager clientConnectionManager : list) {
            stringBuilder.append(ClientEventTraceLoggerContext.addClientConnectionInfo(clientConnectionManager));
        }
        return stringBuilder.toString();
    }

    public static String addConsumeEventTraceInfo(nConsumeEvent nConsumeEvent2) {
        if (nConsumeEvent2 != null) {
            nHeader nHeader2;
            String string = ClientEventTraceLoggerContext.eidFormat(nConsumeEvent2.getEventID());
            nEventProperties nEventProperties2 = nConsumeEvent2.getProperties();
            if (nEventProperties2 != null && nEventProperties2.containsKey("uuid")) {
                string = string + ", UUID=" + nEventProperties2.getString("uuid");
            }
            if (nConsumeEvent2.getEventTag() != null) {
                string = string + ", tag=" + nConsumeEvent2.getEventTag();
            }
            if ((nHeader2 = nConsumeEvent2.getHeader()) != null) {
                if (nHeader2.getMessageId() != null) {
                    string = string + ", msgId=" + fStringByteConverter.convert(nHeader2.getMessageId());
                }
                string = string + ", redelivery=" + nHeader2.redeliveredCount;
            }
            return string;
        }
        return "";
    }

    public static String addChannelIterateInfo(nChannelIterate nChannelIterate2) {
        String string = "nChannelIterate={command=";
        switch (nChannelIterate2.getCommand()) {
            case 5: {
                string = string + "Create";
                break;
            }
            case 6: {
                string = string + "Close";
                break;
            }
            case 0: {
                string = string + "First";
                break;
            }
            case 1: {
                string = string + "Last";
                break;
            }
            case 2: {
                string = string + "Next";
                break;
            }
            case 3: {
                string = string + "Previous";
                break;
            }
            case 8: {
                string = string + "Rollback";
                break;
            }
            case 7: {
                string = string + "Ack";
                break;
            }
            default: {
                string = string + "Unknown";
            }
        }
        string = string + ", iteratorId=" + nChannelIterate2.getIteratorIdAsString() + ", autoAck=" + nChannelIterate2.isAutoAck() + ", windowSize=" + nChannelIterate2.getMaxUnackedEvents() + ", namedId=" + nChannelIterate2.getNameId() + ", selector=" + nChannelIterate2.getSelector() + ", timeout=" + nChannelIterate2.getTimeout() + ", startEid=" + nChannelIterate2.getEID() + ", requestId=" + nChannelIterate2.getRequestId();
        if (nChannelIterate2.hasEvents()) {
            string = string + ", events=";
            string = nChannelIterate2.getEvents() != null ? string + ClientEventTraceLoggerContext.addPubEventsInfo(nChannelIterate2.getEvents()) : (nChannelIterate2.getEvent() != null ? string + ClientEventTraceLoggerContext.addPubEventTraceInfo(nChannelIterate2.getEvent()) : string + "None");
        }
        return string + "}";
    }

    public static String addChAttributesInfo(com.pcbsys.nirvana.client.nChannelAttributes nChannelAttributes2) {
        return "attr={type=" + nConstants.CHAN_TYPES[nChannelAttributes2.getType()] + ", JMSEngine=" + nChannelAttributes2.isJMSEngine() + ", TTL=" + nChannelAttributes2.getTTL() + ", capacity=" + nChannelAttributes2.getMaxEvents() + ", ID=" + nChannelAttributes2.getUniqueId() + ", spindleSize=" + nChannelAttributes2.getProperties().getMultiFileEventsPerSpindle() + ", isClusterWide=" + nChannelAttributes2.isClusterWide() + "}";
    }

    public static String addChAttributesInfo(nChannelAttributes nChannelAttributes2) {
        return "attr={type=" + nConstants.CHAN_TYPES[nChannelAttributes2.getType()] + ", JMSEngine=" + nChannelAttributes2.isUseJMSEngine() + ", TTL=" + nChannelAttributes2.getTTL() + ", capacity=" + nChannelAttributes2.getMaxEvents() + ", ID=" + nChannelAttributes2.getUniqueId() + ", isClusterWide=" + nChannelAttributes2.isClusterWide() + "}";
    }

    public static String addDurAttributesInfo(nDurableAttributes nDurableAttributes2) {
        return "Durable={" + nDurableAttributes2.getName() + ", type=" + nDurableAttributes2.getType().toString() + ", persistent=" + nDurableAttributes2.isPersistent() + ", clustered=" + nDurableAttributes2.isClustered() + ", selector=" + nDurableAttributes2.getSelector() + "}";
    }

    public static String addPopQueueInfo(nPopQueue nPopQueue2) {
        return "popReaderId=" + nPopQueue2.getReaderUniqueID() + ", popQueueCommand=" + (nPopQueue2.getCommand() == nPopQueueCommand.POP ? "Pop" : "Close") + ", requestId=" + nPopQueue2.getRequestId() + ", windowSize=" + nPopQueue2.getWindowSize() + ", batchSize=" + nPopQueue2.getBatchSize() + ", selector=" + nPopQueue2.getSelector() + ", timeout=" + nPopQueue2.getTimeout() + ", isAutoAck=" + (nPopQueue2.getWindowSize() == 0 ? "true" : "false");
    }

    public static String addPubEventTraceInfo(nPublished nPublished2) {
        nHeader nHeader2;
        String string = ClientEventTraceLoggerContext.eidFormat(nPublished2.getEID());
        fEventDictionary fEventDictionary2 = nPublished2.getDictionary();
        if (fEventDictionary2 != null && fEventDictionary2.containsKey("uuid")) {
            string = string + ", UUID=" + fEventDictionary2.getString("uuid");
        }
        if ((nHeader2 = nPublished2.getHeader()) != null && nHeader2.getMessageId() != null) {
            string = string + ", msgId=" + fStringByteConverter.convert(nHeader2.getMessageId());
        }
        if (nPublished2.getTag() != null) {
            string = string + ", tag=" + fStringByteConverter.convert(nPublished2.getTag());
        }
        return string;
    }

    public static String addPubEventsInfo(List<nPublished> list) {
        StringBuilder stringBuilder = new StringBuilder();
        if (list.size() == 0) {
            return "None";
        }
        for (nPublished nPublished2 : list) {
            if (nPublished2 != null) {
                stringBuilder.append(ClientEventTraceLoggerContext.addPubEventTraceInfo(nPublished2));
            }
            if (list.get(list.size() - 1).equals(nPublished2)) continue;
            stringBuilder.append(", ");
        }
        return stringBuilder.toString();
    }

    public static String addDurableInfo(nDurable nDurable2) {
        String string = "durableInfo={durableName=" + nDurable2.getName() + ", durableType=";
        string = nDurable2.isShared() && nDurable2.isSerial() ? string + "Serial" : (nDurable2.isShared() ? string + "Shared" : string + "Named");
        return string + ", nameId=" + nDurable2.getID() + ", selector=" + (nDurable2.getSelector() != null ? nDurable2.getSelector() : "null") + "}";
    }

    public static String addIndexPurgeInfo(nIndexedDurablePurgeEvent nIndexedDurablePurgeEvent2) {
        String string = "indexPurgeInfo={command=";
        switch (nIndexedDurablePurgeEvent2.getCommand()) {
            case 1: {
                string = string + "Remove, EID=" + nIndexedDurablePurgeEvent2.getCurrentEID();
                break;
            }
            case 2: {
                string = string + "Remove range, startEID=" + nIndexedDurablePurgeEvent2.getCurrentEID() + ", endEID=" + nIndexedDurablePurgeEvent2.getEndEID();
                break;
            }
            case 4: {
                string = string + "Remove filter, selector=" + nIndexedDurablePurgeEvent2.getSelector();
                break;
            }
            case 3: {
                string = string + "Remove all";
            }
        }
        return string + ", nameId=" + nIndexedDurablePurgeEvent2.getDurableId() + ", requestId=" + nIndexedDurablePurgeEvent2.getRequestId() + "}";
    }

    public static String addPurgeInfo(nPurge nPurge2) {
        return "purgeInfo={startEID=" + nPurge2.getStartEID() + ", endEID=" + nPurge2.getEndEID() + ", selector=" + nPurge2.getSelector() + ", purgeJoins=" + nPurge2.getPurgeJoinsFlag() + ", isSynchronous=" + nPurge2.isSynchronous() + ", requestId=" + nPurge2.getRequestId() + "}";
    }

    public static String getClassNameWithPackage(Class clazz) {
        String string = clazz.getPackage().getName();
        return string.substring(string.lastIndexOf(".") + 1) + "\\" + clazz.getSimpleName();
    }

    private void setupTraceLogProperties() {
        String string;
        String string2;
        String string3;
        block12: {
            StoreLogConfigLevel storeLogConfigLevel;
            String string4 = System.getProperty("com.softwareag.um.client.log.TraceStoreLogLevel", EnvironmentProperties.DEFAULT_TRACE_STORE_LOG_LEVEL_PROP);
            try {
                storeLogConfigLevel = StoreLogConfigLevel.getLevel(string4);
            }
            catch (Exception exception) {
                storeLogConfigLevel = StoreLogConfigLevel.OFF;
            }
            try {
                this.setLogLevel(storeLogConfigLevel);
            }
            catch (IllegalStateException illegalStateException) {
                if (storeLogConfigLevel == StoreLogConfigLevel.OFF) break block12;
                nConstants.logger.error("Setting trace store log level to " + storeLogConfigLevel.name() + " has no effect since event tracing is disabled: " + this.loggerProviderFailure);
            }
        }
        String string5 = System.getProperty("com.softwareag.um.client.log.TraceLoggerPath", DEFAULT_CLIENT_LOG_PATH);
        if (string5 != null) {
            this.setLogPath(string5);
        }
        if ((string3 = System.getProperty("com.softwareag.um.client.log.TraceStores")) != null) {
            this.setEnabledStores(string3);
        }
        if ((string2 = System.getProperty("com.softwareag.um.client.log.TraceStoreLogSize")) != null) {
            try {
                this.setSingleLogSize(Integer.parseInt(string2));
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        if ((string = System.getProperty("com.softwareag.um.client.log.TraceFolderLogSize")) != null) {
            try {
                this.setGlobalLogSize(Integer.parseInt(string));
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }
}

