/*
 * Decompiled with CFR 0.152.
 */
package com.pcbsys.nirvana.base;

import com.pcbsys.foundation.drivers.fConnectionDetails;
import com.pcbsys.nirvana.client.nIllegalArgumentException;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class UrlProcessor {
    private static Pattern HS_PATTERN = Pattern.compile("\\((.*?)\\)");

    public static List<List<String>> processURL(String string) throws nIllegalArgumentException {
        UrlProcessor.checkNull(string);
        List<String> list = UrlProcessor.preProcessHorizontalScalabilityURL(string);
        ArrayList<List<String>> arrayList = new ArrayList<List<String>>();
        if (list.isEmpty()) {
            arrayList.add(UrlProcessor.processFailOverString(string));
        } else {
            UrlProcessor.isHSSyntaxValid(list, string);
            for (String string2 : list) {
                arrayList.add(UrlProcessor.processFailOverString(string2));
            }
        }
        return arrayList;
    }

    private static List<String> processFailOverString(String string) throws nIllegalArgumentException {
        ArrayList<String> arrayList = new ArrayList<String>();
        for (String string2 : string.split(",")) {
            if (string2.isEmpty()) {
                throw new nIllegalArgumentException("Invalid url supplied : <null>");
            }
            ArrayList arrayList2 = new ArrayList();
            Collections.addAll(arrayList2, string2.split(";"));
            if (arrayList2.isEmpty()) continue;
            Collections.shuffle(arrayList2);
            for (String string3 : arrayList2) {
                arrayList.add(string3.trim());
            }
        }
        return arrayList;
    }

    private static void isHSSyntaxValid(List<String> list, String string) throws nIllegalArgumentException {
        Pattern pattern = Pattern.compile("://");
        Matcher matcher = pattern.matcher(string);
        int n = 0;
        while (matcher.find()) {
            ++n;
        }
        int n2 = 0;
        for (String string2 : list) {
            int n3 = 0;
            Matcher matcher2 = pattern.matcher(string2);
            while (matcher2.find()) {
                ++n3;
            }
            if (n3 <= 1) continue;
            n2 += n3 - 1;
        }
        if ((n -= n2) != list.size()) {
            throw new nIllegalArgumentException("Invalid HS Syntax: " + string);
        }
    }

    public static List<List<String>> preprocessURL(String[] stringArray) throws nIllegalArgumentException {
        Object object;
        UrlProcessor.checkNull(stringArray);
        ArrayList<String> arrayList = new ArrayList<String>();
        boolean bl = false;
        for (String string : stringArray) {
            if (string == null) {
                throw new nIllegalArgumentException("Invalid url supplied : <null>");
            }
            if (string.isEmpty()) {
                throw new nIllegalArgumentException("Invalid url supplied : <Empty String>");
            }
            List<String> list = UrlProcessor.preProcessHorizontalScalabilityURL(string);
            if (!list.isEmpty()) {
                bl = true;
                if (list.size() > 1) {
                    throw new nIllegalArgumentException("Invalid url supplied : Cannot have more than a single group of connections per array entry");
                }
                arrayList.add(list.get(0).trim());
                continue;
            }
            arrayList.add(string.trim());
        }
        if (arrayList.isEmpty()) {
            throw new nIllegalArgumentException("Invalid url supplied : <null>");
        }
        if (!bl) {
            object = new ArrayList();
            object.add(arrayList);
            return object;
        }
        object = new ArrayList();
        for (String string : arrayList) {
            object.add(UrlProcessor.processFailOverString(string.trim()));
        }
        return object;
    }

    private static List<String> preProcessHorizontalScalabilityURL(String string) {
        Matcher matcher = HS_PATTERN.matcher(string);
        ArrayList<String> arrayList = new ArrayList<String>();
        while (matcher.find()) {
            arrayList.add(matcher.group(1));
        }
        return arrayList;
    }

    private static void checkNull(Object object) throws nIllegalArgumentException {
        if (object == null) {
            throw new nIllegalArgumentException("Invalid url supplied : <null>");
        }
    }

    public static List<fConnectionDetails> createConnectionList(List<String> list) throws IOException {
        ArrayList<fConnectionDetails> arrayList = new ArrayList<fConnectionDetails>();
        for (String string : list) {
            fConnectionDetails fConnectionDetails2 = new fConnectionDetails(string);
            arrayList.add(fConnectionDetails2);
        }
        return arrayList;
    }

    public static List<String> getConnectionGroupsFromUrl(String string) throws nIllegalArgumentException {
        List<String> list = UrlProcessor.preProcessHorizontalScalabilityURL(string);
        if (list.isEmpty()) {
            throw new nIllegalArgumentException("The specified URL is not a horizontal scalability URL: " + string);
        }
        try {
            UrlProcessor.createConnectionList(list);
        }
        catch (IOException iOException) {
            throw new nIllegalArgumentException("Invalid URL specified: " + string, iOException);
        }
        return list;
    }
}

