/*
 * Decompiled with CFR 0.152.
 */
package com.pcbsys.nirvana.base.clientimpl.multiconnection;

import com.pcbsys.foundation.drivers.fConnectionDetails;
import com.pcbsys.foundation.security.fSubject;
import com.pcbsys.nirvana.base.clientimpl.ClientConnectionManager;
import com.pcbsys.nirvana.base.clientimpl.multiconnection.ClientConnectionStateManager;
import com.pcbsys.nirvana.base.clientimpl.multiconnection.SessionAttributes;
import com.pcbsys.nirvana.base.clientimpl.multiconnection.nChannelIteratorManagerImpl;
import com.pcbsys.nirvana.base.clientimpl.multiconnection.nConnectionStatisticsManagerImpl;
import com.pcbsys.nirvana.base.clientimpl.multiconnection.nDataGroupManagerImpl;
import com.pcbsys.nirvana.base.clientimpl.multiconnection.nEventProcessorImpl;
import com.pcbsys.nirvana.base.clientimpl.multiconnection.nExceptionListenerManagerImpl;
import com.pcbsys.nirvana.base.clientimpl.multiconnection.nRealmMangerImpl;
import com.pcbsys.nirvana.base.clientimpl.multiconnection.nRedirectManagerImpl;
import com.pcbsys.nirvana.base.clientimpl.multiconnection.nStoreManagerImpl;
import com.pcbsys.nirvana.base.clientimpl.nChannelIteratorHelper;
import com.pcbsys.nirvana.base.clientimpl.nChannelIteratorManager;
import com.pcbsys.nirvana.base.clientimpl.nConnectionManagerBuilder;
import com.pcbsys.nirvana.base.clientimpl.nConnectionStatisticsManager;
import com.pcbsys.nirvana.base.clientimpl.nDataGroupManager;
import com.pcbsys.nirvana.base.clientimpl.nDataGroupManagerHelper;
import com.pcbsys.nirvana.base.clientimpl.nDurableHelper;
import com.pcbsys.nirvana.base.clientimpl.nEventProcessor;
import com.pcbsys.nirvana.base.clientimpl.nExceptionListenerManager;
import com.pcbsys.nirvana.base.clientimpl.nQueueReaderManagerHelper;
import com.pcbsys.nirvana.base.clientimpl.nRealmManager;
import com.pcbsys.nirvana.base.clientimpl.nRedirectManager;
import com.pcbsys.nirvana.base.clientimpl.nRedirectManagerHelper;
import com.pcbsys.nirvana.base.clientimpl.nStoreManagerHelper;
import com.pcbsys.nirvana.base.clientimpl.singleconnection.eventhandlers.EventHandlerInitialiser;
import com.pcbsys.nirvana.base.events.nPopQueue;
import com.pcbsys.nirvana.base.events.nPopQueueCommand;
import com.pcbsys.nirvana.base.nThreadManager;
import com.pcbsys.nirvana.client.nAbstractChannel;
import com.pcbsys.nirvana.client.nDataStream;
import com.pcbsys.nirvana.client.nDataStreamListener;
import com.pcbsys.nirvana.client.nIllegalArgumentException;
import com.pcbsys.nirvana.client.nRealmUnreachableException;
import com.pcbsys.nirvana.client.nReconnectHandler;
import com.pcbsys.nirvana.client.nSecurityException;
import com.pcbsys.nirvana.client.nServerExtensionCallback;
import com.pcbsys.nirvana.client.nSession;
import com.pcbsys.nirvana.client.nSessionNotConnectedException;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicLong;

public class ClientConnectionManagerImpl
implements ClientConnectionManager {
    private final List<ClientConnectionManager> myClientConnections;
    private final ClientConnectionStateManager myClientConnectionsStateManager;
    private final nExceptionListenerManager myExceptionListenerManager;
    private final nRedirectManager myRedirectionManager;
    private final nStoreManagerImpl myStoreManager;
    private final nDataGroupManagerImpl myDataGroupManager;
    private final nConnectionStatisticsManagerImpl myConnectionStatisticsManager;
    private final nRealmMangerImpl myRealmManager;
    private final nSession mySession;
    private final com.pcbsys.nirvana.base.clientimpl.SessionAttributes sessionAttributes;
    private final nDurableHelper myDurableManagerHelper;
    private final nChannelIteratorManager myChannelIteratorManager;
    private final nThreadManager myThreadManager;
    private final AtomicLong myTransactionalCounter = new AtomicLong(0L);
    private final AtomicBoolean isClosing;
    private final nEventProcessorImpl myEventProcessor;
    private final String myUniqueClientAllocatedConnectionID;
    private boolean isInitialised;

    public ClientConnectionManagerImpl(String string, nSession nSession2, com.pcbsys.nirvana.base.clientimpl.SessionAttributes sessionAttributes, nThreadManager nThreadManager2, nQueueReaderManagerHelper nQueueReaderManagerHelper2, nDataGroupManagerHelper nDataGroupManagerHelper2, nChannelIteratorHelper nChannelIteratorHelper2, nRedirectManagerHelper nRedirectManagerHelper2, nStoreManagerHelper nStoreManagerHelper2, nDurableHelper nDurableHelper2, String string2, String string3) {
        this.mySession = nSession2;
        this.isClosing = new AtomicBoolean(false);
        this.isInitialised = false;
        this.sessionAttributes = sessionAttributes;
        ArrayList<ClientConnectionManager> arrayList = new ArrayList<ClientConnectionManager>();
        for (int i = 0; i < sessionAttributes.getConnectionDetails().size(); ++i) {
            arrayList.add(new nConnectionManagerBuilder().setUniqueClientAllocatedID(string + "-" + i).setSession(nSession2).setSessionAttributes(new SessionAttributes(sessionAttributes, i)).setThreadManager(nThreadManager2).setQueueReaderManagerHelper(nQueueReaderManagerHelper2).setDataGroupManagerHelper(nDataGroupManagerHelper2).setChannelIteratorHelper(nChannelIteratorHelper2).setRedirectManagerHelper(nRedirectManagerHelper2).setStoreManagerHelper(nStoreManagerHelper2).setDurableManagerHelper(nDurableHelper2).setUsername(string2).setPassword(string3).setAdminApiSession(false).createConnectionManager());
        }
        this.myUniqueClientAllocatedConnectionID = string;
        this.myClientConnections = Collections.unmodifiableList(arrayList);
        this.myDurableManagerHelper = nDurableHelper2;
        this.myThreadManager = nThreadManager2;
        this.myExceptionListenerManager = new nExceptionListenerManagerImpl(this.myClientConnections, this.myThreadManager);
        this.myRedirectionManager = new nRedirectManagerImpl();
        this.myDataGroupManager = new nDataGroupManagerImpl();
        this.myRealmManager = new nRealmMangerImpl();
        this.myConnectionStatisticsManager = new nConnectionStatisticsManagerImpl();
        this.myStoreManager = new nStoreManagerImpl(this.mySession, nThreadManager2, this, nQueueReaderManagerHelper2, nStoreManagerHelper2, this.myExceptionListenerManager, this.myClientConnections);
        this.myChannelIteratorManager = new nChannelIteratorManagerImpl(nChannelIteratorHelper2, this.myStoreManager);
        this.myClientConnectionsStateManager = new ClientConnectionStateManager(nSession2, this.myClientConnections, this.myStoreManager);
        this.myEventProcessor = new nEventProcessorImpl(this, this.myClientConnections, this.myStoreManager);
    }

    @Override
    public nExceptionListenerManager getExceptionListenerManager() {
        return this.myExceptionListenerManager;
    }

    @Override
    public nStoreManagerImpl getStoreManager() {
        return this.myStoreManager;
    }

    @Override
    public nDataGroupManager getDataGroupManager() {
        return this.myDataGroupManager;
    }

    @Override
    public nRealmManager getRealmManager() {
        return this.myRealmManager;
    }

    @Override
    public nRedirectManager getRedirectManager() {
        return this.myRedirectionManager;
    }

    @Override
    public nConnectionStatisticsManager getConnectionStatisticsManager() {
        return this.myConnectionStatisticsManager;
    }

    @Override
    public nEventProcessor getEventProcessor() {
        return this.myEventProcessor;
    }

    @Override
    public boolean isMemberOfCluster() {
        return false;
    }

    @Override
    public nDurableHelper getDurableManagerHelper() {
        return this.myDurableManagerHelper;
    }

    @Override
    public nChannelIteratorManager getChannelIteratorManager() {
        return this.myChannelIteratorManager;
    }

    @Override
    public void close() {
        if (!this.isClosing.getAndSet(true)) {
            this.myClientConnectionsStateManager.close();
        }
        this.myStoreManager.close();
    }

    @Override
    public nDataStream initialise(nDataStreamListener nDataStreamListener2, EventHandlerInitialiser eventHandlerInitialiser, boolean bl, boolean bl2) throws nRealmUnreachableException, nSessionNotConnectedException, nSecurityException {
        if (nDataStreamListener2 != null) {
            throw new IllegalArgumentException(new nIllegalArgumentException("Cannot use data stream with horizontal scalability"));
        }
        this.myThreadManager.setThreadPoolSize(this.myClientConnections.size() * 2);
        this.myEventProcessor.initialise();
        this.myClientConnectionsStateManager.initialise(eventHandlerInitialiser, bl, bl2);
        for (ClientConnectionManager clientConnectionManager : this.myClientConnections) {
            clientConnectionManager.getStoreManager().registerStateListener(this.myStoreManager.getStoreManagerStateListener());
        }
        this.isInitialised = true;
        return null;
    }

    @Override
    public boolean isInitialised() {
        return this.isInitialised;
    }

    @Override
    public void addReconnectHandler(nReconnectHandler nReconnectHandler2) {
        this.myClientConnectionsStateManager.addReconnectHandler(nReconnectHandler2);
    }

    @Override
    public void removeReconnectHandler(nReconnectHandler nReconnectHandler2) {
        this.myClientConnectionsStateManager.removeReconnectHandler(nReconnectHandler2);
    }

    @Override
    public void releaseRequests() {
        this.myEventProcessor.releaseRequests(nEvent2 -> !(nEvent2 instanceof nPopQueue) || ((nPopQueue)nEvent2).getCommand() != nPopQueueCommand.CLOSE);
    }

    @Override
    public void unblockThread(String string) {
        this.myEventProcessor.unblockThread(string);
    }

    @Override
    public long getServerProvidedSessionID() {
        return -1L;
    }

    @Override
    public String getServerProvidedRealmName() {
        StringBuilder stringBuilder = new StringBuilder();
        for (ClientConnectionManager clientConnectionManager : this.myClientConnections) {
            try {
                String string = clientConnectionManager.getServerProvidedRealmName();
                stringBuilder.append('(').append(string).append(')');
            }
            catch (nSessionNotConnectedException nSessionNotConnectedException2) {}
        }
        return stringBuilder.toString();
    }

    @Override
    public int getServerProvidedMaxBufferSize() {
        int n = Integer.MAX_VALUE;
        for (ClientConnectionManager clientConnectionManager : this.myClientConnections) {
            if (!clientConnectionManager.isMaxBufferSizeClientCheck()) continue;
            n = Math.min(clientConnectionManager.getServerProvidedMaxBufferSize(), n);
        }
        return n;
    }

    @Override
    public boolean isMaxBufferSizeClientCheck() {
        for (ClientConnectionManager clientConnectionManager : this.myClientConnections) {
            if (!clientConnectionManager.isMaxBufferSizeClientCheck()) continue;
            return true;
        }
        return false;
    }

    @Override
    public void setHTTPURLParameters(String string) {
        for (ClientConnectionManager clientConnectionManager : this.myClientConnections) {
            clientConnectionManager.setHTTPURLParameters(string);
        }
    }

    @Override
    public String getThirdPartyCookies() {
        throw new UnsupportedOperationException();
    }

    @Override
    public void configureMultiplexManager(ClientConnectionManager clientConnectionManager) {
        throw new UnsupportedOperationException();
    }

    @Override
    public String getRemoteUrl() throws nSessionNotConnectedException {
        StringBuilder stringBuilder = new StringBuilder();
        for (ClientConnectionManager clientConnectionManager : this.myClientConnections) {
            stringBuilder.append("(").append(clientConnectionManager.getRemoteUrl()).append(")");
        }
        return stringBuilder.toString();
    }

    @Override
    public boolean isConnected() {
        return this.myClientConnectionsStateManager.isConnected();
    }

    @Override
    public String getLocalHostAndPort() throws nSessionNotConnectedException {
        StringBuilder stringBuilder = new StringBuilder();
        for (ClientConnectionManager clientConnectionManager : this.myClientConnections) {
            if (!clientConnectionManager.isConnected()) continue;
            stringBuilder.append("(").append(clientConnectionManager.getLocalHostAndPort()).append(")");
        }
        return stringBuilder.toString();
    }

    @Override
    public void setPrincipals(String[] stringArray) {
        for (ClientConnectionManager clientConnectionManager : this.myClientConnections) {
            clientConnectionManager.setPrincipals(stringArray);
        }
    }

    @Override
    public fSubject getSubjectFromConnection() throws nSessionNotConnectedException {
        return this.myClientConnections.get(0).getSubjectFromConnection();
    }

    @Override
    public String getServerProvidedURLList() {
        StringBuilder stringBuilder = new StringBuilder();
        for (ClientConnectionManager clientConnectionManager : this.myClientConnections) {
            stringBuilder.append("(").append(clientConnectionManager.getServerProvidedURLList()).append(")");
        }
        return stringBuilder.toString();
    }

    @Override
    public boolean isVirtual() {
        return false;
    }

    @Override
    public void updateConnectionListWithServerList() throws IOException, nIllegalArgumentException {
        for (ClientConnectionManager clientConnectionManager : this.myClientConnections) {
            clientConnectionManager.updateConnectionListWithServerList();
        }
    }

    @Override
    public List<fConnectionDetails> getSessionAttributesList() {
        throw new UnsupportedOperationException();
    }

    @Override
    public void registerExtensionCallback(nServerExtensionCallback nServerExtensionCallback2) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean isPaused() {
        return this.mySession.isPaused();
    }

    @Override
    public long getServerProvidedTransactionTTL() {
        long l = Long.MIN_VALUE;
        for (ClientConnectionManager clientConnectionManager : this.myClientConnections) {
            l = Math.max(clientConnectionManager.getServerProvidedTransactionTTL(), l);
        }
        return l;
    }

    @Override
    public long allocateTransactionID(nAbstractChannel nAbstractChannel2) {
        int n = 0;
        int n2 = 0;
        while (!(n2++ >= this.myClientConnections.size() || this.myClientConnections.get(n = this.myStoreManager.getStoreList(this.myStoreManager.getStoreManagerHelper().getAttributes(nAbstractChannel2).getUniqueId()).allocateNextPublishRequestLocation()).isConnected() && this.myStoreManager.getStoreList(nAbstractChannel2.getStoreAttributes().getUniqueId()).getHiddenStoreList()[n] != null)) {
        }
        return ((long)n << 32) + this.myTransactionalCounter.getAndIncrement();
    }

    @Override
    public String getClientAllocatedSessionID() {
        return this.myUniqueClientAllocatedConnectionID;
    }

    @Override
    public String getSessionInfo() {
        return "";
    }

    @Override
    public void resetConnection() {
        for (ClientConnectionManager clientConnectionManager : this.myClientConnections) {
            clientConnectionManager.resetConnection();
        }
    }

    public boolean isClosing() {
        return this.isClosing.get();
    }

    public boolean isAlive() {
        return !this.isClosing.get() && this.myClientConnectionsStateManager.isConnected();
    }

    public com.pcbsys.nirvana.base.clientimpl.SessionAttributes getSessionAttributes() {
        return this.sessionAttributes;
    }
}

