/*
 * Decompiled with CFR 0.152.
 */
package com.pcbsys.nirvana.base.clientimpl.multiconnection;

import com.pcbsys.foundation.logger.fLogLevel;
import com.pcbsys.foundation.threads.fScheduledTask;
import com.pcbsys.foundation.threads.fThreadScheduler;
import com.pcbsys.nirvana.base.clientimpl.ClientConnectionManager;
import com.pcbsys.nirvana.base.clientimpl.multiconnection.HSCommonHelper;
import com.pcbsys.nirvana.base.clientimpl.multiconnection.HSLogger;
import com.pcbsys.nirvana.base.clientimpl.multiconnection.NodeReconnectionHelper;
import com.pcbsys.nirvana.base.clientimpl.multiconnection.nStoreManagerImpl;
import com.pcbsys.nirvana.base.clientimpl.singleconnection.eventhandlers.EventHandlerInitialiser;
import com.pcbsys.nirvana.client.nRealmUnreachableException;
import com.pcbsys.nirvana.client.nReconnectHandler;
import com.pcbsys.nirvana.client.nSecurityException;
import com.pcbsys.nirvana.client.nSession;
import com.pcbsys.nirvana.client.nSessionNotConnectedException;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.atomic.AtomicBoolean;

class ClientConnectionStateManager {
    private final List<ClientConnectionManager> clientConnectionManagers;
    private final ArrayList<ClientConnectionManager> currentlyDisconnectedConnectionManagers;
    private final List<nReconnectHandler> reconnectHandlers;
    private final nSession rootSession;
    private final nStoreManagerImpl myStoreManager;
    private final NodeReconnectionHelper reconnectionHelper;
    private final AtomicBoolean isConnected;
    private boolean isClosed;
    private EventHandlerInitialiser eventHandlerInitialser;
    private boolean disconnectOnClusterFailure;
    private boolean sessionThreadsDaemon;

    ClientConnectionStateManager(nSession nSession2, List<ClientConnectionManager> list, nStoreManagerImpl nStoreManagerImpl2) {
        new ValidateConnectionState();
        this.isClosed = false;
        this.rootSession = nSession2;
        this.clientConnectionManagers = list;
        this.isConnected = new AtomicBoolean(false);
        for (ClientConnectionManager clientConnectionManager : this.clientConnectionManagers) {
            clientConnectionManager.addReconnectHandler(new ReconnectHandlerProxy(clientConnectionManager));
        }
        this.currentlyDisconnectedConnectionManagers = new ArrayList();
        this.reconnectHandlers = new ArrayList<nReconnectHandler>();
        this.myStoreManager = nStoreManagerImpl2;
        this.reconnectionHelper = new NodeReconnectionHelper(this.clientConnectionManagers, this.myStoreManager);
    }

    void close() {
        this.isClosed = true;
        this.reconnectHandlers.clear();
        for (ClientConnectionManager clientConnectionManager : this.clientConnectionManagers) {
            clientConnectionManager.close();
        }
        HSLogger.println(fLogLevel.DEBUG, "Horizontal scalability session has been closed: " + this.getInnerSessionsInfo());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void addReconnectHandler(nReconnectHandler nReconnectHandler2) {
        if (nReconnectHandler2 != null) {
            List<nReconnectHandler> list = this.reconnectHandlers;
            synchronized (list) {
                this.reconnectHandlers.add(nReconnectHandler2);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void removeReconnectHandler(nReconnectHandler nReconnectHandler2) {
        if (nReconnectHandler2 != null) {
            List<nReconnectHandler> list = this.reconnectHandlers;
            synchronized (list) {
                this.reconnectHandlers.remove(nReconnectHandler2);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void initialise(EventHandlerInitialiser eventHandlerInitialiser, boolean bl, boolean bl2) throws nSecurityException, nSessionNotConnectedException, nRealmUnreachableException {
        this.eventHandlerInitialser = eventHandlerInitialiser;
        this.disconnectOnClusterFailure = bl;
        this.sessionThreadsDaemon = bl2;
        ArrayList<ClientConnectionManager> arrayList = this.currentlyDisconnectedConnectionManagers;
        synchronized (arrayList) {
            for (ClientConnectionManager clientConnectionManager : this.clientConnectionManagers) {
                try {
                    clientConnectionManager.initialise(null, eventHandlerInitialiser, bl, bl2);
                }
                catch (nRealmUnreachableException | nSecurityException | nSessionNotConnectedException nBaseClientException2) {
                    this.currentlyDisconnectedConnectionManagers.add(clientConnectionManager);
                    if (this.currentlyDisconnectedConnectionManagers.size() != this.clientConnectionManagers.size()) continue;
                    this.currentlyDisconnectedConnectionManagers.clear();
                    throw nBaseClientException2;
                }
            }
        }
        this.isConnected.getAndSet(true);
        HSLogger.println(fLogLevel.DEBUG, "Horizontal scalability session has been established: " + this.getInnerSessionsInfo());
        fThreadScheduler.getInstance().addTask(new ValidateConnectionState(), 1000L);
    }

    public boolean isConnected() {
        return this.isConnected.get();
    }

    private String getInnerSessionsInfo() {
        String string = "SessionInfo: ";
        string = string + HSCommonHelper.createHSSessionInfo(this.clientConnectionManagers);
        return string;
    }

    class ReconnectHandlerProxy
    implements nReconnectHandler {
        private final ClientConnectionManager clientConnectionManager;

        ReconnectHandlerProxy(ClientConnectionManager clientConnectionManager) {
            this.clientConnectionManager = clientConnectionManager;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void disconnected(nSession nSession2) {
            ArrayList arrayList = ClientConnectionStateManager.this.currentlyDisconnectedConnectionManagers;
            synchronized (arrayList) {
                if (!ClientConnectionStateManager.this.currentlyDisconnectedConnectionManagers.contains(this.clientConnectionManager)) {
                    HSLogger.println(fLogLevel.DEBUG, "Inner HS session: " + this.clientConnectionManager.getSessionInfo() + " has disconnected");
                    ClientConnectionStateManager.this.currentlyDisconnectedConnectionManagers.add(this.clientConnectionManager);
                    ClientConnectionStateManager.this.reconnectionHelper.cleanUpOnDisconnect(this.clientConnectionManager);
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void reconnected(nSession nSession2) {
            ArrayList arrayList = ClientConnectionStateManager.this.currentlyDisconnectedConnectionManagers;
            synchronized (arrayList) {
                if (ClientConnectionStateManager.this.currentlyDisconnectedConnectionManagers.contains(this.clientConnectionManager)) {
                    HSLogger.println(fLogLevel.DEBUG, "Inner HS session: " + this.clientConnectionManager.getSessionInfo() + " has reconnected");
                    ClientConnectionStateManager.this.currentlyDisconnectedConnectionManagers.remove(this.clientConnectionManager);
                }
            }
            ClientConnectionStateManager.this.reconnectionHelper.refreshStoreManager(this.clientConnectionManager);
        }

        @Override
        public boolean tryAgain(nSession nSession2) {
            return true;
        }
    }

    class ValidateConnectionState
    extends fScheduledTask {
        ValidateConnectionState() {
        }

        @Override
        public long reSchedule() {
            if (ClientConnectionStateManager.this.isClosed) {
                return -1L;
            }
            return 1000L;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void execute() {
            ArrayList arrayList = ClientConnectionStateManager.this.currentlyDisconnectedConnectionManagers;
            synchronized (arrayList) {
                nReconnectHandler[] nReconnectHandlerArray;
                if (ClientConnectionStateManager.this.currentlyDisconnectedConnectionManagers.size() > 0) {
                    for (nReconnectHandler[] nReconnectHandlerArray2 : ClientConnectionStateManager.this.currentlyDisconnectedConnectionManagers) {
                        if (nReconnectHandlerArray2.isInitialised()) continue;
                        try {
                            nReconnectHandlerArray2.initialise(null, ClientConnectionStateManager.this.eventHandlerInitialser, ClientConnectionStateManager.this.disconnectOnClusterFailure, ClientConnectionStateManager.this.sessionThreadsDaemon);
                            HSLogger.println(fLogLevel.LOG, "Successfully initialised session for horizontal scalability session : " + nReconnectHandlerArray2.getSessionInfo());
                            ClientConnectionStateManager.this.reconnectionHelper.refreshStoreManager((ClientConnectionManager)nReconnectHandlerArray2);
                        }
                        catch (nRealmUnreachableException | nSecurityException | nSessionNotConnectedException nBaseClientException2) {
                            HSLogger.println(fLogLevel.LOG, "Attempted to initialise session for horizontal scalability session however failed with following exception", nBaseClientException2);
                        }
                    }
                }
                if (ClientConnectionStateManager.this.isConnected.get() && ClientConnectionStateManager.this.currentlyDisconnectedConnectionManagers.size() == ClientConnectionStateManager.this.clientConnectionManagers.size()) {
                    ClientConnectionStateManager.this.isConnected.getAndSet(false);
                    HSLogger.println(fLogLevel.DEBUG, "Horizontal scalability session has been disconnected: " + ClientConnectionStateManager.this.getInnerSessionsInfo());
                    nReconnectHandlerArray = new nReconnectHandler[ClientConnectionStateManager.this.reconnectHandlers.size()];
                    for (nReconnectHandler nReconnectHandler2 : nReconnectHandlerArray = ClientConnectionStateManager.this.reconnectHandlers.toArray(nReconnectHandlerArray)) {
                        nReconnectHandler2.disconnected(ClientConnectionStateManager.this.rootSession);
                    }
                } else if (!ClientConnectionStateManager.this.isConnected.get() && ClientConnectionStateManager.this.currentlyDisconnectedConnectionManagers.size() != ClientConnectionStateManager.this.clientConnectionManagers.size()) {
                    ClientConnectionStateManager.this.isConnected.getAndSet(true);
                    HSLogger.println(fLogLevel.DEBUG, "Horizontal scalability session has reconnected: " + ClientConnectionStateManager.this.getInnerSessionsInfo());
                    nReconnectHandlerArray = new nReconnectHandler[ClientConnectionStateManager.this.reconnectHandlers.size()];
                    for (nReconnectHandler nReconnectHandler3 : nReconnectHandlerArray = ClientConnectionStateManager.this.reconnectHandlers.toArray(nReconnectHandlerArray)) {
                        nReconnectHandler3.reconnected(ClientConnectionStateManager.this.rootSession);
                    }
                }
            }
        }
    }
}

