/*
 * Decompiled with CFR 0.152.
 */
package com.pcbsys.nirvana.base.clientimpl.multiconnection;

import com.pcbsys.foundation.logger.fLogLevel;
import com.pcbsys.nirvana.base.clientimpl.multiconnection.HSLogger;
import com.pcbsys.nirvana.base.clientimpl.multiconnection.StoreGroup;
import com.pcbsys.nirvana.base.clientimpl.nStoreManagerHelper;
import com.pcbsys.nirvana.base.nClientChannelList;
import com.pcbsys.nirvana.client.nConsumeEvent;
import com.pcbsys.nirvana.client.nEventListener;
import java.util.ArrayList;
import java.util.List;

public class EventListenerMultiplexer {
    private final List<nEventListener> hiddenEventListeners;
    private final StoreGroup storeGroup;
    private final nClientChannelList publicStore;

    public EventListenerMultiplexer(StoreGroup storeGroup, nStoreManagerHelper nStoreManagerHelper2, int n, boolean bl) {
        this.storeGroup = storeGroup;
        this.publicStore = nStoreManagerHelper2.getBaseChannel(storeGroup.getPublicStore()).getChannelList();
        this.hiddenEventListeners = new ArrayList<nEventListener>();
        for (int i = 0; i < n; ++i) {
            this.hiddenEventListeners.add(new HiddenEventListener(this, i, bl));
        }
    }

    public List<nEventListener> getHiddenEventListeners() {
        return this.hiddenEventListeners;
    }

    private static class HiddenEventListener
    implements nEventListener {
        private final EventListenerMultiplexer eventListenerMultiplexer;
        private final int connectionLocation;
        private final boolean storeEventMapping;

        HiddenEventListener(EventListenerMultiplexer eventListenerMultiplexer, int n, boolean bl) {
            this.eventListenerMultiplexer = eventListenerMultiplexer;
            this.connectionLocation = n;
            this.storeEventMapping = bl;
        }

        @Override
        public void go(nConsumeEvent nConsumeEvent2) {
            if (nConsumeEvent2.getEventID() == -2L) {
                HSLogger.println(fLogLevel.TRACE, "Received a channel deleted event, suppressing");
                return;
            }
            this.eventListenerMultiplexer.storeGroup.allocateEvent(nConsumeEvent2, this.connectionLocation, this.storeEventMapping);
            this.eventListenerMultiplexer.publicStore.push(nConsumeEvent2, nConsumeEvent2.getSignature());
        }
    }
}

