/*
 * Decompiled with CFR 0.152.
 */
package com.pcbsys.nirvana.base.clientimpl.multiconnection;

import com.pcbsys.foundation.logger.fLogLevel;
import com.pcbsys.nirvana.base.clientimpl.ClientConnectionManager;
import com.pcbsys.nirvana.base.clientimpl.multiconnection.AsynchronousEventListener;
import com.pcbsys.nirvana.base.clientimpl.multiconnection.DurableGroup;
import com.pcbsys.nirvana.base.clientimpl.multiconnection.HSLogger;
import com.pcbsys.nirvana.base.clientimpl.multiconnection.IteratorMetaData;
import com.pcbsys.nirvana.base.clientimpl.multiconnection.StoreGroup;
import com.pcbsys.nirvana.base.clientimpl.multiconnection.SynchronousEventConsumerManager;
import com.pcbsys.nirvana.base.clientimpl.multiconnection.nChannelIteratorWrapper;
import com.pcbsys.nirvana.base.clientimpl.multiconnection.nStoreManagerImpl;
import com.pcbsys.nirvana.base.events.nChannelNotFoundExceptionEvent;
import com.pcbsys.nirvana.base.events.nEvent;
import com.pcbsys.nirvana.base.events.nUserFind;
import com.pcbsys.nirvana.base.nChannelAttributes;
import com.pcbsys.nirvana.client.nAbstractChannel;
import com.pcbsys.nirvana.client.nChannel;
import com.pcbsys.nirvana.client.nChannelAlreadySubscribedException;
import com.pcbsys.nirvana.client.nChannelImpl;
import com.pcbsys.nirvana.client.nChannelNotFoundException;
import com.pcbsys.nirvana.client.nDurable;
import com.pcbsys.nirvana.client.nEventListener;
import com.pcbsys.nirvana.client.nIllegalArgumentException;
import com.pcbsys.nirvana.client.nNameAlreadyBoundException;
import com.pcbsys.nirvana.client.nNameDoesNotExistException;
import com.pcbsys.nirvana.client.nQueue;
import com.pcbsys.nirvana.client.nRequestTimedOutException;
import com.pcbsys.nirvana.client.nSecurityException;
import com.pcbsys.nirvana.client.nSelectorParserException;
import com.pcbsys.nirvana.client.nSessionNotConnectedException;
import com.pcbsys.nirvana.client.nSessionPausedException;
import com.pcbsys.nirvana.client.nUnexpectedResponseException;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

public class NodeReconnectionHelper {
    private final List<ClientConnectionManager> myClientConnectionManagers;
    private final nStoreManagerImpl myStoreManager;

    public NodeReconnectionHelper(List<ClientConnectionManager> list, nStoreManagerImpl nStoreManagerImpl2) {
        this.myClientConnectionManagers = list;
        this.myStoreManager = nStoreManagerImpl2;
    }

    void refreshStoreManager(ClientConnectionManager clientConnectionManager) {
        this.refreshStores(clientConnectionManager);
        this.refreshDurableObjects(clientConnectionManager);
        this.handleSubscriptions(clientConnectionManager);
        this.handleSyncSubscriptions(clientConnectionManager);
    }

    void cleanUpOnDisconnect(ClientConnectionManager clientConnectionManager) {
        int n = this.myClientConnectionManagers.indexOf(clientConnectionManager);
        for (nAbstractChannel nAbstractChannel2 : this.myStoreManager.getStores()) {
            Object object;
            StoreGroup storeGroup = this.myStoreManager.getStoreList(nAbstractChannel2.getStoreAttributes().getUniqueId());
            if (nAbstractChannel2.getStoreAttributes().getChannelMode() == 101) {
                long l = storeGroup.getPublicStore().getStoreAttributes().getUniqueId();
                if (!this.myStoreManager.getReaderManager().hasStoreReaders(l) || (object = storeGroup.getAndCleanEidsByConnection(n)).size() <= 0) continue;
                this.myStoreManager.getReaderManager().rollbackOnDisconnect((List<Long>)object, l);
                continue;
            }
            HashMap<Long, SynchronousEventConsumerManager> hashMap = storeGroup.getIteratorManagers();
            Iterator<Map.Entry<Long, SynchronousEventConsumerManager>> iterator = hashMap.entrySet().iterator();
            while (iterator.hasNext()) {
                object = iterator.next().getValue();
                ((SynchronousEventConsumerManager)object).clearWrapperEntry(n);
            }
        }
    }

    private void refreshStores(ClientConnectionManager clientConnectionManager) {
        List<nAbstractChannel> list = clientConnectionManager.getStoreManager().getStores();
        for (ClientConnectionManager clientConnectionManager2 : this.myClientConnectionManagers) {
            List<nAbstractChannel> list2 = clientConnectionManager2.getStoreManager().getStores();
            if (clientConnectionManager2 == clientConnectionManager || list2 == list) continue;
            for (nAbstractChannel nAbstractChannel2 : list2) {
                this.addLocalStoreToHSSession(nAbstractChannel2, clientConnectionManager);
            }
        }
    }

    private void handleSyncSubscriptions(ClientConnectionManager clientConnectionManager) {
        int n = this.myClientConnectionManagers.indexOf(clientConnectionManager);
        for (nAbstractChannel nAbstractChannel2 : this.myStoreManager.getStores()) {
            long l = nAbstractChannel2.getStoreAttributes().getUniqueId();
            StoreGroup storeGroup = this.myStoreManager.getStoreList(l);
            HashMap<Long, SynchronousEventConsumerManager> hashMap = storeGroup.getIteratorManagers();
            Iterator<Map.Entry<Long, SynchronousEventConsumerManager>> iterator = hashMap.entrySet().iterator();
            while (iterator.hasNext()) {
                boolean bl;
                SynchronousEventConsumerManager synchronousEventConsumerManager = iterator.next().getValue();
                if (synchronousEventConsumerManager.getChannelIterators()[n] != null || !(bl = synchronousEventConsumerManager.shouldAddIterator(n))) continue;
                IteratorMetaData iteratorMetaData = synchronousEventConsumerManager.getIteratorMetaData();
                DurableGroup durableGroup = storeGroup.getDurableManager().getDurableGroup(iteratorMetaData.durableID);
                nDurable nDurable2 = durableGroup == null ? null : durableGroup.getHiddenDurableList()[n];
                synchronousEventConsumerManager.setChannelIterator(new nChannelIteratorWrapper(this.myStoreManager, (nChannel)storeGroup.getHiddenStoreList()[n], iteratorMetaData.startEID, iteratorMetaData.selector, nDurable2, iteratorMetaData.autoAck, iteratorMetaData.maxUnackedEvents, iteratorMetaData.storeEventMappings), n);
            }
        }
    }

    private void addLocalStoreToHSSession(nAbstractChannel nAbstractChannel2, ClientConnectionManager clientConnectionManager) {
        long l = nAbstractChannel2.getStoreAttributes().getUniqueId();
        if (clientConnectionManager.getStoreManager().get(l) == null) {
            nUserFind nUserFind2 = new nUserFind(this.myStoreManager.getStoreManagerHelper().getAttributes(nAbstractChannel2));
            try {
                nEvent nEvent2 = clientConnectionManager.getEventProcessor().writeEvent(nUserFind2);
                if (nEvent2 instanceof nUserFind) {
                    nUserFind nUserFind3 = (nUserFind)nEvent2;
                    nChannelAttributes nChannelAttributes2 = nUserFind3.getChannelAttributes();
                    if (nChannelAttributes2.getChannelMode() == 100) {
                        ((com.pcbsys.nirvana.base.clientimpl.singleconnection.nStoreManagerImpl)clientConnectionManager.getStoreManager()).createAndPutChannel(nChannelAttributes2);
                        HSLogger.println(fLogLevel.DEBUG, "Successfully obtained channel " + nChannelAttributes2.getName() + " on : " + clientConnectionManager.getSessionInfo());
                    } else {
                        ((com.pcbsys.nirvana.base.clientimpl.singleconnection.nStoreManagerImpl)clientConnectionManager.getStoreManager()).createAndPutQueue(nChannelAttributes2);
                        HSLogger.println(fLogLevel.DEBUG, "Successfully obtained queue " + nChannelAttributes2.getName() + " on : " + clientConnectionManager.getSessionInfo());
                    }
                    if (this.myStoreManager.getStoreList(l) != null && this.myStoreManager.getStoreList(l).getHiddenStoreList()[this.myClientConnectionManagers.indexOf(clientConnectionManager)] == null) {
                        this.myStoreManager.getStoreList(l).addHiddenStore(clientConnectionManager.getStoreManager().get(l), clientConnectionManager);
                    }
                } else if (nEvent2 instanceof nChannelNotFoundExceptionEvent) {
                    if (nAbstractChannel2 instanceof nChannel) {
                        HSLogger.println(fLogLevel.DEBUG, "Unable to find channel " + ((nChannel)nAbstractChannel2).getName() + " on : " + clientConnectionManager.getSessionInfo());
                    } else if (nAbstractChannel2 instanceof nQueue) {
                        HSLogger.println(fLogLevel.DEBUG, "Unable to find queue " + ((nQueue)nAbstractChannel2).getName() + " on : " + clientConnectionManager.getSessionInfo());
                    }
                }
            }
            catch (nRequestTimedOutException | nSessionNotConnectedException | nSessionPausedException nBaseClientException2) {
                HSLogger.println(fLogLevel.TRACE, "Failed to send event: " + nUserFind2.getClass().getSimpleName() + " to connection : " + clientConnectionManager.getSessionInfo(), nBaseClientException2);
            }
            catch (nIllegalArgumentException nIllegalArgumentException2) {
                HSLogger.println(fLogLevel.TRACE, "Failed to obtain channel " + nAbstractChannel2.getStoreAttributes().getName() + " on : " + clientConnectionManager.getSessionInfo(), nIllegalArgumentException2);
            }
        } else if (this.myStoreManager.getStoreList(l) != null && this.myStoreManager.getStoreList(l).getHiddenStoreList()[this.myClientConnectionManagers.indexOf(clientConnectionManager)] == null) {
            this.myStoreManager.getStoreList(l).addHiddenStore(clientConnectionManager.getStoreManager().get(l), clientConnectionManager);
        }
    }

    private void refreshDurableObjects(ClientConnectionManager clientConnectionManager) {
        for (ClientConnectionManager clientConnectionManager2 : this.myClientConnectionManagers) {
            List<nAbstractChannel> list = clientConnectionManager2.getStoreManager().getStores();
            if (clientConnectionManager2 == clientConnectionManager) continue;
            for (nAbstractChannel nAbstractChannel2 : list) {
                this.addLocalDurableToHSSession(nAbstractChannel2, clientConnectionManager);
            }
        }
    }

    private void addLocalDurableToHSSession(nAbstractChannel nAbstractChannel2, ClientConnectionManager clientConnectionManager) {
        long l = nAbstractChannel2.getStoreAttributes().getUniqueId();
        StoreGroup storeGroup = this.myStoreManager.getStoreList(l);
        nAbstractChannel nAbstractChannel3 = clientConnectionManager.getStoreManager().get(l);
        if (this.myStoreManager.getStoreList(l) != null && this.myStoreManager.getStoreList(l).getPublicStore() instanceof nChannel && nAbstractChannel3 instanceof nChannel) {
            List<DurableGroup> list = storeGroup.getDurableManager().getDurableGroups();
            for (DurableGroup durableGroup : list) {
                String string = durableGroup.getBaseNamedObject().getName();
                try {
                    int n = this.myClientConnectionManagers.indexOf(clientConnectionManager);
                    nDurable nDurable2 = ((nChannel)nAbstractChannel3).getDurableManager().get(string);
                    if (nDurable2 != null) {
                        if (durableGroup.getHiddenDurableList()[n] != null) continue;
                        durableGroup.addHiddenDurable(nDurable2, n);
                        HSLogger.println(fLogLevel.DEBUG, "Successfully obtained durable " + nDurable2.getName() + " on : " + clientConnectionManager.getSessionInfo());
                        continue;
                    }
                    HSLogger.println(fLogLevel.DEBUG, "Failed to obtain durable " + string + " on channel " + ((nChannel)nAbstractChannel3).getName() + " from connection : " + clientConnectionManager.getSessionInfo());
                }
                catch (Exception exception) {
                    HSLogger.println(fLogLevel.WARN, "Error while trying to obtain durable " + string + " on channel " + ((nChannel)nAbstractChannel3).getName() + " from connection " + clientConnectionManager.getSessionInfo(), exception);
                    return;
                }
            }
        }
    }

    private void handleSubscriptions(ClientConnectionManager clientConnectionManager) {
        for (nAbstractChannel nAbstractChannel2 : this.myStoreManager.getStores()) {
            nEventListener nEventListener2;
            nAbstractChannel nAbstractChannel3;
            long l = nAbstractChannel2.getStoreAttributes().getUniqueId();
            if (!this.myStoreManager.getStoreList(l).getAsyncEventListener().hasActiveSubscription() || (nAbstractChannel3 = clientConnectionManager.getStoreManager().get(l)) == null || (nEventListener2 = this.myStoreManager.getStoreManagerHelper().getBaseChannel(nAbstractChannel3).getChannelList().getSubscriber()) != null) continue;
            this.addSubscription(clientConnectionManager, l);
        }
    }

    private void addSubscription(ClientConnectionManager clientConnectionManager, long l) {
        nChannelImpl nChannelImpl2 = this.getStoreToUse(clientConnectionManager, l);
        if (nChannelImpl2 == null) {
            HSLogger.println(fLogLevel.WARN, "Unable to find channel " + l + " on connection " + clientConnectionManager.getSessionInfo() + ". Therefore subscription cannot be re-established");
            return;
        }
        AsynchronousEventListener asynchronousEventListener = this.myStoreManager.getStoreList(l).getAsyncEventListener();
        nEventListener nEventListener2 = asynchronousEventListener.getEventListenerMultiplexer().getHiddenEventListeners().get(this.myClientConnectionManagers.indexOf(clientConnectionManager));
        if (asynchronousEventListener.isDurableSubscription()) {
            this.addDurableSubscriber(clientConnectionManager, nEventListener2, nChannelImpl2, asynchronousEventListener, l);
        } else {
            this.addSubscriber(clientConnectionManager, nEventListener2, nChannelImpl2, asynchronousEventListener);
        }
    }

    private void addSubscriber(ClientConnectionManager clientConnectionManager, nEventListener nEventListener2, nChannelImpl nChannelImpl2, AsynchronousEventListener asynchronousEventListener) {
        try {
            HSLogger.println(fLogLevel.DEBUG, "Adding subscription to " + nChannelImpl2.getBaseChannelAttributes().getName() + " from connection: " + clientConnectionManager.getSessionInfo());
            nChannelImpl2.addSubscriber(nEventListener2, asynchronousEventListener.getSelector(), asynchronousEventListener.getEID(), null, false, asynchronousEventListener.isMaintainPriority(), asynchronousEventListener.isInfiniteWindow());
        }
        catch (nChannelAlreadySubscribedException | nChannelNotFoundException | nRequestTimedOutException | nSecurityException | nSelectorParserException | nSessionNotConnectedException | nSessionPausedException | nUnexpectedResponseException nBaseClientException2) {
            HSLogger.println(fLogLevel.WARN, "Exception while adding subscription on connection: " + clientConnectionManager.getSessionInfo() + " " + nBaseClientException2.getMessage(), nBaseClientException2);
        }
    }

    private void addDurableSubscriber(ClientConnectionManager clientConnectionManager, nEventListener nEventListener2, nChannelImpl nChannelImpl2, AsynchronousEventListener asynchronousEventListener, long l) {
        int n = this.myClientConnectionManagers.indexOf(clientConnectionManager);
        nDurable nDurable2 = this.myStoreManager.getStoreList(l).getDurableManager().getDurableGroup(asynchronousEventListener.getDurableID()).getHiddenDurableList()[n];
        if (nDurable2 == null) {
            HSLogger.println(fLogLevel.WARN, "Unable to find durable on channel " + nChannelImpl2.getBaseChannelAttributes().getName() + ". Therefore subscription to this object cannot be re-established");
            return;
        }
        try {
            HSLogger.println(fLogLevel.DEBUG, "Adding durable subscription to " + nChannelImpl2.getBaseChannelAttributes().getName() + " for durable " + nDurable2.getName() + " from connection: " + clientConnectionManager.getSessionInfo());
            nChannelImpl2.addSubscriber(nEventListener2, nDurable2, asynchronousEventListener.getSelector(), null, false, (int)asynchronousEventListener.getEID());
        }
        catch (nChannelAlreadySubscribedException | nChannelNotFoundException | nIllegalArgumentException | nNameAlreadyBoundException | nNameDoesNotExistException | nRequestTimedOutException | nSecurityException | nSelectorParserException | nSessionNotConnectedException | nSessionPausedException | nUnexpectedResponseException nBaseClientException2) {
            HSLogger.println(fLogLevel.WARN, "Exception while adding subscription on connection: " + clientConnectionManager.getSessionInfo() + " " + nBaseClientException2.getMessage(), nBaseClientException2);
        }
    }

    private nChannelImpl getStoreToUse(ClientConnectionManager clientConnectionManager, long l) {
        int n = this.myClientConnectionManagers.indexOf(clientConnectionManager);
        StoreGroup storeGroup = this.myStoreManager.getStoreList(l);
        nAbstractChannel nAbstractChannel2 = storeGroup.getHiddenStoreList()[n];
        return this.myStoreManager.getStoreManagerHelper().getBaseChannel(nAbstractChannel2);
    }
}

