/*
 * Decompiled with CFR 0.152.
 */
package com.pcbsys.nirvana.base.clientimpl.multiconnection;

import com.pcbsys.nirvana.base.clientimpl.ClientConnectionManager;
import com.pcbsys.nirvana.base.clientimpl.multiconnection.ExceptionWrapper;
import com.pcbsys.nirvana.base.clientimpl.singleconnection.ClientConnectionManagerImpl;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class OperationExceptionValidator {
    private final List<ClientConnectionManager> myClientConnections;
    private final Map<String, ExceptionWrapper> exceptionWrapperList = new HashMap<String, ExceptionWrapper>();

    public OperationExceptionValidator(List<ClientConnectionManager> list) {
        this.myClientConnections = list;
    }

    public void addInnerSessionException(int n, String string, String string2) {
        ExceptionWrapper exceptionWrapper = this.exceptionWrapperList.get(string);
        if (exceptionWrapper == null) {
            ExceptionWrapper exceptionWrapper2 = new ExceptionWrapper();
            exceptionWrapper2.add(string2, n);
            this.exceptionWrapperList.put(string, exceptionWrapper2);
        } else if (!exceptionWrapper.contaisSingleException(string2, n)) {
            exceptionWrapper.add(string2, n);
        }
    }

    public boolean validateException(int n, String string) {
        switch (n) {
            case 38: {
                return this.validateShouldThrow(string, n);
            }
        }
        return false;
    }

    private String[] getAllClientUniqueSessionIDs() {
        String[] stringArray = new String[this.myClientConnections.size()];
        for (int i = 0; i < this.myClientConnections.size(); ++i) {
            stringArray[i] = ((ClientConnectionManagerImpl)this.myClientConnections.get(i)).getUniqueClientAllocatedID();
        }
        return stringArray;
    }

    private boolean validateShouldThrow(String string, int n) {
        ExceptionWrapper exceptionWrapper = this.exceptionWrapperList.get(string);
        return exceptionWrapper != null && exceptionWrapper.containsKey(n) && exceptionWrapper.containsAll(this.getAllClientUniqueSessionIDs(), n);
    }

    public void removeStoreEntries(String string) {
        this.exceptionWrapperList.remove(string);
    }

    public void removeClientConnectionManager(String string) {
        ClientConnectionManager clientConnectionManager = null;
        for (ClientConnectionManager clientConnectionManager2 : this.myClientConnections) {
            if (!clientConnectionManager2.getClientAllocatedSessionID().equals(string)) continue;
            clientConnectionManager = clientConnectionManager2;
        }
        this.myClientConnections.remove(clientConnectionManager);
    }
}

