/*
 * Decompiled with CFR 0.152.
 */
package com.pcbsys.nirvana.base.clientimpl.multiconnection;

import com.pcbsys.foundation.logger.fLogLevel;
import com.pcbsys.nirvana.base.clientimpl.multiconnection.HSLogger;
import com.pcbsys.nirvana.base.clientimpl.multiconnection.eventhandlers.EventProcessor;
import com.pcbsys.nirvana.base.events.nEvent;
import com.pcbsys.nirvana.base.events.nSynchronous;
import com.pcbsys.nirvana.base.events.nSynchronousCallbackWrapper;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;

public class OutgoingEventMultiplexWrapper {
    private final nEvent originalEvent;
    protected final nEvent[] outgoingEventWrappers;
    private final Thread thread;
    protected final CountDownLatch countDownLatch;
    protected boolean isComplete = false;
    private boolean clear = false;
    private boolean wasPaused = false;

    public OutgoingEventMultiplexWrapper(Thread thread, nEvent nEvent2, nEvent[] nEventArray) {
        this.thread = thread;
        this.originalEvent = nEvent2;
        this.countDownLatch = null;
        this.outgoingEventWrappers = nEventArray;
    }

    public OutgoingEventMultiplexWrapper(Thread thread, nEvent nEvent2) {
        this.thread = thread;
        this.originalEvent = nEvent2;
        this.countDownLatch = null;
        this.outgoingEventWrappers = new nEvent[0];
    }

    public OutgoingEventMultiplexWrapper(Thread thread, nSynchronous nSynchronous2, EventProcessor eventProcessor) {
        this.thread = thread;
        this.originalEvent = nSynchronous2;
        boolean bl = nSynchronous2.isSynchronous();
        if (bl) {
            this.outgoingEventWrappers = new nSynchronousCallbackWrapper[eventProcessor.getCountOfConnections()];
            this.countDownLatch = new CountDownLatch(eventProcessor.getCountOfConnections());
        } else {
            this.outgoingEventWrappers = new nEvent[eventProcessor.getCountOfConnections()];
            this.countDownLatch = null;
        }
        for (int i = 0; i < eventProcessor.getCountOfConnections(); ++i) {
            if (eventProcessor.getClientConnectionsHidden().get(i).isConnected()) {
                if (bl) {
                    this.outgoingEventWrappers[i] = new nSynchronousCallbackWrapper(nSynchronous2, this.countDownLatch);
                    continue;
                }
                this.outgoingEventWrappers[i] = nSynchronous2;
                continue;
            }
            HSLogger.println(fLogLevel.WARN, "Could not send event: " + nSynchronous2.getClass().getSimpleName() + " to: " + eventProcessor.getClientConnectionsHidden().get(i).getSessionInfo() + " as session is not connected.");
            if (this.countDownLatch == null) continue;
            this.countDownLatch.countDown();
        }
    }

    public OutgoingEventMultiplexWrapper(Thread thread, nSynchronous nSynchronous2, nSynchronousCallbackWrapper[] nSynchronousCallbackWrapperArray, CountDownLatch countDownLatch) {
        this.thread = thread;
        this.originalEvent = nSynchronous2;
        this.outgoingEventWrappers = nSynchronousCallbackWrapperArray;
        this.countDownLatch = countDownLatch;
        for (nSynchronousCallbackWrapper nSynchronousCallbackWrapper2 : nSynchronousCallbackWrapperArray) {
            if (nSynchronousCallbackWrapper2 == null) continue;
            nSynchronousCallbackWrapper2.setCountDownLatch(countDownLatch);
        }
    }

    public long getRequestId() {
        if (this.originalEvent instanceof nSynchronous) {
            return ((nSynchronous)this.originalEvent).getRequestId();
        }
        return -1L;
    }

    public nEvent getOriginalEvent() {
        return this.originalEvent;
    }

    public nEvent[] getOutgoingEventWrappers() {
        return this.outgoingEventWrappers;
    }

    public Thread getThread() {
        return this.thread;
    }

    synchronized void clear() {
        this.isComplete = true;
        this.clear = true;
        this.clearCountDownLatch();
    }

    synchronized void paused() {
        this.wasPaused = true;
        this.isComplete = true;
        this.clear = true;
        this.clearCountDownLatch();
    }

    void clearCountDownLatch() {
        if (this.countDownLatch != null) {
            while (this.countDownLatch.getCount() > 0L) {
                this.countDownLatch.countDown();
            }
        }
    }

    void decreaseCountDownLatch() {
        if (this.countDownLatch != null && this.countDownLatch.getCount() > 0L) {
            this.countDownLatch.countDown();
        }
    }

    public boolean wasPaused() {
        return this.wasPaused;
    }

    public boolean isClear() {
        return this.clear;
    }

    public void waitForComplete(long l) throws InterruptedException {
        if (this.countDownLatch != null) {
            this.countDownLatch.await(l, TimeUnit.MILLISECONDS);
        }
    }
}

