/*
 * Decompiled with CFR 0.152.
 */
package com.pcbsys.nirvana.base.clientimpl.multiconnection;

import com.pcbsys.foundation.drivers.fConnectionDetails;
import java.util.ArrayList;
import java.util.List;

class SessionAttributes
implements com.pcbsys.nirvana.base.clientimpl.SessionAttributes {
    private final List<List<fConnectionDetails>> connectionDetails;
    private final String[] enabledCiphers;
    private final String keyStorePath;
    private final String keyStorePassword;
    private final String certificateAlias;
    private final String trustStorePath;
    private final String trustStorePassword;
    private final String sslProtocol;
    private final String sessionNameIdentifier;
    private final long reconnectInterval;
    private final long initialConnectionRetryCount;
    private final boolean isRequestPriorityConnection;
    private final boolean isFollowTheMaster;
    private final String clientAppID;
    private boolean isDisconnectOnClusterFailure;
    private final boolean isDisableReconnect;
    private final boolean isRequestUnthrottledConnection;
    private boolean isSessionThreadsDaemon;
    private final boolean isAdviseAsynchronousEventListenersOfStoreDelete;
    private final boolean isReconnectImmediately;

    public SessionAttributes(com.pcbsys.nirvana.base.clientimpl.SessionAttributes sessionAttributes, int n) {
        this.enabledCiphers = sessionAttributes.getEnabledCiphers();
        this.keyStorePath = sessionAttributes.getKeyStorePath();
        this.keyStorePassword = sessionAttributes.getKeyStorePassword();
        this.certificateAlias = sessionAttributes.getCertificateAlias();
        this.trustStorePath = sessionAttributes.getTrustStorePath();
        this.trustStorePassword = sessionAttributes.getTrustStorePassword();
        this.sslProtocol = sessionAttributes.getSslProtocol();
        this.sessionNameIdentifier = sessionAttributes.getSessionName();
        this.reconnectInterval = sessionAttributes.getReconnectInterval();
        this.initialConnectionRetryCount = sessionAttributes.getInitialConnectionRetryCount();
        this.isRequestPriorityConnection = sessionAttributes.isRequestPriorityConnection();
        this.isFollowTheMaster = sessionAttributes.isFollowTheMaster();
        this.isDisconnectOnClusterFailure = sessionAttributes.isDisconnectOnClusterFailure();
        this.isDisableReconnect = sessionAttributes.isDisableReconnect();
        this.isRequestUnthrottledConnection = sessionAttributes.isRequestUnthrottledConnection();
        this.isSessionThreadsDaemon = sessionAttributes.isSessionThreadsDaemon();
        this.isAdviseAsynchronousEventListenersOfStoreDelete = sessionAttributes.isAdviseAsynchronousEventListenersOfStoreDelete();
        this.isReconnectImmediately = sessionAttributes.isReconnectImmediately();
        this.connectionDetails = new ArrayList<List<fConnectionDetails>>();
        this.connectionDetails.add(sessionAttributes.getConnectionDetails().get(n));
        this.clientAppID = sessionAttributes.getClientAppID();
    }

    @Override
    public List<List<fConnectionDetails>> getConnectionDetails() {
        return this.connectionDetails;
    }

    @Override
    public boolean isSSLConfigured() {
        return this.getTrustStorePath() != null || this.getTrustStorePassword() != null || this.getKeyStorePath() != null || this.getKeyStorePassword() != null || this.getCertificateAlias() != null || this.getEnabledCiphers() != null || this.getSslProtocol() != null;
    }

    @Override
    public String[] getEnabledCiphers() {
        return this.enabledCiphers;
    }

    @Override
    public String getKeyStorePath() {
        return this.keyStorePath;
    }

    @Override
    public String getKeyStorePassword() {
        return this.keyStorePassword;
    }

    @Override
    public String getCertificateAlias() {
        return this.certificateAlias;
    }

    @Override
    public String getTrustStorePath() {
        return this.trustStorePath;
    }

    @Override
    public String getTrustStorePassword() {
        return this.trustStorePassword;
    }

    @Override
    public String getSslProtocol() {
        return this.sslProtocol;
    }

    @Override
    public String getSessionName() {
        return this.sessionNameIdentifier;
    }

    @Override
    public long getReconnectInterval() {
        return this.reconnectInterval;
    }

    @Override
    public long getInitialConnectionRetryCount() {
        return this.initialConnectionRetryCount;
    }

    @Override
    public boolean isHorizontalScalabilitySession() {
        return false;
    }

    @Override
    public String getClientAppID() {
        return this.clientAppID;
    }

    @Override
    @Deprecated
    public boolean isRequestPriorityConnection() {
        return this.isRequestPriorityConnection;
    }

    @Override
    public boolean isFollowTheMaster() {
        return this.isFollowTheMaster;
    }

    @Override
    public boolean isDisconnectOnClusterFailure() {
        return this.isDisconnectOnClusterFailure;
    }

    @Override
    public void isDisconnectOnClusterFailure(boolean bl) {
        this.isDisconnectOnClusterFailure = bl;
    }

    @Override
    public boolean isDisableReconnect() {
        return this.isDisableReconnect;
    }

    @Override
    public boolean isRequestUnthrottledConnection() {
        return this.isRequestUnthrottledConnection;
    }

    @Override
    public boolean isSessionThreadsDaemon() {
        return this.isSessionThreadsDaemon;
    }

    @Override
    public void isSessionThreadsDaemon(boolean bl) {
        this.isSessionThreadsDaemon = bl;
    }

    @Override
    public boolean isAdviseAsynchronousEventListenersOfStoreDelete() {
        return this.isAdviseAsynchronousEventListenersOfStoreDelete;
    }

    @Override
    public boolean isReconnectImmediately() {
        return this.isReconnectImmediately;
    }

    public String toString() {
        return "nSessionAttributes:conns=" + this.connectionDetails.size() + "/" + this.connectionDetails;
    }
}

