/*
 * Decompiled with CFR 0.152.
 */
package com.pcbsys.nirvana.base.clientimpl.multiconnection;

import com.pcbsys.foundation.collections.fast.Long2ObjectOpenAddressingHashMap;
import com.pcbsys.foundation.logger.fLogLevel;
import com.pcbsys.nirvana.base.clientimpl.ClientConnectionManager;
import com.pcbsys.nirvana.base.clientimpl.multiconnection.AsynchronousEventListener;
import com.pcbsys.nirvana.base.clientimpl.multiconnection.EventListenerMultiplexer;
import com.pcbsys.nirvana.base.clientimpl.multiconnection.HSLogger;
import com.pcbsys.nirvana.base.clientimpl.multiconnection.SynchronousEventConsumerManager;
import com.pcbsys.nirvana.base.clientimpl.multiconnection.nDurableManagerImpl;
import com.pcbsys.nirvana.base.clientimpl.nStoreManagerHelper;
import com.pcbsys.nirvana.base.events.nPublished;
import com.pcbsys.nirvana.base.events.nUserSubscribe;
import com.pcbsys.nirvana.base.nConsumeEventHelper;
import com.pcbsys.nirvana.client.nAbstractChannel;
import com.pcbsys.nirvana.client.nChannelImpl;
import com.pcbsys.nirvana.client.nConsumeEvent;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicLong;

public class StoreGroup {
    private final nAbstractChannel publicStore;
    private final nAbstractChannel[] hiddenStoreList;
    private final nDurableManagerImpl durableManager;
    private final AtomicLong eventIdentifier;
    private final Long2ObjectOpenAddressingHashMap<EventGrouping> outStandingEvents;
    private final nStoreManagerHelper storeManagerHelper;
    private final HashMap<Long, SynchronousEventConsumerManager> synchronousIteratorEventConsumerManagers;
    private final HashMap<Long, SynchronousEventConsumerManager> synchronousReaderEventConsumerManagers;
    private final Map<Integer, Map<Long, int[]>> readerIndexesMap;
    private final List<ClientConnectionManager> myClientConnectionManagers;
    private final AsynchronousEventListener myAsyncEventListener;
    private int nextPublishRequestLocation;

    StoreGroup(nAbstractChannel nAbstractChannel2, nAbstractChannel[] nAbstractChannelArray, nStoreManagerHelper nStoreManagerHelper2, List<ClientConnectionManager> list) {
        this.publicStore = nAbstractChannel2;
        this.hiddenStoreList = nAbstractChannelArray;
        this.durableManager = new nDurableManagerImpl();
        this.eventIdentifier = new AtomicLong(-1L);
        this.outStandingEvents = new Long2ObjectOpenAddressingHashMap();
        this.storeManagerHelper = nStoreManagerHelper2;
        this.synchronousIteratorEventConsumerManagers = new HashMap();
        this.synchronousReaderEventConsumerManagers = new HashMap();
        this.nextPublishRequestLocation = 0;
        this.readerIndexesMap = new HashMap<Integer, Map<Long, int[]>>();
        this.myClientConnectionManagers = list;
        this.myAsyncEventListener = new AsynchronousEventListener();
    }

    public nAbstractChannel getPublicStore() {
        return this.publicStore;
    }

    public nAbstractChannel[] getHiddenStoreList() {
        return this.hiddenStoreList;
    }

    public void addHiddenStore(nAbstractChannel nAbstractChannel2, ClientConnectionManager clientConnectionManager) {
        int n = this.myClientConnectionManagers.indexOf(clientConnectionManager);
        if (this.hiddenStoreList[n] == null) {
            this.hiddenStoreList[n] = nAbstractChannel2;
        }
    }

    public nDurableManagerImpl getDurableManager() {
        return this.durableManager;
    }

    public Map<Integer, Map<Long, int[]>> getReaderIndexesMap() {
        return this.readerIndexesMap;
    }

    public synchronized int allocateNextPublishRequestLocation() {
        this.nextPublishRequestLocation = (this.nextPublishRequestLocation + 1) % this.hiddenStoreList.length;
        return this.nextPublishRequestLocation;
    }

    private long allocateEventIdentifier() {
        return this.eventIdentifier.incrementAndGet();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void allocateEvent(nConsumeEvent nConsumeEvent2, int n, boolean bl) {
        long l = this.allocateEventIdentifier();
        if (HSLogger.canLog(fLogLevel.TRACE)) {
            this.logEventInfo(nConsumeEvent2.getEventID(), l, this.hiddenStoreList[n], this.myClientConnectionManagers.get(n));
        }
        if (bl) {
            EventGrouping eventGrouping = new EventGrouping(l, nConsumeEvent2.getEventID(), nConsumeEventHelper.getEventChannel(nConsumeEvent2), nConsumeEventHelper.getDurableIdentifier(nConsumeEvent2), n);
            Long2ObjectOpenAddressingHashMap<EventGrouping> long2ObjectOpenAddressingHashMap = this.outStandingEvents;
            synchronized (long2ObjectOpenAddressingHashMap) {
                this.outStandingEvents.put(l, eventGrouping);
            }
        }
        nConsumeEvent2.setEventID(l);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void allocateEvent(nPublished nPublished2, int n, long l, boolean bl) {
        if (nPublished2 == null) {
            return;
        }
        long l2 = this.allocateEventIdentifier();
        if (HSLogger.canLog(fLogLevel.TRACE)) {
            this.logEventInfo(nPublished2.getEID(), l2, this.hiddenStoreList[n], this.myClientConnectionManagers.get(n));
        }
        if (bl) {
            EventGrouping eventGrouping = new EventGrouping(l2, nPublished2.getEID(), this.storeManagerHelper.getBaseChannel(this.hiddenStoreList[n]), l, n);
            Long2ObjectOpenAddressingHashMap<EventGrouping> long2ObjectOpenAddressingHashMap = this.outStandingEvents;
            synchronized (long2ObjectOpenAddressingHashMap) {
                this.outStandingEvents.put(l2, eventGrouping);
            }
        }
        nPublished2.setEID(l2);
    }

    public void clearEventMappings() {
        this.outStandingEvents.clear();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public EventGrouping getAndReleaseEvent(long l) {
        HSLogger.println(fLogLevel.TRACE, "Releasing event: " + l);
        Long2ObjectOpenAddressingHashMap<EventGrouping> long2ObjectOpenAddressingHashMap = this.outStandingEvents;
        synchronized (long2ObjectOpenAddressingHashMap) {
            return this.outStandingEvents.remove(l);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public EventGrouping[] getAndReleaseEventEqualAndLesser(long l) {
        HSLogger.println(fLogLevel.TRACE, "Releasing equal and less than: " + l);
        EventGrouping[] eventGroupingArray = new EventGrouping[this.hiddenStoreList.length];
        Long2ObjectOpenAddressingHashMap<EventGrouping> long2ObjectOpenAddressingHashMap = this.outStandingEvents;
        synchronized (long2ObjectOpenAddressingHashMap) {
            Iterator<EventGrouping> iterator = this.outStandingEvents.iterator();
            while (iterator.hasNext()) {
                EventGrouping eventGrouping = iterator.next();
                if (eventGrouping.getPublicEventIdentifier() > l) continue;
                EventGrouping eventGrouping2 = eventGroupingArray[eventGrouping.connectionLocation];
                if (eventGrouping2 == null) {
                    eventGroupingArray[((EventGrouping)eventGrouping).connectionLocation] = eventGrouping;
                } else if (eventGrouping2.getHiddenEventIdentifier() < eventGrouping.getHiddenEventIdentifier()) {
                    eventGroupingArray[((EventGrouping)eventGrouping).connectionLocation] = eventGrouping;
                }
                iterator.remove();
            }
            return eventGroupingArray;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<Long> getAndCleanEidsByConnection(int n) {
        ArrayList<Long> arrayList = new ArrayList<Long>();
        Long2ObjectOpenAddressingHashMap<EventGrouping> long2ObjectOpenAddressingHashMap = this.outStandingEvents;
        synchronized (long2ObjectOpenAddressingHashMap) {
            Iterator<EventGrouping> iterator = this.outStandingEvents.iterator();
            while (iterator.hasNext()) {
                EventGrouping eventGrouping = iterator.next();
                if (eventGrouping.connectionLocation != n) continue;
                arrayList.add(eventGrouping.getPublicEventIdentifier());
                iterator.remove();
            }
        }
        return arrayList;
    }

    public long getCurrentEventIdentifier() {
        return this.eventIdentifier.get();
    }

    public SynchronousEventConsumerManager getIteratorEventConsumerManager(long l) {
        SynchronousEventConsumerManager synchronousEventConsumerManager = this.synchronousIteratorEventConsumerManagers.get(l);
        if (synchronousEventConsumerManager == null) {
            synchronousEventConsumerManager = new SynchronousEventConsumerManager(this, this.storeManagerHelper, this.myClientConnectionManagers);
            this.synchronousIteratorEventConsumerManagers.put(l, synchronousEventConsumerManager);
        }
        return synchronousEventConsumerManager;
    }

    public void removeIteratorEventManager(long l) {
        if (this.synchronousIteratorEventConsumerManagers.containsKey(l)) {
            this.synchronousIteratorEventConsumerManagers.remove(l);
        }
    }

    public HashMap<Long, SynchronousEventConsumerManager> getIteratorManagers() {
        return this.synchronousIteratorEventConsumerManagers;
    }

    public SynchronousEventConsumerManager getReaderEventConsumerManager(long l) {
        SynchronousEventConsumerManager synchronousEventConsumerManager = this.synchronousReaderEventConsumerManagers.get(l);
        if (synchronousEventConsumerManager == null) {
            synchronousEventConsumerManager = new SynchronousEventConsumerManager(this, this.storeManagerHelper, this.myClientConnectionManagers);
            this.synchronousReaderEventConsumerManagers.put(l, synchronousEventConsumerManager);
        }
        return synchronousEventConsumerManager;
    }

    public void removeReaderEventManager(long l) {
        if (this.synchronousReaderEventConsumerManagers.containsKey(l)) {
            this.synchronousReaderEventConsumerManagers.remove(l);
        }
    }

    public AsynchronousEventListener getAsyncEventListener() {
        return this.myAsyncEventListener;
    }

    public void removeAsyncEventListener() {
        this.myAsyncEventListener.removeSubscriptionDetails();
    }

    public void addAsyncEventListener(nUserSubscribe nUserSubscribe2, EventListenerMultiplexer eventListenerMultiplexer) {
        this.myAsyncEventListener.addSubscriptionDetails(nUserSubscribe2, eventListenerMultiplexer);
    }

    private void logEventInfo(long l, long l2, nAbstractChannel nAbstractChannel2, ClientConnectionManager clientConnectionManager) {
        HSLogger.println(fLogLevel.TRACE, "Allocating event with original ID: " + l + " HS ID: " + l2 + " from connection: " + clientConnectionManager.getSessionInfo() + " on channel: " + nAbstractChannel2.getStoreAttributes().getName());
    }

    public static class EventGrouping {
        private final long publicEventIdentifier;
        private final long hiddenEventIdentifier;
        private final nChannelImpl eventChannel;
        private final long durableIdentifier;
        private final int connectionLocation;

        private EventGrouping(long l, long l2, nChannelImpl nChannelImpl2, long l3, int n) {
            this.publicEventIdentifier = l;
            this.hiddenEventIdentifier = l2;
            this.eventChannel = nChannelImpl2;
            this.durableIdentifier = l3;
            this.connectionLocation = n;
        }

        long getPublicEventIdentifier() {
            return this.publicEventIdentifier;
        }

        public long getHiddenEventIdentifier() {
            return this.hiddenEventIdentifier;
        }

        public nChannelImpl getEventChannel() {
            return this.eventChannel;
        }

        public long getDurableIdentifier() {
            return this.durableIdentifier;
        }
    }
}

