/*
 * Decompiled with CFR 0.152.
 */
package com.pcbsys.nirvana.base.clientimpl.multiconnection;

import com.pcbsys.nirvana.base.clientimpl.ClientConnectionManager;
import com.pcbsys.nirvana.base.clientimpl.multiconnection.IteratorMetaData;
import com.pcbsys.nirvana.base.clientimpl.multiconnection.StoreGroup;
import com.pcbsys.nirvana.base.clientimpl.multiconnection.nChannelIteratorWrapper;
import com.pcbsys.nirvana.base.clientimpl.multiconnection.nSynchronousConsumerEventCallbackWrapper;
import com.pcbsys.nirvana.base.clientimpl.nStoreManagerHelper;
import com.pcbsys.nirvana.base.events.nCachedChannelAttributes;
import com.pcbsys.nirvana.base.events.nChannelIterate;
import com.pcbsys.nirvana.base.events.nEvent;
import com.pcbsys.nirvana.base.events.nPopQueue;
import com.pcbsys.nirvana.base.events.nPopQueueCommand;
import com.pcbsys.nirvana.base.events.nPublished;
import com.pcbsys.nirvana.base.events.nSynchronous;
import com.pcbsys.nirvana.base.events.nSynchronousCallbackWrapper;
import com.pcbsys.nirvana.client.nAbstractChannel;
import java.util.List;
import java.util.concurrent.CountDownLatch;

public class SynchronousEventConsumerManager {
    private final StoreGroup storeGroup;
    private final nStoreManagerHelper storeManagerHelper;
    private final nSynchronousConsumerEventCallbackWrapper[] eventCallbackWrappers;
    private final int numberOfConnections;
    private int connectionLocation = 0;
    private int latchCount;
    private final nChannelIteratorWrapper[] channelIterators;
    private final List<ClientConnectionManager> myClientConnectionManagers;
    private IteratorMetaData iteratorMetaData;
    private CountDownLatch countDownLatch;

    SynchronousEventConsumerManager(StoreGroup storeGroup, nStoreManagerHelper nStoreManagerHelper2, List<ClientConnectionManager> list) {
        this.storeGroup = storeGroup;
        this.storeManagerHelper = nStoreManagerHelper2;
        this.numberOfConnections = storeGroup.getHiddenStoreList().length;
        this.eventCallbackWrappers = new nSynchronousConsumerEventCallbackWrapper[this.numberOfConnections];
        this.channelIterators = new nChannelIteratorWrapper[this.numberOfConnections];
        this.myClientConnectionManagers = list;
    }

    public synchronized void setChannelIterator(nChannelIteratorWrapper nChannelIteratorWrapper2, int n) {
        this.channelIterators[n] = nChannelIteratorWrapper2;
        this.eventCallbackWrappers[n] = null;
    }

    public synchronized boolean shouldAddIterator(int n) {
        boolean bl = false;
        if (this.channelIterators[n] != null) {
            return bl;
        }
        for (int i = 0; i < this.channelIterators.length; ++i) {
            if (n == i || this.channelIterators[i] == null || !this.myClientConnectionManagers.get(i).isConnected()) continue;
            bl = true;
        }
        return bl;
    }

    public synchronized nSynchronousCallbackWrapper[] getEventCallbackWrappers() {
        return this.eventCallbackWrappers;
    }

    public synchronized void clearWrapperEntry(int n) {
        this.eventCallbackWrappers[n] = null;
    }

    public synchronized boolean hasEventReady() {
        for (int i = 0; i < this.numberOfConnections; ++i) {
            nCachedChannelAttributes nCachedChannelAttributes2;
            int n = (i + this.connectionLocation) % this.numberOfConnections;
            nSynchronousConsumerEventCallbackWrapper nSynchronousConsumerEventCallbackWrapper2 = this.eventCallbackWrappers[n];
            if (nSynchronousConsumerEventCallbackWrapper2 == null || nSynchronousConsumerEventCallbackWrapper2.getInboundEvent() == null) continue;
            boolean bl = false;
            int n2 = 0;
            if (nSynchronousConsumerEventCallbackWrapper2.getInboundEvent().getId() == 33) {
                nCachedChannelAttributes2 = (nPopQueue)nSynchronousConsumerEventCallbackWrapper2.getInboundEvent();
                if (((nPopQueue)nCachedChannelAttributes2).getEvents() != null || ((nPopQueue)nCachedChannelAttributes2).getEvent() != null) {
                    bl = true;
                } else {
                    ++n2;
                }
            } else if (nSynchronousConsumerEventCallbackWrapper2.getInboundEvent().getId() == 89) {
                nCachedChannelAttributes2 = (nChannelIterate)nSynchronousConsumerEventCallbackWrapper2.getInboundEvent();
                if (((nChannelIterate)nCachedChannelAttributes2).getEvents() != null && !((nChannelIterate)nCachedChannelAttributes2).getEvents().isEmpty() || ((nChannelIterate)nCachedChannelAttributes2).getEvent() != null) {
                    bl = true;
                } else {
                    ++n2;
                }
            } else {
                ++n2;
            }
            if (bl) {
                this.connectionLocation = n;
                return true;
            }
            if (n2 != this.numberOfConnections) continue;
            return true;
        }
        return false;
    }

    public synchronized nEvent getInboundEvent() {
        for (int i = 0; i < this.numberOfConnections; ++i) {
            nCachedChannelAttributes nCachedChannelAttributes2;
            int n = (i + this.connectionLocation) % this.numberOfConnections;
            nSynchronousConsumerEventCallbackWrapper nSynchronousConsumerEventCallbackWrapper2 = this.eventCallbackWrappers[n];
            if (nSynchronousConsumerEventCallbackWrapper2 == null || nSynchronousConsumerEventCallbackWrapper2.getInboundEvent() == null) continue;
            nEvent nEvent2 = nSynchronousConsumerEventCallbackWrapper2.getInboundEvent();
            if (nEvent2.getId() == 33) {
                nCachedChannelAttributes2 = (nPopQueue)nEvent2;
                if (!((nPopQueue)nCachedChannelAttributes2).hasEvents()) {
                    this.eventCallbackWrappers[n] = null;
                    continue;
                }
                boolean bl = ((nPopQueue)nCachedChannelAttributes2).getWindowSize() > 0;
                this.eventCallbackWrappers[n] = null;
                if (((nPopQueue)nCachedChannelAttributes2).getEvent() != null) {
                    this.storeGroup.allocateEvent(((nPopQueue)nCachedChannelAttributes2).getEvent(), n, -1L, bl);
                } else if (((nPopQueue)nCachedChannelAttributes2).getEvents() != null) {
                    for (nPublished nPublished2 : ((nPopQueue)nCachedChannelAttributes2).getEvents()) {
                        this.storeGroup.allocateEvent(nPublished2, n, -1L, bl);
                    }
                }
            } else if (nEvent2.getId() == 89) {
                nCachedChannelAttributes2 = (nChannelIterate)nEvent2;
                if (!((nChannelIterate)nCachedChannelAttributes2).hasEvents()) {
                    this.eventCallbackWrappers[n] = null;
                    continue;
                }
                nChannelIteratorWrapper nChannelIteratorWrapper2 = this.channelIterators[n];
                nChannelIteratorWrapper2.processResponse((nChannelIterate)nCachedChannelAttributes2);
                this.eventCallbackWrappers[n] = null;
                if (((nChannelIterate)nCachedChannelAttributes2).getEvents() != null) {
                    for (nPublished nPublished3 : ((nChannelIterate)nCachedChannelAttributes2).getEvents()) {
                        this.storeGroup.allocateEvent(nPublished3, n, ((nChannelIterate)nEvent2).getNameId(), nChannelIteratorWrapper2.isStoreEventMappings());
                    }
                } else {
                    this.storeGroup.allocateEvent(((nChannelIterate)nCachedChannelAttributes2).getEvent(), n, ((nChannelIterate)nEvent2).getNameId(), nChannelIteratorWrapper2.isStoreEventMappings());
                }
            }
            this.connectionLocation = n + 1;
            return nEvent2;
        }
        return null;
    }

    public synchronized nSynchronousConsumerEventCallbackWrapper[] requestQueueEvents(nPopQueue nPopQueue2, boolean bl) {
        nSynchronousConsumerEventCallbackWrapper[] nSynchronousConsumerEventCallbackWrapperArray = new nSynchronousConsumerEventCallbackWrapper[this.numberOfConnections];
        this.latchCount = 0;
        for (int i = 0; i < this.numberOfConnections; ++i) {
            nSynchronousConsumerEventCallbackWrapper nSynchronousConsumerEventCallbackWrapper2;
            Object object;
            if (!this.myClientConnectionManagers.get(i).isConnected()) {
                if (this.eventCallbackWrappers[i] == null) continue;
                this.eventCallbackWrappers[i] = null;
                continue;
            }
            boolean bl2 = false;
            if (this.eventCallbackWrappers[i] == null) {
                bl2 = true;
            } else if (this.eventCallbackWrappers[i].getInboundEvent() != null && this.eventCallbackWrappers[i].getInboundEvent().getId() == 33 && !((nPopQueue)(object = (nPopQueue)this.eventCallbackWrappers[i].getInboundEvent())).hasEvents()) {
                bl2 = true;
            }
            if (!bl2 || (object = this.storeGroup.getHiddenStoreList()[i]) == null) continue;
            nPopQueue nPopQueue3 = new nPopQueue(this.storeManagerHelper.getAttributes((nAbstractChannel)object).getUniqueId(), nPopQueueCommand.POP, nPopQueue2.getSelector(), nPopQueue2.getReaderUniqueID());
            nPopQueue3.setTimeout(nPopQueue2.getTimeout());
            nPopQueue3.setWindowSize(nPopQueue2.getWindowSize());
            nPopQueue3.setIsInfiniteWindow(nPopQueue2.isInfiniteWindow());
            nPopQueue3.setBatchSize(nPopQueue2.getBatchSize());
            this.eventCallbackWrappers[i] = nSynchronousConsumerEventCallbackWrapper2 = new nSynchronousConsumerEventCallbackWrapper((nSynchronous)nPopQueue3, true);
            nSynchronousConsumerEventCallbackWrapperArray[i] = nSynchronousConsumerEventCallbackWrapper2;
            ++this.latchCount;
        }
        this.countDownLatch = new CountDownLatch(this.latchCount);
        if (!bl) {
            this.setCountDownLatchOnOutstanding(this.countDownLatch);
        }
        return nSynchronousConsumerEventCallbackWrapperArray;
    }

    public synchronized nSynchronousConsumerEventCallbackWrapper[] requestIterateEvent(nChannelIterate nChannelIterate2, boolean bl) {
        nSynchronousConsumerEventCallbackWrapper[] nSynchronousConsumerEventCallbackWrapperArray = new nSynchronousConsumerEventCallbackWrapper[this.numberOfConnections];
        this.latchCount = 0;
        for (int i = 0; i < this.numberOfConnections; ++i) {
            nSynchronousConsumerEventCallbackWrapper nSynchronousConsumerEventCallbackWrapper2;
            nChannelIterate nChannelIterate3;
            if (!this.myClientConnectionManagers.get(i).isConnected()) {
                if (this.eventCallbackWrappers[i] == null) continue;
                this.eventCallbackWrappers[i] = null;
                continue;
            }
            boolean bl2 = false;
            if (this.eventCallbackWrappers[i] == null) {
                bl2 = true;
            } else if (this.eventCallbackWrappers[i].getInboundEvent() != null && this.eventCallbackWrappers[i].getInboundEvent().getId() == 89 && !(nChannelIterate3 = (nChannelIterate)this.eventCallbackWrappers[i].getInboundEvent()).hasEvents()) {
                bl2 = true;
            }
            if (!bl2 || this.channelIterators[i] == null || (nChannelIterate3 = this.channelIterators[i].getNextWrapped(nChannelIterate2.getTimeout())) == null) continue;
            this.eventCallbackWrappers[i] = nSynchronousConsumerEventCallbackWrapper2 = new nSynchronousConsumerEventCallbackWrapper((nSynchronous)nChannelIterate3, false);
            nSynchronousConsumerEventCallbackWrapperArray[i] = nSynchronousConsumerEventCallbackWrapper2;
            ++this.latchCount;
        }
        this.countDownLatch = new CountDownLatch(this.latchCount);
        if (!bl) {
            this.setCountDownLatchOnOutstanding(this.countDownLatch);
        }
        return nSynchronousConsumerEventCallbackWrapperArray;
    }

    public nChannelIteratorWrapper[] getChannelIterators() {
        return this.channelIterators;
    }

    public void setIteratorMetaData(IteratorMetaData iteratorMetaData) {
        this.iteratorMetaData = iteratorMetaData;
    }

    public IteratorMetaData getIteratorMetaData() {
        return this.iteratorMetaData;
    }

    public synchronized CountDownLatch getCountDownLatch() {
        return this.countDownLatch;
    }

    private void setCountDownLatchOnOutstanding(CountDownLatch countDownLatch) {
        boolean bl = false;
        for (nSynchronousConsumerEventCallbackWrapper nSynchronousConsumerEventCallbackWrapper2 : this.eventCallbackWrappers) {
            nCachedChannelAttributes nCachedChannelAttributes2;
            if (nSynchronousConsumerEventCallbackWrapper2 == null || !nSynchronousConsumerEventCallbackWrapper2.checkEventAndSetCountDownLatch(countDownLatch)) continue;
            nEvent nEvent2 = nSynchronousConsumerEventCallbackWrapper2.getInboundEvent();
            if (nEvent2.getId() == 89) {
                nCachedChannelAttributes2 = (nChannelIterate)nEvent2;
                if (!((nChannelIterate)nCachedChannelAttributes2).hasEvents()) continue;
                bl = true;
                continue;
            }
            if (nEvent2.getId() == 33) {
                nCachedChannelAttributes2 = (nPopQueue)nEvent2;
                if (!((nPopQueue)nCachedChannelAttributes2).hasEvents()) continue;
                bl = true;
                continue;
            }
            bl = true;
        }
        if (bl) {
            while (countDownLatch.getCount() > 0L) {
                countDownLatch.countDown();
            }
        }
    }
}

