/*
 * Decompiled with CFR 0.152.
 */
package com.pcbsys.nirvana.base.clientimpl.multiconnection.eventhandlers;

import com.pcbsys.nirvana.base.clientimpl.ClientConnectionManager;
import com.pcbsys.nirvana.base.clientimpl.multiconnection.HSCommonHelper;
import com.pcbsys.nirvana.base.clientimpl.multiconnection.OutgoingEventMultiplexWrapper;
import com.pcbsys.nirvana.base.clientimpl.multiconnection.eventhandlers.EventHandler;
import com.pcbsys.nirvana.base.clientimpl.multiconnection.eventhandlers.NoOperationHandler;
import com.pcbsys.nirvana.base.events.nEvent;
import java.util.List;

public class EventProcessor {
    private final EventHandler[] myEventHandlers;
    private final List<ClientConnectionManager> clientConnectionsState;
    private boolean isClosed = false;

    public EventProcessor(boolean bl, List<ClientConnectionManager> list) {
        this.clientConnectionsState = list;
        this.myEventHandlers = new EventHandler[116];
        for (int i = 0; i < 116; ++i) {
            this.myEventHandlers[i] = new NoOperationHandler(i, this, bl);
        }
    }

    void registerHandler(int n, EventHandler eventHandler) {
        if (eventHandler == null) {
            throw new IllegalStateException("Cannot pass a null client event handler");
        }
        this.myEventHandlers[n] = eventHandler;
    }

    public OutgoingEventMultiplexWrapper processEventOutbound(nEvent nEvent2) {
        if (!this.isClosed && nEvent2 != null) {
            return this.myEventHandlers[nEvent2.getId()].processEventOutbound(nEvent2);
        }
        return null;
    }

    public nEvent processEventInbound(OutgoingEventMultiplexWrapper outgoingEventMultiplexWrapper) {
        if (!this.isClosed && outgoingEventMultiplexWrapper != null) {
            return this.myEventHandlers[outgoingEventMultiplexWrapper.getOriginalEvent().getId()].processEventInbound(outgoingEventMultiplexWrapper);
        }
        return null;
    }

    public int getCountOfConnections() {
        return this.clientConnectionsState.size();
    }

    public List<ClientConnectionManager> getClientConnectionsHidden() {
        return this.clientConnectionsState;
    }

    public String getHiddenConnectionsIDs() {
        return HSCommonHelper.createHSSessionInfo(this.clientConnectionsState);
    }
}

