/*
 * Decompiled with CFR 0.152.
 */
package com.pcbsys.nirvana.base.clientimpl.multiconnection.eventhandlers;

import com.pcbsys.foundation.logger.fLogLevel;
import com.pcbsys.nirvana.base.ClientEventTraceLoggerContext;
import com.pcbsys.nirvana.base.clientimpl.multiconnection.DurableGroup;
import com.pcbsys.nirvana.base.clientimpl.multiconnection.HSLogger;
import com.pcbsys.nirvana.base.clientimpl.multiconnection.IteratorMetaData;
import com.pcbsys.nirvana.base.clientimpl.multiconnection.OutgoingEventMultiplexWrapper;
import com.pcbsys.nirvana.base.clientimpl.multiconnection.StoreGroup;
import com.pcbsys.nirvana.base.clientimpl.multiconnection.SynchronousConsumerOutgoingEventMultiplexWrapper;
import com.pcbsys.nirvana.base.clientimpl.multiconnection.SynchronousEventConsumerManager;
import com.pcbsys.nirvana.base.clientimpl.multiconnection.eventhandlers.EventHandler;
import com.pcbsys.nirvana.base.clientimpl.multiconnection.eventhandlers.EventProcessor;
import com.pcbsys.nirvana.base.clientimpl.multiconnection.nChannelIteratorWrapper;
import com.pcbsys.nirvana.base.clientimpl.multiconnection.nStoreManagerImpl;
import com.pcbsys.nirvana.base.clientimpl.multiconnection.nSynchronousConsumerEventCallbackWrapper;
import com.pcbsys.nirvana.base.events.nChannelIterate;
import com.pcbsys.nirvana.base.events.nEvent;
import com.pcbsys.nirvana.base.events.nExceptionEvent;
import com.pcbsys.nirvana.client.nBaseClientException;
import com.pcbsys.nirvana.client.nChannel;
import com.pcbsys.nirvana.client.nChannelNotFoundException;
import com.pcbsys.nirvana.client.nDurable;
import com.pcbsys.nirvana.client.nRealmNotFoundException;
import com.pcbsys.nirvana.client.nRequestTimedOutException;
import com.pcbsys.nirvana.client.nSecurityException;
import com.pcbsys.nirvana.client.nSelectorParserException;
import com.pcbsys.nirvana.client.nSessionNotConnectedException;
import com.pcbsys.nirvana.client.nSessionPausedException;
import com.pcbsys.nirvana.client.nUnexpectedResponseException;
import java.util.Arrays;

class nChannelIterateHandler
extends EventHandler {
    private final nStoreManagerImpl storeManager;
    private static final String CLASS_NAME = "nChannelIterateHandler";

    nChannelIterateHandler(EventProcessor eventProcessor, nStoreManagerImpl nStoreManagerImpl2) {
        super(89, eventProcessor);
        this.storeManager = nStoreManagerImpl2;
    }

    @Override
    OutgoingEventMultiplexWrapper processEventOutbound(nEvent nEvent2) {
        nChannelIterate nChannelIterate2 = (nChannelIterate)nEvent2;
        StoreGroup storeGroup = this.storeManager.getStoreList(nChannelIterate2.getChannelAttributesId());
        int n = nChannelIterate2.getCommand();
        Throwable throwable = null;
        if (storeGroup.getPublicStore().getTraceLogger().isInfoEnabled()) {
            storeGroup.getPublicStore().getTraceLogger().info("HS> channel iterate request received. " + ClientEventTraceLoggerContext.addClientConnectionInfo(this.eventProcessor.getClientConnectionsHidden()) + ", " + ClientEventTraceLoggerContext.addChannelIterateInfo(nChannelIterate2), CLASS_NAME);
        }
        switch (n) {
            case 2: {
                SynchronousEventConsumerManager synchronousEventConsumerManager = storeGroup.getIteratorEventConsumerManager(nChannelIterate2.getIteratorId());
                boolean bl = nChannelIterate2.getTimeout() != -1L;
                nSynchronousConsumerEventCallbackWrapper[] nSynchronousConsumerEventCallbackWrapperArray = synchronousEventConsumerManager.requestIterateEvent(nChannelIterate2, bl);
                return new SynchronousConsumerOutgoingEventMultiplexWrapper(Thread.currentThread(), nChannelIterate2, nSynchronousConsumerEventCallbackWrapperArray, synchronousEventConsumerManager, synchronousEventConsumerManager.getCountDownLatch());
            }
            case 0: 
            case 1: 
            case 3: {
                throw new UnsupportedOperationException("Operations: get Last/First/Previous are not supported within an HS environment.");
            }
            case 5: {
                boolean bl;
                SynchronousEventConsumerManager synchronousEventConsumerManager = storeGroup.getIteratorEventConsumerManager(nChannelIterate2.getIteratorId());
                long l = nChannelIterate2.getNameId();
                DurableGroup durableGroup = storeGroup.getDurableManager().getDurableGroup(l);
                boolean bl2 = bl = !nChannelIterate2.isAutoAck();
                if (durableGroup != null) {
                    nDurable nDurable2 = durableGroup.getHiddenDurableList()[0];
                    bl = !nChannelIterate2.isAutoAck() || nChannelIterate2.isAutoAck() && (nDurable2.isShared() || nDurable2.isSerial());
                }
                for (int i = 0; i < this.eventProcessor.getCountOfConnections(); ++i) {
                    nDurable nDurable3;
                    nChannel nChannel2 = (nChannel)storeGroup.getHiddenStoreList()[i];
                    if (nChannel2 == null) {
                        HSLogger.println(fLogLevel.DEBUG, "Failed to create iterator on connection: " + this.eventProcessor.getClientConnectionsHidden().get(i).getSessionInfo() + " as channel is not present.");
                        continue;
                    }
                    nDurable nDurable4 = nDurable3 = durableGroup == null ? null : durableGroup.getHiddenDurableList()[i];
                    if (l != -1L && nDurable3 == null) continue;
                    nChannelIteratorWrapper nChannelIteratorWrapper2 = new nChannelIteratorWrapper(this.storeManager, nChannel2, -1L, nChannelIterate2.getSelector(), nDurable3, nChannelIterate2.isAutoAck(), nChannelIterate2.getMaxUnackedEvents(), bl);
                    synchronousEventConsumerManager.setChannelIterator(nChannelIteratorWrapper2, i);
                }
                synchronousEventConsumerManager.setIteratorMetaData(new IteratorMetaData(-1L, nChannelIterate2.isAutoAck(), nChannelIterate2.getMaxUnackedEvents(), bl, nChannelIterate2.getSelector(), nChannelIterate2.getNameId()));
                break;
            }
            case 6: {
                SynchronousEventConsumerManager synchronousEventConsumerManager = storeGroup.getIteratorEventConsumerManager(nChannelIterate2.getIteratorId());
                nChannelIteratorWrapper[] nChannelIteratorWrapperArray = synchronousEventConsumerManager.getChannelIterators();
                for (int i = 0; i < this.eventProcessor.getCountOfConnections(); ++i) {
                    if (this.eventProcessor.getClientConnectionsHidden().get(i).isConnected()) {
                        if (nChannelIteratorWrapperArray[i] == null) continue;
                        nChannelIteratorWrapperArray[i].close();
                        synchronousEventConsumerManager.setChannelIterator(null, i);
                        continue;
                    }
                    HSLogger.println(fLogLevel.DEBUG, "Failed to close iterator on connection: " + this.eventProcessor.getClientConnectionsHidden().get(i).getSessionInfo() + " as session is not connected.");
                }
                storeGroup.removeIteratorEventManager(nChannelIterate2.getIteratorId());
                break;
            }
            case 7: {
                StoreGroup.EventGrouping[] eventGroupingArray = storeGroup.getAndReleaseEventEqualAndLesser(nChannelIterate2.getEID());
                if (eventGroupingArray == null) break;
                nChannelIteratorWrapper[] nChannelIteratorWrapperArray = storeGroup.getIteratorEventConsumerManager(nChannelIterate2.getIteratorId()).getChannelIterators();
                for (int i = 0; i < this.eventProcessor.getCountOfConnections(); ++i) {
                    try {
                        if (eventGroupingArray[i] == null) continue;
                        nChannelIteratorWrapperArray[i].ack(eventGroupingArray[i].getHiddenEventIdentifier());
                        continue;
                    }
                    catch (nChannelNotFoundException | nRealmNotFoundException | nRequestTimedOutException | nSecurityException | nSelectorParserException | nSessionNotConnectedException | nSessionPausedException | nUnexpectedResponseException nBaseClientException2) {
                        this.storeManager.getExceptionListener().processException(nBaseClientException2);
                        HSLogger.println(fLogLevel.WARN, "Exception while processing event. On connection: " + this.eventProcessor.getClientConnectionsHidden().get(i).getSessionInfo() + " " + nBaseClientException2.getMessage(), nBaseClientException2);
                        throwable = nBaseClientException2;
                    }
                }
                break;
            }
            case 8: {
                long[] lArray = nChannelIterate2.getAckEvents();
                Arrays.sort(lArray);
                StoreGroup.EventGrouping[] eventGroupingArray = storeGroup.getAndReleaseEventEqualAndLesser(lArray[lArray.length - 1]);
                nChannelIteratorWrapper[] nChannelIteratorWrapperArray = storeGroup.getIteratorEventConsumerManager(nChannelIterate2.getIteratorId()).getChannelIterators();
                for (int i = 0; i < this.eventProcessor.getCountOfConnections(); ++i) {
                    try {
                        if (eventGroupingArray[i] == null || nChannelIteratorWrapperArray[i] == null) continue;
                        nChannelIteratorWrapperArray[i].rollback(eventGroupingArray[i].getHiddenEventIdentifier());
                        continue;
                    }
                    catch (nChannelNotFoundException | nRealmNotFoundException | nRequestTimedOutException | nSecurityException | nSelectorParserException | nSessionNotConnectedException | nSessionPausedException | nUnexpectedResponseException nBaseClientException3) {
                        this.storeManager.getExceptionListener().processException(nBaseClientException3);
                        HSLogger.println(fLogLevel.WARN, "Exception while processing event. On connection: " + this.eventProcessor.getClientConnectionsHidden().get(i).getSessionInfo() + " " + nBaseClientException3.getMessage(), nBaseClientException3);
                        throwable = nBaseClientException3;
                    }
                }
                break;
            }
        }
        if (throwable != null) {
            if (storeGroup.getPublicStore().getTraceLogger().isWarnEnabled()) {
                storeGroup.getPublicStore().getTraceLogger().warn("HS> channel iterate operation failed. reason=" + throwable.getMessage() + ", " + ClientEventTraceLoggerContext.addChannelIterateInfo(nChannelIterate2), CLASS_NAME);
            }
            return new OutgoingEventMultiplexWrapper(Thread.currentThread(), nEvent2, new nEvent[]{new nExceptionEvent(((nBaseClientException)throwable).getID(), throwable.getMessage(), true)});
        }
        return new OutgoingEventMultiplexWrapper(Thread.currentThread(), nEvent2);
    }

    @Override
    nEvent processEventInbound(OutgoingEventMultiplexWrapper outgoingEventMultiplexWrapper) {
        nChannelIterate nChannelIterate2 = (nChannelIterate)outgoingEventMultiplexWrapper.getOriginalEvent();
        if (nChannelIterate2.getCommand() == 2) {
            nEvent[] nEventArray = this.storeManager.getStoreList(nChannelIterate2.getChannelAttributesId());
            SynchronousEventConsumerManager synchronousEventConsumerManager = nEventArray.getIteratorEventConsumerManager(nChannelIterate2.getIteratorId());
            nEvent nEvent2 = synchronousEventConsumerManager.getInboundEvent();
            if (nEvent2 != null && nEvent2.getId() != 89) {
                return nEvent2;
            }
            if (nEvent2 != null) {
                nEvent nEvent3 = (nChannelIterate)nEvent2;
                nChannelIterate2.setEvent(((nChannelIterate)nEvent3).getEvent());
                nChannelIterate2.setEvents(((nChannelIterate)nEvent3).getEvents());
            }
        }
        if (nChannelIterate2.getCommand() == 7 || nChannelIterate2.getCommand() == 8) {
            for (nEvent nEvent3 : outgoingEventMultiplexWrapper.getOutgoingEventWrappers()) {
                if (nEvent3.getId() != 75) continue;
                return nEvent3;
            }
        }
        return nChannelIterate2;
    }
}

