/*
 * Decompiled with CFR 0.152.
 */
package com.pcbsys.nirvana.base.clientimpl.multiconnection.eventhandlers;

import com.pcbsys.foundation.logger.fLogLevel;
import com.pcbsys.nirvana.base.ClientEventTraceLoggerContext;
import com.pcbsys.nirvana.base.clientimpl.multiconnection.DurableGroup;
import com.pcbsys.nirvana.base.clientimpl.multiconnection.HSLogger;
import com.pcbsys.nirvana.base.clientimpl.multiconnection.OutgoingEventMultiplexWrapper;
import com.pcbsys.nirvana.base.clientimpl.multiconnection.StoreGroup;
import com.pcbsys.nirvana.base.clientimpl.multiconnection.eventhandlers.EventHandler;
import com.pcbsys.nirvana.base.clientimpl.multiconnection.eventhandlers.EventProcessor;
import com.pcbsys.nirvana.base.clientimpl.multiconnection.nStoreManagerImpl;
import com.pcbsys.nirvana.base.clientimpl.nStoreManagerHelper;
import com.pcbsys.nirvana.base.events.nEvent;
import com.pcbsys.nirvana.base.events.nExceptionEvent;
import com.pcbsys.nirvana.base.events.nManageNamedSub;
import com.pcbsys.nirvana.base.nBaseNamedObject;
import com.pcbsys.nirvana.client.nAbstractChannel;
import com.pcbsys.nirvana.client.nBaseClientException;
import com.pcbsys.nirvana.client.nChannel;
import com.pcbsys.nirvana.client.nChannelNotFoundException;
import com.pcbsys.nirvana.client.nDurable;
import com.pcbsys.nirvana.client.nDurableAttributes;
import com.pcbsys.nirvana.client.nIllegalArgumentException;
import com.pcbsys.nirvana.client.nIndexedDurable;
import com.pcbsys.nirvana.client.nNameAlreadyBoundException;
import com.pcbsys.nirvana.client.nNameDoesNotExistException;
import com.pcbsys.nirvana.client.nRequestTimedOutException;
import com.pcbsys.nirvana.client.nSecurityException;
import com.pcbsys.nirvana.client.nSelectorParserException;
import com.pcbsys.nirvana.client.nSessionNotConnectedException;
import com.pcbsys.nirvana.client.nSessionPausedException;
import com.pcbsys.nirvana.client.nUnexpectedResponseException;

class nManageNamedSubHandler
extends EventHandler {
    private static final String CLASS_NAME = nManageNamedSubHandler.class.getSimpleName();
    private final nStoreManagerImpl storeManager;
    private final nStoreManagerHelper storeManagerHelper;

    nManageNamedSubHandler(EventProcessor eventProcessor, nStoreManagerImpl nStoreManagerImpl2) {
        super(85, eventProcessor);
        this.storeManager = nStoreManagerImpl2;
        this.storeManagerHelper = nStoreManagerImpl2.getStoreManagerHelper();
    }

    @Override
    OutgoingEventMultiplexWrapper processEventOutbound(nEvent nEvent2) {
        nManageNamedSub nManageNamedSub2 = (nManageNamedSub)nEvent2;
        HSLogger.println(fLogLevel.TRACE, "Sending durable: " + nManageNamedSub2.getName() + " operation: " + nManageNamedSub2.getCommand() + " to connection: " + this.eventProcessor.getHiddenConnectionsIDs());
        return new OutgoingEventMultiplexWrapper(Thread.currentThread(), nManageNamedSub2);
    }

    @Override
    nEvent processEventInbound(OutgoingEventMultiplexWrapper outgoingEventMultiplexWrapper) {
        nManageNamedSub nManageNamedSub2 = (nManageNamedSub)outgoingEventMultiplexWrapper.getOriginalEvent();
        switch (nManageNamedSub2.getCommand()) {
            case 0: {
                HSLogger.println(fLogLevel.TRACE, "Received durable: " + nManageNamedSub2.getName() + " creation response event with command Add from connection: " + this.eventProcessor.getHiddenConnectionsIDs());
                return this.addDurable(nManageNamedSub2, false);
            }
            case 4: {
                HSLogger.println(fLogLevel.TRACE, "Received durable: " + nManageNamedSub2.getName() + " creation response event with command AddOrFail from connection: " + this.eventProcessor.getHiddenConnectionsIDs());
                return this.addDurable(nManageNamedSub2, true);
            }
            case 1: {
                HSLogger.println(fLogLevel.TRACE, "Received durable: " + nManageNamedSub2.getName() + " deletion response event from connection: " + this.eventProcessor.getHiddenConnectionsIDs());
                return this.deleteDurable(nManageNamedSub2);
            }
            case 2: {
                if (nManageNamedSub2.getName() == null) {
                    throw new UnsupportedOperationException();
                }
                HSLogger.println(fLogLevel.TRACE, "Received durable: " + nManageNamedSub2.getName() + " get response event from connection: " + this.eventProcessor.getHiddenConnectionsIDs());
                return this.getDurable(nManageNamedSub2);
            }
            case 3: {
                HSLogger.println(fLogLevel.TRACE, "Received durable: " + nManageNamedSub2.getName() + " unbind response event from connection: " + this.eventProcessor.getHiddenConnectionsIDs());
                return this.unBindDurable(nManageNamedSub2);
            }
            case 5: {
                HSLogger.println(fLogLevel.TRACE, "Received durable: " + nManageNamedSub2.getName() + " rebuild response event from connection: " + this.eventProcessor.getHiddenConnectionsIDs());
                return this.rebuildSelector(nManageNamedSub2);
            }
            case 6: {
                throw new UnsupportedOperationException();
            }
        }
        throw new UnsupportedOperationException();
    }

    private nEvent addDurable(nManageNamedSub nManageNamedSub2, boolean bl) {
        StoreGroup storeGroup = this.storeManager.getStoreList(nManageNamedSub2.getChannelAttributesId());
        nAbstractChannel nAbstractChannel2 = storeGroup.getPublicStore();
        if (nAbstractChannel2.getTraceLogger().isTraceEnabled()) {
            nAbstractChannel2.getTraceLogger().trace("HS> Creating durables for HS store. durableName=" + nManageNamedSub2.getName() + ", conns=" + this.eventProcessor.getHiddenConnectionsIDs(), CLASS_NAME);
        }
        nDurable[] nDurableArray = new nDurable[this.eventProcessor.getCountOfConnections()];
        nDurableAttributes.nDurableType nDurableType2 = nDurableAttributes.nDurableType.Named;
        if (nManageNamedSub2.isShared()) {
            nDurableType2 = nDurableAttributes.nDurableType.Shared;
        } else if (nManageNamedSub2.isSerial()) {
            nDurableType2 = nDurableAttributes.nDurableType.Serial;
        }
        int n = 0;
        nBaseClientException nBaseClientException2 = null;
        for (int i = 0; i < this.eventProcessor.getCountOfConnections(); ++i) {
            nChannel nChannel2 = (nChannel)storeGroup.getHiddenStoreList()[i];
            if (nChannel2 == null) {
                ++n;
                continue;
            }
            try {
                nDurableAttributes nDurableAttributes2 = nDurableAttributes.create(nDurableType2, nManageNamedSub2.getName());
                if (nManageNamedSub2.getSelector() != null) {
                    nDurableAttributes2.setSelector(nManageNamedSub2.getSelector());
                }
                nDurableAttributes2.setStartEID(nManageNamedSub2.getEID());
                nDurableAttributes2.setPersistent(nManageNamedSub2.isPersistant());
                if (nChannel2.getStoreAttributes().isClusterWide() && nManageNamedSub2.isClusterWide()) {
                    nDurableAttributes2.setClustered(true);
                }
                nDurableArray[i] = this.storeManagerHelper.getBaseChannel(nChannel2).createDurable(nDurableAttributes2, bl);
                continue;
            }
            catch (nChannelNotFoundException | nIllegalArgumentException | nNameAlreadyBoundException | nRequestTimedOutException | nSecurityException | nSelectorParserException | nSessionNotConnectedException | nSessionPausedException | nUnexpectedResponseException nBaseClientException3) {
                nBaseClientException2 = nBaseClientException3;
                ++n;
                String string = "Exception during durable creation: " + nManageNamedSub2.getName() + " on connection: " + ClientEventTraceLoggerContext.addClientConnectionInfo(this.eventProcessor.getClientConnectionsHidden().get(i)) + " " + nBaseClientException3.getMessage();
                HSLogger.println(fLogLevel.FATAL, string, nBaseClientException3);
            }
        }
        if (n == this.eventProcessor.getCountOfConnections()) {
            this.storeManager.getExceptionListener().processException(nBaseClientException2);
            return new nExceptionEvent(nBaseClientException2.getID(), nBaseClientException2.getMessage(), true);
        }
        DurableGroup durableGroup = storeGroup.getDurableManager().createDurable(nManageNamedSub2, nDurableArray);
        nManageNamedSub2.setList(new nBaseNamedObject[]{durableGroup.getBaseNamedObject()});
        return nManageNamedSub2;
    }

    private nEvent deleteDurable(nManageNamedSub nManageNamedSub2) {
        StoreGroup storeGroup = this.storeManager.getStoreList(nManageNamedSub2.getChannelAttributesId());
        nAbstractChannel nAbstractChannel2 = storeGroup.getPublicStore();
        if (nAbstractChannel2.getTraceLogger().isTraceEnabled()) {
            nAbstractChannel2.getTraceLogger().trace("HS> Deleting durables for HS store durableName=" + nManageNamedSub2.getName() + ", conns=" + this.eventProcessor.getHiddenConnectionsIDs(), CLASS_NAME);
        }
        int n = 0;
        nBaseClientException nBaseClientException2 = null;
        for (int i = 0; i < this.eventProcessor.getCountOfConnections(); ++i) {
            nChannel nChannel2 = (nChannel)storeGroup.getHiddenStoreList()[i];
            if (nChannel2 == null) {
                ++n;
                continue;
            }
            DurableGroup durableGroup = storeGroup.getDurableManager().getDurableGroup(nManageNamedSub2.getNameId());
            if (durableGroup == null) continue;
            try {
                this.storeManagerHelper.getBaseChannel(nChannel2).delNamedObject(durableGroup.getHiddenDurableList()[i]);
                continue;
            }
            catch (nChannelNotFoundException | nIllegalArgumentException | nNameDoesNotExistException | nRequestTimedOutException | nSecurityException | nSessionNotConnectedException | nSessionPausedException | nUnexpectedResponseException nBaseClientException3) {
                ++n;
                nBaseClientException2 = nBaseClientException3;
                HSLogger.println(fLogLevel.FATAL, "Exception while deleting durable: " + nManageNamedSub2.getName() + " on connection: " + ClientEventTraceLoggerContext.addClientConnectionInfo(this.eventProcessor.getClientConnectionsHidden().get(i)) + " " + nBaseClientException3.getMessage(), nBaseClientException3);
            }
        }
        if (n == this.eventProcessor.getCountOfConnections()) {
            this.storeManager.getExceptionListener().processException(nBaseClientException2);
            return new nExceptionEvent(nBaseClientException2.getID(), nBaseClientException2.getMessage(), true);
        }
        return nManageNamedSub2;
    }

    private nEvent getDurable(nManageNamedSub nManageNamedSub2) {
        StoreGroup storeGroup = this.storeManager.getStoreList(nManageNamedSub2.getChannelAttributesId());
        DurableGroup durableGroup = storeGroup.getDurableManager().getDurableGroup(nManageNamedSub2.getName());
        if (durableGroup == null) {
            nDurable[] nDurableArray = new nDurable[this.eventProcessor.getCountOfConnections()];
            int n = 0;
            nBaseClientException nBaseClientException2 = null;
            for (int i = 0; i < this.eventProcessor.getCountOfConnections(); ++i) {
                nChannel nChannel2 = (nChannel)storeGroup.getHiddenStoreList()[i];
                if (nChannel2 == null) {
                    ++n;
                    continue;
                }
                try {
                    nDurableArray[i] = this.storeManagerHelper.getBaseChannel(nChannel2).getNamedObject(nManageNamedSub2.getName());
                    continue;
                }
                catch (nChannelNotFoundException | nNameDoesNotExistException | nRequestTimedOutException | nSecurityException | nSessionNotConnectedException | nSessionPausedException | nUnexpectedResponseException nBaseClientException3) {
                    ++n;
                    nBaseClientException2 = nBaseClientException3;
                }
            }
            if (n == this.eventProcessor.getCountOfConnections()) {
                return new nExceptionEvent(nBaseClientException2.getID(), nBaseClientException2.getMessage(), true);
            }
            durableGroup = storeGroup.getDurableManager().createDurable(nManageNamedSub2, nDurableArray);
        }
        nManageNamedSub2.setList(new nBaseNamedObject[]{durableGroup.getBaseNamedObject()});
        return nManageNamedSub2;
    }

    private nEvent unBindDurable(nManageNamedSub nManageNamedSub2) {
        StoreGroup storeGroup = this.storeManager.getStoreList(nManageNamedSub2.getChannelAttributesId());
        nAbstractChannel nAbstractChannel2 = storeGroup.getPublicStore();
        if (nAbstractChannel2.getTraceLogger().isTraceEnabled()) {
            nAbstractChannel2.getTraceLogger().trace("HS> Unbinding durables for HS store. durableName=" + nManageNamedSub2.getName() + ", conns=" + this.eventProcessor.getHiddenConnectionsIDs(), CLASS_NAME);
        }
        int n = 0;
        nBaseClientException nBaseClientException2 = null;
        for (int i = 0; i < this.eventProcessor.getCountOfConnections(); ++i) {
            nChannel nChannel2 = (nChannel)storeGroup.getHiddenStoreList()[i];
            if (nChannel2 == null) {
                ++n;
                continue;
            }
            DurableGroup durableGroup = storeGroup.getDurableManager().getDurableGroup(nManageNamedSub2.getNameId());
            if (durableGroup == null) continue;
            try {
                this.storeManagerHelper.getBaseChannel(nChannel2).unbindNamedObject(durableGroup.getHiddenDurableList()[i]);
                continue;
            }
            catch (nChannelNotFoundException | nIllegalArgumentException | nNameDoesNotExistException | nRequestTimedOutException | nSessionNotConnectedException | nSessionPausedException | nUnexpectedResponseException nBaseClientException3) {
                ++n;
                nBaseClientException2 = nBaseClientException3;
                HSLogger.println(fLogLevel.FATAL, "Exception while unbinding durable: " + nManageNamedSub2.getName() + " on connection: " + this.eventProcessor.getClientConnectionsHidden().get(i).getSessionInfo() + " " + nBaseClientException3.getMessage(), nBaseClientException3);
            }
        }
        if (n == this.eventProcessor.getCountOfConnections()) {
            this.storeManager.getExceptionListener().processException(nBaseClientException2);
            return new nExceptionEvent(nBaseClientException2.getID(), nBaseClientException2.getMessage(), true);
        }
        return nManageNamedSub2;
    }

    private nEvent rebuildSelector(nManageNamedSub nManageNamedSub2) {
        StoreGroup storeGroup = this.storeManager.getStoreList(nManageNamedSub2.getChannelAttributesId());
        nAbstractChannel nAbstractChannel2 = storeGroup.getPublicStore();
        if (nAbstractChannel2.getTraceLogger().isTraceEnabled()) {
            nAbstractChannel2.getTraceLogger().trace("HS> Rebuilding selector for HS store durables durableName=" + nManageNamedSub2.getName() + ", conns=" + this.eventProcessor.getHiddenConnectionsIDs(), CLASS_NAME);
        }
        int n = 0;
        nBaseClientException nBaseClientException2 = null;
        for (int i = 0; i < this.eventProcessor.getCountOfConnections(); ++i) {
            DurableGroup durableGroup = storeGroup.getDurableManager().getDurableGroup(nManageNamedSub2.getNameId());
            if (durableGroup == null) continue;
            if (durableGroup.getHiddenDurableList()[i] == null) {
                ++n;
                continue;
            }
            try {
                ((nIndexedDurable)durableGroup.getHiddenDurableList()[i]).rebuildSelector(nManageNamedSub2.getSelector());
                continue;
            }
            catch (nIllegalArgumentException | nRequestTimedOutException | nSessionNotConnectedException | nSessionPausedException nBaseClientException3) {
                ++n;
                nBaseClientException2 = nBaseClientException3;
                HSLogger.println(fLogLevel.FATAL, "Exception while rebuilding durable selector: " + nManageNamedSub2.getName() + " on connection: " + this.eventProcessor.getClientConnectionsHidden().get(i).getSessionInfo() + " " + nBaseClientException3.getMessage(), nBaseClientException3);
            }
        }
        if (n == this.eventProcessor.getCountOfConnections()) {
            this.storeManager.getExceptionListener().processException(nBaseClientException2);
            return new nExceptionEvent(nBaseClientException2.getID(), nBaseClientException2.getMessage(), true);
        }
        return nManageNamedSub2;
    }
}

