/*
 * Decompiled with CFR 0.152.
 */
package com.pcbsys.nirvana.base.clientimpl.multiconnection.eventhandlers;

import com.pcbsys.foundation.logger.fLogLevel;
import com.pcbsys.nirvana.base.ClientEventTraceLoggerContext;
import com.pcbsys.nirvana.base.clientimpl.multiconnection.DurableGroup;
import com.pcbsys.nirvana.base.clientimpl.multiconnection.EventListenerMultiplexer;
import com.pcbsys.nirvana.base.clientimpl.multiconnection.HSLogger;
import com.pcbsys.nirvana.base.clientimpl.multiconnection.OutgoingEventMultiplexWrapper;
import com.pcbsys.nirvana.base.clientimpl.multiconnection.StoreGroup;
import com.pcbsys.nirvana.base.clientimpl.multiconnection.eventhandlers.EventHandler;
import com.pcbsys.nirvana.base.clientimpl.multiconnection.eventhandlers.EventProcessor;
import com.pcbsys.nirvana.base.clientimpl.multiconnection.nStoreManagerImpl;
import com.pcbsys.nirvana.base.clientimpl.nStoreManagerHelper;
import com.pcbsys.nirvana.base.events.nEvent;
import com.pcbsys.nirvana.base.events.nExceptionEvent;
import com.pcbsys.nirvana.base.events.nUserSubscribe;
import com.pcbsys.nirvana.client.nAbstractChannel;
import com.pcbsys.nirvana.client.nBaseClientException;
import com.pcbsys.nirvana.client.nChannelAlreadySubscribedException;
import com.pcbsys.nirvana.client.nChannelImpl;
import com.pcbsys.nirvana.client.nChannelNotFoundException;
import com.pcbsys.nirvana.client.nIllegalArgumentException;
import com.pcbsys.nirvana.client.nNameAlreadyBoundException;
import com.pcbsys.nirvana.client.nNameDoesNotExistException;
import com.pcbsys.nirvana.client.nRequestTimedOutException;
import com.pcbsys.nirvana.client.nSecurityException;
import com.pcbsys.nirvana.client.nSelectorParserException;
import com.pcbsys.nirvana.client.nSessionNotConnectedException;
import com.pcbsys.nirvana.client.nSessionPausedException;
import com.pcbsys.nirvana.client.nUnexpectedResponseException;

class nUserSubscribeHandler
extends EventHandler {
    private static final String CLASS_NAME = nUserSubscribeHandler.class.getSimpleName();
    private final nStoreManagerImpl storeManager;
    private final nStoreManagerHelper storeManagerHelper;

    nUserSubscribeHandler(EventProcessor eventProcessor, nStoreManagerImpl nStoreManagerImpl2) {
        super(12, eventProcessor);
        this.storeManager = nStoreManagerImpl2;
        this.storeManagerHelper = nStoreManagerImpl2.getStoreManagerHelper();
    }

    @Override
    OutgoingEventMultiplexWrapper processEventOutbound(nEvent nEvent2) {
        return new OutgoingEventMultiplexWrapper(Thread.currentThread(), (nUserSubscribe)nEvent2);
    }

    @Override
    nEvent processEventInbound(OutgoingEventMultiplexWrapper outgoingEventMultiplexWrapper) {
        nUserSubscribe nUserSubscribe2 = (nUserSubscribe)outgoingEventMultiplexWrapper.getOriginalEvent();
        StoreGroup storeGroup = this.storeManager.getStoreList(nUserSubscribe2.getChannelAttributesId());
        if (nUserSubscribe2.getNameId() != -1L) {
            EventListenerMultiplexer eventListenerMultiplexer = new EventListenerMultiplexer(storeGroup, this.storeManagerHelper, this.eventProcessor.getCountOfConnections(), true);
            return this.processDurableSubscription(storeGroup, eventListenerMultiplexer, nUserSubscribe2);
        }
        EventListenerMultiplexer eventListenerMultiplexer = new EventListenerMultiplexer(storeGroup, this.storeManagerHelper, this.eventProcessor.getCountOfConnections(), this.storeManagerHelper.isQueue(storeGroup.getPublicStore()) && nUserSubscribe2.getEID() != 0L);
        return this.processSubscription(storeGroup, eventListenerMultiplexer, nUserSubscribe2);
    }

    private nEvent processSubscription(StoreGroup storeGroup, EventListenerMultiplexer eventListenerMultiplexer, nUserSubscribe nUserSubscribe2) {
        nBaseClientException nBaseClientException2 = null;
        int n = 0;
        if (storeGroup.getPublicStore().getTraceLogger().isInfoEnabled()) {
            storeGroup.getPublicStore().getTraceLogger().info("HS> Adding subscription. " + ClientEventTraceLoggerContext.addClientConnectionInfo(this.eventProcessor.getClientConnectionsHidden()), CLASS_NAME);
        }
        for (int i = 0; i < this.eventProcessor.getCountOfConnections(); ++i) {
            nAbstractChannel nAbstractChannel2 = storeGroup.getHiddenStoreList()[i];
            if (nAbstractChannel2 == null) {
                ++n;
                nBaseClientException2 = new nChannelNotFoundException("User Subscribe for: " + this.eventProcessor.getClientConnectionsHidden().get(i).getSessionInfo() + " failed as store is not present: " + nUserSubscribe2.getChannelAttributesId() + " on connection: " + this.eventProcessor.getClientConnectionsHidden().get(i).getSessionInfo());
                continue;
            }
            nChannelImpl nChannelImpl2 = this.storeManagerHelper.getBaseChannel(nAbstractChannel2);
            try {
                HSLogger.println(fLogLevel.TRACE, "Adding subscription store: " + nChannelImpl2.getBaseChannelAttributes().getName() + " from connection: " + this.eventProcessor.getClientConnectionsHidden().get(i).getSessionInfo());
                nChannelImpl2.addSubscriber(eventListenerMultiplexer.getHiddenEventListeners().get(i), nUserSubscribe2.getSelector(), nUserSubscribe2.getEID(), null, false, nUserSubscribe2.isMaintainPriority(), nUserSubscribe2.isInfiniteWindow());
                if (storeGroup.getAsyncEventListener().hasActiveSubscription()) continue;
                storeGroup.addAsyncEventListener(nUserSubscribe2, eventListenerMultiplexer);
                continue;
            }
            catch (nChannelAlreadySubscribedException | nChannelNotFoundException | nRequestTimedOutException | nSecurityException | nSelectorParserException | nSessionNotConnectedException | nSessionPausedException | nUnexpectedResponseException nBaseClientException3) {
                ++n;
                nBaseClientException2 = nBaseClientException3;
                HSLogger.println(fLogLevel.WARN, "Exception while adding subscription on connection: " + this.eventProcessor.getClientConnectionsHidden().get(i).getSessionInfo() + " " + nBaseClientException3.getMessage(), nBaseClientException3);
            }
        }
        if (n == this.eventProcessor.getCountOfConnections()) {
            this.storeManager.getExceptionListener().processException(nBaseClientException2);
            return new nExceptionEvent(nBaseClientException2.getID(), nBaseClientException2.getMessage(), true);
        }
        return nUserSubscribe2;
    }

    private nEvent processDurableSubscription(StoreGroup storeGroup, EventListenerMultiplexer eventListenerMultiplexer, nUserSubscribe nUserSubscribe2) {
        nBaseClientException nBaseClientException2 = null;
        int n = 0;
        DurableGroup durableGroup = storeGroup.getDurableManager().getDurableGroup(nUserSubscribe2.getNameId());
        if (storeGroup.getPublicStore().getTraceLogger().isInfoEnabled()) {
            storeGroup.getPublicStore().getTraceLogger().info("HS> Adding durable subscription. nameId=" + nUserSubscribe2.getNameId() + ClientEventTraceLoggerContext.addClientConnectionInfo(this.eventProcessor.getClientConnectionsHidden()), CLASS_NAME);
        }
        for (int i = 0; i < this.eventProcessor.getCountOfConnections(); ++i) {
            nAbstractChannel nAbstractChannel2 = storeGroup.getHiddenStoreList()[i];
            if (nAbstractChannel2 == null) {
                nBaseClientException2 = new nChannelNotFoundException("User Subscribe for: " + this.eventProcessor.getClientConnectionsHidden().get(i).getSessionInfo() + " failed as store is not present: " + nUserSubscribe2.getChannelAttributesId() + " on connection: " + this.eventProcessor.getClientConnectionsHidden().get(i).getSessionInfo());
                continue;
            }
            nChannelImpl nChannelImpl2 = this.storeManagerHelper.getBaseChannel(nAbstractChannel2);
            try {
                if (durableGroup.getHiddenDurableList()[i] == null) {
                    nBaseClientException2 = new nNameDoesNotExistException("User Subscribe for: " + this.eventProcessor.getClientConnectionsHidden().get(i).getSessionInfo() + " failed as durable is not present: " + nUserSubscribe2.getNameId() + " on connection: " + this.eventProcessor.getClientConnectionsHidden().get(i).getSessionInfo());
                    continue;
                }
                HSLogger.println(fLogLevel.TRACE, "Adding durable subscription from store: " + nChannelImpl2.getBaseChannelAttributes().getName() + " from connection: " + this.eventProcessor.getClientConnectionsHidden().get(i).getSessionInfo());
                nChannelImpl2.addSubscriber(eventListenerMultiplexer.getHiddenEventListeners().get(i), durableGroup.getHiddenDurableList()[i], nUserSubscribe2.getSelector(), null, false, (int)nUserSubscribe2.getEID());
                if (storeGroup.getAsyncEventListener().hasActiveSubscription()) continue;
                storeGroup.addAsyncEventListener(nUserSubscribe2, eventListenerMultiplexer);
                continue;
            }
            catch (nChannelAlreadySubscribedException | nChannelNotFoundException | nIllegalArgumentException | nNameAlreadyBoundException | nNameDoesNotExistException | nRequestTimedOutException | nSecurityException | nSelectorParserException | nSessionNotConnectedException | nSessionPausedException | nUnexpectedResponseException nBaseClientException3) {
                HSLogger.println(fLogLevel.WARN, "Exception adding durable subscription on connection: " + this.eventProcessor.getClientConnectionsHidden().get(i).getSessionInfo() + " " + nBaseClientException3.getMessage(), nBaseClientException3);
                ++n;
                nBaseClientException2 = nBaseClientException3;
            }
        }
        if (n == this.eventProcessor.getCountOfConnections()) {
            if (storeGroup.getPublicStore().getTraceLogger().isWarnEnabled()) {
                storeGroup.getPublicStore().getTraceLogger().warn("HS> Failed to add subscription. reason=" + nBaseClientException2.getMessage() + ClientEventTraceLoggerContext.addClientConnectionInfo(this.eventProcessor.getClientConnectionsHidden()), CLASS_NAME);
            }
            this.storeManager.getExceptionListener().processException(nBaseClientException2);
            return new nExceptionEvent(nBaseClientException2.getID(), nBaseClientException2.getMessage(), true);
        }
        return nUserSubscribe2;
    }
}

