/*
 * Decompiled with CFR 0.152.
 */
package com.pcbsys.nirvana.base.clientimpl.multiconnection;

import com.pcbsys.foundation.base.fTimer;
import com.pcbsys.foundation.collections.fast.Long2ObjectOpenAddressingHashMap;
import com.pcbsys.foundation.logger.fLogLevel;
import com.pcbsys.nirvana.base.clientimpl.ClientConnectionManager;
import com.pcbsys.nirvana.base.clientimpl.multiconnection.ClientConnectionManagerImpl;
import com.pcbsys.nirvana.base.clientimpl.multiconnection.HSLogger;
import com.pcbsys.nirvana.base.clientimpl.multiconnection.OutgoingEventMultiplexWrapper;
import com.pcbsys.nirvana.base.clientimpl.multiconnection.eventhandlers.EventHandlerInitialiser;
import com.pcbsys.nirvana.base.clientimpl.multiconnection.eventhandlers.EventProcessor;
import com.pcbsys.nirvana.base.clientimpl.multiconnection.nStoreManagerImpl;
import com.pcbsys.nirvana.base.clientimpl.nEventProcessor;
import com.pcbsys.nirvana.base.events.nEvent;
import com.pcbsys.nirvana.base.events.nPopQueue;
import com.pcbsys.nirvana.base.events.nPopQueueCommand;
import com.pcbsys.nirvana.base.nConstants;
import com.pcbsys.nirvana.base.nRuntime;
import com.pcbsys.nirvana.client.nRequestTimedOutException;
import com.pcbsys.nirvana.client.nSessionNotConnectedException;
import com.pcbsys.nirvana.client.nSessionPausedException;
import java.util.Iterator;
import java.util.List;
import java.util.function.Predicate;

class nEventProcessorImpl
implements nEventProcessor {
    private final EventProcessor eventProcessor;
    private final List<ClientConnectionManager> clientConnectionsManagers;
    private final Long2ObjectOpenAddressingHashMap<OutgoingEventMultiplexWrapper> outstandingEvents;
    private final ClientConnectionManagerImpl connectionManager;
    private final nStoreManagerImpl storeManager;

    nEventProcessorImpl(ClientConnectionManagerImpl clientConnectionManagerImpl, List<ClientConnectionManager> list, nStoreManagerImpl nStoreManagerImpl2) {
        this.connectionManager = clientConnectionManagerImpl;
        this.storeManager = nStoreManagerImpl2;
        this.clientConnectionsManagers = list;
        this.eventProcessor = new EventProcessor(nRuntime.sDevelopersBuild, list);
        this.outstandingEvents = new Long2ObjectOpenAddressingHashMap();
    }

    public void initialise() {
        new EventHandlerInitialiser().initialiseEventHandlers(this.eventProcessor, this.clientConnectionsManagers, this.connectionManager.getStoreManager());
    }

    @Override
    public nEvent writeEvent(nEvent nEvent2) throws nSessionNotConnectedException, nRequestTimedOutException, nSessionPausedException {
        return this.writeEvent(nEvent2, nConstants.getEVENTWAIT());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public nEvent writeEvent(nEvent nEvent2, long l) throws nSessionNotConnectedException, nRequestTimedOutException, nSessionPausedException {
        boolean bl;
        boolean bl2;
        long l2;
        if (!this.connectionManager.isAlive()) {
            throw new nSessionNotConnectedException("Session has been closed");
        }
        if (this.connectionManager.isPaused() && nEvent2.getId() != 36 && (nEvent2.getId() != 33 || ((nPopQueue)nEvent2).getCommand() != nPopQueueCommand.CLOSE)) {
            throw new nSessionPausedException("Session is paused");
        }
        if (l <= -1L) {
            l2 = Long.MAX_VALUE;
            l = Long.MAX_VALUE;
        } else {
            l2 = fTimer.getTicks() + l;
        }
        OutgoingEventMultiplexWrapper outgoingEventMultiplexWrapper = this.eventProcessor.processEventOutbound(nEvent2);
        boolean bl3 = bl2 = outgoingEventMultiplexWrapper.getRequestId() != -1L;
        if (bl2) {
            Long2ObjectOpenAddressingHashMap<OutgoingEventMultiplexWrapper> long2ObjectOpenAddressingHashMap = this.outstandingEvents;
            synchronized (long2ObjectOpenAddressingHashMap) {
                this.outstandingEvents.put(outgoingEventMultiplexWrapper.getRequestId(), outgoingEventMultiplexWrapper);
            }
        }
        for (int i = 0; i < outgoingEventMultiplexWrapper.getOutgoingEventWrappers().length; ++i) {
            try {
                if (outgoingEventMultiplexWrapper.getOutgoingEventWrappers()[i] == null) continue;
                this.clientConnectionsManagers.get(i).getEventProcessor().writeEvent(outgoingEventMultiplexWrapper.getOutgoingEventWrappers()[i], l);
                continue;
            }
            catch (nRequestTimedOutException | nSessionNotConnectedException | nSessionPausedException nBaseClientException2) {
                HSLogger.println(fLogLevel.TRACE, "Failed to send event: " + outgoingEventMultiplexWrapper.getOutgoingEventWrappers()[i].getClass().getSimpleName() + " to connection: " + this.clientConnectionsManagers.get(i).getSessionInfo(), nBaseClientException2);
                outgoingEventMultiplexWrapper.decreaseCountDownLatch();
                this.storeManager.getExceptionListener().processException(nBaseClientException2);
            }
        }
        try {
            outgoingEventMultiplexWrapper.waitForComplete(l);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        boolean bl4 = bl = l2 < fTimer.getTicks();
        if (bl2) {
            Long2ObjectOpenAddressingHashMap<OutgoingEventMultiplexWrapper> long2ObjectOpenAddressingHashMap = this.outstandingEvents;
            synchronized (long2ObjectOpenAddressingHashMap) {
                this.outstandingEvents.remove(outgoingEventMultiplexWrapper.getRequestId());
            }
        }
        if (!this.connectionManager.isAlive()) {
            throw new nSessionNotConnectedException("Session has been closed via another thread");
        }
        if ((this.connectionManager.isPaused() || outgoingEventMultiplexWrapper.wasPaused()) && nEvent2.getId() != 36 && (nEvent2.getId() != 33 || ((nPopQueue)nEvent2).getCommand() != nPopQueueCommand.CLOSE)) {
            throw new nSessionPausedException("Session is paused");
        }
        if (outgoingEventMultiplexWrapper.isClear()) {
            throw new nSessionNotConnectedException("Session with the Realm has been disconnected");
        }
        if (bl) {
            throw new nRequestTimedOutException("" + nConstants.getEVENTWAIT() + " last ID = " + outgoingEventMultiplexWrapper.getRequestId() + " " + outgoingEventMultiplexWrapper.getOriginalEvent().getClass().toString());
        }
        return this.eventProcessor.processEventInbound(outgoingEventMultiplexWrapper);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void unblockThread(String string) {
        Long2ObjectOpenAddressingHashMap<OutgoingEventMultiplexWrapper> long2ObjectOpenAddressingHashMap = this.outstandingEvents;
        synchronized (long2ObjectOpenAddressingHashMap) {
            Iterator<OutgoingEventMultiplexWrapper> iterator = this.outstandingEvents.iterator();
            while (iterator.hasNext()) {
                OutgoingEventMultiplexWrapper outgoingEventMultiplexWrapper = iterator.next();
                if (!outgoingEventMultiplexWrapper.getThread().getName().equals(string)) continue;
                outgoingEventMultiplexWrapper.clear();
                iterator.remove();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void releaseRequests(Predicate<nEvent> predicate) {
        if (predicate == null) {
            throw new IllegalArgumentException("Matcher must not be null");
        }
        Long2ObjectOpenAddressingHashMap<OutgoingEventMultiplexWrapper> long2ObjectOpenAddressingHashMap = this.outstandingEvents;
        synchronized (long2ObjectOpenAddressingHashMap) {
            Iterator<OutgoingEventMultiplexWrapper> iterator = this.outstandingEvents.iterator();
            while (iterator.hasNext()) {
                OutgoingEventMultiplexWrapper outgoingEventMultiplexWrapper = iterator.next();
                if (!predicate.test(outgoingEventMultiplexWrapper.getOriginalEvent())) continue;
                if (this.connectionManager.isPaused()) {
                    outgoingEventMultiplexWrapper.paused();
                } else {
                    outgoingEventMultiplexWrapper.clear();
                }
                iterator.remove();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void releaseRequests() {
        Long2ObjectOpenAddressingHashMap<OutgoingEventMultiplexWrapper> long2ObjectOpenAddressingHashMap = this.outstandingEvents;
        synchronized (long2ObjectOpenAddressingHashMap) {
            for (OutgoingEventMultiplexWrapper outgoingEventMultiplexWrapper : this.outstandingEvents.values()) {
                if (this.connectionManager.isPaused()) {
                    outgoingEventMultiplexWrapper.paused();
                    continue;
                }
                outgoingEventMultiplexWrapper.clear();
            }
            this.outstandingEvents.clear();
        }
    }

    @Override
    public void close() {
    }
}

