/*
 * Decompiled with CFR 0.152.
 */
package com.pcbsys.nirvana.base.clientimpl.multiconnection;

import com.pcbsys.foundation.collections.fast.Long2ObjectOpenAddressingHashMap;
import com.pcbsys.foundation.logger.fLogLevel;
import com.pcbsys.foundation.utils.fStringByteConverter;
import com.pcbsys.nirvana.base.ClientEventTraceLoggerContext;
import com.pcbsys.nirvana.base.clientimpl.ClientConnectionManager;
import com.pcbsys.nirvana.base.clientimpl.StoreManagerStateListener;
import com.pcbsys.nirvana.base.clientimpl.multiconnection.ClientConnectionManagerImpl;
import com.pcbsys.nirvana.base.clientimpl.multiconnection.CompareChannelAttributes;
import com.pcbsys.nirvana.base.clientimpl.multiconnection.HSLogger;
import com.pcbsys.nirvana.base.clientimpl.multiconnection.OperationExceptionValidator;
import com.pcbsys.nirvana.base.clientimpl.multiconnection.StoreGroup;
import com.pcbsys.nirvana.base.clientimpl.multiconnection.SynchronousEventConsumerManager;
import com.pcbsys.nirvana.base.clientimpl.multiconnection.nQueueReaderManagerImpl;
import com.pcbsys.nirvana.base.clientimpl.nExceptionListenerManager;
import com.pcbsys.nirvana.base.clientimpl.nQueueReaderManager;
import com.pcbsys.nirvana.base.clientimpl.nQueueReaderManagerHelper;
import com.pcbsys.nirvana.base.clientimpl.nStoreManager;
import com.pcbsys.nirvana.base.clientimpl.nStoreManagerHelper;
import com.pcbsys.nirvana.base.nChannelAttributes;
import com.pcbsys.nirvana.base.nThreadManager;
import com.pcbsys.nirvana.client.nAbstractChannel;
import com.pcbsys.nirvana.client.nChannel;
import com.pcbsys.nirvana.client.nChannelImpl;
import com.pcbsys.nirvana.client.nConsumeEvent;
import com.pcbsys.nirvana.client.nIllegalArgumentException;
import com.pcbsys.nirvana.client.nIllegalChannelMode;
import com.pcbsys.nirvana.client.nQueue;
import com.pcbsys.nirvana.client.nSession;
import com.pcbsys.nirvana.client.nStoreDeletedException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

public class nStoreManagerImpl
implements nStoreManager {
    private static final String CLASS_NAME = ClientEventTraceLoggerContext.getClassNameWithPackage(nStoreManagerImpl.class);
    private final Long2ObjectOpenAddressingHashMap<nAbstractChannel> myStoreList;
    private final nQueueReaderManager myQueueReaderManager;
    private final nThreadManager myThreadManager;
    private final nSession mySession;
    private final nStoreManagerHelper myHelper;
    private final nExceptionListenerManager myExceptionListenerManager;
    private final ClientConnectionManagerImpl myConnectionManager;
    private final List<ClientConnectionManager> myClientConnectionManagers;
    private final OperationExceptionValidator myOperationValidator;
    private final Long2ObjectOpenAddressingHashMap<StoreGroup> connectionChannelLookup;
    private final StoreManagerStateListenerImpl stateListenerForSingleConnections;

    nStoreManagerImpl(nSession nSession2, nThreadManager nThreadManager2, ClientConnectionManagerImpl clientConnectionManagerImpl, nQueueReaderManagerHelper nQueueReaderManagerHelper2, nStoreManagerHelper nStoreManagerHelper2, nExceptionListenerManager nExceptionListenerManager2, List<ClientConnectionManager> list) {
        this.myExceptionListenerManager = nExceptionListenerManager2;
        this.myStoreList = new Long2ObjectOpenAddressingHashMap();
        this.myQueueReaderManager = new nQueueReaderManagerImpl(nQueueReaderManagerHelper2, this);
        this.myThreadManager = nThreadManager2;
        this.myConnectionManager = clientConnectionManagerImpl;
        this.mySession = nSession2;
        this.myHelper = nStoreManagerHelper2;
        this.myClientConnectionManagers = list;
        this.connectionChannelLookup = new Long2ObjectOpenAddressingHashMap();
        this.stateListenerForSingleConnections = new StoreManagerStateListenerImpl();
        this.myOperationValidator = new OperationExceptionValidator(this.myClientConnectionManagers);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() {
        Long2ObjectOpenAddressingHashMap<nAbstractChannel> long2ObjectOpenAddressingHashMap = this.myStoreList;
        synchronized (long2ObjectOpenAddressingHashMap) {
            Iterator<nAbstractChannel> iterator = this.myStoreList.iterator();
            while (iterator.hasNext()) {
                this.myHelper.getBaseChannel(iterator.next()).getChannelList().setDeleted();
            }
            this.myStoreList.clear();
            this.connectionChannelLookup.clear();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public nAbstractChannel get(long l) {
        Long2ObjectOpenAddressingHashMap<nAbstractChannel> long2ObjectOpenAddressingHashMap = this.myStoreList;
        synchronized (long2ObjectOpenAddressingHashMap) {
            return this.myStoreList.get(l);
        }
    }

    @Override
    public nAbstractChannel get(nChannelAttributes nChannelAttributes2) {
        if (nChannelAttributes2.getUniqueId() != -1L) {
            return this.get(nChannelAttributes2.getUniqueId());
        }
        return this.findStore(nChannelAttributes2.getName());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private nAbstractChannel findStore(String string) {
        Long2ObjectOpenAddressingHashMap<nAbstractChannel> long2ObjectOpenAddressingHashMap = this.myStoreList;
        synchronized (long2ObjectOpenAddressingHashMap) {
            Iterator<nAbstractChannel> iterator = this.myStoreList.iterator();
            while (iterator.hasNext()) {
                nAbstractChannel nAbstractChannel2 = iterator.next();
                if (!this.myHelper.getAttributes(nAbstractChannel2).getName().equals(string)) continue;
                return nAbstractChannel2;
            }
        }
        return null;
    }

    @Override
    public void remove(nChannelAttributes nChannelAttributes2) {
        nAbstractChannel nAbstractChannel2 = this.removeStoreFromHSLayer(nChannelAttributes2);
        this.completeStoreLifecycle(nAbstractChannel2);
        this.myOperationValidator.removeStoreEntries(nChannelAttributes2.getName());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private nAbstractChannel removeStoreFromHSLayer(nChannelAttributes nChannelAttributes2) {
        nAbstractChannel nAbstractChannel2 = null;
        Long2ObjectOpenAddressingHashMap<nAbstractChannel> long2ObjectOpenAddressingHashMap = this.myStoreList;
        synchronized (long2ObjectOpenAddressingHashMap) {
            ArrayList<Long> arrayList = new ArrayList<Long>();
            Iterator<Long> iterator = this.myStoreList.keySet().iterator();
            while (iterator.hasNext()) {
                long l = (Long)iterator.next();
                nAbstractChannel nAbstractChannel3 = this.myStoreList.get(l);
                if (nAbstractChannel3 == null || !this.myHelper.getAttributes(nAbstractChannel3).getName().equals(nChannelAttributes2.getName())) continue;
                arrayList.add(l);
            }
            for (Long l : arrayList) {
                nAbstractChannel2 = this.myStoreList.remove(l);
            }
        }
        return nAbstractChannel2;
    }

    private void validateInnerSessionChannelRemoval(nChannelAttributes nChannelAttributes2, String string) {
        if (this.myOperationValidator.validateException(38, nChannelAttributes2.getName())) {
            nAbstractChannel nAbstractChannel2 = this.removeStoreFromHSLayer(nChannelAttributes2);
            this.completeStoreLifecycle(nAbstractChannel2);
            this.myOperationValidator.removeStoreEntries(nChannelAttributes2.getName());
        } else {
            HSLogger.println(fLogLevel.DEBUG, "Deleting store " + nChannelAttributes2.getName() + " from inner session with id: " + string + " ,as it has been removed from the server");
        }
    }

    public StoreGroup getStoreList(long l) {
        return this.connectionChannelLookup.get(l);
    }

    @Override
    public nChannel getChannel(nChannelAttributes nChannelAttributes2) throws nIllegalChannelMode {
        if (nChannelAttributes2.getUniqueId() != -1L) {
            return this.validateChannel(this.get(nChannelAttributes2.getUniqueId()));
        }
        return this.validateChannel(this.findStore(nChannelAttributes2.getName()));
    }

    private nChannel validateChannel(nAbstractChannel nAbstractChannel2) throws nIllegalChannelMode {
        if (nAbstractChannel2 != null) {
            if (!this.myHelper.isQueue(nAbstractChannel2)) {
                return (nChannel)nAbstractChannel2;
            }
            throw new nIllegalChannelMode("Store is a nQueue");
        }
        return null;
    }

    @Override
    public nQueue getQueue(nChannelAttributes nChannelAttributes2) throws nIllegalChannelMode {
        if (nChannelAttributes2.getUniqueId() != -1L) {
            return this.validateQueue(this.get(nChannelAttributes2.getUniqueId()));
        }
        return this.validateQueue(this.findStore(nChannelAttributes2.getName()));
    }

    private nQueue validateQueue(nAbstractChannel nAbstractChannel2) throws nIllegalChannelMode {
        if (nAbstractChannel2 != null) {
            if (this.myHelper.isQueue(nAbstractChannel2)) {
                return (nQueue)nAbstractChannel2;
            }
            throw new nIllegalChannelMode("Store is a nChannel");
        }
        return null;
    }

    @Override
    public void setMultiplexStoreFlag(boolean bl) {
        if (bl) {
            throw new UnsupportedOperationException("Cannot use multiplex stores with horizontally scalable sessions");
        }
    }

    @Override
    public boolean isMultiplexStores() {
        return false;
    }

    @Override
    public nQueueReaderManager getReaderManager() {
        return this.myQueueReaderManager;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void createAndPutChannel(nChannelAttributes nChannelAttributes2, nChannelAttributes[] nChannelAttributesArray) {
        this.validateStoreEquality(nChannelAttributesArray);
        Long2ObjectOpenAddressingHashMap<nAbstractChannel> long2ObjectOpenAddressingHashMap = this.myStoreList;
        synchronized (long2ObjectOpenAddressingHashMap) {
            nAbstractChannel nAbstractChannel2 = this.get(nChannelAttributes2);
            if (nAbstractChannel2 != null && !this.myHelper.isQueue(nAbstractChannel2) && this.myHelper.getAttributes(nAbstractChannel2).getName().equals(nChannelAttributes2.getName()) && this.myHelper.getAttributes(nAbstractChannel2).getUniqueId() == nChannelAttributes2.getUniqueId()) {
                return;
            }
            nChannel nChannel2 = null;
            try {
                nChannel2 = this.myHelper.createChannel(nChannelAttributes2, this.mySession, this.myThreadManager, this.myConnectionManager, this.isMultiplexStores());
                if (nChannel2 != null && nChannel2.getTraceLogger().isInfoEnabled()) {
                    nChannel2.getTraceLogger().info("HS> Created channel successfully. " + ClientEventTraceLoggerContext.addChAttributesInfo(nChannel2.getChannelAttributes()) + ClientEventTraceLoggerContext.addClientConnectionInfo(this.myConnectionManager), CLASS_NAME);
                }
            }
            catch (nIllegalArgumentException nIllegalArgumentException2) {
                HSLogger.println(fLogLevel.WARN, "Encountered an issue whilst creating a channel.", nIllegalArgumentException2);
            }
            this.put(nChannelAttributes2.getUniqueId(), nChannel2, nChannelAttributesArray);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void createAndPutQueue(nChannelAttributes nChannelAttributes2, nChannelAttributes[] nChannelAttributesArray) {
        this.validateStoreEquality(nChannelAttributesArray);
        Long2ObjectOpenAddressingHashMap<nAbstractChannel> long2ObjectOpenAddressingHashMap = this.myStoreList;
        synchronized (long2ObjectOpenAddressingHashMap) {
            nAbstractChannel nAbstractChannel2 = this.get(nChannelAttributes2);
            if (nAbstractChannel2 != null && this.myHelper.isQueue(nAbstractChannel2) && this.myHelper.getAttributes(nAbstractChannel2).getName().equals(nChannelAttributes2.getName()) && this.myHelper.getAttributes(nAbstractChannel2).getUniqueId() == nChannelAttributes2.getUniqueId()) {
                return;
            }
            nQueue nQueue2 = null;
            try {
                nQueue2 = this.myHelper.createQueue(nChannelAttributes2, this.mySession, this.myThreadManager, this.myQueueReaderManager, this.myConnectionManager);
                if (nQueue2 != null && nQueue2.getTraceLogger().isInfoEnabled()) {
                    nQueue2.getTraceLogger().info("HS> Created queue successfully. " + ClientEventTraceLoggerContext.addChAttributesInfo(nQueue2.getQueueAttributes()) + ClientEventTraceLoggerContext.addClientConnectionInfo(this.myConnectionManager), CLASS_NAME);
                }
            }
            catch (nIllegalArgumentException nIllegalArgumentException2) {
                HSLogger.println(fLogLevel.WARN, "Encountered an issue whilst creating a queue.", nIllegalArgumentException2);
            }
            this.put(nChannelAttributes2.getUniqueId(), nQueue2, nChannelAttributesArray);
        }
    }

    private void validateStoreEquality(nChannelAttributes[] nChannelAttributesArray) {
        nChannelAttributes nChannelAttributes2 = null;
        for (nChannelAttributes nChannelAttributes3 : nChannelAttributesArray) {
            if (nChannelAttributes2 == null) {
                nChannelAttributes2 = nChannelAttributes3;
                continue;
            }
            if (nChannelAttributes3 == null || CompareChannelAttributes.areChannelAttributesValid(nChannelAttributes2, nChannelAttributes3)) continue;
            throw new UnsupportedOperationException("One of the stores does not contain a store equivalent to the others, cannot proceed");
        }
    }

    private void put(long l, nAbstractChannel nAbstractChannel2, nChannelAttributes[] nChannelAttributesArray) {
        this.completeStoreLifecycle(this.myStoreList.put(l, nAbstractChannel2));
        nAbstractChannel[] nAbstractChannelArray = new nAbstractChannel[nChannelAttributesArray.length];
        for (int i = 0; i < nChannelAttributesArray.length; ++i) {
            nChannelAttributes nChannelAttributes2 = nChannelAttributesArray[i];
            if (nChannelAttributes2 == null) continue;
            nAbstractChannelArray[i] = this.myClientConnectionManagers.get(i).getStoreManager().get(nChannelAttributes2);
        }
        StoreGroup storeGroup = new StoreGroup(nAbstractChannel2, nAbstractChannelArray, this.myHelper, this.myClientConnectionManagers);
        this.connectionChannelLookup.put(l, storeGroup);
    }

    private void completeStoreLifecycle(nAbstractChannel nAbstractChannel2) {
        if (nAbstractChannel2 != null) {
            nChannelImpl nChannelImpl2 = this.myHelper.getBaseChannel(nAbstractChannel2);
            nChannelImpl2.getChannelList().setDeleted();
            if (nChannelImpl2.getTraceLogger().isInfoEnabled()) {
                nChannelImpl2.getTraceLogger().info("HS> Deleted store successfully as it has been removed from the server." + ClientEventTraceLoggerContext.addChAttributesInfo(nChannelImpl2.getBaseChannelAttributes()) + ", conn=" + this.myConnectionManager.getSessionInfo(), CLASS_NAME);
            }
            HSLogger.println(fLogLevel.WARN, "Deleting store " + nChannelImpl2.getBaseChannelAttributes().getName() + " as it has been removed from the server");
            nStoreDeletedException nStoreDeletedException2 = new nStoreDeletedException("The store \"" + nChannelImpl2.getBaseChannelAttributes().getName() + "\" has been deleted actions will need to be taken to recover from this serverside operation", nAbstractChannel2);
            this.myExceptionListenerManager.processException(nStoreDeletedException2);
            if (this.myConnectionManager.getSessionAttributes().isAdviseAsynchronousEventListenersOfStoreDelete()) {
                nConsumeEvent nConsumeEvent2 = new nConsumeEvent("CHANNEL DELETED", fStringByteConverter.convert("The channel has been deleted"));
                nConsumeEvent2.setEventID(-2L);
                nChannelImpl2.getChannelList().push(nConsumeEvent2, null);
            }
        }
    }

    @Override
    public void registerStateListener(StoreManagerStateListener storeManagerStateListener) {
        throw new UnsupportedOperationException();
    }

    public StoreManagerStateListener getStoreManagerStateListener() {
        return this.stateListenerForSingleConnections;
    }

    public nStoreManagerHelper getStoreManagerHelper() {
        return this.myHelper;
    }

    @Override
    public List<nAbstractChannel> getStores() {
        return new ArrayList<nAbstractChannel>(this.myStoreList.values());
    }

    private void removeInnerIterator(long l, String string) {
        StoreGroup storeGroup = this.connectionChannelLookup.get(l);
        if (storeGroup != null) {
            Iterator<Map.Entry<Long, SynchronousEventConsumerManager>> iterator = storeGroup.getIteratorManagers().entrySet().iterator();
            while (iterator.hasNext()) {
                SynchronousEventConsumerManager synchronousEventConsumerManager = iterator.next().getValue();
                synchronousEventConsumerManager.setChannelIterator(null, this.getConnectionIndex(string));
            }
        }
    }

    private int getConnectionIndex(String string) {
        int n = -1;
        for (ClientConnectionManager clientConnectionManager : this.myClientConnectionManagers) {
            if (!clientConnectionManager.getClientAllocatedSessionID().equals(string)) continue;
            n = this.myClientConnectionManagers.indexOf(clientConnectionManager);
            break;
        }
        return n;
    }

    public OperationExceptionValidator getExceptionValidator() {
        return this.myOperationValidator;
    }

    public nExceptionListenerManager getExceptionListener() {
        return this.myExceptionListenerManager;
    }

    private class StoreManagerStateListenerImpl
    implements StoreManagerStateListener {
        private StoreManagerStateListenerImpl() {
        }

        @Override
        public void storeDestroyed(nAbstractChannel nAbstractChannel2, String string) {
            nStoreManagerImpl.this.myOperationValidator.addInnerSessionException(38, nAbstractChannel2.getStoreAttributes().getName(), string);
            nAbstractChannel nAbstractChannel3 = nStoreManagerImpl.this.findStore(nAbstractChannel2.getStoreAttributes().getName());
            if (nAbstractChannel3 != null) {
                nStoreManagerImpl.this.removeInnerIterator(nAbstractChannel3.getStoreAttributes().getUniqueId(), string);
                nStoreManagerImpl.this.validateInnerSessionChannelRemoval(nStoreManagerImpl.this.myHelper.getAttributes(nAbstractChannel2), string);
            }
        }
    }
}

