/*
 * Decompiled with CFR 0.152.
 */
package com.pcbsys.nirvana.base.clientimpl.singleconnection;

import com.pcbsys.foundation.base.fTimer;
import com.pcbsys.foundation.drivers.fConnectionDetails;
import com.pcbsys.foundation.drivers.fDriver;
import com.pcbsys.foundation.drivers.fDriverFactory;
import com.pcbsys.foundation.drivers.fMultiplexDriver;
import com.pcbsys.foundation.drivers.fMultiplexManager;
import com.pcbsys.foundation.drivers.fURLDriver;
import com.pcbsys.foundation.io.fBaseEventFactory;
import com.pcbsys.foundation.io.fConnection;
import com.pcbsys.foundation.io.fEventInputStream;
import com.pcbsys.foundation.io.fEventOutputStream;
import com.pcbsys.foundation.io.fLoopConnection;
import com.pcbsys.foundation.io.fStreamFactory;
import com.pcbsys.foundation.logger.fLogLevel;
import com.pcbsys.foundation.security.auth.fAuthenticationException;
import com.pcbsys.foundation.security.fSubject;
import com.pcbsys.foundation.utils.StringUtils;
import com.pcbsys.foundation.utils.fSystemConfiguration;
import com.pcbsys.nirvana.base.ConnectionQueueListenerWrapper;
import com.pcbsys.nirvana.base.UrlProcessor;
import com.pcbsys.nirvana.base.clientimpl.ClientConnectionManager;
import com.pcbsys.nirvana.base.clientimpl.SessionAttributes;
import com.pcbsys.nirvana.base.clientimpl.nChannelIteratorHelper;
import com.pcbsys.nirvana.base.clientimpl.nChannelIteratorManager;
import com.pcbsys.nirvana.base.clientimpl.nConnectionStatisticsManager;
import com.pcbsys.nirvana.base.clientimpl.nDataGroupManagerHelper;
import com.pcbsys.nirvana.base.clientimpl.nDurableHelper;
import com.pcbsys.nirvana.base.clientimpl.nEventProcessor;
import com.pcbsys.nirvana.base.clientimpl.nExceptionListenerManager;
import com.pcbsys.nirvana.base.clientimpl.nQueueReaderManager;
import com.pcbsys.nirvana.base.clientimpl.nQueueReaderManagerHelper;
import com.pcbsys.nirvana.base.clientimpl.nRealmManager;
import com.pcbsys.nirvana.base.clientimpl.nRedirectManager;
import com.pcbsys.nirvana.base.clientimpl.nRedirectManagerHelper;
import com.pcbsys.nirvana.base.clientimpl.nStoreManagerHelper;
import com.pcbsys.nirvana.base.clientimpl.singleconnection.Constants;
import com.pcbsys.nirvana.base.clientimpl.singleconnection.EventProcessingThread;
import com.pcbsys.nirvana.base.clientimpl.singleconnection.LoopEventCallback;
import com.pcbsys.nirvana.base.clientimpl.singleconnection.eventhandlers.ClientEventDispatcher;
import com.pcbsys.nirvana.base.clientimpl.singleconnection.eventhandlers.EventHandlerInitialiser;
import com.pcbsys.nirvana.base.clientimpl.singleconnection.eventhandlers.NoOperationHandler;
import com.pcbsys.nirvana.base.clientimpl.singleconnection.eventhandlers.nServerExtensionHandler;
import com.pcbsys.nirvana.base.clientimpl.singleconnection.nChannelIteratorManagerImpl;
import com.pcbsys.nirvana.base.clientimpl.singleconnection.nConnectionStatisticsManagerImpl;
import com.pcbsys.nirvana.base.clientimpl.singleconnection.nDataGroupManagerImpl;
import com.pcbsys.nirvana.base.clientimpl.singleconnection.nEventProcessorImpl;
import com.pcbsys.nirvana.base.clientimpl.singleconnection.nExceptionListenerManagerImpl;
import com.pcbsys.nirvana.base.clientimpl.singleconnection.nMulticastManager;
import com.pcbsys.nirvana.base.clientimpl.singleconnection.nMulticastPumpImpl;
import com.pcbsys.nirvana.base.clientimpl.singleconnection.nQueueReaderManagerImpl;
import com.pcbsys.nirvana.base.clientimpl.singleconnection.nRealmManagerImpl;
import com.pcbsys.nirvana.base.clientimpl.singleconnection.nRedirectManagerImpl;
import com.pcbsys.nirvana.base.clientimpl.singleconnection.nStoreManagerImpl;
import com.pcbsys.nirvana.base.events.nEvent;
import com.pcbsys.nirvana.base.events.nEventFactory;
import com.pcbsys.nirvana.base.events.nExceptionEvent;
import com.pcbsys.nirvana.base.events.nSecurity;
import com.pcbsys.nirvana.base.events.nServerHandshake;
import com.pcbsys.nirvana.base.events.nServerRedirect;
import com.pcbsys.nirvana.base.nConstants;
import com.pcbsys.nirvana.base.nExceptionFactory;
import com.pcbsys.nirvana.base.nRuntime;
import com.pcbsys.nirvana.base.nThreadManager;
import com.pcbsys.nirvana.client.nAbstractChannel;
import com.pcbsys.nirvana.client.nBaseClientException;
import com.pcbsys.nirvana.client.nConnectionQueueListener;
import com.pcbsys.nirvana.client.nDataStream;
import com.pcbsys.nirvana.client.nDataStreamListener;
import com.pcbsys.nirvana.client.nIllegalArgumentException;
import com.pcbsys.nirvana.client.nRealmUnreachableException;
import com.pcbsys.nirvana.client.nReconnectHandler;
import com.pcbsys.nirvana.client.nSecurityException;
import com.pcbsys.nirvana.client.nServerExtensionCallback;
import com.pcbsys.nirvana.client.nSession;
import com.pcbsys.nirvana.client.nSessionNotConnectedException;
import com.pcbsys.nirvana.client.nUnexpectedResponseException;
import java.io.BufferedInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import java.util.StringTokenizer;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.Predicate;

public class ClientConnectionManagerImpl
implements ClientConnectionManager {
    private static final int sMaximumBufferReadSize = 0x100000;
    private final nSession mySession;
    private final SessionAttributes mySessionAttributes;
    private final nMulticastManager myMulticastManager;
    private final nStoreManagerImpl myStoreManager;
    private final nDataGroupManagerImpl myDataGroupManager;
    private final nThreadManager myThreadManager;
    private final nQueueReaderManager myQueueReaderManager;
    private final String myUsername;
    private final ClientEventDispatcher myEventDispatcher;
    private final nEventProcessorImpl myEventProcessor;
    private final Random myRandomGenerator;
    private final String myUniqueClientAllocatedConnectionID;
    private final List<nReconnectHandler> myReconnectHandlers;
    private final fDriverFactory myDriverFactory;
    private final AtomicInteger myTransactionalCounter = new AtomicInteger(0);
    private final nRealmManager myRealmManager;
    private final nExceptionListenerManager myExceptionListenerManager;
    private final nRedirectManager myRedirectionManager;
    private final nChannelIteratorManagerImpl myChannelIteratorManager;
    private final nConnectionStatisticsManager myConnectionStatisticsManager;
    private final nDurableHelper myDurableManagerHelper;
    private final nStoreManagerHelper myStoreManagerHelper;
    private final boolean isLoopConnection;
    private final boolean isAdminApiSession;
    private volatile fConnection myConnection;
    private volatile boolean followTheMasterRedirect;
    private volatile boolean isDisconnected;
    private volatile boolean isClosing;
    private boolean isInitialised;
    private long myInitialConnectionRetryAttempts;
    private int myDelayCounter;
    private long myLastReconnectTime;
    private boolean handshakeRecd;
    private int myServerSetMaxBufferSize;
    private boolean myMaxBufferSizeClientCheck = true;
    private long myServerSessionId;
    private long myServerTransactionTTL;
    private String myRealmName;
    private boolean isMemberOfCluster;
    private String currentMaster;
    private String rnameList;
    private volatile EventProcessingThread myRunLoop;
    private fMultiplexManager myMultiplexManager;
    private nConnectionQueueListener myConnectionQueueListener;

    public ClientConnectionManagerImpl(String string, nSession nSession2, SessionAttributes sessionAttributes, nThreadManager nThreadManager2, nQueueReaderManagerHelper nQueueReaderManagerHelper2, nDataGroupManagerHelper nDataGroupManagerHelper2, nChannelIteratorHelper nChannelIteratorHelper2, nRedirectManagerHelper nRedirectManagerHelper2, nStoreManagerHelper nStoreManagerHelper2, nDurableHelper nDurableHelper2, String string2, String string3, boolean bl) {
        this.mySession = nSession2;
        this.mySessionAttributes = sessionAttributes;
        this.myInitialConnectionRetryAttempts = sessionAttributes.getInitialConnectionRetryCount();
        this.myThreadManager = nThreadManager2;
        this.myUsername = string2;
        this.myDriverFactory = this.myUsername != null ? new fDriverFactory(this.myUsername, string3) : new fDriverFactory();
        this.myDriverFactory.clearAndSetConnectionList(this.mySessionAttributes.getConnectionDetails().get(0));
        this.myRandomGenerator = new Random();
        this.myReconnectHandlers = new ArrayList<nReconnectHandler>();
        this.isLoopConnection = false;
        this.isInitialised = false;
        this.myUniqueClientAllocatedConnectionID = string;
        this.isDisconnected = true;
        this.isClosing = false;
        this.handshakeRecd = false;
        this.myRealmName = "";
        this.rnameList = "";
        this.myServerSetMaxBufferSize = 0x100000;
        this.myDriverFactory.configureSSL(this.mySessionAttributes);
        this.isAdminApiSession = bl;
        this.myEventDispatcher = new ClientEventDispatcher(116, nRuntime.sDevelopersBuild);
        this.myRealmManager = new nRealmManagerImpl();
        this.myExceptionListenerManager = new nExceptionListenerManagerImpl(this.myThreadManager);
        this.myQueueReaderManager = new nQueueReaderManagerImpl(nQueueReaderManagerHelper2);
        this.myStoreManager = new nStoreManagerImpl(this.mySession, this.myThreadManager, this, this.myQueueReaderManager, nStoreManagerHelper2, this.myExceptionListenerManager);
        this.myChannelIteratorManager = new nChannelIteratorManagerImpl(nChannelIteratorHelper2);
        this.myEventProcessor = new nEventProcessorImpl(this, this.myEventDispatcher);
        this.myDataGroupManager = new nDataGroupManagerImpl(this.myEventProcessor, nDataGroupManagerHelper2, this.mySession);
        this.myMulticastManager = nRuntime.sEnableMulticast ? new nMulticastManager(this.myEventProcessor, this.myThreadManager) : new nMulticastManager();
        this.myRedirectionManager = new nRedirectManagerImpl(this.myUsername, nRedirectManagerHelper2);
        this.myConnectionStatisticsManager = new nConnectionStatisticsManagerImpl(this);
        this.myDurableManagerHelper = nDurableHelper2;
        this.myStoreManagerHelper = nStoreManagerHelper2;
    }

    @Override
    public void close() {
        this.isClosing = true;
        this.myEventProcessor.releaseRequests();
        this.myDataGroupManager.close();
        this.myEventDispatcher.close();
        this.clearConnection();
        this.myEventProcessor.close();
        this.closeCurrentRunLoop();
        this.myRedirectionManager.close();
        this.myStoreManager.close();
        this.myMulticastManager.clear();
        this.myChannelIteratorManager.close();
    }

    @Override
    public boolean isPaused() {
        return this.mySession.isPaused();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addReconnectHandler(nReconnectHandler nReconnectHandler2) {
        if (nReconnectHandler2 != null) {
            List<nReconnectHandler> list = this.myReconnectHandlers;
            synchronized (list) {
                this.myReconnectHandlers.add(nReconnectHandler2);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void removeReconnectHandler(nReconnectHandler nReconnectHandler2) {
        if (nReconnectHandler2 != null) {
            List<nReconnectHandler> list = this.myReconnectHandlers;
            synchronized (list) {
                this.myReconnectHandlers.remove(nReconnectHandler2);
            }
        }
    }

    private void handleDisconnect() {
        for (nReconnectHandler nReconnectHandler2 : this.myReconnectHandlers) {
            try {
                nReconnectHandler2.disconnected(this.mySession);
            }
            catch (Throwable throwable) {
                Constants.logger.log(throwable);
            }
        }
    }

    private boolean shouldTryAgain() {
        if (this.isClosing) {
            return false;
        }
        for (nReconnectHandler nReconnectHandler2 : this.myReconnectHandlers) {
            try {
                if (nReconnectHandler2.tryAgain(this.mySession)) continue;
                return false;
            }
            catch (Throwable throwable) {
                Constants.logger.log(throwable);
            }
        }
        return true;
    }

    private void handleReconnected() {
        for (nReconnectHandler nReconnectHandler2 : this.myReconnectHandlers) {
            try {
                nReconnectHandler2.reconnected(this.mySession);
            }
            catch (Throwable throwable) {
                Constants.logger.log(throwable);
            }
        }
    }

    public String getUniqueClientAllocatedID() {
        return this.myUniqueClientAllocatedConnectionID;
    }

    boolean isLoopConnection() {
        return this.isLoopConnection;
    }

    @Override
    public boolean isInitialised() {
        return this.isInitialised;
    }

    @Override
    public boolean isConnected() {
        fConnection fConnection2 = this.myConnection;
        return !this.isClosing && !this.isDisconnected && fConnection2 != null && fConnection2.isAlive();
    }

    public boolean isAlive() {
        fConnection fConnection2 = this.myConnection;
        return !this.isClosing && fConnection2 != null && fConnection2.isAlive();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void processEventFromConnection() {
        fConnection fConnection2 = null;
        try {
            fConnection2 = this.getBaseConnection();
            this.myEventProcessor.processEvent((nEvent)fConnection2.read());
        }
        catch (Exception exception) {
            if (Constants.logger.canLog(fLogLevel.INFO)) {
                Constants.logger.info("Connection closing due to following Exception: " + exception.getMessage() + " - " + this.getLocalPort() + " => " + this.mySessionAttributes);
                Constants.logger.trace(exception);
            }
            ClientConnectionManagerImpl clientConnectionManagerImpl = this;
            synchronized (clientConnectionManagerImpl) {
                if (this.myConnection != null && this.myConnection.equals(fConnection2)) {
                    this.clearConnection();
                    this.myEventProcessor.releaseRequests();
                }
            }
        }
    }

    int getLocalPort() {
        try {
            return this.getBaseConnection().getDriver().getLocalPort();
        }
        catch (nSessionNotConnectedException nSessionNotConnectedException2) {
            return 0;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public nDataStream initialise(nDataStreamListener nDataStreamListener2, EventHandlerInitialiser eventHandlerInitialiser, boolean bl, boolean bl2) throws nRealmUnreachableException, nSessionNotConnectedException, nSecurityException {
        int n = 0;
        this.mySessionAttributes.isDisconnectOnClusterFailure(bl);
        this.mySessionAttributes.isSessionThreadsDaemon(bl2);
        try {
            Exception exception;
            eventHandlerInitialiser.initialiseEventHandlers(this.myEventDispatcher, this);
            this.myDataGroupManager.initialise(this.myThreadManager, nDataStreamListener2, new nMulticastPumpImpl(this.myDataGroupManager, this.myMulticastManager));
            while (true) {
                try {
                    this.followTheMasterRedirect = false;
                    exception = null;
                    this.connect();
                }
                catch (Exception exception2) {
                    exception = exception2;
                    Constants.logger.warn("Failed to connect to Realm on attempt " + ++n + " - " + this.mySessionAttributes, exception2);
                    this.clearConnection();
                    if (this.followTheMasterRedirect) continue;
                    if (this.mySessionAttributes.getInitialConnectionRetryCount() <= 0L) {
                        if (exception2 instanceof nSessionNotConnectedException) {
                            throw (nSessionNotConnectedException)exception2;
                        }
                        if (!(exception2 instanceof nSecurityException) || exception2.getMessage().contains("Disconnected since no cluster has been formed yet")) continue;
                        throw (nSecurityException)exception2;
                    }
                    --this.myInitialConnectionRetryAttempts;
                    if (this.myInitialConnectionRetryAttempts == -1L || this.myInitialConnectionRetryAttempts > 0L || this.followTheMasterRedirect) continue;
                }
                break;
            }
            if (this.isDisconnected) {
                nRealmUnreachableException nRealmUnreachableException2 = new nRealmUnreachableException("Realm was still unreachable after max retry count - " + this.mySessionAttributes.getInitialConnectionRetryCount());
                if (exception != null) {
                    nRealmUnreachableException2.initCause(exception);
                }
                throw nRealmUnreachableException2;
            }
            this.isInitialised = true;
            nDataStream nDataStream2 = this.myDataGroupManager.getSessionDataStream();
            return nDataStream2;
        }
        finally {
            if (!this.isInitialised) {
                this.closeFailedInitialise();
            }
        }
    }

    void closeFailedInitialise() {
        this.closeCurrentRunLoop();
        this.clearConnection();
        this.myEventProcessor.releaseRequests();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void doReconnect() {
        if (this.isClosing) {
            return;
        }
        this.myEventProcessor.releaseRequests();
        this.myMulticastManager.clear();
        this.checkReconnectHandlers();
        if (this.mySessionAttributes.isDisableReconnect()) {
            this.isClosing = true;
            this.clearConnection();
            this.closeCurrentRunLoop();
            return;
        }
        try {
            this.reconnectDelay();
            if (this.isClosing) {
                return;
            }
            if (this.myMultiplexManager != null) {
                Object object = this.myMultiplexManager.myReconnectMutex;
                synchronized (object) {
                    this.connect();
                }
            } else {
                this.connect();
            }
            if (this.myConnectionQueueListener != null) {
                try {
                    this.getBaseConnection().addConnectionQueueListener(new ConnectionQueueListenerWrapper(this.myConnectionQueueListener));
                }
                catch (Exception exception) {
                    Constants.logger.error(exception);
                }
            }
            this.myStoreManager.connectionReconnected();
            this.myChannelIteratorManager.reconnect();
            try {
                this.myDataGroupManager.reconnectDataGroups();
            }
            catch (nSessionNotConnectedException nSessionNotConnectedException2) {
                Constants.logger.error("Failed to reconnect data groups - " + nSessionNotConnectedException2);
                Constants.logger.debug(nSessionNotConnectedException2);
            }
            catch (Exception exception) {
                Constants.logger.error(exception);
            }
            this.handleReconnected();
        }
        catch (Exception exception) {
            Constants.logger.error("Reconnection attempt failed due to " + exception.getMessage());
            this.clearConnection();
        }
    }

    private void checkReconnectHandlers() {
        if (this.isInitialised()) {
            if (!this.isDisconnected) {
                this.isDisconnected = true;
                this.handleDisconnect();
                this.myStoreManager.connectionDisconnected();
            } else {
                this.reconnectTryAgain();
            }
        }
    }

    private void reconnectTryAgain() {
        if (!this.shouldTryAgain()) {
            this.isClosing = true;
        }
        if (this.isClosing) {
            this.clearConnection();
            this.closeCurrentRunLoop();
        }
    }

    private void reconnectDelay() throws InterruptedException {
        long l = 10000L;
        long l2 = 1000L;
        if (this.mySessionAttributes.isReconnectImmediately()) {
            l2 = this.mySessionAttributes.getReconnectInterval();
        } else if (this.myLastReconnectTime != 0L) {
            long l3 = fTimer.getTicks() - this.myLastReconnectTime;
            if (l3 < 60000L) {
                ++this.myDelayCounter;
                if (this.myDelayCounter > 22) {
                    this.myDelayCounter = 22;
                }
                l2 = (long)(this.myDelayCounter * this.myDelayCounter * 1000) + Math.abs(this.myRandomGenerator.nextLong() % l);
            } else {
                this.myDelayCounter = 0;
            }
        }
        l2 += fTimer.getTicks();
        while (fTimer.getTicks() < l2) {
            Thread.sleep(100L);
            if (!this.isClosing) continue;
            break;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void connect() throws nBaseClientException, IOException {
        this.myLastReconnectTime = fTimer.getTicks();
        if (this.isClosing) {
            return;
        }
        Constants.logger.warn("Session " + this.myUniqueClientAllocatedConnectionID + " attempting connection to " + this.myDriverFactory.toString());
        try {
            boolean bl = false;
            Object object = this;
            synchronized (object) {
                if (this.myMultiplexManager != null && this.myMultiplexManager.isConnected()) {
                    this.setBaseConnection(this.setupMultiplexChannel());
                } else {
                    this.setBaseConnection(this.establishConnection());
                    if (this.getBaseConnection() instanceof fLoopConnection) {
                        LoopEventCallback loopEventCallback = new LoopEventCallback(this.myEventProcessor, this.mySession);
                        this.getBaseConnection().registerHandler(loopEventCallback);
                    }
                    bl = this.myMultiplexManager != null;
                }
            }
            object = this;
            synchronized (object) {
                if (this.myRunLoop == null) {
                    this.myRunLoop = new EventProcessingThread(this, this.mySessionAttributes.isSessionThreadsDaemon());
                }
            }
            object = this.myRunLoop;
            synchronized (object) {
                this.myRunLoop.notify();
            }
            this.requestHandshake();
            this.isDisconnected = false;
            if (bl) {
                this.myMultiplexManager.reconnectDriver(this.getBaseConnection());
            }
        }
        catch (nBaseClientException nBaseClientException2) {
            if (!this.followTheMasterRedirect) {
                this.myDriverFactory.incrementConnectionList();
            }
            throw nBaseClientException2;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void closeCurrentRunLoop() {
        ClientConnectionManagerImpl clientConnectionManagerImpl = this;
        synchronized (clientConnectionManagerImpl) {
            if (this.myRunLoop != null) {
                this.myRunLoop.setExit();
                this.myRunLoop = null;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void requestHandshake() throws nBaseClientException {
        nServerHandshake nServerHandshake2;
        this.handshakeRecd = false;
        nServerHandshake nServerHandshake3 = new nServerHandshake(this.myServerSessionId, 0L);
        nServerHandshake3.setSyncMode(true);
        boolean bl = this.mySessionAttributes.isDisconnectOnClusterFailure();
        boolean bl2 = this.mySessionAttributes.isFollowTheMaster();
        if (bl2 && !bl) {
            Constants.logger.warn("Follow The Master is enabled, using value \"true\" for disconnectOnClusterFailure");
        }
        nServerHandshake3.setDisconnectIfClusterFails(bl || bl2);
        nServerHandshake3.setFollowTheMaster(bl2);
        nServerHandshake3.setEnableDataStream(this.myDataGroupManager.hasStreamListener());
        nServerHandshake3.setMulticastSupport(this.myMulticastManager.isEnabled());
        nServerHandshake3.setRequestPriorityConnection(this.mySessionAttributes.isRequestPriorityConnection());
        nServerHandshake3.setRequestUnthrottledConnection(this.mySessionAttributes.isRequestUnthrottledConnection());
        nServerHandshake3.setAdmin(this.isAdminApiSession);
        if (StringUtils.isEmpty(this.mySessionAttributes.getClientAppID())) {
            nServerHandshake3.setRealmName(this.mySessionAttributes.getSessionName());
        } else {
            nServerHandshake3.markClientAppIdSet();
            nServerHandshake3.setRealmName(nConstants.joinClientAppIDAndSessName(this.mySessionAttributes.getClientAppID(), this.mySessionAttributes.getSessionName()));
        }
        if (this.myDataGroupManager.getSessionDataStream() != null) {
            nServerHandshake3.setDataStreamId(this.myDataGroupManager.getSessionDataStream().getName());
        }
        nServerHandshake3.setSendMasterRealm(this.isAdminApiSession || bl2);
        nEvent nEvent2 = this.myEventProcessor.writeEvent(nServerHandshake3);
        if (nEvent2.getId() == 66) {
            nServerHandshake2 = (nServerHandshake)nEvent2;
            if (!nRuntime.acceptClientVersion(nServerHandshake2.getBuildName(), this.isAdminApiSession)) {
                Object object = this;
                synchronized (object) {
                    if (this.getBaseConnection() != null) {
                        this.getBaseConnection().close();
                        this.setBaseConnection(null);
                    }
                }
                object = "Unsupported client version requested. ClientVersion : " + nRuntime.sReleaseDetails + " productVersion : " + nServerHandshake2.getBuildName() + ". " + (this.isAdminApiSession ? "Session requested by Admin Client." : "");
                Constants.logger.warn((String)object);
                throw new nRealmUnreachableException((String)object);
            }
            if (nServerHandshake2.isFollowTheMaster()) {
                this.myEventDispatcher.handleServerOriginatingEvent(new nServerRedirect(nServerHandshake2.getMasterRealm()));
                this.clearConnection();
                this.followTheMasterRedirect = true;
                throw new nSessionNotConnectedException("Being Redirected");
            }
            this.myServerSessionId = nServerHandshake2.getSessionId();
            this.myServerTransactionTTL = nServerHandshake2.getTransactionTTL();
            this.myRealmName = nServerHandshake2.getRealmName();
            this.myServerSetMaxBufferSize = (int)nServerHandshake2.getMaxBufferSize();
            this.getBaseConnection().setBufferSize(this.myServerSetMaxBufferSize);
            this.myMaxBufferSizeClientCheck = nServerHandshake2.getMaxBufferSizeClientCheck();
            this.getBaseConnection().setBufferCompression(nServerHandshake2.isCompressedBuffers());
            this.isMemberOfCluster = nServerHandshake2.isMemberOfCluster();
            if (nServerHandshake2.sendMasterRealm()) {
                this.currentMaster = nServerHandshake2.getMasterRealm();
            }
            String string = nServerHandshake2.getClientHostName();
            String string2 = nServerHandshake2.getClientUser();
            Object[] objectArray = new Object[]{string, string2};
            try {
                this.getBaseConnection().getDriver().updateResource("SERVERIP", objectArray);
            }
            catch (Exception exception) {
                // empty catch block
            }
            if (!this.getBaseConnection().getConnectionDetails().isVirtual()) {
                this.setRNameList(nServerHandshake2.getServerRNames());
            }
        } else {
            if (nEvent2.getId() == 75) {
                nExceptionEvent nExceptionEvent2 = (nExceptionEvent)nEvent2;
                throw nExceptionFactory.getException(nExceptionEvent2.getExceptionId(), nExceptionEvent2.toString());
            }
            if (nEvent2.getId() == 40) {
                if (!nConstants.doReconnectAfterACLRevoked()) {
                    Constants.logger.warn("User=" + this.myUsername + " not authorised on Realm Server, stopping runLoop - " + this.getLocalPort() + " => " + this.mySessionAttributes);
                    this.mySession.close();
                }
                throw new nSecurityException(((nSecurity)nEvent2).getMessage());
            }
            this.myEventDispatcher.handleServerOriginatingEvent(nServerHandshake3);
            throw new nUnexpectedResponseException("Unexpected response to handshake request, " + nEvent2.getClass().toString());
        }
        this.myDataGroupManager.initialiseDataStream(nServerHandshake2.getDataStreamId(), this.getBaseConnection().getSubject().toString());
        this.handshakeRecd = true;
        Constants.logger.warn("Session " + this.myUniqueClientAllocatedConnectionID + " has been established with Session ID: " + Long.toHexString(this.myServerSessionId) + " Local Socket: " + this.getBaseConnection().getDriver().getLocalId() + " Remote Socket: " + this.getBaseConnection().getDriver().getId());
        Constants.logger.error("Session " + this.myUniqueClientAllocatedConnectionID + " has connected to realm with name: " + this.myRealmName);
    }

    private void setRNameList(String string) throws nSessionNotConnectedException {
        if (string.trim().length() > 0) {
            StringTokenizer stringTokenizer = new StringTokenizer(string, ",");
            String string2 = this.getBaseConnection().getConnectionDetails().getHost();
            StringBuilder stringBuilder = new StringBuilder();
            boolean bl = true;
            while (stringTokenizer.hasMoreElements()) {
                String string3 = stringTokenizer.nextElement().toString();
                try {
                    fConnectionDetails fConnectionDetails2 = new fConnectionDetails(string3);
                    if (string2 != "" && fConnectionDetails2.getHost().equalsIgnoreCase("0.0.0.0")) {
                        fConnectionDetails2 = new fConnectionDetails(fConnectionDetails2.getType(), string2, fConnectionDetails2.getPort(), fConnectionDetails2.getFile());
                    }
                    stringBuilder.append(fConnectionDetails2.toString());
                    if (bl) {
                        bl = false;
                        continue;
                    }
                    stringBuilder.append(",");
                }
                catch (Exception exception) {}
            }
            this.rnameList = stringBuilder.toString();
        }
    }

    private fConnection setupMultiplexChannel() throws IOException {
        fMultiplexDriver fMultiplexDriver2 = this.myMultiplexManager.create(this.myUsername);
        fEventInputStream fEventInputStream2 = fSystemConfiguration.isAnApplet() ? fStreamFactory.createInputStream(((fDriver)fMultiplexDriver2).getInputStream(), (fBaseEventFactory)nEventFactory.getDefault(), this.myServerSetMaxBufferSize) : fStreamFactory.createInputStream((InputStream)new BufferedInputStream(((fDriver)fMultiplexDriver2).getInputStream()), (fBaseEventFactory)nEventFactory.getDefault(), this.myServerSetMaxBufferSize);
        fEventOutputStream fEventOutputStream2 = new fEventOutputStream(((fDriver)fMultiplexDriver2).getOutputStream(), nEventFactory.getDefault());
        fEventOutputStream2.writeByte((byte)17);
        return new fConnection(fMultiplexDriver2, fEventOutputStream2, fEventInputStream2, nEventFactory.getDefault(), false);
    }

    private fConnection establishConnection() throws nRealmUnreachableException, nSecurityException {
        try {
            return fConnection.createConnection(this.myDriverFactory, nEventFactory.getDefault(), this.myServerSetMaxBufferSize, false, 17);
        }
        catch (fAuthenticationException fAuthenticationException2) {
            nSecurityException nSecurityException2 = new nSecurityException(fAuthenticationException2.getMessage());
            nSecurityException2.initCause(fAuthenticationException2);
            throw nSecurityException2;
        }
        catch (Exception exception) {
            nRealmUnreachableException nRealmUnreachableException2 = new nRealmUnreachableException(exception.getMessage());
            if (exception.getCause() != null) {
                nRealmUnreachableException2.initCause(exception);
            }
            throw nRealmUnreachableException2;
        }
    }

    synchronized void clearConnection() {
        try {
            if (this.myConnection != null) {
                Constants.logger.warn("Session " + this.myUniqueClientAllocatedConnectionID + " has been disconnected with Session ID: " + Long.toHexString(this.myServerSessionId) + " Local Socket: " + this.myConnection.getDriver().getLocalId() + " Remote Socket: " + this.myConnection.getDriver().getId());
                if (!this.myRealmName.isEmpty()) {
                    Constants.logger.error("Session " + this.myUniqueClientAllocatedConnectionID + " has disconnected from realm with name: " + this.myRealmName);
                }
                this.myRealmName = "";
                this.myConnection.close();
            }
        }
        catch (Exception exception) {
            Constants.logger.trace("Session " + this.myUniqueClientAllocatedConnectionID + " during closing socket raised exception " + exception.getMessage());
        }
        finally {
            this.myConnection = null;
        }
    }

    @Override
    public boolean isMaxBufferSizeClientCheck() {
        return this.myMaxBufferSizeClientCheck;
    }

    @Override
    public int getServerProvidedMaxBufferSize() {
        return this.myServerSetMaxBufferSize;
    }

    @Override
    public void configureMultiplexManager(ClientConnectionManager clientConnectionManager) {
        ClientConnectionManagerImpl clientConnectionManagerImpl = (ClientConnectionManagerImpl)clientConnectionManager;
        try {
            if (clientConnectionManagerImpl.myMultiplexManager == null) {
                clientConnectionManagerImpl.getBaseConnection().initialiseMultipexedDriver(null);
                clientConnectionManagerImpl.myMultiplexManager = ((fMultiplexDriver)clientConnectionManagerImpl.getBaseConnection().getDriver()).getManager();
            }
            this.myMultiplexManager = clientConnectionManagerImpl.myMultiplexManager;
        }
        catch (Exception exception) {
            Constants.logger.warn(exception);
        }
    }

    public fConnection getConnection() {
        return this.myConnection;
    }

    public fDriverFactory getDriverFactory() {
        return this.myDriverFactory;
    }

    @Override
    public void updateConnectionListWithServerList() throws IOException, nIllegalArgumentException {
        this.myDriverFactory.clearAndSetConnectionList(UrlProcessor.createConnectionList(UrlProcessor.processURL(this.rnameList).get(0)));
    }

    public void updateConnectionListWithServerList(List<fConnectionDetails> list) {
        this.myDriverFactory.clearAndSetConnectionList(list);
    }

    @Override
    public void setPrincipals(String[] stringArray) {
        this.myDriverFactory.setPrincipals(stringArray);
    }

    boolean awaitingServerHandshake() {
        return !this.handshakeRecd;
    }

    @Override
    public long getServerProvidedSessionID() {
        return this.myServerSessionId;
    }

    @Override
    public fSubject getSubjectFromConnection() throws nSessionNotConnectedException {
        return this.getBaseConnection().getSubject();
    }

    @Override
    public long getServerProvidedTransactionTTL() {
        return this.myServerTransactionTTL;
    }

    @Override
    public String getServerProvidedRealmName() throws nSessionNotConnectedException {
        if (this.isConnected()) {
            return this.myRealmName;
        }
        throw new nSessionNotConnectedException("The session is not currently connected");
    }

    @Override
    public boolean isMemberOfCluster() {
        return this.isMemberOfCluster;
    }

    public String getCurrentMaster() {
        return this.currentMaster;
    }

    @Override
    public String getServerProvidedURLList() {
        return this.rnameList;
    }

    @Override
    public void releaseRequests() {
        Predicate<nEvent> predicate = nEvent2 -> !Constants.isEventAllowedOnSessionPause(nEvent2);
        this.myEventProcessor.releaseRequests(predicate);
    }

    @Override
    public void unblockThread(String string) {
        this.myEventProcessor.unblockThread(string);
    }

    @Override
    public void setHTTPURLParameters(String string) {
        fURLDriver.setHTTPURLParameter(string);
    }

    public long getOutputByteCount() throws nSessionNotConnectedException {
        return this.getBaseConnection().getOutputByteCount();
    }

    public long getInputByteCount() throws nSessionNotConnectedException {
        return this.getBaseConnection().getInputByteCount();
    }

    public long getQueueSize() throws nSessionNotConnectedException {
        return this.getBaseConnection().getQueueSize();
    }

    public long getEventTxCount() throws nSessionNotConnectedException {
        return this.getBaseConnection().getEventTxCount();
    }

    public long getEventRxCount() throws nSessionNotConnectedException {
        return this.getBaseConnection().getEventRxCount();
    }

    int getCurrentResponseTime() throws nSessionNotConnectedException {
        return this.getBaseConnection().getCurrentResponseTime();
    }

    @Override
    public boolean isVirtual() throws nSessionNotConnectedException {
        return this.getBaseConnection().getConnectionDetails().isVirtual();
    }

    @Override
    public String getLocalHostAndPort() throws nSessionNotConnectedException {
        String string = "";
        fConnection fConnection2 = this.getBaseConnection();
        if (fConnection2.getLocalID() != null) {
            if (fConnection2.getLocalID().equals("Not Connected")) {
                fConnectionDetails fConnectionDetails2 = fConnection2.getConnectionDetails();
                string = fConnectionDetails.getProtocolString(fConnectionDetails2.getType()) + "://" + fConnectionDetails2.getHost() + ":" + fConnectionDetails2.getPort();
            } else {
                string = fConnection2.getLocalID();
            }
        }
        return string;
    }

    @Override
    public nDurableHelper getDurableManagerHelper() {
        return this.myDurableManagerHelper;
    }

    public nStoreManagerHelper getStoreManagerHelper() {
        return this.myStoreManagerHelper;
    }

    @Override
    public String getThirdPartyCookies() throws nSessionNotConnectedException {
        fDriver fDriver2 = this.getBaseConnection().getDriver();
        if (fDriver2 instanceof fURLDriver) {
            return ((fURLDriver)fDriver2).get3rdPartyCookies();
        }
        return "";
    }

    @Override
    public String getRemoteUrl() throws nSessionNotConnectedException {
        fDriver fDriver2 = this.getBaseConnection().getDriver();
        return fDriver2.getType() + "://" + fDriver2.getId();
    }

    void addInternalConnectionQueueConnectionListener(nConnectionQueueListener nConnectionQueueListener2) throws nIllegalArgumentException {
        fConnection fConnection2 = this.getConnection();
        if (fConnection2 != null && fConnection2.getConnectionQueueListener() != null) {
            throw new nIllegalArgumentException("You have already registered a connection listener");
        }
        this.myConnectionQueueListener = nConnectionQueueListener2;
        if (fConnection2 != null) {
            fConnection2.addConnectionQueueListener(new ConnectionQueueListenerWrapper(nConnectionQueueListener2));
        }
    }

    void removeInternalConnectionQueueListener(nConnectionQueueListener nConnectionQueueListener2) throws nIllegalArgumentException {
        if (this.myConnectionQueueListener != null && !this.myConnectionQueueListener.equals(nConnectionQueueListener2)) {
            throw new nIllegalArgumentException("Listener not registered");
        }
        this.myConnectionQueueListener = null;
        fConnection fConnection2 = this.getConnection();
        if (fConnection2 != null) {
            fConnection2.removeConnectionQueueListener();
        }
    }

    @Override
    public long allocateTransactionID(nAbstractChannel nAbstractChannel2) {
        return this.myServerSessionId + (long)this.myTransactionalCounter.getAndIncrement();
    }

    @Override
    public String getClientAllocatedSessionID() {
        return this.myUniqueClientAllocatedConnectionID;
    }

    @Override
    public String getSessionInfo() {
        String string = "{localURL=";
        try {
            string = string + this.getLocalHostAndPort();
        }
        catch (nSessionNotConnectedException nSessionNotConnectedException2) {
            string = string + "NOT CONNECTED";
        }
        string = string + ", remoteURL=" + this.getSessionAttributesList().get(0) + ", serverProvidedSID=" + Long.toHexString(this.getServerProvidedSessionID()) + ", clientAllocatedSID=" + this.getUniqueClientAllocatedID() + "}";
        return string;
    }

    @Override
    public void resetConnection() {
        this.clearConnection();
    }

    public void setKeepAliveTimeOnCurrentConnection(long l) {
        fConnection fConnection2 = this.getConnection();
        if (fConnection2 != null && fConnection2.isAlive()) {
            fConnection2.setCurrentKeepAliveTime(l);
        }
    }

    @Override
    public nEventProcessor getEventProcessor() {
        return this.myEventProcessor;
    }

    @Override
    public nExceptionListenerManager getExceptionListenerManager() {
        return this.myExceptionListenerManager;
    }

    @Override
    public nStoreManagerImpl getStoreManager() {
        return this.myStoreManager;
    }

    @Override
    public nDataGroupManagerImpl getDataGroupManager() {
        return this.myDataGroupManager;
    }

    @Override
    public nRealmManager getRealmManager() {
        return this.myRealmManager;
    }

    @Override
    public nRedirectManager getRedirectManager() {
        return this.myRedirectionManager;
    }

    @Override
    public nChannelIteratorManager getChannelIteratorManager() {
        return this.myChannelIteratorManager;
    }

    @Override
    public nConnectionStatisticsManager getConnectionStatisticsManager() {
        return this.myConnectionStatisticsManager;
    }

    @Override
    public void registerExtensionCallback(nServerExtensionCallback nServerExtensionCallback2) {
        if (nServerExtensionCallback2 == null) {
            new NoOperationHandler(88, this.myEventDispatcher, nRuntime.sDevelopersBuild);
        } else {
            new nServerExtensionHandler(this.myEventDispatcher, nServerExtensionCallback2);
        }
    }

    public nMulticastManager getMulticastManager() {
        return this.myMulticastManager;
    }

    public nQueueReaderManager getQueueReaderManager() {
        return this.myQueueReaderManager;
    }

    public SessionAttributes getAttributes() {
        return this.mySessionAttributes;
    }

    @Override
    public List<fConnectionDetails> getSessionAttributesList() {
        ArrayList<fConnectionDetails> arrayList = new ArrayList<fConnectionDetails>();
        for (List<fConnectionDetails> list : this.mySessionAttributes.getConnectionDetails()) {
            arrayList.addAll(list);
        }
        return arrayList;
    }

    fConnection getBaseConnection() throws nSessionNotConnectedException {
        fConnection fConnection2 = this.myConnection;
        if (fConnection2 == null || !fConnection2.isAlive()) {
            throw new nSessionNotConnectedException();
        }
        return fConnection2;
    }

    private void setBaseConnection(fConnection fConnection2) {
        this.myConnection = fConnection2;
    }

    boolean isClosing() {
        return this.isClosing;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void validateRunThreadIsSafe() {
        if (this.myRunLoop != null && this.myRunLoop.isCurrentThread(Thread.currentThread())) {
            this.closeCurrentRunLoop();
            this.myThreadManager.enableThreading();
            ClientConnectionManagerImpl clientConnectionManagerImpl = this;
            synchronized (clientConnectionManagerImpl) {
                this.myRunLoop = new EventProcessingThread(this, this.mySessionAttributes.isSessionThreadsDaemon());
            }
        }
    }

    boolean isDisconnected() {
        return this.isDisconnected;
    }
}

