/*
 * Decompiled with CFR 0.152.
 */
package com.pcbsys.nirvana.base.clientimpl.singleconnection;

import com.pcbsys.foundation.utils.fSystemConfiguration;
import com.pcbsys.nirvana.base.clientimpl.singleconnection.ClientConnectionManagerImpl;
import com.pcbsys.nirvana.base.nConstants;

class EventProcessingThread
implements Runnable {
    private final ClientConnectionManagerImpl myConnectionManager;
    private final Thread myThread;
    private volatile boolean exit = false;

    EventProcessingThread(ClientConnectionManagerImpl clientConnectionManagerImpl, boolean bl) {
        this.myConnectionManager = clientConnectionManagerImpl;
        if (!this.myConnectionManager.isLoopConnection()) {
            this.myThread = new Thread(this);
            this.setThreadNamed(" Active");
            String string = fSystemConfiguration.getProperty("com.softwareag.um.client.connection.reader.daemon");
            if (string != null) {
                this.myThread.setDaemon(string.equalsIgnoreCase("true"));
            } else {
                this.myThread.setDaemon(bl);
            }
            this.myThread.start();
        } else {
            this.myThread = null;
        }
    }

    private void setThreadNamed(String string) {
        this.myThread.setName("UM-Connection-Reader:" + this.myConnectionManager.getUniqueClientAllocatedID() + string);
    }

    @Override
    public void run() {
        nConstants.logger.info("Event processing thread named \"" + this.myThread.getName() + "\" started");
        while (!this.mustExit()) {
            try {
                if (this.myConnectionManager.isPaused()) {
                    try {
                        Thread.sleep(500L);
                    }
                    catch (InterruptedException interruptedException) {}
                    continue;
                }
                if (this.myConnectionManager.isAlive()) {
                    this.myConnectionManager.processEventFromConnection();
                    continue;
                }
                if (this.myConnectionManager.isInitialised()) {
                    this.myConnectionManager.doReconnect();
                    continue;
                }
                try {
                    Thread.sleep(100L);
                }
                catch (InterruptedException interruptedException) {}
            }
            catch (Error error) {
                nConstants.logger.error("Session closing due to following Error: " + error.toString() + " - " + this.myConnectionManager.getLocalPort() + " => " + this.myConnectionManager.getAttributes().toString());
                nConstants.logger.error(error);
                this.myConnectionManager.closeFailedInitialise();
                break;
            }
        }
        nConstants.logger.info("Event processing thread named \"" + this.myThread.getName() + "\" finished");
    }

    private boolean mustExit() {
        return this.exit;
    }

    void setExit() {
        if (!this.exit) {
            String string = this.myThread.getName();
            this.setThreadNamed(" Completed");
            nConstants.logger.info("Event processing thread renamed from \"" + string + "\" to " + this.myThread.getName());
            this.exit = true;
            this.myThread.interrupt();
        }
    }

    boolean isCurrentThread(Thread thread) {
        return this.myThread == thread;
    }
}

