/*
 * Decompiled with CFR 0.152.
 */
package com.pcbsys.nirvana.base.clientimpl.singleconnection;

import com.pcbsys.nirvana.base.clientimpl.nDataGroupManagerHelper;
import com.pcbsys.nirvana.base.clientimpl.singleconnection.Constants;
import com.pcbsys.nirvana.client.nDataGroup;
import com.pcbsys.nirvana.client.nDataGroupDeletedException;
import com.pcbsys.nirvana.client.nDataGroupListener;
import com.pcbsys.nirvana.client.nDataStream;
import java.util.Iterator;

class ParentDataGroupNotifier {
    private static final Notifier DATA_STREAM_DELETED_NOTIFIER = new Notifier(){

        @Override
        void notifyParent(nDataGroupListener nDataGroupListener2, nDataGroup nDataGroup2, nDataStream nDataStream2, boolean bl) throws nDataGroupDeletedException {
            nDataGroupListener2.deletedStream(nDataGroup2, nDataStream2, nDataGroup2.size(), bl);
        }
    };
    private static final Notifier DATA_STREAM_ADDED_NOTIFIER = new Notifier(){

        @Override
        void notifyParent(nDataGroupListener nDataGroupListener2, nDataGroup nDataGroup2, nDataStream nDataStream2, boolean bl) throws nDataGroupDeletedException {
            nDataGroupListener2.addedStream(nDataGroup2, nDataStream2, nDataGroup2.size());
        }
    };

    ParentDataGroupNotifier() {
    }

    private static void notifyParents(Iterator<nDataGroup> iterator, nDataGroup nDataGroup2, Notifier notifier, nDataStream nDataStream2, boolean bl, nDataGroupManagerHelper nDataGroupManagerHelper2) {
        while (iterator.hasNext()) {
            nDataGroup nDataGroup3 = iterator.next();
            if (nDataGroup3.getName().equals(nDataGroup2.getName())) continue;
            try {
                nDataGroupListener nDataGroupListener2;
                if (!ParentDataGroupNotifier.shouldNotify(nDataGroup3, nDataGroup2) || (nDataGroupListener2 = nDataGroupManagerHelper2.getListener(nDataGroup3)) == null) continue;
                notifier.notifyParent(nDataGroupListener2, nDataGroup3, nDataStream2, bl);
            }
            catch (nDataGroupDeletedException nDataGroupDeletedException2) {
                Constants.logger.warn(nDataGroupDeletedException2);
            }
        }
    }

    static void notifyStreamAdded(Iterator<nDataGroup> iterator, nDataGroup nDataGroup2, nDataStream nDataStream2, boolean bl, nDataGroupManagerHelper nDataGroupManagerHelper2) {
        ParentDataGroupNotifier.notifyParents(iterator, nDataGroup2, DATA_STREAM_ADDED_NOTIFIER, nDataStream2, bl, nDataGroupManagerHelper2);
    }

    static void notifyStreamDeleted(Iterator<nDataGroup> iterator, nDataGroup nDataGroup2, nDataStream nDataStream2, boolean bl, nDataGroupManagerHelper nDataGroupManagerHelper2) {
        ParentDataGroupNotifier.notifyParents(iterator, nDataGroup2, DATA_STREAM_DELETED_NOTIFIER, nDataStream2, bl, nDataGroupManagerHelper2);
    }

    private static boolean shouldNotify(nDataGroup nDataGroup2, nDataGroup nDataGroup3) throws nDataGroupDeletedException {
        if (nDataGroup2.contains(nDataGroup3)) {
            return true;
        }
        Iterator<nDataGroup> iterator = nDataGroup2.getGroups();
        boolean bl = false;
        while (iterator.hasNext()) {
            bl = bl || ParentDataGroupNotifier.shouldNotify(iterator.next(), nDataGroup3);
        }
        return bl;
    }

    private static abstract class Notifier {
        private Notifier() {
        }

        abstract void notifyParent(nDataGroupListener var1, nDataGroup var2, nDataStream var3, boolean var4) throws nDataGroupDeletedException;
    }
}

