/*
 * Decompiled with CFR 0.152.
 */
package com.pcbsys.nirvana.base.clientimpl.singleconnection.eventhandlers;

import com.pcbsys.nirvana.base.clientimpl.singleconnection.eventhandlers.ClientEventHandler;
import com.pcbsys.nirvana.base.clientimpl.singleconnection.eventhandlers.NoOperationHandler;
import com.pcbsys.nirvana.base.events.nEvent;

public class ClientEventDispatcher {
    private final ClientEventHandler[] myEventHandlers;
    private boolean isClosed = false;

    public ClientEventDispatcher(int n, boolean bl) {
        this.myEventHandlers = new ClientEventHandler[n];
        for (int i = 0; i < n; ++i) {
            this.myEventHandlers[i] = new NoOperationHandler(i, this, bl);
        }
    }

    void registerHandler(int n, ClientEventHandler clientEventHandler) {
        if (clientEventHandler == null) {
            throw new IllegalStateException("Cannot pass a null client event handler");
        }
        clientEventHandler.setOriginalHandler(this.myEventHandlers[n]);
        this.myEventHandlers[n] = clientEventHandler;
    }

    public void close() {
        this.isClosed = true;
        for (int i = 0; i < this.myEventHandlers.length; ++i) {
            this.myEventHandlers[i] = null;
        }
    }

    public void handleServerOriginatingEvent(nEvent nEvent2) {
        if (!this.isClosed && nEvent2 != null && nEvent2.getId() != 150) {
            this.myEventHandlers[nEvent2.getId()].handleServerOriginatingEvent(nEvent2);
        }
    }

    public void handleClientResponseEvent(nEvent nEvent2, nEvent nEvent3) {
        if (!this.isClosed) {
            this.myEventHandlers[nEvent3.getId()].handleClientResponseEvent(nEvent2, nEvent3);
        }
    }
}

