/*
 * Decompiled with CFR 0.152.
 */
package com.pcbsys.nirvana.base.clientimpl.singleconnection;

import com.pcbsys.nirvana.base.clientimpl.nDataGroupManager;
import com.pcbsys.nirvana.base.clientimpl.nDataGroupManagerHelper;
import com.pcbsys.nirvana.base.clientimpl.nEventProcessor;
import com.pcbsys.nirvana.base.clientimpl.singleconnection.ParentDataGroupNotifier;
import com.pcbsys.nirvana.base.clientimpl.singleconnection.nMulticastPumpImpl;
import com.pcbsys.nirvana.base.events.nDataGroupAdmin;
import com.pcbsys.nirvana.base.events.nEvent;
import com.pcbsys.nirvana.base.events.nPublished;
import com.pcbsys.nirvana.base.events.nStreamStatusUpdate;
import com.pcbsys.nirvana.base.nConstants;
import com.pcbsys.nirvana.base.nDataGroup;
import com.pcbsys.nirvana.base.nDataGroupEventPump;
import com.pcbsys.nirvana.base.nDataStream;
import com.pcbsys.nirvana.base.nExceptionEventProcessor;
import com.pcbsys.nirvana.base.nThreadManager;
import com.pcbsys.nirvana.client.nConflationAttributes;
import com.pcbsys.nirvana.client.nDataGroupDeletedException;
import com.pcbsys.nirvana.client.nDataGroupListener;
import com.pcbsys.nirvana.client.nDataStreamListener;
import com.pcbsys.nirvana.client.nIllegalArgumentException;
import com.pcbsys.nirvana.client.nRequestTimedOutException;
import com.pcbsys.nirvana.client.nSecurityException;
import com.pcbsys.nirvana.client.nSession;
import com.pcbsys.nirvana.client.nSessionNotConnectedException;
import com.pcbsys.nirvana.client.nSessionPausedException;
import com.pcbsys.nirvana.client.nUnexpectedResponseException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;

public class nDataGroupManagerImpl
implements nDataGroupManager {
    private final nEventProcessor myEventProcessor;
    private final nSession mySession;
    private final nDataGroupManagerHelper myDataGroupManagerHelper;
    private final LinkedHashMap<Long, com.pcbsys.nirvana.client.nDataGroup> myKnownDeletedDataGroups = new LinkedHashMap();
    private final LinkedHashMap<Long, com.pcbsys.nirvana.client.nDataGroup> myKnownDataGroups;
    private final LinkedHashMap<Long, com.pcbsys.nirvana.client.nDataGroup> myRecoveringDataGroups = new LinkedHashMap();
    private final LinkedHashMap<Long, String> myGroupMapping;
    private final StreamUpdateHandler[] myUpdateHandlers;
    private com.pcbsys.nirvana.client.nDataStream myDataStream;
    private nDataGroupEventPump myDataGroupPump;
    private com.pcbsys.nirvana.client.nDataGroup myGlobal;
    private nDataGroupListener myGroupListener;
    private nDataStreamListener myStreamListener;
    private nMulticastPumpImpl myMulticastCallback;
    private boolean hasStreamListener;
    private volatile boolean isClosed;

    nDataGroupManagerImpl(nEventProcessor nEventProcessor2, nDataGroupManagerHelper nDataGroupManagerHelper2, nSession nSession2) {
        this.myKnownDataGroups = new LinkedHashMap();
        this.myGroupMapping = new LinkedHashMap();
        this.myDataGroupManagerHelper = nDataGroupManagerHelper2;
        this.myEventProcessor = nEventProcessor2;
        this.mySession = nSession2;
        this.hasStreamListener = false;
        this.myGroupMapping.put(0L, "global");
        this.isClosed = false;
        this.myUpdateHandlers = new StreamUpdateHandler[31];
        for (int i = 0; i < 31; ++i) {
            this.myUpdateHandlers[i] = null;
        }
        this.myUpdateHandlers[30] = new GroupMappingHandler();
        this.myUpdateHandlers[12] = new GroupRemovedHandler();
        this.myUpdateHandlers[14] = new GroupInsertedHandler();
        this.myUpdateHandlers[11] = new GroupAddedHandler();
        this.myUpdateHandlers[13] = new GroupRemovedHandler();
        this.myUpdateHandlers[12] = new GroupDeletedHandler();
        this.myUpdateHandlers[1] = new StreamAddedHandler();
        this.myUpdateHandlers[2] = new StreamDeletedHandler();
        this.myUpdateHandlers[3] = new SnoopStreamAddedHandler();
        this.myUpdateHandlers[4] = new SnoopStreamDeletedHandler();
    }

    public void initialise(nThreadManager nThreadManager2, nDataStreamListener nDataStreamListener2, nMulticastPumpImpl nMulticastPumpImpl2) {
        this.hasStreamListener = nDataStreamListener2 != null;
        this.myStreamListener = nDataStreamListener2;
        this.myDataGroupPump = new nDataGroupEventPump(nThreadManager2, nMulticastPumpImpl2);
        this.myMulticastCallback = nMulticastPumpImpl2;
    }

    void initialiseDataStream(String string, String string2) {
        this.myDataStream = this.myDataGroupManagerHelper.createStream(string, string2);
    }

    public synchronized void close() {
        this.isClosed = true;
        if (this.myDataGroupPump != null) {
            this.myDataGroupPump.close();
        }
        this.myKnownDataGroups.clear();
        this.myRecoveringDataGroups.clear();
        this.myGroupMapping.clear();
        this.myKnownDeletedDataGroups.clear();
    }

    public void processEvent(nEvent nEvent2) {
        if (this.isClosed) {
            return;
        }
        this.myDataGroupPump.pushEvent(nEvent2);
    }

    void sendEventToListener(nPublished nPublished2) {
        if (!this.isClosed) {
            this.myDataGroupManagerHelper.deliverEvent(nPublished2, this.get(nPublished2.getChannelAttributesId()), this.myStreamListener);
        }
    }

    @Override
    public void pauseStream() {
        if (this.isClosed) {
            return;
        }
        if (!this.myDataGroupPump.isPaused()) {
            this.myDataGroupPump.pause();
        }
    }

    @Override
    public void resumeStream() {
        if (this.isClosed) {
            return;
        }
        if (this.myDataGroupPump.isPaused()) {
            this.myDataGroupPump.resume();
        }
    }

    void dataGroupStructureUpdate(nStreamStatusUpdate nStreamStatusUpdate2) {
        StreamUpdateHandler streamUpdateHandler;
        boolean bl = false;
        if (nStreamStatusUpdate2.getAction() >= 0 && nStreamStatusUpdate2.getAction() < this.myUpdateHandlers.length && (streamUpdateHandler = this.myUpdateHandlers[nStreamStatusUpdate2.getAction()]) != null) {
            bl = true;
            streamUpdateHandler.handleUpdate(nStreamStatusUpdate2);
        }
        if (!bl) {
            nConstants.logger.warn("Stream Status Update received but no handler available to handle update");
        }
    }

    public synchronized String get(long l) {
        return this.myGroupMapping.get(l);
    }

    @Override
    public synchronized com.pcbsys.nirvana.client.nDataGroup getKnownDataGroup(long l) {
        return this.myKnownDataGroups.get(l);
    }

    @Override
    public synchronized int getKnownGroupCount() {
        return this.myKnownDataGroups.size();
    }

    @Override
    public synchronized com.pcbsys.nirvana.client.nDataGroup[] getGroupsContaining(com.pcbsys.nirvana.client.nDataGroup nDataGroup2) {
        LinkedList<com.pcbsys.nirvana.client.nDataGroup> linkedList = new LinkedList<com.pcbsys.nirvana.client.nDataGroup>();
        Iterator<com.pcbsys.nirvana.client.nDataGroup> iterator = this.myKnownDataGroups.values().iterator();
        this.addAnyGroupContainingGroup(nDataGroup2, linkedList, iterator);
        com.pcbsys.nirvana.client.nDataGroup[] nDataGroupArray = new com.pcbsys.nirvana.client.nDataGroup[linkedList.size()];
        return linkedList.toArray(nDataGroupArray);
    }

    public nMulticastPumpImpl getMulticastCallback() {
        return this.myMulticastCallback;
    }

    @Override
    public nDataGroupListener getGroupListener() {
        return this.myGroupListener;
    }

    @Override
    public com.pcbsys.nirvana.client.nDataStream getSessionDataStream() {
        return this.myDataStream;
    }

    @Override
    public nSession getSession() {
        return this.mySession;
    }

    boolean hasStreamListener() {
        return this.hasStreamListener;
    }

    @Override
    public synchronized void putKnownDataGroup(long l, com.pcbsys.nirvana.client.nDataGroup nDataGroup2) {
        this.myKnownDataGroups.put(l, nDataGroup2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void deleteDataGroup(String[] stringArray) throws nIllegalArgumentException, nRequestTimedOutException, nSessionPausedException, nSessionNotConnectedException, nSecurityException, nUnexpectedResponseException {
        nDataGroupManagerImpl nDataGroupManagerImpl2 = this;
        synchronized (nDataGroupManagerImpl2) {
            ArrayList<com.pcbsys.nirvana.client.nDataGroup> arrayList = new ArrayList<com.pcbsys.nirvana.client.nDataGroup>();
            for (String string : stringArray) {
                if (string == null || string.length() == 0) {
                    throw new nIllegalArgumentException("Please supply valid Data Group Names");
                }
                com.pcbsys.nirvana.client.nDataGroup nDataGroup2 = this.getDataGroup(string);
                if (nDataGroup2 == null) continue;
                arrayList.add(nDataGroup2);
            }
            if (arrayList.size() > 0) {
                Object[] objectArray = new com.pcbsys.nirvana.client.nDataGroup[arrayList.size()];
                arrayList.toArray(objectArray);
                this.deleteDataGroup((com.pcbsys.nirvana.client.nDataGroup[])objectArray);
            }
        }
    }

    @Override
    public void deleteDataGroup(String string) throws nIllegalArgumentException, nRequestTimedOutException, nSessionPausedException, nSessionNotConnectedException, nSecurityException, nUnexpectedResponseException {
        if (string == null || string.length() == 0) {
            throw new nIllegalArgumentException("Please supply a valid Data Group Name");
        }
        com.pcbsys.nirvana.client.nDataGroup nDataGroup2 = this.getDataGroup(string);
        if (nDataGroup2 != null) {
            this.deleteDataGroup(nDataGroup2);
        }
    }

    private void addAnyGroupContainingGroup(com.pcbsys.nirvana.client.nDataGroup nDataGroup2, List<com.pcbsys.nirvana.client.nDataGroup> list, Iterator<com.pcbsys.nirvana.client.nDataGroup> iterator) {
        while (iterator.hasNext()) {
            com.pcbsys.nirvana.client.nDataGroup nDataGroup3 = iterator.next();
            try {
                if (!nDataGroup3.contains(nDataGroup2)) continue;
                list.add(nDataGroup3);
            }
            catch (nDataGroupDeletedException nDataGroupDeletedException2) {}
        }
    }

    private synchronized com.pcbsys.nirvana.client.nDataGroup getDataGroup(String string) throws nRequestTimedOutException, nSessionPausedException, nSessionNotConnectedException, nSecurityException, nUnexpectedResponseException {
        com.pcbsys.nirvana.client.nDataGroup nDataGroup2 = null;
        com.pcbsys.nirvana.client.nDataGroup[] nDataGroupArray = this.myKnownDataGroups.values().iterator();
        while (nDataGroupArray.hasNext()) {
            com.pcbsys.nirvana.client.nDataGroup nDataGroup3 = nDataGroupArray.next();
            if (!nDataGroup3.getName().equals(string)) continue;
            nDataGroup2 = nDataGroup3;
            break;
        }
        if (nDataGroup2 == null && (nDataGroupArray = this.getDataGroups(string, null)) != null) {
            for (int i = 0; i != nDataGroupArray.length; ++i) {
                if (!nDataGroupArray[i].getName().equals(string)) continue;
                nDataGroup2 = nDataGroupArray[i];
                break;
            }
        }
        return nDataGroup2;
    }

    private synchronized com.pcbsys.nirvana.client.nDataGroup findGroup(String string) {
        com.pcbsys.nirvana.client.nDataGroup nDataGroup2 = null;
        for (com.pcbsys.nirvana.client.nDataGroup nDataGroup3 : this.myKnownDataGroups.values()) {
            if (!nDataGroup3.getName().equals(string)) continue;
            nDataGroup2 = nDataGroup3;
            break;
        }
        return nDataGroup2;
    }

    public synchronized void handleServerReconnectDataGroup(nDataGroupAdmin nDataGroupAdmin2) {
        try {
            Object object;
            if (nDataGroupAdmin2.getGroup() != null && this.myRecoveringDataGroups.containsKey(nDataGroupAdmin2.getGroup().getID()) && (object = this.myRecoveringDataGroups.get(nDataGroupAdmin2.getGroup().getID())) != null) {
                this.myKnownDataGroups.put(((com.pcbsys.nirvana.client.nDataGroup)object).getID(), (com.pcbsys.nirvana.client.nDataGroup)object);
                this.updateGroup(this.myGlobal, nDataGroupAdmin2.getGroup());
            }
            if ((object = nDataGroupAdmin2.getGroups()) != null) {
                Iterator<nDataGroup> iterator = object.iterator();
                while (iterator.hasNext()) {
                    nDataGroup nDataGroup2 = iterator.next();
                    com.pcbsys.nirvana.client.nDataGroup nDataGroup3 = this.myRecoveringDataGroups.get(nDataGroup2.getID());
                    if (nDataGroup3 == null) continue;
                    this.myKnownDataGroups.put(nDataGroup3.getID(), nDataGroup3);
                    this.updateGroup(nDataGroup3, nDataGroup2);
                }
            }
        }
        catch (nDataGroupDeletedException nDataGroupDeletedException2) {
            // empty catch block
        }
        this.myRecoveringDataGroups.clear();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public com.pcbsys.nirvana.client.nDataGroup getDefaultDataGroup(nDataGroupListener nDataGroupListener2, boolean bl) throws nRequestTimedOutException, nSessionPausedException, nSessionNotConnectedException, nSecurityException, nUnexpectedResponseException {
        nDataGroupAdmin nDataGroupAdmin2;
        if (bl) {
            nDataGroupAdmin2 = nDataGroupListener2 != null ? new nDataGroupAdmin(3, true) : new nDataGroupAdmin(3, false);
        } else {
            if (this.myGlobal != null && this.myDataGroupManagerHelper.getListener(this.myGlobal) != null) {
                return this.myGlobal;
            }
            nDataGroupAdmin2 = new nDataGroupAdmin(3, false);
        }
        nEvent nEvent2 = this.writeEvent(nDataGroupAdmin2);
        if (nEvent2 instanceof nDataGroupAdmin) {
            nDataGroupManagerImpl nDataGroupManagerImpl2 = this;
            synchronized (nDataGroupManagerImpl2) {
                com.pcbsys.nirvana.client.nDataGroup nDataGroup2;
                nDataGroupAdmin nDataGroupAdmin3 = (nDataGroupAdmin)nEvent2;
                this.myGlobal = nDataGroup2 = this.myDataGroupManagerHelper.createGroup(nDataGroupAdmin3.getGroup(), this, null, nDataGroupAdmin3.getGroup().getPriority());
                this.myDataGroupManagerHelper.setReadOnly(nDataGroup2);
                if (nDataGroupListener2 != null) {
                    try {
                        this.myDataGroupManagerHelper.setListener(this.myGlobal, nDataGroupListener2);
                    }
                    catch (nDataGroupDeletedException nDataGroupDeletedException2) {
                        // empty catch block
                    }
                }
                return nDataGroup2;
            }
        }
        nExceptionEventProcessor.checkSecurityException(nEvent2);
        nExceptionEventProcessor.checkUnexpectedExceptionEvent(nEvent2, "getDefaultDataGroup : " + nEvent2.getClass().getName());
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void sendServerAddDataGroupListener(com.pcbsys.nirvana.client.nDataGroup nDataGroup2, nDataGroupListener nDataGroupListener2) throws nUnexpectedResponseException, nSecurityException, nDataGroupDeletedException, nSessionNotConnectedException, nSessionPausedException, nRequestTimedOutException {
        nDataGroupAdmin nDataGroupAdmin2;
        if (nDataGroup2.isReadOnly()) {
            nDataGroupAdmin2 = new nDataGroupAdmin(3, true);
        } else {
            nDataGroupAdmin2 = new nDataGroupAdmin(24, nDataGroup2.getName());
            nDataGroupAdmin2.setRegisterListener(true);
        }
        nEvent nEvent2 = this.writeEvent(nDataGroupAdmin2);
        nDataGroupManagerImpl nDataGroupManagerImpl2 = this;
        synchronized (nDataGroupManagerImpl2) {
            if (nEvent2 instanceof nDataGroupAdmin) {
                if (nDataGroup2.isReadOnly()) {
                    return;
                }
                nDataGroup nDataGroup3 = ((nDataGroupAdmin)nEvent2).getGroup();
                if (nDataGroup3 == null) {
                    throw new nDataGroupDeletedException();
                }
                long l = nDataGroup3.getID();
                com.pcbsys.nirvana.client.nDataGroup nDataGroup4 = this.myKnownDataGroups.get(l);
                if (nDataGroup4 == null) {
                    throw new nDataGroupDeletedException();
                }
                this.myDataGroupManagerHelper.initialiseStreams(nDataGroup4, nDataGroup3);
                nDataGroup4.addListener(nDataGroupListener2);
            } else {
                nExceptionEventProcessor.checkSecurityException(nEvent2);
                nExceptionEventProcessor.checkUnexpectedExceptionEvent(nEvent2, "addListener: " + nEvent2.getClass().getName());
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public com.pcbsys.nirvana.client.nDataGroup findOrCreateGroup(String string, nDataGroupListener nDataGroupListener2, nConflationAttributes nConflationAttributes2, boolean bl, boolean bl2, int n) throws nSecurityException, nUnexpectedResponseException, nSessionNotConnectedException, nSessionPausedException, nRequestTimedOutException {
        com.pcbsys.nirvana.client.nDataGroup nDataGroup2 = this.findGroup(string);
        if (nDataGroup2 != null) {
            if (nDataGroupListener2 != null) {
                try {
                    if (this.myDataGroupManagerHelper.getListener(nDataGroup2) != null) {
                        this.myDataGroupManagerHelper.setListener(nDataGroup2, nDataGroupListener2);
                    } else {
                        nDataGroup2.addListener(nDataGroupListener2);
                    }
                }
                catch (nDataGroupDeletedException nDataGroupDeletedException2) {
                    // empty catch block
                }
            }
            return nDataGroup2;
        }
        nDataGroupAdmin nDataGroupAdmin2 = new nDataGroupAdmin(0, string);
        if (this.myGroupListener == null) {
            nDataGroupAdmin2.setRegisterListener(nDataGroupListener2 != null);
        } else {
            nDataGroupAdmin2.setRegisterListener(true);
        }
        if (nConflationAttributes2 != null) {
            nDataGroupAdmin2.setConflationInterval(nConflationAttributes2.getInterval());
            if (nConflationAttributes2.getAction() == 1) {
                nDataGroupAdmin2.setConflationMerge(true);
            }
        }
        nDataGroupAdmin2.setEnableMulticast(bl);
        nDataGroupAdmin2.setDeleteReplacedEvents(bl2);
        nDataGroupAdmin2.setPriority(n);
        nEvent nEvent2 = this.writeEvent(nDataGroupAdmin2);
        nDataGroupManagerImpl nDataGroupManagerImpl2 = this;
        synchronized (nDataGroupManagerImpl2) {
            if (nEvent2 instanceof nDataGroupAdmin) {
                nDataGroupAdmin nDataGroupAdmin3 = (nDataGroupAdmin)nEvent2;
                nDataGroup nDataGroup3 = nDataGroupAdmin3.getGroup();
                nDataGroup2 = this.myKnownDataGroups.get(nDataGroup3.getID());
                if (nDataGroup2 == null) {
                    nDataGroup2 = this.myDataGroupManagerHelper.createGroup(nDataGroup3, this, nDataGroup3.isEnableMulticast(), nDataGroup3.getPriority());
                    this.myKnownDataGroups.put(nDataGroup2.getID(), nDataGroup2);
                } else {
                    this.myDataGroupManagerHelper.initialiseStreams(nDataGroup2, nDataGroup3);
                }
                try {
                    if (nDataGroupListener2 != null) {
                        this.myDataGroupManagerHelper.setListener(nDataGroup2, nDataGroupListener2);
                    }
                }
                catch (nDataGroupDeletedException nDataGroupDeletedException3) {
                    // empty catch block
                }
                return nDataGroup2;
            }
            nExceptionEventProcessor.checkSecurityException(nEvent2);
            nExceptionEventProcessor.checkUnexpectedExceptionEvent(nEvent2, "createDataGroup : " + nEvent2.getClass().getName());
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void deleteDataGroup(com.pcbsys.nirvana.client.nDataGroup nDataGroup2) throws nRequestTimedOutException, nSessionPausedException, nSessionNotConnectedException, nSecurityException, nUnexpectedResponseException {
        if (nDataGroup2.isReadOnly()) {
            throw new nSecurityException("You cannot delete the default group");
        }
        if (nDataGroup2.isClosed()) {
            return;
        }
        nDataGroupAdmin nDataGroupAdmin2 = new nDataGroupAdmin(2, nDataGroup2.getName());
        nEvent nEvent2 = this.writeEvent(nDataGroupAdmin2);
        nDataGroupManagerImpl nDataGroupManagerImpl2 = this;
        synchronized (nDataGroupManagerImpl2) {
            if (nEvent2 instanceof nDataGroupAdmin) {
                try {
                    this.myKnownDataGroups.remove(nDataGroup2.getID());
                    this.myKnownDeletedDataGroups.put(nDataGroup2.getID(), nDataGroup2);
                    this.myDataGroupManagerHelper.closeGroup(nDataGroup2);
                }
                catch (Exception exception) {
                    nConstants.logger.warn(exception);
                }
            } else {
                nExceptionEventProcessor.checkSecurityException(nEvent2);
                nExceptionEventProcessor.checkUnexpectedExceptionEvent(nEvent2, "deleteDataGroup : " + nEvent2.getClass().getName());
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public com.pcbsys.nirvana.client.nDataGroup[] createDataGroups(String[] stringArray, nConflationAttributes nConflationAttributes2, boolean bl) throws nIllegalArgumentException, nRequestTimedOutException, nSessionPausedException, nSessionNotConnectedException, nSecurityException, nUnexpectedResponseException {
        ArrayList<com.pcbsys.nirvana.client.nDataGroup> arrayList = new ArrayList<com.pcbsys.nirvana.client.nDataGroup>();
        LinkedHashMap<String, com.pcbsys.nirvana.client.nDataGroup> linkedHashMap = new LinkedHashMap<String, com.pcbsys.nirvana.client.nDataGroup>();
        Object object = this;
        synchronized (this) {
            com.pcbsys.nirvana.client.nDataGroup nDataGroup2;
            for (com.pcbsys.nirvana.client.nDataGroup nDataGroup3 : this.myKnownDataGroups.values()) {
                linkedHashMap.put(nDataGroup3.getName(), nDataGroup3);
            }
            // ** MonitorExit[object] (shouldn't be in output)
            for (String object2 : stringArray) {
                if (object2 == null || object2.length() == 0) {
                    throw new nIllegalArgumentException("Please supply a valid Data Group Name");
                }
                nDataGroup2 = (com.pcbsys.nirvana.client.nDataGroup)linkedHashMap.get(object2);
                if (nDataGroup2 == null) break;
                arrayList.add(nDataGroup2);
            }
            if (arrayList.size() == stringArray.length) {
                object = new com.pcbsys.nirvana.client.nDataGroup[stringArray.length];
                return (com.pcbsys.nirvana.client.nDataGroup[])arrayList.toArray((T[])object);
            }
            object = new nDataGroupAdmin(4, stringArray);
            ((nDataGroupAdmin)object).setEnableMulticast(bl);
            ((nDataGroupAdmin)object).setRegisterListener(this.myGroupListener != null);
            if (nConflationAttributes2 != null) {
                ((nDataGroupAdmin)object).setConflationInterval(nConflationAttributes2.getInterval());
                if (nConflationAttributes2.getAction() == 1) {
                    ((nDataGroupAdmin)object).setConflationMerge(true);
                }
            }
            nEvent nEvent2 = this.writeEvent((nEvent)object);
            String[] stringArray2 = this;
            synchronized (this) {
                if (nEvent2 instanceof nDataGroupAdmin) {
                    com.pcbsys.nirvana.client.nDataGroup[] nDataGroupArray;
                    nDataGroupAdmin nDataGroupAdmin2 = (nDataGroupAdmin)nEvent2;
                    Iterator<nDataGroup> iterator = nDataGroupAdmin2.getGroups().iterator();
                    ArrayList<com.pcbsys.nirvana.client.nDataGroup> arrayList2 = new ArrayList<com.pcbsys.nirvana.client.nDataGroup>();
                    while (iterator.hasNext()) {
                        nDataGroupArray = iterator.next();
                        nDataGroup2 = this.myKnownDataGroups.get(nDataGroupArray.getID());
                        if (nDataGroup2 == null) {
                            nDataGroup2 = this.myDataGroupManagerHelper.createGroup((nDataGroup)nDataGroupArray, (nDataGroupManagerImpl)this, nDataGroupArray.isEnableMulticast(), nDataGroupArray.getPriority());
                            this.myKnownDataGroups.put(nDataGroup2.getID(), nDataGroup2);
                        }
                        arrayList2.add(nDataGroup2);
                    }
                    nDataGroupArray = new com.pcbsys.nirvana.client.nDataGroup[arrayList2.size()];
                    // ** MonitorExit[stringArray2] (shouldn't be in output)
                    return arrayList2.toArray(nDataGroupArray);
                }
                nExceptionEventProcessor.checkSecurityException(nEvent2);
                nExceptionEventProcessor.checkUnexpectedExceptionEvent(nEvent2, "createDataGroups : " + nEvent2.getClass().getName());
                // ** MonitorExit[stringArray2] (shouldn't be in output)
                return null;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void deleteDataGroup(com.pcbsys.nirvana.client.nDataGroup[] nDataGroupArray) throws nRequestTimedOutException, nSessionPausedException, nSessionNotConnectedException, nSecurityException, nUnexpectedResponseException {
        if (nDataGroupArray.length == 0) {
            return;
        }
        String[] stringArray = new String[nDataGroupArray.length];
        for (int i = 0; i < nDataGroupArray.length; ++i) {
            stringArray[i] = nDataGroupArray[i].getName();
        }
        nDataGroupAdmin nDataGroupAdmin2 = new nDataGroupAdmin(6, stringArray);
        nEvent nEvent2 = this.writeEvent(nDataGroupAdmin2);
        nDataGroupManagerImpl nDataGroupManagerImpl2 = this;
        synchronized (nDataGroupManagerImpl2) {
            if (nEvent2 instanceof nDataGroupAdmin) {
                for (com.pcbsys.nirvana.client.nDataGroup nDataGroup2 : nDataGroupArray) {
                    this.myKnownDataGroups.remove(nDataGroup2.getID());
                    this.myKnownDeletedDataGroups.put(nDataGroup2.getID(), nDataGroup2);
                    this.myDataGroupManagerHelper.closeGroup(nDataGroup2);
                }
            } else {
                nExceptionEventProcessor.checkSecurityException(nEvent2);
                nExceptionEventProcessor.checkUnexpectedExceptionEvent(nEvent2, "deleteDataGroup : " + nEvent2.getClass().getName());
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public com.pcbsys.nirvana.client.nDataGroup[] getDataGroups(String string, nDataGroupListener nDataGroupListener2) throws nRequestTimedOutException, nSessionPausedException, nSessionNotConnectedException, nSecurityException, nUnexpectedResponseException {
        nDataGroupAdmin nDataGroupAdmin2 = new nDataGroupAdmin(5, nDataGroupListener2 != null);
        nDataGroupAdmin2.setName(string);
        nEvent nEvent2 = this.writeEvent(nDataGroupAdmin2);
        nDataGroupManagerImpl nDataGroupManagerImpl2 = this;
        synchronized (nDataGroupManagerImpl2) {
            if (nEvent2 instanceof nDataGroupAdmin) {
                nDataGroupAdmin nDataGroupAdmin3 = (nDataGroupAdmin)nEvent2;
                nConflationAttributes nConflationAttributes2 = null;
                if (nDataGroupAdmin3.hasConflation()) {
                    int n = 1;
                    if (!nDataGroupAdmin3.getConflationMerge()) {
                        n = 0;
                    }
                    try {
                        nConflationAttributes2 = new nConflationAttributes(n, nDataGroupAdmin3.getConflationInterval());
                    }
                    catch (nIllegalArgumentException nIllegalArgumentException2) {
                        // empty catch block
                    }
                }
                com.pcbsys.nirvana.client.nDataGroup nDataGroup2 = this.myDataGroupManagerHelper.createGroup(nDataGroupAdmin3.getGroup(), this, nConflationAttributes2, nDataGroupAdmin3.getGroup().getPriority());
                if ((string == null || string.length() == 0) && nDataGroupListener2 != null) {
                    this.myGroupListener = nDataGroupListener2;
                }
                if (this.myGlobal == null) {
                    this.myGlobal = nDataGroup2;
                }
                this.myDataGroupManagerHelper.setReadOnly(nDataGroup2);
                Collection<nDataGroup> collection = ((nDataGroupAdmin)nEvent2).getGroups();
                com.pcbsys.nirvana.client.nDataGroup[] nDataGroupArray = new com.pcbsys.nirvana.client.nDataGroup[collection == null ? 0 : collection.size()];
                if (collection != null) {
                    int n = 0;
                    for (nDataGroup nDataGroup3 : collection) {
                        com.pcbsys.nirvana.client.nDataGroup nDataGroup4 = this.myKnownDataGroups.get(nDataGroup3.getID());
                        if (nDataGroup4 == null) {
                            nDataGroup4 = this.myDataGroupManagerHelper.createGroup(nDataGroup3, this, nDataGroup3.isEnableMulticast(), nDataGroup3.getPriority());
                            this.myKnownDataGroups.put(nDataGroup4.getID(), nDataGroup4);
                        } else if (this.myDataGroupManagerHelper.getListener(nDataGroup4) == null) {
                            this.myDataGroupManagerHelper.initialiseStreams(nDataGroup4, nDataGroup3);
                        }
                        nDataGroupArray[n] = nDataGroup4;
                        try {
                            this.myDataGroupManagerHelper.setListener(nDataGroup4, nDataGroupListener2);
                        }
                        catch (nDataGroupDeletedException nDataGroupDeletedException2) {
                            // empty catch block
                        }
                        ++n;
                    }
                }
                return nDataGroupArray;
            }
            nExceptionEventProcessor.checkSecurityException(nEvent2);
            nExceptionEventProcessor.checkUnexpectedExceptionEvent(nEvent2, "getDataGroups : " + nEvent2.getClass().getName());
            return null;
        }
    }

    synchronized void reconnectDataGroups() throws nSessionNotConnectedException, nSessionPausedException, nRequestTimedOutException {
        String[] stringArray;
        Iterator<com.pcbsys.nirvana.client.nDataGroup> iterator = this.myKnownDataGroups.values().iterator();
        ArrayList<String> arrayList = new ArrayList<String>();
        while (iterator.hasNext()) {
            stringArray = iterator.next();
            if (this.myDataGroupManagerHelper.getListener((com.pcbsys.nirvana.client.nDataGroup)stringArray) == null) continue;
            arrayList.add(stringArray.getName());
        }
        stringArray = new String[arrayList.size()];
        stringArray = arrayList.toArray(stringArray);
        nDataGroupAdmin nDataGroupAdmin2 = new nDataGroupAdmin(7, stringArray);
        nDataGroupAdmin2.setRegisterListener(this.myGlobal != null && this.myDataGroupManagerHelper.getListener(this.myGlobal) != null);
        nDataGroupAdmin2.setGroupRegistration(this.myGroupListener != null);
        nDataGroupAdmin2.setSynchronous(false);
        this.writeEvent(nDataGroupAdmin2);
        this.myRecoveringDataGroups.clear();
        this.myKnownDataGroups.clear();
    }

    @Override
    public nEvent writeEvent(nEvent nEvent2) throws nSessionNotConnectedException, nSessionPausedException, nRequestTimedOutException {
        return this.myEventProcessor.writeEvent(nEvent2);
    }

    private void updateGroup(com.pcbsys.nirvana.client.nDataGroup nDataGroup2, nDataGroup nDataGroup3) throws nDataGroupDeletedException {
        if (nDataGroup2 != null && nDataGroup3 != null) {
            nDataGroupListener nDataGroupListener2 = this.myDataGroupManagerHelper.getListener(nDataGroup2);
            nDataStream[] nDataStreamArray2 = nDataGroup3.getStreams();
            if (nDataStreamArray2 != null) {
                ArrayList<nDataStream> arrayList = new ArrayList<nDataStream>();
                for (nDataStream object : nDataStreamArray2) {
                    if (nDataGroup2.contains(object.getName())) continue;
                    arrayList.add(object);
                }
                for (nDataStream nDataStream2 : arrayList) {
                    com.pcbsys.nirvana.client.nDataStream nDataStream3 = this.myDataGroupManagerHelper.createStream(nDataStream2.getName(), nDataStream2.getSubject());
                    this.myDataGroupManagerHelper.addToStream(nDataGroup2, nDataStream3);
                    if (nDataGroupListener2 == null) continue;
                    nDataGroupListener2.addedStream(nDataGroup2, nDataStream3, nDataGroup2.size());
                }
                Iterator<com.pcbsys.nirvana.client.nDataStream> iterator = nDataGroup2.getStreams();
                ArrayList<com.pcbsys.nirvana.client.nDataStream> arrayList2 = new ArrayList<com.pcbsys.nirvana.client.nDataStream>();
                while (iterator.hasNext()) {
                    int n = 0;
                    com.pcbsys.nirvana.client.nDataStream nDataStream2 = (com.pcbsys.nirvana.client.nDataStream)iterator.next();
                    for (nDataStream nDataStream3 : nDataStreamArray2) {
                        if (!nDataStream2.getName().equals(nDataStream3.getName())) continue;
                        n = 1;
                        break;
                    }
                    if (n != 0) continue;
                    arrayList2.add(nDataStream2);
                }
                for (com.pcbsys.nirvana.client.nDataStream nDataStream4 : arrayList2) {
                    this.myDataGroupManagerHelper.removeFromGroup(nDataGroup2, nDataStream4, false);
                }
            }
        }
    }

    private final class GroupMappingHandler
    implements StreamUpdateHandler {
        private GroupMappingHandler() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void handleUpdate(nStreamStatusUpdate nStreamStatusUpdate2) {
            long[] lArray = nStreamStatusUpdate2.getIDs();
            String[] stringArray = nStreamStatusUpdate2.getNames();
            nDataGroupManagerImpl nDataGroupManagerImpl2 = nDataGroupManagerImpl.this;
            synchronized (nDataGroupManagerImpl2) {
                for (int i = 0; i < lArray.length; ++i) {
                    nDataGroupManagerImpl.this.myGroupMapping.put(lArray[i], stringArray[i]);
                }
            }
        }
    }

    private final class SnoopStreamDeletedHandler
    implements StreamUpdateHandler {
        private SnoopStreamDeletedHandler() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void handleUpdate(nStreamStatusUpdate nStreamStatusUpdate2) {
            if (nStreamStatusUpdate2.getGroupID() != 0L) {
                com.pcbsys.nirvana.client.nDataGroup nDataGroup2 = nDataGroupManagerImpl.this.getKnownDataGroup(nStreamStatusUpdate2.getGroupID());
                if (nDataGroup2 == null) {
                    return;
                }
                try {
                    com.pcbsys.nirvana.client.nDataStream nDataStream2 = nDataGroup2.getSnoopStream(nStreamStatusUpdate2.getStreamId());
                    if (nDataStream2 == null) {
                        nDataStream2 = nDataGroupManagerImpl.this.myDataGroupManagerHelper.createStream(nStreamStatusUpdate2.getStreamId(), nStreamStatusUpdate2.getSubject());
                    }
                    nDataGroupManagerImpl.this.myDataGroupManagerHelper.removeFromSnoopList(nDataGroup2, nDataStream2);
                }
                catch (Exception exception) {}
            } else {
                LinkedList<com.pcbsys.nirvana.client.nDataGroup> linkedList = new LinkedList<com.pcbsys.nirvana.client.nDataGroup>();
                com.pcbsys.nirvana.client.nDataStream nDataStream3 = nDataGroupManagerImpl.this.myDataGroupManagerHelper.createStream(nStreamStatusUpdate2.getStreamId(), nStreamStatusUpdate2.getSubject());
                nDataGroupManagerImpl nDataGroupManagerImpl2 = nDataGroupManagerImpl.this;
                synchronized (nDataGroupManagerImpl2) {
                    for (com.pcbsys.nirvana.client.nDataGroup nDataGroup2 : nDataGroupManagerImpl.this.myKnownDataGroups.values()) {
                        try {
                            if (!nDataGroup2.containsSnoop(nStreamStatusUpdate2.getStreamId())) continue;
                            linkedList.add(nDataGroup2);
                        }
                        catch (nDataGroupDeletedException nDataGroupDeletedException2) {}
                    }
                }
                if (nDataGroupManagerImpl.this.myGlobal != null) {
                    nDataGroupManagerImpl.this.myDataGroupManagerHelper.removeFromSnoopList(nDataGroupManagerImpl.this.myGlobal, nDataStream3);
                }
                if (linkedList.size() > 0) {
                    for (com.pcbsys.nirvana.client.nDataGroup nDataGroup3 : linkedList) {
                        nDataGroupManagerImpl.this.myDataGroupManagerHelper.removeFromSnoopList(nDataGroup3, nDataStream3);
                    }
                }
            }
        }
    }

    private final class SnoopStreamAddedHandler
    implements StreamUpdateHandler {
        private SnoopStreamAddedHandler() {
        }

        @Override
        public void handleUpdate(nStreamStatusUpdate nStreamStatusUpdate2) {
            if (nStreamStatusUpdate2.getGroupID() != 0L) {
                com.pcbsys.nirvana.client.nDataGroup nDataGroup2 = nDataGroupManagerImpl.this.getKnownDataGroup(nStreamStatusUpdate2.getGroupID());
                if (nDataGroup2 == null) {
                    return;
                }
                com.pcbsys.nirvana.client.nDataStream nDataStream2 = null;
                if (nDataGroupManagerImpl.this.myGlobal != null) {
                    try {
                        nDataStream2 = nDataGroupManagerImpl.this.myGlobal.getSnoopStream(nStreamStatusUpdate2.getStreamId());
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
                if (nDataStream2 == null) {
                    nDataStream2 = nDataGroupManagerImpl.this.myDataGroupManagerHelper.createStream(nStreamStatusUpdate2.getStreamId(), nStreamStatusUpdate2.getSubject());
                }
                nDataGroupManagerImpl.this.myDataGroupManagerHelper.addToSnoop(nDataGroup2, nDataStream2);
            } else if (nDataGroupManagerImpl.this.myGlobal != null) {
                com.pcbsys.nirvana.client.nDataStream nDataStream3 = nDataGroupManagerImpl.this.myDataGroupManagerHelper.createStream(nStreamStatusUpdate2.getStreamId(), nStreamStatusUpdate2.getSubject());
                nDataGroupManagerImpl.this.myDataGroupManagerHelper.addToSnoop(nDataGroupManagerImpl.this.myGlobal, nDataStream3);
            }
        }
    }

    private final class GroupRemovedHandler
    implements StreamUpdateHandler {
        private GroupRemovedHandler() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void handleUpdate(nStreamStatusUpdate nStreamStatusUpdate2) {
            com.pcbsys.nirvana.client.nDataGroup nDataGroup2 = null;
            try {
                com.pcbsys.nirvana.client.nDataGroup nDataGroup3;
                nDataGroupManagerImpl nDataGroupManagerImpl2 = nDataGroupManagerImpl.this;
                synchronized (nDataGroupManagerImpl2) {
                    nDataGroup3 = (com.pcbsys.nirvana.client.nDataGroup)nDataGroupManagerImpl.this.myKnownDataGroups.get(nStreamStatusUpdate2.getGroupID());
                    if (nDataGroup3 != null) {
                        nDataGroup2 = nDataGroup3.getGroup(nStreamStatusUpdate2.getStreamId());
                    }
                }
                if (nDataGroup2 != null) {
                    nDataGroupManagerImpl.this.myDataGroupManagerHelper.removeFromGroup(nDataGroup3, nDataGroup2);
                    if (nDataGroupManagerImpl.this.myGroupListener != null) {
                        nDataGroupManagerImpl.this.myGroupListener.removedGroup(nDataGroup3, nDataGroup2, nDataGroup3.size());
                    }
                }
            }
            catch (nDataGroupDeletedException nDataGroupDeletedException2) {
                // empty catch block
            }
        }
    }

    private final class GroupInsertedHandler
    implements StreamUpdateHandler {
        private GroupInsertedHandler() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void handleUpdate(nStreamStatusUpdate nStreamStatusUpdate2) {
            com.pcbsys.nirvana.client.nDataGroup nDataGroup2;
            com.pcbsys.nirvana.client.nDataGroup nDataGroup3 = null;
            nDataGroupManagerImpl nDataGroupManagerImpl2 = nDataGroupManagerImpl.this;
            synchronized (nDataGroupManagerImpl2) {
                nDataGroup2 = (com.pcbsys.nirvana.client.nDataGroup)nDataGroupManagerImpl.this.myKnownDataGroups.get(nStreamStatusUpdate2.getGroupID());
                Iterator iterator = nDataGroupManagerImpl.this.myKnownDataGroups.values().iterator();
                while (iterator.hasNext() && nDataGroup3 == null) {
                    com.pcbsys.nirvana.client.nDataGroup nDataGroup4 = (com.pcbsys.nirvana.client.nDataGroup)iterator.next();
                    if (!nDataGroup4.getName().equals(nStreamStatusUpdate2.getStreamId())) continue;
                    nDataGroup3 = nDataGroup4;
                }
            }
            if (nDataGroup2 != null && nDataGroup3 != null && nDataGroup3 != nDataGroup2) {
                nDataGroupManagerImpl.this.myDataGroupManagerHelper.addToGroup(nDataGroup2, nDataGroup3);
                if (nDataGroupManagerImpl.this.myDataGroupManagerHelper.getListener(nDataGroup2) != null) {
                    try {
                        nDataGroupManagerImpl.this.myDataGroupManagerHelper.getListener(nDataGroup2).addedGroup(nDataGroup2, nDataGroup3, nDataGroup2.size());
                    }
                    catch (nDataGroupDeletedException nDataGroupDeletedException2) {
                        // empty catch block
                    }
                }
                if (nDataGroupManagerImpl.this.myGroupListener != null) {
                    try {
                        nDataGroupManagerImpl.this.myGroupListener.addedGroup(nDataGroup2, nDataGroup3, nDataGroup2.size());
                    }
                    catch (nDataGroupDeletedException nDataGroupDeletedException3) {
                        // empty catch block
                    }
                }
            }
        }
    }

    private final class GroupDeletedHandler
    implements StreamUpdateHandler {
        private GroupDeletedHandler() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void handleUpdate(nStreamStatusUpdate nStreamStatusUpdate2) {
            com.pcbsys.nirvana.client.nDataGroup nDataGroup2 = null;
            LinkedList linkedList = new LinkedList();
            try {
                nDataGroupManagerImpl nDataGroupManagerImpl2 = nDataGroupManagerImpl.this;
                synchronized (nDataGroupManagerImpl2) {
                    nDataGroup2 = (com.pcbsys.nirvana.client.nDataGroup)nDataGroupManagerImpl.this.myKnownDataGroups.get(nStreamStatusUpdate2.getGroup().getID());
                    if (nDataGroup2 != null) {
                        nDataGroupManagerImpl.this.myKnownDataGroups.remove(nDataGroup2.getID());
                        Object object = nDataGroupManagerImpl.this.myKnownDataGroups.values().iterator();
                        nDataGroupManagerImpl.this.addAnyGroupContainingGroup(nDataGroup2, linkedList, object);
                    }
                    if (nDataGroup2 == null && (nDataGroup2 = (com.pcbsys.nirvana.client.nDataGroup)nDataGroupManagerImpl.this.myKnownDeletedDataGroups.get(nStreamStatusUpdate2.getGroup().getID())) != null) {
                        nDataGroupManagerImpl.this.myKnownDeletedDataGroups.remove(nDataGroup2.getID());
                    }
                }
                if (nDataGroup2 != null) {
                    if (nDataGroupManagerImpl.this.myDataGroupManagerHelper.getListener(nDataGroup2) != null) {
                        nDataGroupManagerImpl.this.myDataGroupManagerHelper.getListener(nDataGroup2).deletedGroup(nDataGroup2);
                    }
                    if (nDataGroupManagerImpl.this.myGroupListener != null) {
                        nDataGroupManagerImpl.this.myGroupListener.deletedGroup(nDataGroup2);
                    }
                    if (nDataGroupManagerImpl.this.myGlobal != null && nDataGroupManagerImpl.this.myDataGroupManagerHelper.getListener(nDataGroupManagerImpl.this.myGlobal) != null) {
                        nDataGroupManagerImpl.this.myDataGroupManagerHelper.getListener(nDataGroupManagerImpl.this.myGlobal).deletedGroup(nDataGroup2);
                    }
                }
                if (linkedList.size() > 0) {
                    for (Object object : linkedList) {
                        nDataGroupManagerImpl.this.myDataGroupManagerHelper.removeFromGroup((com.pcbsys.nirvana.client.nDataGroup)object, nDataGroup2);
                    }
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            if (nDataGroup2 != null) {
                nDataGroupManagerImpl.this.myDataGroupManagerHelper.closeGroup(nDataGroup2);
            }
        }
    }

    private final class GroupAddedHandler
    implements StreamUpdateHandler {
        private GroupAddedHandler() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void handleUpdate(nStreamStatusUpdate nStreamStatusUpdate2) {
            com.pcbsys.nirvana.client.nDataGroup nDataGroup2;
            com.pcbsys.nirvana.client.nDataGroup nDataGroup3;
            nDataGroup nDataGroup4 = nStreamStatusUpdate2.getGroup();
            nDataGroupManagerImpl nDataGroupManagerImpl2 = nDataGroupManagerImpl.this;
            synchronized (nDataGroupManagerImpl2) {
                nDataGroup3 = (com.pcbsys.nirvana.client.nDataGroup)nDataGroupManagerImpl.this.myKnownDataGroups.get(nStreamStatusUpdate2.getGroup().getID());
                if (nDataGroup3 == null) {
                    nDataGroup3 = nDataGroupManagerImpl.this.myDataGroupManagerHelper.createGroup(nStreamStatusUpdate2.getGroup(), nDataGroupManagerImpl.this, nDataGroup4.isEnableMulticast(), nStreamStatusUpdate2.getGroup().getPriority());
                    nDataGroupManagerImpl.this.myKnownDataGroups.put(nDataGroup3.getID(), nDataGroup3);
                } else {
                    Iterator<nDataStream> iterator = nDataGroup4.values();
                    while (iterator.hasNext()) {
                        nDataStream nDataStream2 = iterator.next();
                        try {
                            if (nDataGroup3 != null && nDataGroup3.getGroup(nDataStream2.getName()) != null) continue;
                            nDataGroup3 = (com.pcbsys.nirvana.client.nDataGroup)nDataGroupManagerImpl.this.myKnownDataGroups.get(((nDataGroup)nDataStream2).getID());
                        }
                        catch (nDataGroupDeletedException nDataGroupDeletedException2) {}
                    }
                }
                nDataGroup2 = (com.pcbsys.nirvana.client.nDataGroup)nDataGroupManagerImpl.this.myKnownDataGroups.get(nDataGroup4.getID());
            }
            if (nDataGroup3 != null && nDataGroup2 != null && nDataGroup2 != nDataGroup3) {
                nDataGroupManagerImpl.this.myDataGroupManagerHelper.addToGroup(nDataGroup2, nDataGroup3);
            }
            if (nDataGroupManagerImpl.this.myGroupListener != null) {
                nDataGroupManagerImpl.this.myGroupListener.createdGroup(nDataGroup3);
            }
            if (nDataGroupManagerImpl.this.myGlobal != null && nDataGroupManagerImpl.this.myDataGroupManagerHelper.getListener(nDataGroupManagerImpl.this.myGlobal) != null) {
                nDataGroupManagerImpl.this.myDataGroupManagerHelper.getListener(nDataGroupManagerImpl.this.myGlobal).createdGroup(nDataGroup3);
            }
        }
    }

    private final class StreamAddedHandler
    implements StreamUpdateHandler {
        private StreamAddedHandler() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void handleUpdate(nStreamStatusUpdate nStreamStatusUpdate2) {
            if (nStreamStatusUpdate2.getGroupID() != 0L) {
                com.pcbsys.nirvana.client.nDataGroup nDataGroup2 = nDataGroupManagerImpl.this.getKnownDataGroup(nStreamStatusUpdate2.getGroupID());
                if (nDataGroup2 == null) {
                    return;
                }
                com.pcbsys.nirvana.client.nDataStream nDataStream2 = null;
                if (nDataGroupManagerImpl.this.myGlobal != null) {
                    try {
                        nDataStream2 = nDataGroupManagerImpl.this.myGlobal.getStream(nStreamStatusUpdate2.getStreamId());
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
                if (nDataStream2 == null) {
                    nDataStream2 = nDataGroupManagerImpl.this.myDataGroupManagerHelper.createStream(nStreamStatusUpdate2.getStreamId(), nStreamStatusUpdate2.getSubject());
                }
                nDataGroupManagerImpl.this.myDataGroupManagerHelper.addToStream(nDataGroup2, nDataStream2);
                try {
                    if (nDataGroupManagerImpl.this.myDataGroupManagerHelper.getListener(nDataGroup2) != null) {
                        nDataGroupManagerImpl.this.myDataGroupManagerHelper.getListener(nDataGroup2).addedStream(nDataGroup2, nDataStream2, nDataGroup2.size());
                    }
                }
                catch (nDataGroupDeletedException nDataGroupDeletedException2) {
                    nConstants.logger.warn(nDataGroupDeletedException2);
                }
                try {
                    if (nDataGroupManagerImpl.this.myGroupListener != null) {
                        nDataGroupManagerImpl.this.myGroupListener.addedStream(nDataGroup2, nDataStream2, nDataGroup2.size());
                    }
                }
                catch (nDataGroupDeletedException nDataGroupDeletedException3) {
                    nConstants.logger.warn(nDataGroupDeletedException3);
                }
                nDataGroupManagerImpl nDataGroupManagerImpl2 = nDataGroupManagerImpl.this;
                synchronized (nDataGroupManagerImpl2) {
                    ParentDataGroupNotifier.notifyStreamAdded(nDataGroupManagerImpl.this.myKnownDataGroups.values().iterator(), nDataGroup2, nDataStream2, nStreamStatusUpdate2.wasServerInduced(), nDataGroupManagerImpl.this.myDataGroupManagerHelper);
                }
            }
            if (nDataGroupManagerImpl.this.myGlobal != null) {
                try {
                    if (nDataGroupManagerImpl.this.myGlobal.contains(nStreamStatusUpdate2.getStreamId())) {
                        return;
                    }
                }
                catch (nDataGroupDeletedException nDataGroupDeletedException4) {
                    // empty catch block
                }
                com.pcbsys.nirvana.client.nDataStream nDataStream3 = nDataGroupManagerImpl.this.myDataGroupManagerHelper.createStream(nStreamStatusUpdate2.getStreamId(), nStreamStatusUpdate2.getSubject());
                nDataGroupManagerImpl.this.myDataGroupManagerHelper.addToStream(nDataGroupManagerImpl.this.myGlobal, nDataStream3);
                try {
                    if (nDataGroupManagerImpl.this.myDataGroupManagerHelper.getListener(nDataGroupManagerImpl.this.myGlobal) != null) {
                        nDataGroupManagerImpl.this.myDataGroupManagerHelper.getListener(nDataGroupManagerImpl.this.myGlobal).addedStream(nDataGroupManagerImpl.this.myGlobal, nDataStream3, nDataGroupManagerImpl.this.myGlobal.size());
                    }
                }
                catch (nDataGroupDeletedException nDataGroupDeletedException5) {
                    nConstants.logger.warn(nDataGroupDeletedException5);
                }
                if (nDataGroupManagerImpl.this.myGroupListener != null) {
                    try {
                        nDataGroupManagerImpl.this.myGroupListener.addedStream(nDataGroupManagerImpl.this.myGlobal, nDataStream3, nDataGroupManagerImpl.this.myGlobal.size());
                    }
                    catch (nDataGroupDeletedException nDataGroupDeletedException6) {
                        // empty catch block
                    }
                }
            }
        }
    }

    private final class StreamDeletedHandler
    implements StreamUpdateHandler {
        private StreamDeletedHandler() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void handleUpdate(nStreamStatusUpdate nStreamStatusUpdate2) {
            if (nStreamStatusUpdate2.getGroupID() != 0L) {
                com.pcbsys.nirvana.client.nDataGroup nDataGroup2 = nDataGroupManagerImpl.this.getKnownDataGroup(nStreamStatusUpdate2.getGroupID());
                if (nDataGroup2 == null) {
                    return;
                }
                try {
                    com.pcbsys.nirvana.client.nDataStream nDataStream2 = nDataGroup2.getStream(nStreamStatusUpdate2.getStreamId());
                    if (nDataStream2 == null) {
                        nDataStream2 = nDataGroupManagerImpl.this.myDataGroupManagerHelper.createStream(nStreamStatusUpdate2.getStreamId(), nStreamStatusUpdate2.getSubject());
                    }
                    nDataGroupManagerImpl.this.myDataGroupManagerHelper.removeFromGroup(nDataGroup2, nDataStream2, nStreamStatusUpdate2.wasServerInduced());
                    if (nDataGroupManagerImpl.this.myGroupListener != null) {
                        try {
                            nDataGroupManagerImpl.this.myGroupListener.deletedStream(nDataGroup2, nDataStream2, nDataGroup2.size(), nStreamStatusUpdate2.wasServerInduced());
                        }
                        catch (nDataGroupDeletedException nDataGroupDeletedException2) {
                            // empty catch block
                        }
                    }
                    nDataGroupManagerImpl nDataGroupManagerImpl2 = nDataGroupManagerImpl.this;
                    synchronized (nDataGroupManagerImpl2) {
                        ParentDataGroupNotifier.notifyStreamDeleted(nDataGroupManagerImpl.this.myKnownDataGroups.values().iterator(), nDataGroup2, nDataStream2, nStreamStatusUpdate2.wasServerInduced(), nDataGroupManagerImpl.this.myDataGroupManagerHelper);
                    }
                }
                catch (nDataGroupDeletedException nDataGroupDeletedException3) {}
            } else {
                LinkedList<com.pcbsys.nirvana.client.nDataGroup> linkedList = new LinkedList<com.pcbsys.nirvana.client.nDataGroup>();
                com.pcbsys.nirvana.client.nDataStream nDataStream3 = nDataGroupManagerImpl.this.myDataGroupManagerHelper.createStream(nStreamStatusUpdate2.getStreamId(), nStreamStatusUpdate2.getSubject());
                nDataGroupManagerImpl nDataGroupManagerImpl3 = nDataGroupManagerImpl.this;
                synchronized (nDataGroupManagerImpl3) {
                    for (com.pcbsys.nirvana.client.nDataGroup nDataGroup2 : nDataGroupManagerImpl.this.myKnownDataGroups.values()) {
                        try {
                            if (!nDataGroup2.contains(nStreamStatusUpdate2.getStreamId())) continue;
                            linkedList.add(nDataGroup2);
                        }
                        catch (nDataGroupDeletedException nDataGroupDeletedException2) {}
                    }
                }
                if (nDataGroupManagerImpl.this.myGlobal != null) {
                    nDataGroupManagerImpl.this.myDataGroupManagerHelper.removeFromGroup(nDataGroupManagerImpl.this.myGlobal, nDataStream3, nStreamStatusUpdate2.wasServerInduced());
                    if (nDataGroupManagerImpl.this.myGroupListener != null) {
                        try {
                            nDataGroupManagerImpl.this.myGroupListener.deletedStream(nDataGroupManagerImpl.this.myGlobal, nDataStream3, nDataGroupManagerImpl.this.myGlobal.size(), nStreamStatusUpdate2.wasServerInduced());
                        }
                        catch (nDataGroupDeletedException nDataGroupDeletedException5) {
                            // empty catch block
                        }
                    }
                }
                if (linkedList.size() > 0) {
                    for (com.pcbsys.nirvana.client.nDataGroup nDataGroup3 : linkedList) {
                        nDataGroupManagerImpl.this.myDataGroupManagerHelper.removeFromGroup(nDataGroup3, nDataStream3, nStreamStatusUpdate2.wasServerInduced());
                        try {
                            if (nDataGroupManagerImpl.this.myGroupListener == null) continue;
                            nDataGroupManagerImpl.this.myGroupListener.deletedStream(nDataGroup3, nDataStream3, nDataGroup3.size(), nStreamStatusUpdate2.wasServerInduced());
                        }
                        catch (Exception exception) {
                            nConstants.logger.warn(exception);
                        }
                    }
                }
            }
        }
    }

    private static interface StreamUpdateHandler {
        public void handleUpdate(nStreamStatusUpdate var1);
    }
}

