/*
 * Decompiled with CFR 0.152.
 */
package com.pcbsys.nirvana.base.clientimpl.singleconnection;

import com.pcbsys.foundation.collections.fast.Long2ObjectOpenAddressingHashMap;
import com.pcbsys.foundation.io.fConnection;
import com.pcbsys.nirvana.base.clientimpl.nEventProcessor;
import com.pcbsys.nirvana.base.clientimpl.singleconnection.ClientConnectionManagerImpl;
import com.pcbsys.nirvana.base.clientimpl.singleconnection.Constants;
import com.pcbsys.nirvana.base.clientimpl.singleconnection.eventhandlers.ClientEventDispatcher;
import com.pcbsys.nirvana.base.events.nEvent;
import com.pcbsys.nirvana.base.events.nSynchronous;
import com.pcbsys.nirvana.base.nConstants;
import com.pcbsys.nirvana.base.nRequestResponseContainer;
import com.pcbsys.nirvana.base.nRuntime;
import com.pcbsys.nirvana.client.nRequestTimedOutException;
import com.pcbsys.nirvana.client.nSessionNotConnectedException;
import com.pcbsys.nirvana.client.nSessionPausedException;
import java.util.Iterator;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.Predicate;

class nEventProcessorImpl
implements nEventProcessor {
    private final ClientEventDispatcher myClientEventDispatcher;
    private final ClientConnectionManagerImpl myConnectionManager;
    private final Long2ObjectOpenAddressingHashMap<nRequestResponseContainer> myEventHash;
    private final AtomicInteger myCurrentBusyThreads;

    nEventProcessorImpl(ClientConnectionManagerImpl clientConnectionManagerImpl, ClientEventDispatcher clientEventDispatcher) {
        this.myConnectionManager = clientConnectionManagerImpl;
        this.myClientEventDispatcher = clientEventDispatcher;
        this.myEventHash = new Long2ObjectOpenAddressingHashMap();
        this.myCurrentBusyThreads = new AtomicInteger(0);
    }

    @Override
    public nEvent writeEvent(nEvent nEvent2) throws nSessionNotConnectedException, nRequestTimedOutException, nSessionPausedException {
        return this.writeEvent(nEvent2, nConstants.getEVENTWAIT());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public nEvent writeEvent(nEvent nEvent2, long l) throws nSessionNotConnectedException, nRequestTimedOutException, nSessionPausedException {
        try {
            this.myCurrentBusyThreads.incrementAndGet();
            if (!this.myConnectionManager.isAlive()) {
                throw new nSessionNotConnectedException("Session has been closed");
            }
            if (this.myConnectionManager.isPaused() && nEvent2.getId() != 36 && !Constants.isEventAllowedOnSessionPause(nEvent2)) {
                throw new nSessionPausedException("Session is paused");
            }
            if (this.myConnectionManager.isDisconnected() && nEvent2.getId() != 66) {
                throw new nSessionNotConnectedException("Session has not not established yet");
            }
            fConnection fConnection2 = this.myConnectionManager.getBaseConnection();
            if (!nEvent2.isSynchronous()) {
                this.sendOutgoingEventNoWait(fConnection2, nEvent2);
                nEvent nEvent3 = null;
                return nEvent3;
            }
            this.myConnectionManager.validateRunThreadIsSafe();
            nRequestResponseContainer nRequestResponseContainer2 = new nRequestResponseContainer((nSynchronous)nEvent2, l);
            Object object = this.myEventHash;
            synchronized (object) {
                this.myEventHash.put(nRequestResponseContainer2.getRequestIdentifier(), nRequestResponseContainer2);
            }
            this.sendOutgoingEvent(fConnection2, nEvent2);
            if (!nRequestResponseContainer2.waitForComplete()) {
                object = null;
                return object;
            }
            if (!this.myConnectionManager.isAlive()) {
                throw new nSessionNotConnectedException("Session has been closed via another thread");
            }
            object = nRequestResponseContainer2.getResponse();
            if (object == null) {
                if (this.myConnectionManager.isPaused() || nRequestResponseContainer2.wasPaused()) {
                    throw new nSessionPausedException("Session is paused");
                }
                if (nRequestResponseContainer2.isClear()) {
                    throw new nSessionNotConnectedException("Session with the Realm has been disconnected");
                }
                Long2ObjectOpenAddressingHashMap<nRequestResponseContainer> long2ObjectOpenAddressingHashMap = this.myEventHash;
                synchronized (long2ObjectOpenAddressingHashMap) {
                    this.myEventHash.remove(nRequestResponseContainer2.getRequestIdentifier());
                }
                if (this.myConnectionManager.isConnected()) {
                    throw new nRequestTimedOutException("" + nConstants.getEVENTWAIT() + " Session: " + this.myConnectionManager.getClientAllocatedSessionID() + " with SessionID: " + Long.toHexString(this.myConnectionManager.getServerProvidedSessionID()) + " last ID = " + nRequestResponseContainer2.getRequestIdentifier() + " " + nEvent2.getClass().toString());
                }
                throw new nSessionNotConnectedException("Session with the Realm has been disconnected");
            }
            fConnection2.setCurrentResponseTime((int)nRequestResponseContainer2.responseTime());
            Object object2 = object;
            return object2;
        }
        finally {
            this.myCurrentBusyThreads.decrementAndGet();
        }
    }

    private void sendOutgoingEvent(fConnection fConnection2, nEvent nEvent2) throws nSessionNotConnectedException {
        try {
            fConnection2.write(nEvent2);
        }
        catch (Exception exception) {
            Constants.logger.error(exception);
            this.myConnectionManager.clearConnection();
            throw new nSessionNotConnectedException(exception.toString(), exception);
        }
    }

    private void sendOutgoingEventNoWait(fConnection fConnection2, nEvent nEvent2) throws nSessionNotConnectedException {
        try {
            fConnection2.write(nEvent2, true, true);
        }
        catch (Exception exception) {
            Constants.logger.error(exception);
            this.myConnectionManager.clearConnection();
            throw new nSessionNotConnectedException(exception.toString(), exception);
        }
    }

    public void processEvent(nEvent nEvent2) {
        if (this.myConnectionManager.isAlive()) {
            if (nEvent2 instanceof nSynchronous && nEvent2.isSynchronous() && this.handleSynchronousEvents((nSynchronous)nEvent2)) {
                return;
            }
            this.myClientEventDispatcher.handleServerOriginatingEvent(nEvent2);
        }
    }

    @Override
    public void close() {
        int n = 0;
        while (this.myCurrentBusyThreads.get() > 0 && n++ < 100) {
            try {
                Thread.sleep(10L);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            this.releaseRequests();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean handleSynchronousEvents(nSynchronous nSynchronous2) {
        nRequestResponseContainer nRequestResponseContainer2;
        Object object = this.myEventHash;
        synchronized (object) {
            nRequestResponseContainer2 = this.myEventHash.remove(nSynchronous2.getRequestId());
            if (nRequestResponseContainer2 == null && this.myConnectionManager.awaitingServerHandshake()) {
                for (nRequestResponseContainer nRequestResponseContainer3 : this.myEventHash.values()) {
                    if (nRequestResponseContainer3.getRequest().getId() != 66) continue;
                    nRequestResponseContainer2 = this.myEventHash.remove(nRequestResponseContainer3.getRequestIdentifier());
                    break;
                }
            }
        }
        if (nRequestResponseContainer2 != null) {
            object = nRequestResponseContainer2.getRequest();
            this.myClientEventDispatcher.handleClientResponseEvent((nEvent)object, nSynchronous2);
            nRequestResponseContainer2.setResponse(nSynchronous2);
            return true;
        }
        if (nSynchronous2.getRequestId() != -1 && nSynchronous2.getId() != 36) {
            if (Constants.logger.isWarningEnabled()) {
                nConstants.logger.warn(" Ignoring response to synchronous event with req id " + nSynchronous2.getRequestId() + " evt=" + nSynchronous2 + " Session: " + this.myConnectionManager.getClientAllocatedSessionID() + " SessionID " + Long.toHexString(this.myConnectionManager.getServerProvidedSessionID()));
            }
            if (nRuntime.sDevelopersBuild) {
                // empty if block
            }
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void releaseRequests() {
        Long2ObjectOpenAddressingHashMap<nRequestResponseContainer> long2ObjectOpenAddressingHashMap = this.myEventHash;
        synchronized (long2ObjectOpenAddressingHashMap) {
            for (nRequestResponseContainer nRequestResponseContainer2 : this.myEventHash.values()) {
                this.clearOrPauseContainer(nRequestResponseContainer2);
            }
            this.myEventHash.clear();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void releaseRequests(Predicate<nEvent> predicate) {
        if (predicate == null) {
            throw new IllegalArgumentException("Matcher must not be null");
        }
        Long2ObjectOpenAddressingHashMap<nRequestResponseContainer> long2ObjectOpenAddressingHashMap = this.myEventHash;
        synchronized (long2ObjectOpenAddressingHashMap) {
            Iterator<nRequestResponseContainer> iterator = this.myEventHash.iterator();
            while (iterator.hasNext()) {
                nRequestResponseContainer nRequestResponseContainer2 = iterator.next();
                if (!predicate.test(nRequestResponseContainer2.getRequest())) continue;
                this.clearOrPauseContainer(nRequestResponseContainer2);
                iterator.remove();
            }
        }
    }

    private void clearOrPauseContainer(nRequestResponseContainer nRequestResponseContainer2) {
        if (this.myConnectionManager.isPaused()) {
            nRequestResponseContainer2.paused();
        } else {
            nRequestResponseContainer2.clear();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void unblockThread(String string) {
        Long2ObjectOpenAddressingHashMap<nRequestResponseContainer> long2ObjectOpenAddressingHashMap = this.myEventHash;
        synchronized (long2ObjectOpenAddressingHashMap) {
            Iterator<nRequestResponseContainer> iterator = this.myEventHash.iterator();
            while (iterator.hasNext()) {
                nRequestResponseContainer nRequestResponseContainer2 = iterator.next();
                if (!nRequestResponseContainer2.getThread().getName().equals(string)) continue;
                nRequestResponseContainer2.clear();
                iterator.remove();
            }
        }
    }
}

