/*
 * Decompiled with CFR 0.152.
 */
package com.pcbsys.nirvana.base.clientimpl.singleconnection;

import com.pcbsys.foundation.threads.fTask;
import com.pcbsys.foundation.threads.fThreadPool;
import com.pcbsys.nirvana.base.clientimpl.nExceptionListenerManager;
import com.pcbsys.nirvana.base.nThreadManager;
import com.pcbsys.nirvana.client.nAsyncExceptionListener;
import com.pcbsys.nirvana.client.nBaseClientException;
import com.pcbsys.nirvana.client.nIllegalArgumentException;
import java.util.ArrayList;
import java.util.List;

public class nExceptionListenerManagerImpl
implements nExceptionListenerManager {
    private final nThreadManager myThreadManager;
    private final List<nAsyncExceptionListener> myExceptionListeners;

    protected nExceptionListenerManagerImpl(nThreadManager nThreadManager2) {
        this.myThreadManager = nThreadManager2;
        this.myExceptionListeners = new ArrayList<nAsyncExceptionListener>();
    }

    @Override
    public void processException(nBaseClientException nBaseClientException2) {
        AsynchronousExceptionTask asynchronousExceptionTask = new AsynchronousExceptionTask(this.myExceptionListeners, nBaseClientException2);
        if (this.myThreadManager == null) {
            fThreadPool.getCommonThreadPool().addTask(asynchronousExceptionTask);
        } else {
            this.myThreadManager.addTask(asynchronousExceptionTask);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void add(nAsyncExceptionListener nAsyncExceptionListener2) throws nIllegalArgumentException {
        if (nAsyncExceptionListener2 == null) {
            throw new nIllegalArgumentException("Must supply a non null nAsyncExceptionListener");
        }
        List<nAsyncExceptionListener> list = this.myExceptionListeners;
        synchronized (list) {
            if (this.myExceptionListeners.contains(nAsyncExceptionListener2)) {
                throw new nIllegalArgumentException("Listener already registered");
            }
            this.myExceptionListeners.add(nAsyncExceptionListener2);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void remove(nAsyncExceptionListener nAsyncExceptionListener2) throws nIllegalArgumentException {
        if (nAsyncExceptionListener2 == null) {
            throw new nIllegalArgumentException("Must supply a non null nAsyncExceptionListener");
        }
        List<nAsyncExceptionListener> list = this.myExceptionListeners;
        synchronized (list) {
            if (!this.myExceptionListeners.contains(nAsyncExceptionListener2)) {
                throw new nIllegalArgumentException("Listener not registered");
            }
            this.myExceptionListeners.remove(nAsyncExceptionListener2);
        }
    }

    private class AsynchronousExceptionTask
    implements fTask {
        private final List<nAsyncExceptionListener> asyncExceptionListeners;
        private final nBaseClientException asynchronousException;

        private AsynchronousExceptionTask(List<nAsyncExceptionListener> list, nBaseClientException nBaseClientException2) {
            this.asyncExceptionListeners = list;
            this.asynchronousException = nBaseClientException2;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void execute() {
            List<nAsyncExceptionListener> list = this.asyncExceptionListeners;
            synchronized (list) {
                nAsyncExceptionListener[] nAsyncExceptionListenerArray = new nAsyncExceptionListener[this.asyncExceptionListeners.size()];
                for (nAsyncExceptionListener nAsyncExceptionListener2 : nAsyncExceptionListenerArray = this.asyncExceptionListeners.toArray(nAsyncExceptionListenerArray)) {
                    nAsyncExceptionListener2.handleException(this.asynchronousException);
                }
            }
        }

        @Override
        public boolean reQueue() {
            return false;
        }
    }
}

