/*
 * Decompiled with CFR 0.152.
 */
package com.pcbsys.nirvana.base.clientimpl.singleconnection;

import com.pcbsys.foundation.base.fTimer;
import com.pcbsys.foundation.drivers.fAsyncReadListener;
import com.pcbsys.foundation.drivers.multicast.fMulticastClient;
import com.pcbsys.foundation.drivers.multicast.fMulticastManager;
import com.pcbsys.foundation.io.fEventInputStream;
import com.pcbsys.foundation.io.fStreamFactory;
import com.pcbsys.foundation.threads.fTask;
import com.pcbsys.foundation.utils.fSystemConfiguration;
import com.pcbsys.nirvana.base.clientimpl.singleconnection.ClientConnectionManagerImpl;
import com.pcbsys.nirvana.base.clientimpl.singleconnection.nMulticastManager;
import com.pcbsys.nirvana.base.events.nEvent;
import com.pcbsys.nirvana.base.events.nEventFactory;
import com.pcbsys.nirvana.base.events.nMulticastDetails;
import com.pcbsys.nirvana.base.events.nPublished;
import com.pcbsys.nirvana.base.nMulticastStreamTransitionManager;
import com.pcbsys.nirvana.base.nThreadManager;
import java.io.IOException;

public class nMulticastReceiver
implements fTask,
fAsyncReadListener {
    private final short myMulticastStreamId;
    private final nMulticastManager myMulticastManager;
    private final nThreadManager myThreadManager;
    private nMulticastStreamTransitionManager myTransitionManager;
    private fMulticastClient myMulticastClient;
    private fEventInputStream myMulticastReceiver;
    private boolean queued;

    nMulticastReceiver(nMulticastManager nMulticastManager2, nMulticastDetails nMulticastDetails2, nMulticastStreamTransitionManager nMulticastStreamTransitionManager2, nThreadManager nThreadManager2, ClientConnectionManagerImpl clientConnectionManagerImpl) {
        this.myMulticastManager = nMulticastManager2;
        this.queued = false;
        this.myMulticastStreamId = nMulticastDetails2.getStreamId();
        nMulticastDetails2.getConfig().setLocalBindingAdapter(fSystemConfiguration.getProperty("BindingInterface"));
        this.myMulticastClient = fMulticastManager.getInstance().createReceiver(nMulticastDetails2.getStreamId(), nMulticastDetails2.getConfig(), clientConnectionManagerImpl.getConnection(), this);
        this.myMulticastClient.sendReady();
        this.myTransitionManager = nMulticastStreamTransitionManager2;
        this.myThreadManager = nThreadManager2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void dataReady() throws IOException {
        boolean bl = false;
        nMulticastReceiver nMulticastReceiver2 = this;
        synchronized (nMulticastReceiver2) {
            if (!this.queued && this.myMulticastClient != null) {
                this.queued = true;
                bl = this.myThreadManager.addTask(this);
            }
        }
        if (!bl) {
            this.execute();
        }
    }

    @Override
    public void execute() {
        try {
            if (this.myMulticastReceiver == null) {
                this.myMulticastReceiver = fStreamFactory.createInputStream(this.myMulticastClient.getInputStream(), nEventFactory.getDefault());
            }
            while (this.myMulticastReceiver.available() != 0) {
                nEvent nEvent2 = (nEvent)this.myMulticastReceiver.readEvent();
                if (nEvent2 instanceof nPublished) {
                    ((nPublished)nEvent2).setMulticastDelivered(true);
                }
                this.myMulticastManager.processEvent(nEvent2);
            }
        }
        catch (Exception exception) {
            this.close();
        }
        if (this.myTransitionManager != null && this.myTransitionManager.inSync() && this.myTransitionManager.lastTCPEventIn() + 10000L < fTimer.currentTimeMillis()) {
            this.myMulticastManager.removeTransition(this.myTransitionManager.getResourceID());
            this.myTransitionManager = null;
        }
    }

    @Override
    public synchronized boolean reQueue() {
        this.queued = false;
        try {
            if (this.myMulticastClient != null) {
                this.queued = this.myMulticastReceiver.available() != 0;
            }
        }
        catch (IOException iOException) {
            this.queued = false;
        }
        return this.queued;
    }

    @Override
    public void close() {
        if (this.myTransitionManager != null) {
            this.myMulticastManager.removeTransition(this.myTransitionManager.getResourceID());
        }
        this.myMulticastManager.removeReceiver(this.myMulticastStreamId);
        if (this.myMulticastClient != null) {
            if (this.myMulticastReceiver != null) {
                this.myMulticastReceiver.close();
            }
            fMulticastManager.getInstance().removeReceiver(this.myMulticastStreamId);
            this.myMulticastClient = null;
        }
    }
}

