/*
 * Decompiled with CFR 0.152.
 */
package com.pcbsys.nirvana.base.clientimpl.singleconnection;

import com.pcbsys.foundation.collections.Vector;
import com.pcbsys.foundation.drivers.fConnectionDetails;
import com.pcbsys.nirvana.base.clientimpl.nRedirectManager;
import com.pcbsys.nirvana.base.clientimpl.nRedirectManagerHelper;
import com.pcbsys.nirvana.base.clientimpl.singleconnection.Constants;
import com.pcbsys.nirvana.base.events.nRedirection;
import com.pcbsys.nirvana.base.nRealm;
import com.pcbsys.nirvana.client.nAbstractChannel;
import com.pcbsys.nirvana.client.nChannel;
import com.pcbsys.nirvana.client.nChannelAlreadyExistsException;
import com.pcbsys.nirvana.client.nChannelAttributes;
import com.pcbsys.nirvana.client.nChannelNotFoundException;
import com.pcbsys.nirvana.client.nIllegalArgumentException;
import com.pcbsys.nirvana.client.nIllegalChannelMode;
import com.pcbsys.nirvana.client.nNameSpaceConflictException;
import com.pcbsys.nirvana.client.nQueue;
import com.pcbsys.nirvana.client.nRealmAlreadyBoundException;
import com.pcbsys.nirvana.client.nRealmNotFoundException;
import com.pcbsys.nirvana.client.nRealmUnreachableException;
import com.pcbsys.nirvana.client.nRequestTimedOutException;
import com.pcbsys.nirvana.client.nSecurityException;
import com.pcbsys.nirvana.client.nSession;
import com.pcbsys.nirvana.client.nSessionAttributes;
import com.pcbsys.nirvana.client.nSessionFactory;
import com.pcbsys.nirvana.client.nSessionNotConnectedException;
import com.pcbsys.nirvana.client.nSessionPausedException;
import com.pcbsys.nirvana.client.nUnexpectedResponseException;
import com.pcbsys.nirvana.client.nUnknownRemoteRealmException;
import java.util.LinkedHashMap;
import java.util.Map;

public class nRedirectManagerImpl
implements nRedirectManager {
    private final LinkedHashMap<String, nSession> mySessionMap;
    private final LinkedHashMap<String, nAbstractChannel> myChannelMap = new LinkedHashMap();
    private final String myUsername;
    private final nRedirectManagerHelper myRedirectManagerHelper;

    protected nRedirectManagerImpl(String string, nRedirectManagerHelper nRedirectManagerHelper2) {
        this.mySessionMap = new LinkedHashMap();
        this.myUsername = string;
        this.myRedirectManagerHelper = nRedirectManagerHelper2;
    }

    @Override
    public nChannel getChannel(nChannelAttributes nChannelAttributes2, nRedirection nRedirection2, long l) throws nSessionNotConnectedException, nUnknownRemoteRealmException, nSecurityException, nChannelAlreadyExistsException, nIllegalArgumentException, nRequestTimedOutException, nSessionPausedException, nUnexpectedResponseException {
        String string = nChannelAttributes2.getName() + "@" + nRedirection2.getRealm().getName();
        if (this.myChannelMap.containsKey(string)) {
            return (nChannel)this.myChannelMap.get(string);
        }
        nSession nSession2 = this.handleRedirect(nRedirection2.getRealm());
        try {
            nChannelAttributes2.setName(nRedirection2.getNormalizedName());
        }
        catch (nIllegalArgumentException nIllegalArgumentException2) {
            // empty catch block
        }
        nChannel nChannel2 = nSession2.createChannel(nChannelAttributes2, l + 1L);
        if (!this.myChannelMap.containsKey(string)) {
            this.myChannelMap.put(string, nChannel2);
        }
        return nChannel2;
    }

    @Override
    public nChannel getChannel(nChannelAttributes nChannelAttributes2, nRedirection nRedirection2) throws nSessionPausedException, nRequestTimedOutException, nUnknownRemoteRealmException, nIllegalArgumentException, nSessionNotConnectedException, nIllegalChannelMode, nUnexpectedResponseException, nChannelNotFoundException, nSecurityException {
        String string = nChannelAttributes2.getName() + "@" + nRedirection2.getRealm().getName();
        if (this.myChannelMap.containsKey(string)) {
            return (nChannel)this.myChannelMap.get(string);
        }
        nSession nSession2 = this.handleRedirect(nRedirection2.getRealm());
        try {
            nChannelAttributes2.setName(nRedirection2.getNormalizedName());
        }
        catch (nIllegalArgumentException nIllegalArgumentException2) {
            // empty catch block
        }
        nChannel nChannel2 = nSession2.findChannel(nChannelAttributes2);
        this.myChannelMap.put(string, nChannel2);
        return nChannel2;
    }

    @Override
    public nQueue getOrCreateQueue(nChannelAttributes nChannelAttributes2, nRedirection nRedirection2) throws nSessionNotConnectedException, nUnknownRemoteRealmException, nSecurityException, nChannelAlreadyExistsException, nIllegalArgumentException, nRequestTimedOutException, nSessionPausedException, nUnexpectedResponseException {
        String string = nChannelAttributes2.getName() + "@" + nRedirection2.getRealm().getName();
        if (this.myChannelMap.containsKey(string)) {
            return (nQueue)this.myChannelMap.get(string);
        }
        nSession nSession2 = this.handleRedirect(nRedirection2.getRealm());
        try {
            nChannelAttributes2.setName(nRedirection2.getNormalizedName());
        }
        catch (nIllegalArgumentException nIllegalArgumentException2) {
            // empty catch block
        }
        nQueue nQueue2 = nSession2.createQueue(nChannelAttributes2);
        this.myChannelMap.put(string, nQueue2);
        return nQueue2;
    }

    @Override
    public nQueue getQueue(nChannelAttributes nChannelAttributes2, nRedirection nRedirection2) throws nSessionNotConnectedException, nUnknownRemoteRealmException, nSecurityException, nIllegalArgumentException, nRequestTimedOutException, nSessionPausedException, nUnexpectedResponseException, nChannelNotFoundException, nIllegalChannelMode {
        String string = nChannelAttributes2.getName() + "@" + nRedirection2.getRealm().getName();
        if (this.myChannelMap.containsKey(string)) {
            return (nQueue)this.myChannelMap.get(string);
        }
        nSession nSession2 = this.handleRedirect(nRedirection2.getRealm());
        try {
            nChannelAttributes2.setName(nRedirection2.getNormalizedName());
        }
        catch (nIllegalArgumentException nIllegalArgumentException2) {
            // empty catch block
        }
        nQueue nQueue2 = nSession2.findQueue(nChannelAttributes2);
        if (!this.myChannelMap.containsKey(string)) {
            this.myChannelMap.put(string, nQueue2);
        }
        return nQueue2;
    }

    private nSession handleRedirect(nRealm nRealm2) throws nIllegalArgumentException {
        nSession nSession2;
        if (this.mySessionMap.get(nRealm2.getName()) != null) {
            nSession2 = this.mySessionMap.get(nRealm2.getName());
            if (!nSession2.isConnected()) {
                this.mySessionMap.remove(nRealm2.getName());
            } else {
                return nSession2;
            }
        }
        Vector<fConnectionDetails> vector = nRealm2.getConnections();
        String[] stringArray = new String[vector.size()];
        for (int i = 0; i < vector.size(); ++i) {
            stringArray[i] = vector.elementAt(i).toString();
        }
        try {
            nSession2 = this.myUsername != null ? nSessionFactory.create(new nSessionAttributes(stringArray), this.myUsername) : nSessionFactory.create(new nSessionAttributes(stringArray));
            nRedirectManager nRedirectManager2 = this.myRedirectManagerHelper.getRedirectManager(nSession2);
            if (!(nRedirectManager2 instanceof nRedirectManagerImpl)) {
                nIllegalArgumentException nIllegalArgumentException2 = new nIllegalArgumentException("Illegal redirection manager, unknwon state for the redirect");
                Constants.logger.log(nIllegalArgumentException2);
                throw nIllegalArgumentException2;
            }
            ((nRedirectManagerImpl)nRedirectManager2).put(this.myChannelMap);
            nSession2.init();
            this.mySessionMap.put(nRealm2.getName(), nSession2);
            return nSession2;
        }
        catch (Exception exception) {
            return null;
        }
    }

    private void put(Map<String, nAbstractChannel> map) {
        this.myChannelMap.putAll(map);
    }

    @Override
    public void processRealmRedirect(nRedirection nRedirection2, com.pcbsys.nirvana.client.nRealm nRealm2) throws nIllegalArgumentException, nRealmNotFoundException, nRealmUnreachableException, nSessionPausedException, nNameSpaceConflictException, nSessionNotConnectedException, nRequestTimedOutException, nUnexpectedResponseException, nRealmAlreadyBoundException, nSecurityException {
        nSession nSession2 = this.handleRedirect(nRedirection2.getRealm());
        nRealm2.setMountPoint(nRedirection2.getNormalizedName());
        nSession2.addRealm(nRealm2);
    }

    @Override
    public void deleteStore(nChannelAttributes nChannelAttributes2, nRedirection nRedirection2) throws nChannelNotFoundException, nUnknownRemoteRealmException, nSessionPausedException, nSessionNotConnectedException, nSecurityException, nRequestTimedOutException, nIllegalArgumentException, nUnexpectedResponseException {
        String string = nChannelAttributes2.getName() + "@" + nRedirection2.getRealm().getName();
        if (this.myChannelMap.containsKey(string)) {
            this.myChannelMap.remove(string);
        }
        nSession nSession2 = this.handleRedirect(nRedirection2.getRealm());
        try {
            nChannelAttributes2.setName(nRedirection2.getNormalizedName());
        }
        catch (nIllegalArgumentException nIllegalArgumentException2) {
            // empty catch block
        }
        nSession2.deleteChannel(nChannelAttributes2);
    }

    @Override
    public void close() {
        for (nSession nSession2 : this.mySessionMap.values()) {
            nSession2.close();
        }
    }
}

