/*
 * Decompiled with CFR 0.152.
 */
package com.pcbsys.nirvana.base.clientimpl.singleconnection;

import com.pcbsys.foundation.collections.fast.Long2ObjectOpenAddressingHashMap;
import com.pcbsys.foundation.utils.fStringByteConverter;
import com.pcbsys.nirvana.base.clientimpl.StoreManagerStateListener;
import com.pcbsys.nirvana.base.clientimpl.nExceptionListenerManager;
import com.pcbsys.nirvana.base.clientimpl.nQueueReaderManager;
import com.pcbsys.nirvana.base.clientimpl.nStoreManager;
import com.pcbsys.nirvana.base.clientimpl.nStoreManagerHelper;
import com.pcbsys.nirvana.base.clientimpl.singleconnection.ClientConnectionManagerImpl;
import com.pcbsys.nirvana.base.clientimpl.singleconnection.Constants;
import com.pcbsys.nirvana.base.events.nGetChannelList;
import com.pcbsys.nirvana.base.nChannelAttributes;
import com.pcbsys.nirvana.base.nClientChannelList;
import com.pcbsys.nirvana.base.nThreadManager;
import com.pcbsys.nirvana.client.nAbstractChannel;
import com.pcbsys.nirvana.client.nChannel;
import com.pcbsys.nirvana.client.nChannelImpl;
import com.pcbsys.nirvana.client.nConsumeEvent;
import com.pcbsys.nirvana.client.nIllegalArgumentException;
import com.pcbsys.nirvana.client.nIllegalChannelMode;
import com.pcbsys.nirvana.client.nQueue;
import com.pcbsys.nirvana.client.nSession;
import com.pcbsys.nirvana.client.nStoreDeletedException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedHashSet;

public class nStoreManagerImpl
implements nStoreManager {
    private final Long2ObjectOpenAddressingHashMap<nAbstractChannel> myStoreList;
    private final nQueueReaderManager myQueueReaderManager;
    private final nThreadManager myThreadManager;
    private final nSession mySession;
    private final nStoreManagerHelper myHelper;
    private final nExceptionListenerManager myExceptionListenerManager;
    private final ClientConnectionManagerImpl myConnectionManager;
    private nAbstractChannel myLastPublish;
    private boolean isMultiplexStores;
    private StoreManagerStateListener storeManagerStateListener;

    nStoreManagerImpl(nSession nSession2, nThreadManager nThreadManager2, ClientConnectionManagerImpl clientConnectionManagerImpl, nQueueReaderManager nQueueReaderManager2, nStoreManagerHelper nStoreManagerHelper2, nExceptionListenerManager nExceptionListenerManager2) {
        this.myExceptionListenerManager = nExceptionListenerManager2;
        this.myStoreList = new Long2ObjectOpenAddressingHashMap();
        this.myQueueReaderManager = nQueueReaderManager2;
        this.myThreadManager = nThreadManager2;
        this.myConnectionManager = clientConnectionManagerImpl;
        this.mySession = nSession2;
        this.myHelper = nStoreManagerHelper2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() {
        Long2ObjectOpenAddressingHashMap<nAbstractChannel> long2ObjectOpenAddressingHashMap = this.myStoreList;
        synchronized (long2ObjectOpenAddressingHashMap) {
            Iterator<nAbstractChannel> iterator = this.myStoreList.iterator();
            while (iterator.hasNext()) {
                this.myHelper.getBaseChannel(iterator.next()).getChannelList().setDeleted();
            }
            this.myStoreList.clear();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public nAbstractChannel get(long l) {
        Long2ObjectOpenAddressingHashMap<nAbstractChannel> long2ObjectOpenAddressingHashMap = this.myStoreList;
        synchronized (long2ObjectOpenAddressingHashMap) {
            return this.myStoreList.get(l);
        }
    }

    @Override
    public nAbstractChannel get(nChannelAttributes nChannelAttributes2) {
        if (nChannelAttributes2.getUniqueId() != -1L) {
            return this.get(nChannelAttributes2.getUniqueId());
        }
        return this.findStore(nChannelAttributes2.getName());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private nAbstractChannel findStore(String string) {
        Long2ObjectOpenAddressingHashMap<nAbstractChannel> long2ObjectOpenAddressingHashMap = this.myStoreList;
        synchronized (long2ObjectOpenAddressingHashMap) {
            Iterator<nAbstractChannel> iterator = this.myStoreList.iterator();
            while (iterator.hasNext()) {
                nAbstractChannel nAbstractChannel2 = iterator.next();
                if (!this.myHelper.getAttributes(nAbstractChannel2).getName().equals(string)) continue;
                return nAbstractChannel2;
            }
        }
        return null;
    }

    public ArrayList<nAbstractChannel> getStores() {
        return new ArrayList<nAbstractChannel>(this.myStoreList.values());
    }

    private void put(long l, nAbstractChannel nAbstractChannel2) {
        this.completeStoreLifecycle(this.myStoreList.put(l, nAbstractChannel2));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void remove(nChannelAttributes nChannelAttributes2) {
        nAbstractChannel nAbstractChannel2 = null;
        Long2ObjectOpenAddressingHashMap<nAbstractChannel> long2ObjectOpenAddressingHashMap = this.myStoreList;
        synchronized (long2ObjectOpenAddressingHashMap) {
            ArrayList<Long> arrayList = new ArrayList<Long>();
            Iterator<Long> iterator = this.myStoreList.keySet().iterator();
            while (iterator.hasNext()) {
                long l = (Long)iterator.next();
                nAbstractChannel nAbstractChannel3 = this.myStoreList.get(l);
                if (nAbstractChannel3 == null || !this.myHelper.getAttributes(nAbstractChannel3).getName().equals(nChannelAttributes2.getName())) continue;
                arrayList.add(l);
            }
            for (Long l : arrayList) {
                nAbstractChannel2 = this.myStoreList.remove(l);
            }
        }
        this.completeStoreLifecycle(nAbstractChannel2);
    }

    private void completeStoreLifecycle(nAbstractChannel nAbstractChannel2) {
        if (nAbstractChannel2 != null) {
            nChannelImpl nChannelImpl2 = this.myHelper.getBaseChannel(nAbstractChannel2);
            nChannelImpl2.getChannelList().setDeleted();
            this.clearLastUsedCache();
            if (this.storeManagerStateListener != null) {
                this.storeManagerStateListener.storeDestroyed(nAbstractChannel2, this.myConnectionManager.getUniqueClientAllocatedID());
            } else {
                Constants.logger.warn("Deleting store " + nChannelImpl2.getBaseChannelAttributes().getName() + " as it has been removed from the server");
                nStoreDeletedException nStoreDeletedException2 = new nStoreDeletedException("The store \"" + nChannelImpl2.getBaseChannelAttributes().getName() + "\" has been deleted actions will need to be taken to recover from this serverside operation", nAbstractChannel2);
                this.myExceptionListenerManager.processException(nStoreDeletedException2);
                if (this.myConnectionManager.getAttributes().isAdviseAsynchronousEventListenersOfStoreDelete()) {
                    nConsumeEvent nConsumeEvent2 = new nConsumeEvent("CHANNEL DELETED", fStringByteConverter.convert("The channel has been deleted"));
                    nConsumeEvent2.setEventID(-2L);
                    nChannelImpl2.getChannelList().push(nConsumeEvent2, null);
                }
            }
        }
    }

    public nChannelImpl getBaseChannelListFromCache(long l) {
        nAbstractChannel nAbstractChannel2 = this.get(l);
        return nAbstractChannel2 != null ? this.myHelper.getBaseChannel(nAbstractChannel2) : null;
    }

    @Override
    public void registerStateListener(StoreManagerStateListener storeManagerStateListener) {
        this.storeManagerStateListener = storeManagerStateListener;
    }

    @Override
    public nChannel getChannel(nChannelAttributes nChannelAttributes2) throws nIllegalChannelMode {
        if (nChannelAttributes2.getUniqueId() != -1L) {
            return this.validateChannel(this.get(nChannelAttributes2.getUniqueId()));
        }
        return this.validateChannel(this.findStore(nChannelAttributes2.getName()));
    }

    private nChannel validateChannel(nAbstractChannel nAbstractChannel2) throws nIllegalChannelMode {
        if (nAbstractChannel2 != null) {
            if (!this.myHelper.isQueue(nAbstractChannel2)) {
                return (nChannel)nAbstractChannel2;
            }
            throw new nIllegalChannelMode("Store is a nQueue");
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public nChannel createAndPutChannel(nChannelAttributes nChannelAttributes2) throws nIllegalArgumentException {
        Long2ObjectOpenAddressingHashMap<nAbstractChannel> long2ObjectOpenAddressingHashMap = this.myStoreList;
        synchronized (long2ObjectOpenAddressingHashMap) {
            nAbstractChannel nAbstractChannel2 = this.get(nChannelAttributes2);
            if (nAbstractChannel2 != null && !this.myHelper.isQueue(nAbstractChannel2) && this.myHelper.getAttributes(nAbstractChannel2).getName().equals(nChannelAttributes2.getName()) && this.myHelper.getAttributes(nAbstractChannel2).getUniqueId() == nChannelAttributes2.getUniqueId()) {
                return (nChannel)nAbstractChannel2;
            }
            nChannel nChannel2 = this.myHelper.createChannel(nChannelAttributes2, this.mySession, this.myThreadManager, this.myConnectionManager, this.isMultiplexStores());
            this.put(nChannelAttributes2.getUniqueId(), nChannel2);
            return nChannel2;
        }
    }

    @Override
    public nQueue getQueue(nChannelAttributes nChannelAttributes2) throws nIllegalChannelMode {
        if (nChannelAttributes2.getUniqueId() != -1L) {
            return this.validateQueue(this.get(nChannelAttributes2.getUniqueId()));
        }
        return this.validateQueue(this.findStore(nChannelAttributes2.getName()));
    }

    private nQueue validateQueue(nAbstractChannel nAbstractChannel2) throws nIllegalChannelMode {
        if (nAbstractChannel2 != null) {
            if (this.myHelper.isQueue(nAbstractChannel2)) {
                return (nQueue)nAbstractChannel2;
            }
            throw new nIllegalChannelMode("Store is a nChannel");
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public nQueue createAndPutQueue(nChannelAttributes nChannelAttributes2) throws nIllegalArgumentException {
        Long2ObjectOpenAddressingHashMap<nAbstractChannel> long2ObjectOpenAddressingHashMap = this.myStoreList;
        synchronized (long2ObjectOpenAddressingHashMap) {
            nAbstractChannel nAbstractChannel2 = this.get(nChannelAttributes2);
            if (nAbstractChannel2 != null && this.myHelper.isQueue(nAbstractChannel2) && this.myHelper.getAttributes(nAbstractChannel2).getName().equals(nChannelAttributes2.getName()) && this.myHelper.getAttributes(nAbstractChannel2).getUniqueId() == nChannelAttributes2.getUniqueId()) {
                return (nQueue)nAbstractChannel2;
            }
            nQueue nQueue2 = this.myHelper.createQueue(nChannelAttributes2, this.mySession, this.myThreadManager, this.myQueueReaderManager, this.myConnectionManager);
            this.put(nChannelAttributes2.getUniqueId(), nQueue2);
            return nQueue2;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void connectionDisconnected() {
        Long2ObjectOpenAddressingHashMap<nAbstractChannel> long2ObjectOpenAddressingHashMap = this.myStoreList;
        synchronized (long2ObjectOpenAddressingHashMap) {
            Iterator<nAbstractChannel> iterator = this.myStoreList.iterator();
            while (iterator.hasNext()) {
                nClientChannelList nClientChannelList2 = this.myHelper.getBaseChannel(iterator.next()).getChannelList();
                if (!nClientChannelList2.hasSubscribers() && !nClientChannelList2.hasListeners()) continue;
                nClientChannelList2.disconnected();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void connectionReconnected() {
        ArrayList<nChannelAttributes> arrayList = new ArrayList<nChannelAttributes>();
        LinkedHashSet<nAbstractChannel> linkedHashSet = this.myStoreList;
        synchronized (linkedHashSet) {
            for (nAbstractChannel object : this.myStoreList.values()) {
                arrayList.add(this.myHelper.getAttributes(object));
            }
        }
        try {
            linkedHashSet = this.myConnectionManager.getEventProcessor().writeEvent(new nGetChannelList(arrayList));
            if (linkedHashSet instanceof nGetChannelList) {
                Iterator<nChannelAttributes> iterator = (nGetChannelList)((Object)linkedHashSet);
                for (nChannelAttributes nChannelAttributes2 : ((nGetChannelList)((Object)iterator)).getChannelList()) {
                    Iterator<nChannelAttributes> iterator2 = arrayList.iterator();
                    while (iterator2.hasNext()) {
                        nChannelAttributes nChannelAttributes3 = iterator2.next();
                        if (!nChannelAttributes3.getName().equals(nChannelAttributes2.getName()) || nChannelAttributes3.getUniqueId() != nChannelAttributes2.getUniqueId()) continue;
                        iterator2.remove();
                    }
                }
            }
            for (nChannelAttributes nChannelAttributes4 : arrayList) {
                this.remove(nChannelAttributes4);
            }
        }
        catch (Exception exception) {
            Constants.logger.fatal("Failed to validate stores current state", exception);
        }
        linkedHashSet = new LinkedHashSet<nAbstractChannel>(this.myStoreList.values());
        for (int i = 9; i >= 0; --i) {
            Iterator iterator = linkedHashSet.iterator();
            while (iterator.hasNext()) {
                nClientChannelList nClientChannelList2 = this.myHelper.getBaseChannel((nAbstractChannel)iterator.next()).getChannelList();
                if (nClientChannelList2.hasSubscribers() || nClientChannelList2.hasListeners()) {
                    int n = nClientChannelList2.getAttributes().getMetaData().containsKey("Priority") ? nClientChannelList2.getAttributes().getMetaData().getInt("Priority") : 4;
                    if (n != i) continue;
                    nClientChannelList2.reconnect();
                    iterator.remove();
                    continue;
                }
                iterator.remove();
            }
        }
        this.myQueueReaderManager.reconnected();
    }

    public nChannelImpl findAndUpdateListener(long l) {
        nAbstractChannel nAbstractChannel2 = this.myLastPublish;
        if (nAbstractChannel2 != null && this.myHelper.getAttributes(nAbstractChannel2).getUniqueId() == l) {
            return this.myHelper.getBaseChannel(nAbstractChannel2);
        }
        this.myLastPublish = nAbstractChannel2 = this.get(l);
        return this.myHelper.getBaseChannel(nAbstractChannel2);
    }

    public void clearLastUsedCache() {
        this.myLastPublish = null;
    }

    @Override
    public void setMultiplexStoreFlag(boolean bl) {
        this.isMultiplexStores = bl;
    }

    @Override
    public boolean isMultiplexStores() {
        return this.isMultiplexStores;
    }

    @Override
    public nQueueReaderManager getReaderManager() {
        return this.myQueueReaderManager;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public nAbstractChannel getPrimaryOrSharedQueue(long l, long l2) {
        nAbstractChannel nAbstractChannel2 = this.get(l);
        if (nAbstractChannel2 == null) {
            Long2ObjectOpenAddressingHashMap<nAbstractChannel> long2ObjectOpenAddressingHashMap = this.myStoreList;
            synchronized (long2ObjectOpenAddressingHashMap) {
                nAbstractChannel2 = this.get(l2);
                if (nAbstractChannel2 != null) {
                    this.put(l, nAbstractChannel2);
                }
            }
        }
        return nAbstractChannel2;
    }
}

