/*
 * Decompiled with CFR 0.152.
 */
package com.pcbsys.nirvana.base.events;

import com.pcbsys.foundation.base.fEventDictionary;
import com.pcbsys.foundation.base.fObjectIds;
import com.pcbsys.foundation.base.fRuntime;
import com.pcbsys.foundation.filters.fFilterable;
import com.pcbsys.foundation.io.fBaseEvent;
import com.pcbsys.foundation.io.fEventInputStream;
import com.pcbsys.foundation.io.fEventOutputStream;
import com.pcbsys.foundation.utils.fStringByteConverter;
import com.pcbsys.nirvana.base.events.nDataConverter;
import com.pcbsys.nirvana.base.events.nEvent;
import com.pcbsys.nirvana.base.nConstants;
import com.pcbsys.nirvana.base.nHeader;
import com.pcbsys.nirvana.base.nRuntime;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.util.Enumeration;

public abstract class nBasePublishEvent
extends nEvent
implements fFilterable {
    public static final byte sIsDom = 1;
    public static final byte sIsTimeOuts = 2;
    public static final byte sHasSignature = 8;
    private static final int BYTE_ARRAY_SIZE_ESTIMATE = 16;
    private nDataConverter myDictionaryConverter;
    protected boolean isReadOnly = false;
    private byte[] myResourceAlias;
    private Object myUserObject;
    private byte[] myCache;
    private int myCacheCount;
    protected byte myType;
    protected boolean isTransient;
    protected nHeader myHeader;
    byte[] myTag;
    boolean isPersist;
    private byte[] myData;
    private byte[] mySignature;
    private boolean isEndOfChannel;
    private boolean myIsDDD;
    private long myChannelAttribId;
    private long myTTL;
    private String myStringTag;
    protected int myEventSize = 0;
    protected long heapUsageEstimate = -1L;

    nBasePublishEvent(int n) {
        super(n);
        this.myTTL = 0L;
        this.isPersist = true;
        this.isTransient = false;
        this.isEndOfChannel = true;
        this.myUserObject = null;
    }

    nBasePublishEvent(int n, long l, byte[] byArray, byte[] byArray2, byte by, fEventDictionary fEventDictionary2, long l2, boolean bl, byte[] byArray3) {
        super(n);
        this.myChannelAttribId = l;
        this.myData = byArray2;
        this.myTag = byArray;
        this.myDictionary = fEventDictionary2;
        this.myType = by;
        this.myTTL = l2;
        this.isPersist = bl;
        this.mySignature = byArray3;
        this.myUserObject = null;
        this.setInitialEventSize();
    }

    public nBasePublishEvent(int n, byte[] byArray, byte[] byArray2) {
        this(n);
        this.myData = byArray;
        this.myTag = byArray2;
        this.setInitialEventSize();
    }

    private void setInitialEventSize() {
        this.myEventSize = (this.myData == null ? 0 : this.myData.length) + (this.myTag == null ? 0 : this.myTag.length) + (this.myDictionary == null ? 0 : this.myDictionary.calculateSize());
    }

    @Override
    public boolean isProducerEvent() {
        return true;
    }

    public void setReadOnly(boolean bl) {
        if (nRuntime.sEnforceReadOnly) {
            this.isReadOnly = bl;
            if (this.myDictionary != null) {
                this.myDictionary.setReadOnly(bl);
            }
            if (this.myHeader != null) {
                this.myHeader.setReadOnly(bl);
            }
        }
    }

    public boolean isEndOfChannel() {
        return this.isEndOfChannel;
    }

    public void setEndOfChannel(boolean bl) {
        this.isEndOfChannel = bl;
    }

    public void setDictionaryConverter(nDataConverter nDataConverter2) {
        this.myDictionaryConverter = nDataConverter2;
    }

    public nDataConverter getDictionaryConverter() {
        return this.myDictionaryConverter;
    }

    @Override
    public fEventDictionary getFilterableDictionary() {
        if (this.myDictionaryConverter != null) {
            return this.myDictionaryConverter.getDictionary(this.myDictionary);
        }
        return this.myDictionary;
    }

    @Override
    public fEventDictionary getDictionary() {
        return this.myDictionary;
    }

    @Override
    public void setDictionary(fEventDictionary fEventDictionary2) {
        this.myDictionary = fEventDictionary2;
    }

    @Override
    public fEventDictionary getHeaderDictionary() {
        if (this.myHeader != null) {
            return this.myHeader.getDictionary();
        }
        return null;
    }

    public Object getUserObject() {
        return this.myUserObject;
    }

    public void setUserObject(Object object) {
        if (this.isReadOnly) {
            nConstants.logger.log("Error: Read Only flag set");
            if (fRuntime.sThrowErrorOnReadOnly) {
                throw new Error("Read Only flag set");
            }
        }
        this.myUserObject = object;
    }

    public long getChannelAttributesId() {
        return this.myChannelAttribId;
    }

    public byte[] getTag() {
        return this.myTag;
    }

    @Override
    public byte[] getData() {
        return this.myData;
    }

    public boolean isDom() {
        return (this.myType & 1) != 0;
    }

    public boolean isTimeOuts() {
        return (this.myType & 2) != 0;
    }

    @Override
    public long getTTL() {
        return this.myTTL;
    }

    @Override
    public void setTTL(long l) {
        if (this.isReadOnly) {
            nConstants.logger.log("Error: Read Only flag set");
            if (fRuntime.sThrowErrorOnReadOnly) {
                throw new Error("Read Only flag set");
            }
        }
        this.myTTL = l;
    }

    public byte[] getSignature() {
        return this.mySignature;
    }

    @Override
    public boolean isPersistant() {
        return this.isPersist;
    }

    public void setPersistant(boolean bl) {
        if (this.isReadOnly) {
            nConstants.logger.log("Error: Read Only flag set");
            if (fRuntime.sThrowErrorOnReadOnly) {
                throw new Error("Read Only flag set");
            }
        }
        this.isPersist = bl;
    }

    public boolean isTransient() {
        return this.isTransient;
    }

    public void setTransient(boolean bl) {
        this.isTransient = bl;
    }

    public boolean isDDD() {
        return this.myIsDDD;
    }

    void setIsDDD(boolean bl) {
        if (this.isReadOnly) {
            nConstants.logger.log("Error: Read Only flag set");
            if (fRuntime.sThrowErrorOnReadOnly) {
                throw new Error("Read Only flag set");
            }
        }
        this.myIsDDD = bl;
    }

    public void setChannelAttributesId(long l) {
        this.myChannelAttribId = l;
    }

    public void setResourceAlias(byte[] byArray) {
        this.myResourceAlias = byArray;
    }

    public byte[] getResourceAlias() {
        return this.myResourceAlias;
    }

    @Override
    public String getIndentifier() {
        if (this.myStringTag == null && this.myTag != null) {
            try {
                this.myStringTag = new String(this.myTag, fObjectIds.sc_StringEncoding);
            }
            catch (UnsupportedEncodingException unsupportedEncodingException) {
                nConstants.logger.warn(unsupportedEncodingException);
            }
        }
        return this.myStringTag;
    }

    public nHeader getHeader() {
        return this.myHeader;
    }

    public void setHeader(nHeader nHeader2) {
        if (this.isReadOnly) {
            nConstants.logger.log("Error: Read Only flag set");
            if (fRuntime.sThrowErrorOnReadOnly) {
                throw new Error("Read Only flag set");
            }
        }
        if (this.myHeader == null && nHeader2 != null) {
            this.heapUsageEstimate += 144L;
        }
        this.myHeader = nHeader2;
    }

    public void generateCache(fEventOutputStream fEventOutputStream2) throws IOException {
        byte[] byArray = this.releaseCache();
        if (byArray != null && fEventOutputStream2.canCompressBinary()) {
            fEventOutputStream2.write(byArray);
        } else {
            this.performWrite(fEventOutputStream2);
            fEventOutputStream2.writeInt(0);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public byte[] releaseCache() {
        if (this.myCache == null || this.myCacheCount == Integer.MAX_VALUE) {
            return this.myCache;
        }
        byte[] byArray = this.myCache;
        nBasePublishEvent nBasePublishEvent2 = this;
        synchronized (nBasePublishEvent2) {
            --this.myCacheCount;
            if (this.myCacheCount == 0) {
                this.resetCache();
            }
        }
        return byArray;
    }

    @Override
    public void setCache(byte[] byArray) {
        this.setCache(byArray, false);
    }

    @Override
    public void setCache(byte[] byArray, boolean bl) {
        this.myCache = byArray;
        this.myCacheCount = bl ? Integer.MAX_VALUE : 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void allocateCache() {
        if (this.myCache == null || this.myCacheCount == Integer.MAX_VALUE) {
            return;
        }
        nBasePublishEvent nBasePublishEvent2 = this;
        synchronized (nBasePublishEvent2) {
            ++this.myCacheCount;
        }
    }

    @Override
    public void resetCache() {
        this.myCache = null;
        this.myCacheCount = 0;
    }

    @Override
    int getCacheCount() {
        return this.myCacheCount;
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder().append("Nirvana Publish Event \n");
        if (this.myData != null) {
            stringBuilder.append("  Buffer size : ").append(this.myData.length).append("\n");
        } else {
            stringBuilder.append("  Buffer is null\n");
        }
        if (this.myTag != null) {
            stringBuilder.append("  TAG = ").append(fStringByteConverter.convert(this.myTag)).append("\n");
        }
        stringBuilder.append("  TTL = ").append(this.myTTL).append("\n");
        if (this.myDictionary != null) {
            Enumeration<String> enumeration = this.myDictionary.getKeysAsStrings();
            while (enumeration.hasMoreElements()) {
                String string = enumeration.nextElement();
                Object object = this.myDictionary.get(string.toString());
                stringBuilder.append("    ").append(string.toString()).append(" = ").append(object.toString()).append("\n");
            }
        }
        if (this.myHeader != null) {
            stringBuilder.append(this.myHeader.toString());
        } else {
            stringBuilder.append("No Header");
        }
        return stringBuilder.toString();
    }

    @Override
    public fBaseEvent getClone() {
        try {
            nBasePublishEvent nBasePublishEvent2 = (nBasePublishEvent)this.clone();
            nBasePublishEvent2.isReadOnly = false;
            this.releaseCache();
            nBasePublishEvent2.resetCache();
            if (this.myDictionary != null) {
                fEventDictionary fEventDictionary2 = new fEventDictionary();
                fEventDictionary2.copy(this.myDictionary, true);
                nBasePublishEvent2.myDictionary = fEventDictionary2;
            }
            if (this.myHeader != null) {
                nBasePublishEvent2.myHeader = this.myHeader.getClone();
                if (this.myDictionary != null) {
                    nBasePublishEvent2.myDictionary.setMissingKeyHandler(nBasePublishEvent2.myHeader);
                }
            }
            if (this.myDictionaryConverter != null) {
                nBasePublishEvent2.myDictionaryConverter = this.myDictionaryConverter.getClone(nBasePublishEvent2);
            }
            nBasePublishEvent2.myUserObject = this.myUserObject;
            return nBasePublishEvent2;
        }
        catch (Exception exception) {
            nConstants.logger.warn(exception);
            return null;
        }
    }

    @Override
    public int getPriority() {
        if (this.myHeader != null) {
            return this.myHeader.getPriority();
        }
        return 4;
    }

    public void setPriority(int n) {
        if (this.myHeader == null) {
            this.myHeader = new nHeader();
        }
        this.myHeader.setPriority((byte)n);
    }

    @Override
    public int getSize() {
        return this.myEventSize;
    }

    protected void setEventSize(int n) {
        this.myEventSize = n;
    }

    @Override
    public void writeExternal(fEventOutputStream fEventOutputStream2) throws IOException {
        byte[] byArray = this.releaseCache();
        if (byArray != null && fEventOutputStream2.canCompressBinary()) {
            fEventOutputStream2.write(byArray);
        } else {
            super.writeExternal(fEventOutputStream2);
        }
    }

    @Override
    protected void performRead(fEventInputStream fEventInputStream2) throws IOException {
        byte by = fEventInputStream2.readByte();
        this.isPersist = (by & 1) != 0;
        this.isTransient = (by & 2) != 0;
        this.isEndOfChannel = (by & 4) != 0;
        this.myType = 0;
        if ((by & 0x20) != 0) {
            this.myType = (byte)(this.myType + 1);
        }
        if ((by & 0x40) != 0) {
            this.myType = (byte)(this.myType + 2);
        }
        this.myChannelAttribId = fEventInputStream2.readLong();
        this.myTTL = fEventInputStream2.readLong();
        if ((by & 0x10) != 0) {
            this.myDictionary = new fEventDictionary();
            this.myDictionary.readExternal(fEventInputStream2);
            this.heapUsageEstimate += (long)this.myDictionary.estimateHeapUsage();
        }
        this.myTag = fEventInputStream2.readByteArray();
        this.heapUsageEstimate += 16L;
        this.myData = fEventInputStream2.readByteArray();
        if (this.myData != this.myTag) {
            this.heapUsageEstimate += 16L;
        }
        this.mySignature = fEventInputStream2.readByteArray();
        if (this.mySignature != this.myTag) {
            this.heapUsageEstimate += 16L;
        }
        if (this.mySignature.length == 0) {
            this.mySignature = null;
        } else {
            this.myType = (byte)(this.myType + 8);
        }
        if ((by & 8) != 0) {
            this.myHeader = new nHeader();
            this.myHeader.readExternal(fEventInputStream2);
            if (this.myDictionary != null) {
                this.myDictionary.setMissingKeyHandler(this.myHeader);
            }
        }
        if (this.myTag != null && this.myTag.length == 0 && this.myDictionary != null) {
            this.myTag = null;
        }
    }

    @Override
    protected void performWrite(fEventOutputStream fEventOutputStream2) throws IOException {
        byte by = 0;
        if (this.isPersist) {
            by = 1;
        }
        if (this.isTransient) {
            by = (byte)(by + 2);
        }
        if (this.isEndOfChannel) {
            by = (byte)(by + 4);
        }
        if (this.myHeader != null) {
            by = (byte)(by + 8);
        }
        if (this.myDictionary != null) {
            by = (byte)(by + 16);
        }
        if ((this.myType & 1) != 0) {
            by = (byte)(by + 32);
        }
        if ((this.myType & 2) != 0) {
            by = (byte)(by + 64);
        }
        by = (byte)(by + 128);
        fEventOutputStream2.writeByte(by);
        fEventOutputStream2.writeLong(this.myChannelAttribId);
        fEventOutputStream2.writeLong(this.myTTL);
        if (this.myDictionary != null) {
            this.myDictionary.writeExternal(fEventOutputStream2);
        }
        fEventOutputStream2.writeByteArray(this.myTag);
        fEventOutputStream2.writeByteArray(this.myData);
        fEventOutputStream2.writeByteArray(this.mySignature);
        if (this.myHeader != null) {
            this.myHeader.writeExternal(fEventOutputStream2);
        }
    }
}

